/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.base.Objects;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionId;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class TransactionGuardImpl
extends TransactionGuard {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.application.TransactionGuardImpl");
    private final Queue<Transaction> myQueue = new LinkedBlockingQueue<Transaction>();
    private final Map<ModalityState, TransactionIdImpl> myModality2Transaction = ContainerUtil.createConcurrentWeakMap();
    private final Map<ModalityState, Boolean> myWriteSafeModalities = ContainerUtil.createConcurrentWeakMap();
    private TransactionIdImpl myCurrentTransaction;
    private boolean myWritingAllowed;

    public TransactionGuardImpl() {
        this.myWriteSafeModalities.put(ModalityState.NON_MODAL, true);
    }

    @NotNull
    private Queue<Transaction> getQueue(@Nullable TransactionIdImpl transaction) {
        while (transaction != null && transaction.myFinished) {
            transaction = transaction.myParent;
        }
        Queue<Transaction> queue = transaction == null ? this.myQueue : transaction.myQueue;
        if (queue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/application/TransactionGuardImpl", "getQueue"));
        }
        return queue;
    }

    private void pollQueueLater() {
        TransactionGuardImpl.invokeLater(new Runnable(){

            @Override
            public void run() {
                Queue queue = TransactionGuardImpl.this.getQueue(TransactionGuardImpl.this.myCurrentTransaction);
                Transaction next = (Transaction)queue.peek();
                if (next != null && TransactionGuardImpl.this.canRunTransactionNow(next, false)) {
                    queue.remove();
                    TransactionGuardImpl.this.runSyncTransaction(next);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSyncTransaction(@NotNull Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "org/jetbrains/kotlin/com/intellij/openapi/application/TransactionGuardImpl", "runSyncTransaction"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (Disposer.isDisposed(transaction.parentDisposable)) {
            return;
        }
        boolean wasWritingAllowed = this.myWritingAllowed;
        this.myWritingAllowed = true;
        this.myCurrentTransaction = new TransactionIdImpl(this.myCurrentTransaction);
        try {
            transaction.runnable.run();
        }
        finally {
            Queue<Transaction> queue = this.getQueue(this.myCurrentTransaction.myParent);
            queue.addAll(this.myCurrentTransaction.myQueue);
            if (!queue.isEmpty()) {
                this.pollQueueLater();
            }
            this.myWritingAllowed = wasWritingAllowed;
            this.myCurrentTransaction.myFinished = true;
            this.myCurrentTransaction = this.myCurrentTransaction.myParent;
        }
    }

    public void submitTransaction(@NotNull Disposable parentDisposable, @Nullable TransactionId expectedContext, @NotNull Runnable _transaction) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/jetbrains/kotlin/com/intellij/openapi/application/TransactionGuardImpl", "submitTransaction"));
        }
        if (_transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_transaction", "org/jetbrains/kotlin/com/intellij/openapi/application/TransactionGuardImpl", "submitTransaction"));
        }
        final TransactionIdImpl expectedId = (TransactionIdImpl)expectedContext;
        final Transaction transaction = new Transaction(_transaction, expectedId, parentDisposable);
        Application app = ApplicationManager.getApplication();
        final boolean isDispatchThread = app.isDispatchThread();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (TransactionGuardImpl.this.canRunTransactionNow(transaction, isDispatchThread)) {
                    TransactionGuardImpl.this.runSyncTransaction(transaction);
                } else {
                    TransactionGuardImpl.this.getQueue(expectedId).offer(transaction);
                    TransactionGuardImpl.this.pollQueueLater();
                }
            }
        };
        if (isDispatchThread) {
            runnable.run();
        } else {
            TransactionGuardImpl.invokeLater(runnable);
        }
    }

    private boolean canRunTransactionNow(Transaction transaction, boolean sync) {
        if (sync && !this.myWritingAllowed) {
            return false;
        }
        TransactionIdImpl currentId = this.myCurrentTransaction;
        if (currentId == null) {
            return true;
        }
        return transaction.expectedContext != null && currentId.myStartCounter <= transaction.expectedContext.myStartCounter;
    }

    public void assertWriteActionAllowed() {
        if (Registry.is("ide.require.transaction.for.model.changes", false) && !this.myWritingAllowed) {
            String message = "Write access is allowed from model transactions only, see TransactionGuard documentation for details";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                message = message + "; current modality=" + ModalityState.current() + "; known modalities=" + this.myWriteSafeModalities;
            }
            LOG.info(message);
        }
    }

    private static void invokeLater(Runnable runnable) {
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.any(), Condition.FALSE);
    }

    @Nullable
    public TransactionIdImpl getModalityTransaction(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "org/jetbrains/kotlin/com/intellij/openapi/application/TransactionGuardImpl", "getModalityTransaction"));
        }
        return this.myModality2Transaction.get(modalityState);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("currentTransaction", this.myCurrentTransaction).add("writingAllowed", this.myWritingAllowed).toString();
    }

    private static class TransactionIdImpl
    implements TransactionId {
        private static final AtomicLong ourTransactionCounter = new AtomicLong();
        final long myStartCounter = ourTransactionCounter.getAndIncrement();
        final Queue<Transaction> myQueue = new LinkedBlockingQueue<Transaction>();
        boolean myFinished;
        final TransactionIdImpl myParent;

        public TransactionIdImpl(@Nullable TransactionIdImpl parent2) {
            this.myParent = parent2;
        }

        public String toString() {
            return "Transaction " + this.myStartCounter + (this.myFinished ? "(finished)" : "");
        }
    }

    private static class Transaction {
        @NotNull
        final Runnable runnable;
        @Nullable
        final TransactionIdImpl expectedContext;
        @NotNull
        final Disposable parentDisposable;

        Transaction(@NotNull Runnable runnable, @Nullable TransactionIdImpl expectedContext, @NotNull Disposable parentDisposable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/kotlin/com/intellij/openapi/application/TransactionGuardImpl$Transaction", "<init>"));
            }
            if (parentDisposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/jetbrains/kotlin/com/intellij/openapi/application/TransactionGuardImpl$Transaction", "<init>"));
            }
            this.runnable = runnable;
            this.expectedContext = expectedContext;
            this.parentDisposable = parentDisposable;
        }
    }
}

