/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

public class VariableAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    private final ResolvedCall<? extends VariableDescriptor> resolvedCall;
    private final JsExpression receiver;

    public static VariableAccessTranslator newInstance(@NotNull TranslationContext context, @NotNull KtReferenceExpression referenceExpression, @Nullable JsExpression receiver) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator", "newInstance"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator", "newInstance"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(referenceExpression, context.bindingContext());
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            resolvedCall2 = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall();
        }
        assert (resolvedCall2.getResultingDescriptor() instanceof VariableDescriptor);
        return new VariableAccessTranslator(context, resolvedCall2, receiver);
    }

    private VariableAccessTranslator(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends VariableDescriptor> resolvedCall2, @Nullable JsExpression receiver) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator", "<init>"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator", "<init>"));
        }
        super(context);
        this.receiver = receiver;
        this.resolvedCall = resolvedCall2;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = CallTranslator.INSTANCE.translateGet(this.context(), this.resolvedCall, this.receiver);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        if (setTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setTo", "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator", "translateAsSet"));
        }
        JsExpression jsExpression = CallTranslator.INSTANCE.translateSet(this.context(), this.resolvedCall, setTo, this.receiver);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator", "translateAsSet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public AccessTranslator getCached() {
        JsExpression cachedReceiver = this.receiver != null ? this.context().cacheExpressionIfNeeded(this.receiver) : null;
        CachedVariableAccessTranslator cachedVariableAccessTranslator = new CachedVariableAccessTranslator(this.context(), this.resolvedCall, cachedReceiver);
        if (cachedVariableAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator", "getCached"));
        }
        return cachedVariableAccessTranslator;
    }

    private static class CachedVariableAccessTranslator
    extends VariableAccessTranslator
    implements AccessTranslator {
        public CachedVariableAccessTranslator(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends VariableDescriptor> resolvedCall2, @Nullable JsExpression cachedReceiver) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator$CachedVariableAccessTranslator", "<init>"));
            }
            if (resolvedCall2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator$CachedVariableAccessTranslator", "<init>"));
            }
            super(context, resolvedCall2, cachedReceiver);
        }

        @Override
        @NotNull
        public AccessTranslator getCached() {
            CachedVariableAccessTranslator cachedVariableAccessTranslator = this;
            if (cachedVariableAccessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator$CachedVariableAccessTranslator", "getCached"));
            }
            return cachedVariableAccessTranslator;
        }
    }
}

