/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u001b\u0010\u0000\u001a\u0004\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0004\u001a\u0019\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0007\u001a\u0019\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\n\u001a\u0019\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\r\u001a\u0019\u0010\u000e\u001a\u00020\f\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"getFile", "Ljava/io/File;", "TF", "file", "(Ljava/lang/Object;)Ljava/io/File;", "getFileContents", "", "(Ljava/lang/Object;)Ljava/lang/CharSequence;", "getFileContentsStream", "Ljava/io/InputStream;", "(Ljava/lang/Object;)Ljava/io/InputStream;", "getFileName", "", "(Ljava/lang/Object;)Ljava/lang/String;", "getFilePath", "kotlin-compiler"})
public final class ScriptFileUtilKt {
    @NotNull
    public static final <TF> String getFileName(TF file2) {
        String string;
        TF TF = file2;
        if (TF instanceof PsiFile) {
            String string2 = ((PsiFile)file2).getOriginalFile().getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "file.originalFile.name");
        } else if (TF instanceof VirtualFile) {
            String string3 = ((VirtualFile)file2).getName();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull(string3, "file.name");
        } else if (TF instanceof File) {
            String string4 = ((File)file2).getName();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull(string4, "file.name");
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported file type " + file2);
        }
        return string;
    }

    @NotNull
    public static final <TF> String getFilePath(TF file2) {
        String string;
        TF TF = file2;
        if (TF instanceof PsiFile) {
            PsiFile psiFile = ((PsiFile)file2).getOriginalFile();
            PsiFile $receiver = psiFile;
            Object object = $receiver.getVirtualFile();
            if (object == null || (object = ((VirtualFile)object).getPath()) == null) {
                object = $receiver.getName();
            }
            String string2 = (String)object;
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "file.originalFile.run { \u2026rtualFile?.path ?: name }");
        } else if (TF instanceof VirtualFile) {
            String string3 = ((VirtualFile)file2).getPath();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull(string3, "file.path");
        } else if (TF instanceof File) {
            String string4 = ((File)file2).getCanonicalPath();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull(string4, "file.canonicalPath");
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported file type " + file2);
        }
        return string;
    }

    @Nullable
    public static final <TF> File getFile(TF file2) {
        File file3;
        TF TF = file2;
        if (TF instanceof PsiFile) {
            PsiFile psiFile = ((PsiFile)file2).getOriginalFile();
            PsiFile $receiver = psiFile;
            VirtualFile virtualFile = $receiver.getVirtualFile();
            file3 = new File(virtualFile != null ? virtualFile.getPath() : null);
        } else if (TF instanceof VirtualFile) {
            file3 = new File(((VirtualFile)file2).getPath());
        } else if (TF instanceof File) {
            file3 = (File)file2;
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported file type " + file2);
        }
        return file3;
    }

    @NotNull
    public static final <TF> CharSequence getFileContents(TF file2) {
        CharSequence charSequence;
        TF TF = file2;
        if (TF instanceof PsiFile) {
            CharSequence charSequence2 = ((PsiFile)file2).getViewProvider().getContents();
            charSequence = charSequence2;
            Intrinsics.checkExpressionValueIsNotNull(charSequence2, "file.viewProvider.contents");
        } else if (TF instanceof VirtualFile) {
            InputStream inputStream = ((VirtualFile)file2).getInputStream();
            Charset charset = ((VirtualFile)file2).getCharset();
            Intrinsics.checkExpressionValueIsNotNull(charset, "file.charset");
            Charset charset2 = charset;
            charSequence = TextStreamsKt.readText(new InputStreamReader(inputStream, charset2));
        } else if (TF instanceof File) {
            charSequence = FilesKt.readText$default((File)file2, null, 1, null);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported file type " + file2);
        }
        return charSequence;
    }

    @NotNull
    public static final <TF> InputStream getFileContentsStream(TF file2) {
        InputStream inputStream;
        TF TF = file2;
        if (TF instanceof PsiFile) {
            ByteArrayInputStream byteArrayInputStream;
            String string = ((Object)((PsiFile)file2).getViewProvider().getContents()).toString();
            Charset charset = null;
            boolean bl = true;
            String string2 = null;
            if (string2 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: byteInputStream");
            }
            if (bl & true) {
                charset = Charsets.UTF_8;
            }
            string2 = string;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
            ByteArrayInputStream byteArrayInputStream3 = byteArrayInputStream;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull(byArray, "(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            byteArrayInputStream2(byArray2);
            inputStream = byteArrayInputStream3;
        } else if (TF instanceof VirtualFile) {
            InputStream inputStream2 = ((VirtualFile)file2).getInputStream();
            inputStream = inputStream2;
            Intrinsics.checkExpressionValueIsNotNull(inputStream2, "file.inputStream");
        } else if (TF instanceof File) {
            File file3 = (File)file2;
            inputStream = new FileInputStream(file3);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported file type " + file2);
        }
        return inputStream;
    }
}

