/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.external.javadoc.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.external.javadoc.JavadocOptionFileOption;
import org.gradle.external.javadoc.OptionLessJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.BooleanJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.EnumJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.FileJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.JavadocOptionFileOptionInternal;
import org.gradle.external.javadoc.internal.JavadocOptionFileWriter;
import org.gradle.external.javadoc.internal.MultilineStringsJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.OptionLessJavadocOptionFileOptionInternal;
import org.gradle.external.javadoc.internal.OptionLessStringsJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.PathJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.StringJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.StringsJavadocOptionFileOption;
import org.gradle.internal.Cast;

public class JavadocOptionFile {
    private final Map<String, JavadocOptionFileOptionInternal<?>> options;
    private final OptionLessJavadocOptionFileOptionInternal<List<String>> sourceNames;

    public JavadocOptionFile() {
        this(new LinkedHashMap(), new OptionLessStringsJavadocOptionFileOption(Lists.newArrayList()));
    }

    private JavadocOptionFile(Map<String, JavadocOptionFileOptionInternal<?>> options, OptionLessJavadocOptionFileOptionInternal<List<String>> sourceNames) {
        this.options = options;
        this.sourceNames = sourceNames;
    }

    public JavadocOptionFile(JavadocOptionFile original) {
        this(JavadocOptionFile.duplicateOptions(original.options), original.sourceNames.duplicate());
    }

    private static Map<String, JavadocOptionFileOptionInternal<?>> duplicateOptions(Map<String, JavadocOptionFileOptionInternal<?>> original) {
        LinkedHashMap duplicateOptions = Maps.newLinkedHashMap();
        for (Map.Entry<String, JavadocOptionFileOptionInternal<?>> entry : original.entrySet()) {
            duplicateOptions.put(entry.getKey(), entry.getValue().duplicate());
        }
        return duplicateOptions;
    }

    public OptionLessJavadocOptionFileOption<List<String>> getSourceNames() {
        return this.sourceNames;
    }

    Map<String, JavadocOptionFileOptionInternal<?>> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public <T> JavadocOptionFileOption<T> addOption(JavadocOptionFileOptionInternal<T> option) {
        if (option == null) {
            throw new IllegalArgumentException("option == null!");
        }
        this.options.put(option.getOption(), option);
        return option;
    }

    public JavadocOptionFileOption<String> addStringOption(String option) {
        return this.addStringOption(option, null);
    }

    public JavadocOptionFileOption<String> addStringOption(String option, String value) {
        return this.addOption(new StringJavadocOptionFileOption(option, value));
    }

    public <T> JavadocOptionFileOption<T> addEnumOption(String option) {
        return this.addEnumOption(option, null);
    }

    public <T> JavadocOptionFileOption<T> addEnumOption(String option, T value) {
        return this.addOption(new EnumJavadocOptionFileOption<T>(option, value));
    }

    public JavadocOptionFileOption<List<File>> addPathOption(String option) {
        return this.addPathOption(option, System.getProperty("path.separator"));
    }

    public JavadocOptionFileOption<List<File>> addPathOption(String option, String joinBy) {
        return this.addOption(new PathJavadocOptionFileOption(option, Lists.newArrayList(), joinBy));
    }

    public JavadocOptionFileOption<List<String>> addStringsOption(String option) {
        return this.addStringsOption(option, System.getProperty("path.separator"));
    }

    public JavadocOptionFileOption<List<String>> addStringsOption(String option, String joinBy) {
        return this.addOption(new StringsJavadocOptionFileOption(option, Lists.newArrayList(), joinBy));
    }

    public JavadocOptionFileOption<List<String>> addMultilineStringsOption(String option) {
        return this.addOption(new MultilineStringsJavadocOptionFileOption(option, Lists.newArrayList()));
    }

    public JavadocOptionFileOption<Boolean> addBooleanOption(String option) {
        return this.addBooleanOption(option, false);
    }

    public JavadocOptionFileOption<Boolean> addBooleanOption(String option, boolean value) {
        return this.addOption(new BooleanJavadocOptionFileOption(option, value));
    }

    public JavadocOptionFileOption<File> addFileOption(String option) {
        return this.addFileOption(option, null);
    }

    public JavadocOptionFileOption<File> addFileOption(String option, File value) {
        return this.addOption(new FileJavadocOptionFileOption(option, value));
    }

    public void write(File optionFile) throws IOException {
        if (optionFile == null) {
            throw new IllegalArgumentException("optionFile == null!");
        }
        JavadocOptionFileWriter optionFileWriter = new JavadocOptionFileWriter(this);
        optionFileWriter.write(optionFile);
    }

    public <T> JavadocOptionFileOption<T> getOption(String option) {
        JavadocOptionFileOption foundOption = this.options.get(option);
        if (foundOption == null) {
            throw new IllegalArgumentException("Cannot find option " + option);
        }
        return (JavadocOptionFileOption)Cast.uncheckedCast((Object)foundOption);
    }
}

