// autogenerated from gen/S390X.rules: do not edit!
// generated with: cd gen; go run *.go

package ssa

import "math"

var _ = math.MinInt8 // in case not otherwise used
func rewriteValueS390X(v *Value, config *Config) bool {
	switch v.Op {
	case OpAdd16:
		return rewriteValueS390X_OpAdd16(v, config)
	case OpAdd32:
		return rewriteValueS390X_OpAdd32(v, config)
	case OpAdd32F:
		return rewriteValueS390X_OpAdd32F(v, config)
	case OpAdd64:
		return rewriteValueS390X_OpAdd64(v, config)
	case OpAdd64F:
		return rewriteValueS390X_OpAdd64F(v, config)
	case OpAdd8:
		return rewriteValueS390X_OpAdd8(v, config)
	case OpAddPtr:
		return rewriteValueS390X_OpAddPtr(v, config)
	case OpAddr:
		return rewriteValueS390X_OpAddr(v, config)
	case OpAnd16:
		return rewriteValueS390X_OpAnd16(v, config)
	case OpAnd32:
		return rewriteValueS390X_OpAnd32(v, config)
	case OpAnd64:
		return rewriteValueS390X_OpAnd64(v, config)
	case OpAnd8:
		return rewriteValueS390X_OpAnd8(v, config)
	case OpAndB:
		return rewriteValueS390X_OpAndB(v, config)
	case OpAtomicAdd32:
		return rewriteValueS390X_OpAtomicAdd32(v, config)
	case OpAtomicAdd64:
		return rewriteValueS390X_OpAtomicAdd64(v, config)
	case OpAtomicCompareAndSwap32:
		return rewriteValueS390X_OpAtomicCompareAndSwap32(v, config)
	case OpAtomicCompareAndSwap64:
		return rewriteValueS390X_OpAtomicCompareAndSwap64(v, config)
	case OpAtomicExchange32:
		return rewriteValueS390X_OpAtomicExchange32(v, config)
	case OpAtomicExchange64:
		return rewriteValueS390X_OpAtomicExchange64(v, config)
	case OpAtomicLoad32:
		return rewriteValueS390X_OpAtomicLoad32(v, config)
	case OpAtomicLoad64:
		return rewriteValueS390X_OpAtomicLoad64(v, config)
	case OpAtomicLoadPtr:
		return rewriteValueS390X_OpAtomicLoadPtr(v, config)
	case OpAtomicStore32:
		return rewriteValueS390X_OpAtomicStore32(v, config)
	case OpAtomicStore64:
		return rewriteValueS390X_OpAtomicStore64(v, config)
	case OpAtomicStorePtrNoWB:
		return rewriteValueS390X_OpAtomicStorePtrNoWB(v, config)
	case OpAvg64u:
		return rewriteValueS390X_OpAvg64u(v, config)
	case OpBswap32:
		return rewriteValueS390X_OpBswap32(v, config)
	case OpBswap64:
		return rewriteValueS390X_OpBswap64(v, config)
	case OpClosureCall:
		return rewriteValueS390X_OpClosureCall(v, config)
	case OpCom16:
		return rewriteValueS390X_OpCom16(v, config)
	case OpCom32:
		return rewriteValueS390X_OpCom32(v, config)
	case OpCom64:
		return rewriteValueS390X_OpCom64(v, config)
	case OpCom8:
		return rewriteValueS390X_OpCom8(v, config)
	case OpConst16:
		return rewriteValueS390X_OpConst16(v, config)
	case OpConst32:
		return rewriteValueS390X_OpConst32(v, config)
	case OpConst32F:
		return rewriteValueS390X_OpConst32F(v, config)
	case OpConst64:
		return rewriteValueS390X_OpConst64(v, config)
	case OpConst64F:
		return rewriteValueS390X_OpConst64F(v, config)
	case OpConst8:
		return rewriteValueS390X_OpConst8(v, config)
	case OpConstBool:
		return rewriteValueS390X_OpConstBool(v, config)
	case OpConstNil:
		return rewriteValueS390X_OpConstNil(v, config)
	case OpConvert:
		return rewriteValueS390X_OpConvert(v, config)
	case OpCtz32:
		return rewriteValueS390X_OpCtz32(v, config)
	case OpCtz64:
		return rewriteValueS390X_OpCtz64(v, config)
	case OpCvt32Fto32:
		return rewriteValueS390X_OpCvt32Fto32(v, config)
	case OpCvt32Fto64:
		return rewriteValueS390X_OpCvt32Fto64(v, config)
	case OpCvt32Fto64F:
		return rewriteValueS390X_OpCvt32Fto64F(v, config)
	case OpCvt32to32F:
		return rewriteValueS390X_OpCvt32to32F(v, config)
	case OpCvt32to64F:
		return rewriteValueS390X_OpCvt32to64F(v, config)
	case OpCvt64Fto32:
		return rewriteValueS390X_OpCvt64Fto32(v, config)
	case OpCvt64Fto32F:
		return rewriteValueS390X_OpCvt64Fto32F(v, config)
	case OpCvt64Fto64:
		return rewriteValueS390X_OpCvt64Fto64(v, config)
	case OpCvt64to32F:
		return rewriteValueS390X_OpCvt64to32F(v, config)
	case OpCvt64to64F:
		return rewriteValueS390X_OpCvt64to64F(v, config)
	case OpDeferCall:
		return rewriteValueS390X_OpDeferCall(v, config)
	case OpDiv16:
		return rewriteValueS390X_OpDiv16(v, config)
	case OpDiv16u:
		return rewriteValueS390X_OpDiv16u(v, config)
	case OpDiv32:
		return rewriteValueS390X_OpDiv32(v, config)
	case OpDiv32F:
		return rewriteValueS390X_OpDiv32F(v, config)
	case OpDiv32u:
		return rewriteValueS390X_OpDiv32u(v, config)
	case OpDiv64:
		return rewriteValueS390X_OpDiv64(v, config)
	case OpDiv64F:
		return rewriteValueS390X_OpDiv64F(v, config)
	case OpDiv64u:
		return rewriteValueS390X_OpDiv64u(v, config)
	case OpDiv8:
		return rewriteValueS390X_OpDiv8(v, config)
	case OpDiv8u:
		return rewriteValueS390X_OpDiv8u(v, config)
	case OpEq16:
		return rewriteValueS390X_OpEq16(v, config)
	case OpEq32:
		return rewriteValueS390X_OpEq32(v, config)
	case OpEq32F:
		return rewriteValueS390X_OpEq32F(v, config)
	case OpEq64:
		return rewriteValueS390X_OpEq64(v, config)
	case OpEq64F:
		return rewriteValueS390X_OpEq64F(v, config)
	case OpEq8:
		return rewriteValueS390X_OpEq8(v, config)
	case OpEqB:
		return rewriteValueS390X_OpEqB(v, config)
	case OpEqPtr:
		return rewriteValueS390X_OpEqPtr(v, config)
	case OpGeq16:
		return rewriteValueS390X_OpGeq16(v, config)
	case OpGeq16U:
		return rewriteValueS390X_OpGeq16U(v, config)
	case OpGeq32:
		return rewriteValueS390X_OpGeq32(v, config)
	case OpGeq32F:
		return rewriteValueS390X_OpGeq32F(v, config)
	case OpGeq32U:
		return rewriteValueS390X_OpGeq32U(v, config)
	case OpGeq64:
		return rewriteValueS390X_OpGeq64(v, config)
	case OpGeq64F:
		return rewriteValueS390X_OpGeq64F(v, config)
	case OpGeq64U:
		return rewriteValueS390X_OpGeq64U(v, config)
	case OpGeq8:
		return rewriteValueS390X_OpGeq8(v, config)
	case OpGeq8U:
		return rewriteValueS390X_OpGeq8U(v, config)
	case OpGetClosurePtr:
		return rewriteValueS390X_OpGetClosurePtr(v, config)
	case OpGetG:
		return rewriteValueS390X_OpGetG(v, config)
	case OpGoCall:
		return rewriteValueS390X_OpGoCall(v, config)
	case OpGreater16:
		return rewriteValueS390X_OpGreater16(v, config)
	case OpGreater16U:
		return rewriteValueS390X_OpGreater16U(v, config)
	case OpGreater32:
		return rewriteValueS390X_OpGreater32(v, config)
	case OpGreater32F:
		return rewriteValueS390X_OpGreater32F(v, config)
	case OpGreater32U:
		return rewriteValueS390X_OpGreater32U(v, config)
	case OpGreater64:
		return rewriteValueS390X_OpGreater64(v, config)
	case OpGreater64F:
		return rewriteValueS390X_OpGreater64F(v, config)
	case OpGreater64U:
		return rewriteValueS390X_OpGreater64U(v, config)
	case OpGreater8:
		return rewriteValueS390X_OpGreater8(v, config)
	case OpGreater8U:
		return rewriteValueS390X_OpGreater8U(v, config)
	case OpHmul16:
		return rewriteValueS390X_OpHmul16(v, config)
	case OpHmul16u:
		return rewriteValueS390X_OpHmul16u(v, config)
	case OpHmul32:
		return rewriteValueS390X_OpHmul32(v, config)
	case OpHmul32u:
		return rewriteValueS390X_OpHmul32u(v, config)
	case OpHmul64:
		return rewriteValueS390X_OpHmul64(v, config)
	case OpHmul64u:
		return rewriteValueS390X_OpHmul64u(v, config)
	case OpHmul8:
		return rewriteValueS390X_OpHmul8(v, config)
	case OpHmul8u:
		return rewriteValueS390X_OpHmul8u(v, config)
	case OpITab:
		return rewriteValueS390X_OpITab(v, config)
	case OpInterCall:
		return rewriteValueS390X_OpInterCall(v, config)
	case OpIsInBounds:
		return rewriteValueS390X_OpIsInBounds(v, config)
	case OpIsNonNil:
		return rewriteValueS390X_OpIsNonNil(v, config)
	case OpIsSliceInBounds:
		return rewriteValueS390X_OpIsSliceInBounds(v, config)
	case OpLeq16:
		return rewriteValueS390X_OpLeq16(v, config)
	case OpLeq16U:
		return rewriteValueS390X_OpLeq16U(v, config)
	case OpLeq32:
		return rewriteValueS390X_OpLeq32(v, config)
	case OpLeq32F:
		return rewriteValueS390X_OpLeq32F(v, config)
	case OpLeq32U:
		return rewriteValueS390X_OpLeq32U(v, config)
	case OpLeq64:
		return rewriteValueS390X_OpLeq64(v, config)
	case OpLeq64F:
		return rewriteValueS390X_OpLeq64F(v, config)
	case OpLeq64U:
		return rewriteValueS390X_OpLeq64U(v, config)
	case OpLeq8:
		return rewriteValueS390X_OpLeq8(v, config)
	case OpLeq8U:
		return rewriteValueS390X_OpLeq8U(v, config)
	case OpLess16:
		return rewriteValueS390X_OpLess16(v, config)
	case OpLess16U:
		return rewriteValueS390X_OpLess16U(v, config)
	case OpLess32:
		return rewriteValueS390X_OpLess32(v, config)
	case OpLess32F:
		return rewriteValueS390X_OpLess32F(v, config)
	case OpLess32U:
		return rewriteValueS390X_OpLess32U(v, config)
	case OpLess64:
		return rewriteValueS390X_OpLess64(v, config)
	case OpLess64F:
		return rewriteValueS390X_OpLess64F(v, config)
	case OpLess64U:
		return rewriteValueS390X_OpLess64U(v, config)
	case OpLess8:
		return rewriteValueS390X_OpLess8(v, config)
	case OpLess8U:
		return rewriteValueS390X_OpLess8U(v, config)
	case OpLoad:
		return rewriteValueS390X_OpLoad(v, config)
	case OpLrot32:
		return rewriteValueS390X_OpLrot32(v, config)
	case OpLrot64:
		return rewriteValueS390X_OpLrot64(v, config)
	case OpLsh16x16:
		return rewriteValueS390X_OpLsh16x16(v, config)
	case OpLsh16x32:
		return rewriteValueS390X_OpLsh16x32(v, config)
	case OpLsh16x64:
		return rewriteValueS390X_OpLsh16x64(v, config)
	case OpLsh16x8:
		return rewriteValueS390X_OpLsh16x8(v, config)
	case OpLsh32x16:
		return rewriteValueS390X_OpLsh32x16(v, config)
	case OpLsh32x32:
		return rewriteValueS390X_OpLsh32x32(v, config)
	case OpLsh32x64:
		return rewriteValueS390X_OpLsh32x64(v, config)
	case OpLsh32x8:
		return rewriteValueS390X_OpLsh32x8(v, config)
	case OpLsh64x16:
		return rewriteValueS390X_OpLsh64x16(v, config)
	case OpLsh64x32:
		return rewriteValueS390X_OpLsh64x32(v, config)
	case OpLsh64x64:
		return rewriteValueS390X_OpLsh64x64(v, config)
	case OpLsh64x8:
		return rewriteValueS390X_OpLsh64x8(v, config)
	case OpLsh8x16:
		return rewriteValueS390X_OpLsh8x16(v, config)
	case OpLsh8x32:
		return rewriteValueS390X_OpLsh8x32(v, config)
	case OpLsh8x64:
		return rewriteValueS390X_OpLsh8x64(v, config)
	case OpLsh8x8:
		return rewriteValueS390X_OpLsh8x8(v, config)
	case OpMod16:
		return rewriteValueS390X_OpMod16(v, config)
	case OpMod16u:
		return rewriteValueS390X_OpMod16u(v, config)
	case OpMod32:
		return rewriteValueS390X_OpMod32(v, config)
	case OpMod32u:
		return rewriteValueS390X_OpMod32u(v, config)
	case OpMod64:
		return rewriteValueS390X_OpMod64(v, config)
	case OpMod64u:
		return rewriteValueS390X_OpMod64u(v, config)
	case OpMod8:
		return rewriteValueS390X_OpMod8(v, config)
	case OpMod8u:
		return rewriteValueS390X_OpMod8u(v, config)
	case OpMove:
		return rewriteValueS390X_OpMove(v, config)
	case OpMul16:
		return rewriteValueS390X_OpMul16(v, config)
	case OpMul32:
		return rewriteValueS390X_OpMul32(v, config)
	case OpMul32F:
		return rewriteValueS390X_OpMul32F(v, config)
	case OpMul64:
		return rewriteValueS390X_OpMul64(v, config)
	case OpMul64F:
		return rewriteValueS390X_OpMul64F(v, config)
	case OpMul8:
		return rewriteValueS390X_OpMul8(v, config)
	case OpNeg16:
		return rewriteValueS390X_OpNeg16(v, config)
	case OpNeg32:
		return rewriteValueS390X_OpNeg32(v, config)
	case OpNeg32F:
		return rewriteValueS390X_OpNeg32F(v, config)
	case OpNeg64:
		return rewriteValueS390X_OpNeg64(v, config)
	case OpNeg64F:
		return rewriteValueS390X_OpNeg64F(v, config)
	case OpNeg8:
		return rewriteValueS390X_OpNeg8(v, config)
	case OpNeq16:
		return rewriteValueS390X_OpNeq16(v, config)
	case OpNeq32:
		return rewriteValueS390X_OpNeq32(v, config)
	case OpNeq32F:
		return rewriteValueS390X_OpNeq32F(v, config)
	case OpNeq64:
		return rewriteValueS390X_OpNeq64(v, config)
	case OpNeq64F:
		return rewriteValueS390X_OpNeq64F(v, config)
	case OpNeq8:
		return rewriteValueS390X_OpNeq8(v, config)
	case OpNeqB:
		return rewriteValueS390X_OpNeqB(v, config)
	case OpNeqPtr:
		return rewriteValueS390X_OpNeqPtr(v, config)
	case OpNilCheck:
		return rewriteValueS390X_OpNilCheck(v, config)
	case OpNot:
		return rewriteValueS390X_OpNot(v, config)
	case OpOffPtr:
		return rewriteValueS390X_OpOffPtr(v, config)
	case OpOr16:
		return rewriteValueS390X_OpOr16(v, config)
	case OpOr32:
		return rewriteValueS390X_OpOr32(v, config)
	case OpOr64:
		return rewriteValueS390X_OpOr64(v, config)
	case OpOr8:
		return rewriteValueS390X_OpOr8(v, config)
	case OpOrB:
		return rewriteValueS390X_OpOrB(v, config)
	case OpRsh16Ux16:
		return rewriteValueS390X_OpRsh16Ux16(v, config)
	case OpRsh16Ux32:
		return rewriteValueS390X_OpRsh16Ux32(v, config)
	case OpRsh16Ux64:
		return rewriteValueS390X_OpRsh16Ux64(v, config)
	case OpRsh16Ux8:
		return rewriteValueS390X_OpRsh16Ux8(v, config)
	case OpRsh16x16:
		return rewriteValueS390X_OpRsh16x16(v, config)
	case OpRsh16x32:
		return rewriteValueS390X_OpRsh16x32(v, config)
	case OpRsh16x64:
		return rewriteValueS390X_OpRsh16x64(v, config)
	case OpRsh16x8:
		return rewriteValueS390X_OpRsh16x8(v, config)
	case OpRsh32Ux16:
		return rewriteValueS390X_OpRsh32Ux16(v, config)
	case OpRsh32Ux32:
		return rewriteValueS390X_OpRsh32Ux32(v, config)
	case OpRsh32Ux64:
		return rewriteValueS390X_OpRsh32Ux64(v, config)
	case OpRsh32Ux8:
		return rewriteValueS390X_OpRsh32Ux8(v, config)
	case OpRsh32x16:
		return rewriteValueS390X_OpRsh32x16(v, config)
	case OpRsh32x32:
		return rewriteValueS390X_OpRsh32x32(v, config)
	case OpRsh32x64:
		return rewriteValueS390X_OpRsh32x64(v, config)
	case OpRsh32x8:
		return rewriteValueS390X_OpRsh32x8(v, config)
	case OpRsh64Ux16:
		return rewriteValueS390X_OpRsh64Ux16(v, config)
	case OpRsh64Ux32:
		return rewriteValueS390X_OpRsh64Ux32(v, config)
	case OpRsh64Ux64:
		return rewriteValueS390X_OpRsh64Ux64(v, config)
	case OpRsh64Ux8:
		return rewriteValueS390X_OpRsh64Ux8(v, config)
	case OpRsh64x16:
		return rewriteValueS390X_OpRsh64x16(v, config)
	case OpRsh64x32:
		return rewriteValueS390X_OpRsh64x32(v, config)
	case OpRsh64x64:
		return rewriteValueS390X_OpRsh64x64(v, config)
	case OpRsh64x8:
		return rewriteValueS390X_OpRsh64x8(v, config)
	case OpRsh8Ux16:
		return rewriteValueS390X_OpRsh8Ux16(v, config)
	case OpRsh8Ux32:
		return rewriteValueS390X_OpRsh8Ux32(v, config)
	case OpRsh8Ux64:
		return rewriteValueS390X_OpRsh8Ux64(v, config)
	case OpRsh8Ux8:
		return rewriteValueS390X_OpRsh8Ux8(v, config)
	case OpRsh8x16:
		return rewriteValueS390X_OpRsh8x16(v, config)
	case OpRsh8x32:
		return rewriteValueS390X_OpRsh8x32(v, config)
	case OpRsh8x64:
		return rewriteValueS390X_OpRsh8x64(v, config)
	case OpRsh8x8:
		return rewriteValueS390X_OpRsh8x8(v, config)
	case OpS390XADD:
		return rewriteValueS390X_OpS390XADD(v, config)
	case OpS390XADDW:
		return rewriteValueS390X_OpS390XADDW(v, config)
	case OpS390XADDWconst:
		return rewriteValueS390X_OpS390XADDWconst(v, config)
	case OpS390XADDconst:
		return rewriteValueS390X_OpS390XADDconst(v, config)
	case OpS390XAND:
		return rewriteValueS390X_OpS390XAND(v, config)
	case OpS390XANDW:
		return rewriteValueS390X_OpS390XANDW(v, config)
	case OpS390XANDWconst:
		return rewriteValueS390X_OpS390XANDWconst(v, config)
	case OpS390XANDconst:
		return rewriteValueS390X_OpS390XANDconst(v, config)
	case OpS390XCMP:
		return rewriteValueS390X_OpS390XCMP(v, config)
	case OpS390XCMPU:
		return rewriteValueS390X_OpS390XCMPU(v, config)
	case OpS390XCMPUconst:
		return rewriteValueS390X_OpS390XCMPUconst(v, config)
	case OpS390XCMPW:
		return rewriteValueS390X_OpS390XCMPW(v, config)
	case OpS390XCMPWU:
		return rewriteValueS390X_OpS390XCMPWU(v, config)
	case OpS390XCMPWUconst:
		return rewriteValueS390X_OpS390XCMPWUconst(v, config)
	case OpS390XCMPWconst:
		return rewriteValueS390X_OpS390XCMPWconst(v, config)
	case OpS390XCMPconst:
		return rewriteValueS390X_OpS390XCMPconst(v, config)
	case OpS390XFMOVDload:
		return rewriteValueS390X_OpS390XFMOVDload(v, config)
	case OpS390XFMOVDloadidx:
		return rewriteValueS390X_OpS390XFMOVDloadidx(v, config)
	case OpS390XFMOVDstore:
		return rewriteValueS390X_OpS390XFMOVDstore(v, config)
	case OpS390XFMOVDstoreidx:
		return rewriteValueS390X_OpS390XFMOVDstoreidx(v, config)
	case OpS390XFMOVSload:
		return rewriteValueS390X_OpS390XFMOVSload(v, config)
	case OpS390XFMOVSloadidx:
		return rewriteValueS390X_OpS390XFMOVSloadidx(v, config)
	case OpS390XFMOVSstore:
		return rewriteValueS390X_OpS390XFMOVSstore(v, config)
	case OpS390XFMOVSstoreidx:
		return rewriteValueS390X_OpS390XFMOVSstoreidx(v, config)
	case OpS390XMOVBZload:
		return rewriteValueS390X_OpS390XMOVBZload(v, config)
	case OpS390XMOVBZloadidx:
		return rewriteValueS390X_OpS390XMOVBZloadidx(v, config)
	case OpS390XMOVBZreg:
		return rewriteValueS390X_OpS390XMOVBZreg(v, config)
	case OpS390XMOVBload:
		return rewriteValueS390X_OpS390XMOVBload(v, config)
	case OpS390XMOVBreg:
		return rewriteValueS390X_OpS390XMOVBreg(v, config)
	case OpS390XMOVBstore:
		return rewriteValueS390X_OpS390XMOVBstore(v, config)
	case OpS390XMOVBstoreconst:
		return rewriteValueS390X_OpS390XMOVBstoreconst(v, config)
	case OpS390XMOVBstoreidx:
		return rewriteValueS390X_OpS390XMOVBstoreidx(v, config)
	case OpS390XMOVDEQ:
		return rewriteValueS390X_OpS390XMOVDEQ(v, config)
	case OpS390XMOVDGE:
		return rewriteValueS390X_OpS390XMOVDGE(v, config)
	case OpS390XMOVDGT:
		return rewriteValueS390X_OpS390XMOVDGT(v, config)
	case OpS390XMOVDLE:
		return rewriteValueS390X_OpS390XMOVDLE(v, config)
	case OpS390XMOVDLT:
		return rewriteValueS390X_OpS390XMOVDLT(v, config)
	case OpS390XMOVDNE:
		return rewriteValueS390X_OpS390XMOVDNE(v, config)
	case OpS390XMOVDaddridx:
		return rewriteValueS390X_OpS390XMOVDaddridx(v, config)
	case OpS390XMOVDload:
		return rewriteValueS390X_OpS390XMOVDload(v, config)
	case OpS390XMOVDloadidx:
		return rewriteValueS390X_OpS390XMOVDloadidx(v, config)
	case OpS390XMOVDreg:
		return rewriteValueS390X_OpS390XMOVDreg(v, config)
	case OpS390XMOVDstore:
		return rewriteValueS390X_OpS390XMOVDstore(v, config)
	case OpS390XMOVDstoreconst:
		return rewriteValueS390X_OpS390XMOVDstoreconst(v, config)
	case OpS390XMOVDstoreidx:
		return rewriteValueS390X_OpS390XMOVDstoreidx(v, config)
	case OpS390XMOVHBRstore:
		return rewriteValueS390X_OpS390XMOVHBRstore(v, config)
	case OpS390XMOVHBRstoreidx:
		return rewriteValueS390X_OpS390XMOVHBRstoreidx(v, config)
	case OpS390XMOVHZload:
		return rewriteValueS390X_OpS390XMOVHZload(v, config)
	case OpS390XMOVHZloadidx:
		return rewriteValueS390X_OpS390XMOVHZloadidx(v, config)
	case OpS390XMOVHZreg:
		return rewriteValueS390X_OpS390XMOVHZreg(v, config)
	case OpS390XMOVHload:
		return rewriteValueS390X_OpS390XMOVHload(v, config)
	case OpS390XMOVHreg:
		return rewriteValueS390X_OpS390XMOVHreg(v, config)
	case OpS390XMOVHstore:
		return rewriteValueS390X_OpS390XMOVHstore(v, config)
	case OpS390XMOVHstoreconst:
		return rewriteValueS390X_OpS390XMOVHstoreconst(v, config)
	case OpS390XMOVHstoreidx:
		return rewriteValueS390X_OpS390XMOVHstoreidx(v, config)
	case OpS390XMOVWBRstore:
		return rewriteValueS390X_OpS390XMOVWBRstore(v, config)
	case OpS390XMOVWBRstoreidx:
		return rewriteValueS390X_OpS390XMOVWBRstoreidx(v, config)
	case OpS390XMOVWZload:
		return rewriteValueS390X_OpS390XMOVWZload(v, config)
	case OpS390XMOVWZloadidx:
		return rewriteValueS390X_OpS390XMOVWZloadidx(v, config)
	case OpS390XMOVWZreg:
		return rewriteValueS390X_OpS390XMOVWZreg(v, config)
	case OpS390XMOVWload:
		return rewriteValueS390X_OpS390XMOVWload(v, config)
	case OpS390XMOVWreg:
		return rewriteValueS390X_OpS390XMOVWreg(v, config)
	case OpS390XMOVWstore:
		return rewriteValueS390X_OpS390XMOVWstore(v, config)
	case OpS390XMOVWstoreconst:
		return rewriteValueS390X_OpS390XMOVWstoreconst(v, config)
	case OpS390XMOVWstoreidx:
		return rewriteValueS390X_OpS390XMOVWstoreidx(v, config)
	case OpS390XMULLD:
		return rewriteValueS390X_OpS390XMULLD(v, config)
	case OpS390XMULLDconst:
		return rewriteValueS390X_OpS390XMULLDconst(v, config)
	case OpS390XMULLW:
		return rewriteValueS390X_OpS390XMULLW(v, config)
	case OpS390XMULLWconst:
		return rewriteValueS390X_OpS390XMULLWconst(v, config)
	case OpS390XNEG:
		return rewriteValueS390X_OpS390XNEG(v, config)
	case OpS390XNEGW:
		return rewriteValueS390X_OpS390XNEGW(v, config)
	case OpS390XNOT:
		return rewriteValueS390X_OpS390XNOT(v, config)
	case OpS390XNOTW:
		return rewriteValueS390X_OpS390XNOTW(v, config)
	case OpS390XOR:
		return rewriteValueS390X_OpS390XOR(v, config)
	case OpS390XORW:
		return rewriteValueS390X_OpS390XORW(v, config)
	case OpS390XORWconst:
		return rewriteValueS390X_OpS390XORWconst(v, config)
	case OpS390XORconst:
		return rewriteValueS390X_OpS390XORconst(v, config)
	case OpS390XSLD:
		return rewriteValueS390X_OpS390XSLD(v, config)
	case OpS390XSLW:
		return rewriteValueS390X_OpS390XSLW(v, config)
	case OpS390XSRAD:
		return rewriteValueS390X_OpS390XSRAD(v, config)
	case OpS390XSRADconst:
		return rewriteValueS390X_OpS390XSRADconst(v, config)
	case OpS390XSRAW:
		return rewriteValueS390X_OpS390XSRAW(v, config)
	case OpS390XSRAWconst:
		return rewriteValueS390X_OpS390XSRAWconst(v, config)
	case OpS390XSRD:
		return rewriteValueS390X_OpS390XSRD(v, config)
	case OpS390XSRW:
		return rewriteValueS390X_OpS390XSRW(v, config)
	case OpS390XSTM2:
		return rewriteValueS390X_OpS390XSTM2(v, config)
	case OpS390XSTMG2:
		return rewriteValueS390X_OpS390XSTMG2(v, config)
	case OpS390XSUB:
		return rewriteValueS390X_OpS390XSUB(v, config)
	case OpS390XSUBEWcarrymask:
		return rewriteValueS390X_OpS390XSUBEWcarrymask(v, config)
	case OpS390XSUBEcarrymask:
		return rewriteValueS390X_OpS390XSUBEcarrymask(v, config)
	case OpS390XSUBW:
		return rewriteValueS390X_OpS390XSUBW(v, config)
	case OpS390XSUBWconst:
		return rewriteValueS390X_OpS390XSUBWconst(v, config)
	case OpS390XSUBconst:
		return rewriteValueS390X_OpS390XSUBconst(v, config)
	case OpS390XXOR:
		return rewriteValueS390X_OpS390XXOR(v, config)
	case OpS390XXORW:
		return rewriteValueS390X_OpS390XXORW(v, config)
	case OpS390XXORWconst:
		return rewriteValueS390X_OpS390XXORWconst(v, config)
	case OpS390XXORconst:
		return rewriteValueS390X_OpS390XXORconst(v, config)
	case OpSelect0:
		return rewriteValueS390X_OpSelect0(v, config)
	case OpSelect1:
		return rewriteValueS390X_OpSelect1(v, config)
	case OpSignExt16to32:
		return rewriteValueS390X_OpSignExt16to32(v, config)
	case OpSignExt16to64:
		return rewriteValueS390X_OpSignExt16to64(v, config)
	case OpSignExt32to64:
		return rewriteValueS390X_OpSignExt32to64(v, config)
	case OpSignExt8to16:
		return rewriteValueS390X_OpSignExt8to16(v, config)
	case OpSignExt8to32:
		return rewriteValueS390X_OpSignExt8to32(v, config)
	case OpSignExt8to64:
		return rewriteValueS390X_OpSignExt8to64(v, config)
	case OpSlicemask:
		return rewriteValueS390X_OpSlicemask(v, config)
	case OpSqrt:
		return rewriteValueS390X_OpSqrt(v, config)
	case OpStaticCall:
		return rewriteValueS390X_OpStaticCall(v, config)
	case OpStore:
		return rewriteValueS390X_OpStore(v, config)
	case OpSub16:
		return rewriteValueS390X_OpSub16(v, config)
	case OpSub32:
		return rewriteValueS390X_OpSub32(v, config)
	case OpSub32F:
		return rewriteValueS390X_OpSub32F(v, config)
	case OpSub64:
		return rewriteValueS390X_OpSub64(v, config)
	case OpSub64F:
		return rewriteValueS390X_OpSub64F(v, config)
	case OpSub8:
		return rewriteValueS390X_OpSub8(v, config)
	case OpSubPtr:
		return rewriteValueS390X_OpSubPtr(v, config)
	case OpTrunc16to8:
		return rewriteValueS390X_OpTrunc16to8(v, config)
	case OpTrunc32to16:
		return rewriteValueS390X_OpTrunc32to16(v, config)
	case OpTrunc32to8:
		return rewriteValueS390X_OpTrunc32to8(v, config)
	case OpTrunc64to16:
		return rewriteValueS390X_OpTrunc64to16(v, config)
	case OpTrunc64to32:
		return rewriteValueS390X_OpTrunc64to32(v, config)
	case OpTrunc64to8:
		return rewriteValueS390X_OpTrunc64to8(v, config)
	case OpXor16:
		return rewriteValueS390X_OpXor16(v, config)
	case OpXor32:
		return rewriteValueS390X_OpXor32(v, config)
	case OpXor64:
		return rewriteValueS390X_OpXor64(v, config)
	case OpXor8:
		return rewriteValueS390X_OpXor8(v, config)
	case OpZero:
		return rewriteValueS390X_OpZero(v, config)
	case OpZeroExt16to32:
		return rewriteValueS390X_OpZeroExt16to32(v, config)
	case OpZeroExt16to64:
		return rewriteValueS390X_OpZeroExt16to64(v, config)
	case OpZeroExt32to64:
		return rewriteValueS390X_OpZeroExt32to64(v, config)
	case OpZeroExt8to16:
		return rewriteValueS390X_OpZeroExt8to16(v, config)
	case OpZeroExt8to32:
		return rewriteValueS390X_OpZeroExt8to32(v, config)
	case OpZeroExt8to64:
		return rewriteValueS390X_OpZeroExt8to64(v, config)
	}
	return false
}
func rewriteValueS390X_OpAdd16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add16  x y)
	// cond:
	// result: (ADDW  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XADDW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpAdd32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add32  x y)
	// cond:
	// result: (ADDW  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XADDW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpAdd32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add32F x y)
	// cond:
	// result: (FADDS x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XFADDS)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpAdd64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add64  x y)
	// cond:
	// result: (ADD  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XADD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpAdd64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add64F x y)
	// cond:
	// result: (FADD x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XFADD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpAdd8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add8   x y)
	// cond:
	// result: (ADDW  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XADDW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpAddPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AddPtr x y)
	// cond:
	// result: (ADD  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XADD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpAddr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Addr {sym} base)
	// cond:
	// result: (MOVDaddr {sym} base)
	for {
		sym := v.Aux
		base := v.Args[0]
		v.reset(OpS390XMOVDaddr)
		v.Aux = sym
		v.AddArg(base)
		return true
	}
}
func rewriteValueS390X_OpAnd16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (And16 x y)
	// cond:
	// result: (ANDW x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpAnd32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (And32 x y)
	// cond:
	// result: (ANDW x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpAnd64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (And64 x y)
	// cond:
	// result: (AND x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XAND)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpAnd8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (And8  x y)
	// cond:
	// result: (ANDW x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpAndB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AndB x y)
	// cond:
	// result: (ANDW x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpAtomicAdd32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AtomicAdd32 ptr val mem)
	// cond:
	// result: (AddTupleFirst32 (LAA ptr val mem) val)
	for {
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XAddTupleFirst32)
		v0 := b.NewValue0(v.Line, OpS390XLAA, MakeTuple(config.fe.TypeUInt32(), TypeMem))
		v0.AddArg(ptr)
		v0.AddArg(val)
		v0.AddArg(mem)
		v.AddArg(v0)
		v.AddArg(val)
		return true
	}
}
func rewriteValueS390X_OpAtomicAdd64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AtomicAdd64 ptr val mem)
	// cond:
	// result: (AddTupleFirst64 (LAAG ptr val mem) val)
	for {
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XAddTupleFirst64)
		v0 := b.NewValue0(v.Line, OpS390XLAAG, MakeTuple(config.fe.TypeUInt64(), TypeMem))
		v0.AddArg(ptr)
		v0.AddArg(val)
		v0.AddArg(mem)
		v.AddArg(v0)
		v.AddArg(val)
		return true
	}
}
func rewriteValueS390X_OpAtomicCompareAndSwap32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AtomicCompareAndSwap32 ptr old new_ mem)
	// cond:
	// result: (LoweredAtomicCas32 ptr old new_ mem)
	for {
		ptr := v.Args[0]
		old := v.Args[1]
		new_ := v.Args[2]
		mem := v.Args[3]
		v.reset(OpS390XLoweredAtomicCas32)
		v.AddArg(ptr)
		v.AddArg(old)
		v.AddArg(new_)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpAtomicCompareAndSwap64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AtomicCompareAndSwap64 ptr old new_ mem)
	// cond:
	// result: (LoweredAtomicCas64 ptr old new_ mem)
	for {
		ptr := v.Args[0]
		old := v.Args[1]
		new_ := v.Args[2]
		mem := v.Args[3]
		v.reset(OpS390XLoweredAtomicCas64)
		v.AddArg(ptr)
		v.AddArg(old)
		v.AddArg(new_)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpAtomicExchange32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AtomicExchange32 ptr val mem)
	// cond:
	// result: (LoweredAtomicExchange32 ptr val mem)
	for {
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XLoweredAtomicExchange32)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpAtomicExchange64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AtomicExchange64 ptr val mem)
	// cond:
	// result: (LoweredAtomicExchange64 ptr val mem)
	for {
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XLoweredAtomicExchange64)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpAtomicLoad32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AtomicLoad32 ptr mem)
	// cond:
	// result: (MOVWZatomicload ptr mem)
	for {
		ptr := v.Args[0]
		mem := v.Args[1]
		v.reset(OpS390XMOVWZatomicload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpAtomicLoad64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AtomicLoad64 ptr mem)
	// cond:
	// result: (MOVDatomicload ptr mem)
	for {
		ptr := v.Args[0]
		mem := v.Args[1]
		v.reset(OpS390XMOVDatomicload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpAtomicLoadPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AtomicLoadPtr ptr mem)
	// cond:
	// result: (MOVDatomicload ptr mem)
	for {
		ptr := v.Args[0]
		mem := v.Args[1]
		v.reset(OpS390XMOVDatomicload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpAtomicStore32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AtomicStore32 ptr val mem)
	// cond:
	// result: (MOVWatomicstore ptr val mem)
	for {
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XMOVWatomicstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpAtomicStore64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AtomicStore64 ptr val mem)
	// cond:
	// result: (MOVDatomicstore ptr val mem)
	for {
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XMOVDatomicstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpAtomicStorePtrNoWB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AtomicStorePtrNoWB ptr val mem)
	// cond:
	// result: (MOVDatomicstore ptr val mem)
	for {
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XMOVDatomicstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpAvg64u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Avg64u <t> x y)
	// cond:
	// result: (ADD (ADD <t> (SRDconst <t> x [1]) (SRDconst <t> y [1])) (ANDconst <t> (AND <t> x y) [1]))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XADD)
		v0 := b.NewValue0(v.Line, OpS390XADD, t)
		v1 := b.NewValue0(v.Line, OpS390XSRDconst, t)
		v1.AuxInt = 1
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XSRDconst, t)
		v2.AuxInt = 1
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		v3 := b.NewValue0(v.Line, OpS390XANDconst, t)
		v3.AuxInt = 1
		v4 := b.NewValue0(v.Line, OpS390XAND, t)
		v4.AddArg(x)
		v4.AddArg(y)
		v3.AddArg(v4)
		v.AddArg(v3)
		return true
	}
}
func rewriteValueS390X_OpBswap32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Bswap32 x)
	// cond:
	// result: (MOVWBR x)
	for {
		x := v.Args[0]
		v.reset(OpS390XMOVWBR)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpBswap64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Bswap64 x)
	// cond:
	// result: (MOVDBR x)
	for {
		x := v.Args[0]
		v.reset(OpS390XMOVDBR)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpClosureCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ClosureCall [argwid] entry closure mem)
	// cond:
	// result: (CALLclosure [argwid] entry closure mem)
	for {
		argwid := v.AuxInt
		entry := v.Args[0]
		closure := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XCALLclosure)
		v.AuxInt = argwid
		v.AddArg(entry)
		v.AddArg(closure)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpCom16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Com16 x)
	// cond:
	// result: (NOTW x)
	for {
		x := v.Args[0]
		v.reset(OpS390XNOTW)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpCom32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Com32 x)
	// cond:
	// result: (NOTW x)
	for {
		x := v.Args[0]
		v.reset(OpS390XNOTW)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpCom64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Com64 x)
	// cond:
	// result: (NOT x)
	for {
		x := v.Args[0]
		v.reset(OpS390XNOT)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpCom8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Com8  x)
	// cond:
	// result: (NOTW x)
	for {
		x := v.Args[0]
		v.reset(OpS390XNOTW)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpConst16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const16  [val])
	// cond:
	// result: (MOVDconst [val])
	for {
		val := v.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValueS390X_OpConst32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const32  [val])
	// cond:
	// result: (MOVDconst [val])
	for {
		val := v.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValueS390X_OpConst32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const32F [val])
	// cond:
	// result: (FMOVSconst [val])
	for {
		val := v.AuxInt
		v.reset(OpS390XFMOVSconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValueS390X_OpConst64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const64  [val])
	// cond:
	// result: (MOVDconst [val])
	for {
		val := v.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValueS390X_OpConst64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const64F [val])
	// cond:
	// result: (FMOVDconst [val])
	for {
		val := v.AuxInt
		v.reset(OpS390XFMOVDconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValueS390X_OpConst8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const8   [val])
	// cond:
	// result: (MOVDconst [val])
	for {
		val := v.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValueS390X_OpConstBool(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ConstBool [b])
	// cond:
	// result: (MOVDconst [b])
	for {
		b := v.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = b
		return true
	}
}
func rewriteValueS390X_OpConstNil(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ConstNil)
	// cond:
	// result: (MOVDconst [0])
	for {
		v.reset(OpS390XMOVDconst)
		v.AuxInt = 0
		return true
	}
}
func rewriteValueS390X_OpConvert(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Convert <t> x mem)
	// cond:
	// result: (MOVDconvert <t> x mem)
	for {
		t := v.Type
		x := v.Args[0]
		mem := v.Args[1]
		v.reset(OpS390XMOVDconvert)
		v.Type = t
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpCtz32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Ctz32 <t> x)
	// cond:
	// result: (SUB (MOVDconst [64]) (FLOGR (MOVWZreg (ANDW <t> (SUBWconst <t> [1] x) (NOTW <t> x)))))
	for {
		t := v.Type
		x := v.Args[0]
		v.reset(OpS390XSUB)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 64
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XFLOGR, config.fe.TypeUInt64())
		v2 := b.NewValue0(v.Line, OpS390XMOVWZreg, config.fe.TypeUInt64())
		v3 := b.NewValue0(v.Line, OpS390XANDW, t)
		v4 := b.NewValue0(v.Line, OpS390XSUBWconst, t)
		v4.AuxInt = 1
		v4.AddArg(x)
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpS390XNOTW, t)
		v5.AddArg(x)
		v3.AddArg(v5)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpCtz64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Ctz64 <t> x)
	// cond:
	// result: (SUB (MOVDconst [64]) (FLOGR (AND <t> (SUBconst <t> [1] x) (NOT <t> x))))
	for {
		t := v.Type
		x := v.Args[0]
		v.reset(OpS390XSUB)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 64
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XFLOGR, config.fe.TypeUInt64())
		v2 := b.NewValue0(v.Line, OpS390XAND, t)
		v3 := b.NewValue0(v.Line, OpS390XSUBconst, t)
		v3.AuxInt = 1
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XNOT, t)
		v4.AddArg(x)
		v2.AddArg(v4)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpCvt32Fto32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt32Fto32 x)
	// cond:
	// result: (CFEBRA x)
	for {
		x := v.Args[0]
		v.reset(OpS390XCFEBRA)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpCvt32Fto64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt32Fto64 x)
	// cond:
	// result: (CGEBRA x)
	for {
		x := v.Args[0]
		v.reset(OpS390XCGEBRA)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpCvt32Fto64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt32Fto64F x)
	// cond:
	// result: (LDEBR x)
	for {
		x := v.Args[0]
		v.reset(OpS390XLDEBR)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpCvt32to32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt32to32F x)
	// cond:
	// result: (CEFBRA x)
	for {
		x := v.Args[0]
		v.reset(OpS390XCEFBRA)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpCvt32to64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt32to64F x)
	// cond:
	// result: (CDFBRA x)
	for {
		x := v.Args[0]
		v.reset(OpS390XCDFBRA)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpCvt64Fto32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt64Fto32 x)
	// cond:
	// result: (CFDBRA x)
	for {
		x := v.Args[0]
		v.reset(OpS390XCFDBRA)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpCvt64Fto32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt64Fto32F x)
	// cond:
	// result: (LEDBR x)
	for {
		x := v.Args[0]
		v.reset(OpS390XLEDBR)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpCvt64Fto64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt64Fto64 x)
	// cond:
	// result: (CGDBRA x)
	for {
		x := v.Args[0]
		v.reset(OpS390XCGDBRA)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpCvt64to32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt64to32F x)
	// cond:
	// result: (CEGBRA x)
	for {
		x := v.Args[0]
		v.reset(OpS390XCEGBRA)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpCvt64to64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt64to64F x)
	// cond:
	// result: (CDGBRA x)
	for {
		x := v.Args[0]
		v.reset(OpS390XCDGBRA)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpDeferCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (DeferCall [argwid] mem)
	// cond:
	// result: (CALLdefer [argwid] mem)
	for {
		argwid := v.AuxInt
		mem := v.Args[0]
		v.reset(OpS390XCALLdefer)
		v.AuxInt = argwid
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpDiv16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div16  x y)
	// cond:
	// result: (DIVW  (MOVHreg x) (MOVHreg y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XDIVW)
		v0 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpDiv16u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div16u x y)
	// cond:
	// result: (DIVWU (MOVHZreg x) (MOVHZreg y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XDIVWU)
		v0 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpDiv32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div32  x y)
	// cond:
	// result: (DIVW  (MOVWreg x) y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XDIVW)
		v0 := b.NewValue0(v.Line, OpS390XMOVWreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpDiv32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div32F x y)
	// cond:
	// result: (FDIVS x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XFDIVS)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpDiv32u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div32u x y)
	// cond:
	// result: (DIVWU (MOVWZreg x) y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XDIVWU)
		v0 := b.NewValue0(v.Line, OpS390XMOVWZreg, config.fe.TypeUInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpDiv64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div64  x y)
	// cond:
	// result: (DIVD  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XDIVD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpDiv64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div64F x y)
	// cond:
	// result: (FDIV x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XFDIV)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpDiv64u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div64u x y)
	// cond:
	// result: (DIVDU x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XDIVDU)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpDiv8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div8   x y)
	// cond:
	// result: (DIVW  (MOVBreg x) (MOVBreg y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XDIVW)
		v0 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpDiv8u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div8u  x y)
	// cond:
	// result: (DIVWU (MOVBZreg x) (MOVBZreg y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XDIVWU)
		v0 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpEq16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq16  x y)
	// cond:
	// result: (MOVDEQ (MOVDconst [0]) (MOVDconst [1]) (CMP (MOVHreg x) (MOVHreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDEQ)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpEq32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq32  x y)
	// cond:
	// result: (MOVDEQ (MOVDconst [0]) (MOVDconst [1]) (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDEQ)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPW, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpEq32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq32F x y)
	// cond:
	// result: (MOVDEQ (MOVDconst [0]) (MOVDconst [1]) (FCMPS x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDEQ)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XFCMPS, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpEq64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq64  x y)
	// cond:
	// result: (MOVDEQ (MOVDconst [0]) (MOVDconst [1]) (CMP x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDEQ)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpEq64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq64F x y)
	// cond:
	// result: (MOVDEQ (MOVDconst [0]) (MOVDconst [1]) (FCMP x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDEQ)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XFCMP, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpEq8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq8   x y)
	// cond:
	// result: (MOVDEQ (MOVDconst [0]) (MOVDconst [1]) (CMP (MOVBreg x) (MOVBreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDEQ)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpEqB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (EqB   x y)
	// cond:
	// result: (MOVDEQ (MOVDconst [0]) (MOVDconst [1]) (CMP (MOVBreg x) (MOVBreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDEQ)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpEqPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (EqPtr x y)
	// cond:
	// result: (MOVDEQ (MOVDconst [0]) (MOVDconst [1]) (CMP x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDEQ)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGeq16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq16  x y)
	// cond:
	// result: (MOVDGE (MOVDconst [0]) (MOVDconst [1]) (CMP (MOVHreg x) (MOVHreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGeq16U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq16U x y)
	// cond:
	// result: (MOVDGE (MOVDconst [0]) (MOVDconst [1]) (CMPU (MOVHZreg x) (MOVHZreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPU, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGeq32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq32  x y)
	// cond:
	// result: (MOVDGE (MOVDconst [0]) (MOVDconst [1]) (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPW, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGeq32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq32F x y)
	// cond:
	// result: (MOVDGEnoinv (MOVDconst [0]) (MOVDconst [1]) (FCMPS x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGEnoinv)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XFCMPS, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGeq32U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq32U x y)
	// cond:
	// result: (MOVDGE (MOVDconst [0]) (MOVDconst [1]) (CMPWU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPWU, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGeq64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq64  x y)
	// cond:
	// result: (MOVDGE (MOVDconst [0]) (MOVDconst [1]) (CMP x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGeq64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq64F x y)
	// cond:
	// result: (MOVDGEnoinv (MOVDconst [0]) (MOVDconst [1]) (FCMP x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGEnoinv)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XFCMP, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGeq64U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq64U x y)
	// cond:
	// result: (MOVDGE (MOVDconst [0]) (MOVDconst [1]) (CMPU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPU, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGeq8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq8   x y)
	// cond:
	// result: (MOVDGE (MOVDconst [0]) (MOVDconst [1]) (CMP (MOVBreg x) (MOVBreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGeq8U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq8U  x y)
	// cond:
	// result: (MOVDGE (MOVDconst [0]) (MOVDconst [1]) (CMPU (MOVBZreg x) (MOVBZreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPU, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGetClosurePtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (GetClosurePtr)
	// cond:
	// result: (LoweredGetClosurePtr)
	for {
		v.reset(OpS390XLoweredGetClosurePtr)
		return true
	}
}
func rewriteValueS390X_OpGetG(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (GetG mem)
	// cond:
	// result: (LoweredGetG mem)
	for {
		mem := v.Args[0]
		v.reset(OpS390XLoweredGetG)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpGoCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (GoCall [argwid] mem)
	// cond:
	// result: (CALLgo [argwid] mem)
	for {
		argwid := v.AuxInt
		mem := v.Args[0]
		v.reset(OpS390XCALLgo)
		v.AuxInt = argwid
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpGreater16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater16  x y)
	// cond:
	// result: (MOVDGT (MOVDconst [0]) (MOVDconst [1]) (CMP (MOVHreg x) (MOVHreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGreater16U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater16U x y)
	// cond:
	// result: (MOVDGT (MOVDconst [0]) (MOVDconst [1]) (CMPU (MOVHZreg x) (MOVHZreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPU, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGreater32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater32  x y)
	// cond:
	// result: (MOVDGT (MOVDconst [0]) (MOVDconst [1]) (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPW, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGreater32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater32F x y)
	// cond:
	// result: (MOVDGTnoinv (MOVDconst [0]) (MOVDconst [1]) (FCMPS x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGTnoinv)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XFCMPS, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGreater32U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater32U x y)
	// cond:
	// result: (MOVDGT (MOVDconst [0]) (MOVDconst [1]) (CMPWU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPWU, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGreater64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater64  x y)
	// cond:
	// result: (MOVDGT (MOVDconst [0]) (MOVDconst [1]) (CMP x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGreater64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater64F x y)
	// cond:
	// result: (MOVDGTnoinv (MOVDconst [0]) (MOVDconst [1]) (FCMP x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGTnoinv)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XFCMP, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGreater64U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater64U x y)
	// cond:
	// result: (MOVDGT (MOVDconst [0]) (MOVDconst [1]) (CMPU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPU, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGreater8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater8   x y)
	// cond:
	// result: (MOVDGT (MOVDconst [0]) (MOVDconst [1]) (CMP (MOVBreg x) (MOVBreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpGreater8U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater8U  x y)
	// cond:
	// result: (MOVDGT (MOVDconst [0]) (MOVDconst [1]) (CMPU (MOVBZreg x) (MOVBZreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPU, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpHmul16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul16  x y)
	// cond:
	// result: (SRDconst [16] (MULLW (MOVHreg x) (MOVHreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRDconst)
		v.AuxInt = 16
		v0 := b.NewValue0(v.Line, OpS390XMULLW, config.fe.TypeInt32())
		v1 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpHmul16u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul16u x y)
	// cond:
	// result: (SRDconst [16] (MULLW (MOVHZreg x) (MOVHZreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRDconst)
		v.AuxInt = 16
		v0 := b.NewValue0(v.Line, OpS390XMULLW, config.fe.TypeInt32())
		v1 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpHmul32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul32  x y)
	// cond:
	// result: (SRDconst [32] (MULLD (MOVWreg x) (MOVWreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRDconst)
		v.AuxInt = 32
		v0 := b.NewValue0(v.Line, OpS390XMULLD, config.fe.TypeInt64())
		v1 := b.NewValue0(v.Line, OpS390XMOVWreg, config.fe.TypeInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XMOVWreg, config.fe.TypeInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpHmul32u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul32u x y)
	// cond:
	// result: (SRDconst [32] (MULLD (MOVWZreg x) (MOVWZreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRDconst)
		v.AuxInt = 32
		v0 := b.NewValue0(v.Line, OpS390XMULLD, config.fe.TypeInt64())
		v1 := b.NewValue0(v.Line, OpS390XMOVWZreg, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XMOVWZreg, config.fe.TypeUInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpHmul64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul64  x y)
	// cond:
	// result: (MULHD  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMULHD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpHmul64u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul64u x y)
	// cond:
	// result: (MULHDU x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMULHDU)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpHmul8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul8   x y)
	// cond:
	// result: (SRDconst [8] (MULLW (MOVBreg x) (MOVBreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRDconst)
		v.AuxInt = 8
		v0 := b.NewValue0(v.Line, OpS390XMULLW, config.fe.TypeInt32())
		v1 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpHmul8u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul8u  x y)
	// cond:
	// result: (SRDconst [8] (MULLW (MOVBZreg x) (MOVBZreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRDconst)
		v.AuxInt = 8
		v0 := b.NewValue0(v.Line, OpS390XMULLW, config.fe.TypeInt32())
		v1 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpITab(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ITab (Load ptr mem))
	// cond:
	// result: (MOVDload ptr mem)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpLoad {
			break
		}
		ptr := v_0.Args[0]
		mem := v_0.Args[1]
		v.reset(OpS390XMOVDload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpInterCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (InterCall [argwid] entry mem)
	// cond:
	// result: (CALLinter [argwid] entry mem)
	for {
		argwid := v.AuxInt
		entry := v.Args[0]
		mem := v.Args[1]
		v.reset(OpS390XCALLinter)
		v.AuxInt = argwid
		v.AddArg(entry)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpIsInBounds(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (IsInBounds idx len)
	// cond:
	// result: (MOVDLT (MOVDconst [0]) (MOVDconst [1]) (CMPU idx len))
	for {
		idx := v.Args[0]
		len := v.Args[1]
		v.reset(OpS390XMOVDLT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPU, TypeFlags)
		v2.AddArg(idx)
		v2.AddArg(len)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpIsNonNil(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (IsNonNil p)
	// cond:
	// result: (MOVDNE (MOVDconst [0]) (MOVDconst [1]) (CMPconst p [0]))
	for {
		p := v.Args[0]
		v.reset(OpS390XMOVDNE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPconst, TypeFlags)
		v2.AuxInt = 0
		v2.AddArg(p)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpIsSliceInBounds(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (IsSliceInBounds idx len)
	// cond:
	// result: (MOVDLE (MOVDconst [0]) (MOVDconst [1]) (CMPU idx len))
	for {
		idx := v.Args[0]
		len := v.Args[1]
		v.reset(OpS390XMOVDLE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPU, TypeFlags)
		v2.AddArg(idx)
		v2.AddArg(len)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLeq16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq16  x y)
	// cond:
	// result: (MOVDLE (MOVDconst [0]) (MOVDconst [1]) (CMP (MOVHreg x) (MOVHreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLeq16U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq16U x y)
	// cond:
	// result: (MOVDLE (MOVDconst [0]) (MOVDconst [1]) (CMPU (MOVHZreg x) (MOVHZreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPU, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLeq32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq32  x y)
	// cond:
	// result: (MOVDLE (MOVDconst [0]) (MOVDconst [1]) (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPW, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLeq32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq32F x y)
	// cond:
	// result: (MOVDGEnoinv (MOVDconst [0]) (MOVDconst [1]) (FCMPS y x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGEnoinv)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XFCMPS, TypeFlags)
		v2.AddArg(y)
		v2.AddArg(x)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLeq32U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq32U x y)
	// cond:
	// result: (MOVDLE (MOVDconst [0]) (MOVDconst [1]) (CMPWU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPWU, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLeq64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq64  x y)
	// cond:
	// result: (MOVDLE (MOVDconst [0]) (MOVDconst [1]) (CMP x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLeq64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq64F x y)
	// cond:
	// result: (MOVDGEnoinv (MOVDconst [0]) (MOVDconst [1]) (FCMP y x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGEnoinv)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XFCMP, TypeFlags)
		v2.AddArg(y)
		v2.AddArg(x)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLeq64U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq64U x y)
	// cond:
	// result: (MOVDLE (MOVDconst [0]) (MOVDconst [1]) (CMPU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPU, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLeq8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq8   x y)
	// cond:
	// result: (MOVDLE (MOVDconst [0]) (MOVDconst [1]) (CMP (MOVBreg x) (MOVBreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLeq8U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq8U  x y)
	// cond:
	// result: (MOVDLE (MOVDconst [0]) (MOVDconst [1]) (CMPU (MOVBZreg x) (MOVBZreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPU, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLess16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less16  x y)
	// cond:
	// result: (MOVDLT (MOVDconst [0]) (MOVDconst [1]) (CMP (MOVHreg x) (MOVHreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLess16U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less16U x y)
	// cond:
	// result: (MOVDLT (MOVDconst [0]) (MOVDconst [1]) (CMPU (MOVHZreg x) (MOVHZreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPU, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLess32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less32  x y)
	// cond:
	// result: (MOVDLT (MOVDconst [0]) (MOVDconst [1]) (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPW, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLess32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less32F x y)
	// cond:
	// result: (MOVDGTnoinv (MOVDconst [0]) (MOVDconst [1]) (FCMPS y x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGTnoinv)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XFCMPS, TypeFlags)
		v2.AddArg(y)
		v2.AddArg(x)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLess32U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less32U x y)
	// cond:
	// result: (MOVDLT (MOVDconst [0]) (MOVDconst [1]) (CMPWU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPWU, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLess64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less64  x y)
	// cond:
	// result: (MOVDLT (MOVDconst [0]) (MOVDconst [1]) (CMP x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLess64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less64F x y)
	// cond:
	// result: (MOVDGTnoinv (MOVDconst [0]) (MOVDconst [1]) (FCMP y x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDGTnoinv)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XFCMP, TypeFlags)
		v2.AddArg(y)
		v2.AddArg(x)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLess64U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less64U x y)
	// cond:
	// result: (MOVDLT (MOVDconst [0]) (MOVDconst [1]) (CMPU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPU, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLess8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less8   x y)
	// cond:
	// result: (MOVDLT (MOVDconst [0]) (MOVDconst [1]) (CMP (MOVBreg x) (MOVBreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLess8U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less8U  x y)
	// cond:
	// result: (MOVDLT (MOVDconst [0]) (MOVDconst [1]) (CMPU (MOVBZreg x) (MOVBZreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDLT)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPU, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpLoad(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Load <t> ptr mem)
	// cond: (is64BitInt(t) || isPtr(t))
	// result: (MOVDload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is64BitInt(t) || isPtr(t)) {
			break
		}
		v.reset(OpS390XMOVDload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: is32BitInt(t) && isSigned(t)
	// result: (MOVWload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is32BitInt(t) && isSigned(t)) {
			break
		}
		v.reset(OpS390XMOVWload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: is32BitInt(t) && !isSigned(t)
	// result: (MOVWZload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is32BitInt(t) && !isSigned(t)) {
			break
		}
		v.reset(OpS390XMOVWZload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: is16BitInt(t) && isSigned(t)
	// result: (MOVHload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is16BitInt(t) && isSigned(t)) {
			break
		}
		v.reset(OpS390XMOVHload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: is16BitInt(t) && !isSigned(t)
	// result: (MOVHZload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is16BitInt(t) && !isSigned(t)) {
			break
		}
		v.reset(OpS390XMOVHZload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: is8BitInt(t) && isSigned(t)
	// result: (MOVBload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is8BitInt(t) && isSigned(t)) {
			break
		}
		v.reset(OpS390XMOVBload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: (t.IsBoolean() || (is8BitInt(t) && !isSigned(t)))
	// result: (MOVBZload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(t.IsBoolean() || (is8BitInt(t) && !isSigned(t))) {
			break
		}
		v.reset(OpS390XMOVBZload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: is32BitFloat(t)
	// result: (FMOVSload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is32BitFloat(t)) {
			break
		}
		v.reset(OpS390XFMOVSload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: is64BitFloat(t)
	// result: (FMOVDload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is64BitFloat(t)) {
			break
		}
		v.reset(OpS390XFMOVDload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpLrot32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lrot32 <t> x [c])
	// cond:
	// result: (RLLconst <t> [c&31] x)
	for {
		t := v.Type
		c := v.AuxInt
		x := v.Args[0]
		v.reset(OpS390XRLLconst)
		v.Type = t
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpLrot64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lrot64 <t> x [c])
	// cond:
	// result: (RLLGconst <t> [c&63] x)
	for {
		t := v.Type
		c := v.AuxInt
		x := v.Args[0]
		v.reset(OpS390XRLLGconst)
		v.Type = t
		v.AuxInt = c & 63
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpLsh16x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh16x16 <t> x y)
	// cond:
	// result: (ANDW (SLW <t> x y) (SUBEWcarrymask <t> (CMPWUconst (MOVHZreg y) [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSLW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 31
		v3 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh16x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh16x32 <t> x y)
	// cond:
	// result: (ANDW (SLW <t> x y) (SUBEWcarrymask <t> (CMPWUconst y [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSLW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 31
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh16x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh16x64 <t> x y)
	// cond:
	// result: (ANDW (SLW <t> x y) (SUBEWcarrymask <t> (CMPUconst y [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSLW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPUconst, TypeFlags)
		v2.AuxInt = 31
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh16x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh16x8  <t> x y)
	// cond:
	// result: (ANDW (SLW <t> x y) (SUBEWcarrymask <t> (CMPWUconst (MOVBZreg y) [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSLW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 31
		v3 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh32x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh32x16 <t> x y)
	// cond:
	// result: (ANDW (SLW <t> x y) (SUBEWcarrymask <t> (CMPWUconst (MOVHZreg y) [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSLW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 31
		v3 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh32x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh32x32 <t> x y)
	// cond:
	// result: (ANDW (SLW <t> x y) (SUBEWcarrymask <t> (CMPWUconst y [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSLW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 31
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh32x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh32x64 <t> x y)
	// cond:
	// result: (ANDW (SLW <t> x y) (SUBEWcarrymask <t> (CMPUconst y [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSLW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPUconst, TypeFlags)
		v2.AuxInt = 31
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh32x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh32x8  <t> x y)
	// cond:
	// result: (ANDW (SLW <t> x y) (SUBEWcarrymask <t> (CMPWUconst (MOVBZreg y) [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSLW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 31
		v3 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh64x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh64x16 <t> x y)
	// cond:
	// result: (AND (SLD <t> x y) (SUBEcarrymask <t> (CMPWUconst (MOVHZreg y) [63])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XAND)
		v0 := b.NewValue0(v.Line, OpS390XSLD, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 63
		v3 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh64x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh64x32 <t> x y)
	// cond:
	// result: (AND (SLD <t> x y) (SUBEcarrymask <t> (CMPWUconst y [63])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XAND)
		v0 := b.NewValue0(v.Line, OpS390XSLD, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 63
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh64x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh64x64 <t> x y)
	// cond:
	// result: (AND (SLD <t> x y) (SUBEcarrymask <t> (CMPUconst y [63])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XAND)
		v0 := b.NewValue0(v.Line, OpS390XSLD, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPUconst, TypeFlags)
		v2.AuxInt = 63
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh64x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh64x8  <t> x y)
	// cond:
	// result: (AND (SLD <t> x y) (SUBEcarrymask <t> (CMPWUconst (MOVBZreg y) [63])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XAND)
		v0 := b.NewValue0(v.Line, OpS390XSLD, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 63
		v3 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh8x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh8x16 <t> x y)
	// cond:
	// result: (ANDW (SLW <t> x y) (SUBEWcarrymask <t> (CMPWUconst (MOVHZreg y) [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSLW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 31
		v3 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh8x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh8x32 <t> x y)
	// cond:
	// result: (ANDW (SLW <t> x y) (SUBEWcarrymask <t> (CMPWUconst y [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSLW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 31
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh8x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh8x64 <t> x y)
	// cond:
	// result: (ANDW (SLW <t> x y) (SUBEWcarrymask <t> (CMPUconst y [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSLW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPUconst, TypeFlags)
		v2.AuxInt = 31
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpLsh8x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh8x8  <t> x y)
	// cond:
	// result: (ANDW (SLW <t> x y) (SUBEWcarrymask <t> (CMPWUconst (MOVBZreg y) [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSLW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 31
		v3 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpMod16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod16  x y)
	// cond:
	// result: (MODW  (MOVHreg x) (MOVHreg y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMODW)
		v0 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpMod16u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod16u x y)
	// cond:
	// result: (MODWU (MOVHZreg x) (MOVHZreg y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMODWU)
		v0 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpMod32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod32  x y)
	// cond:
	// result: (MODW  (MOVWreg x) y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMODW)
		v0 := b.NewValue0(v.Line, OpS390XMOVWreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpMod32u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod32u x y)
	// cond:
	// result: (MODWU (MOVWZreg x) y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMODWU)
		v0 := b.NewValue0(v.Line, OpS390XMOVWZreg, config.fe.TypeUInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpMod64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod64  x y)
	// cond:
	// result: (MODD  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMODD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpMod64u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod64u x y)
	// cond:
	// result: (MODDU x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMODDU)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpMod8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod8   x y)
	// cond:
	// result: (MODW  (MOVBreg x) (MOVBreg y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMODW)
		v0 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpMod8u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod8u  x y)
	// cond:
	// result: (MODWU (MOVBZreg x) (MOVBZreg y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMODWU)
		v0 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpMove(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Move [s] _ _ mem)
	// cond: SizeAndAlign(s).Size() == 0
	// result: mem
	for {
		s := v.AuxInt
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 0) {
			break
		}
		v.reset(OpCopy)
		v.Type = mem.Type
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 1
	// result: (MOVBstore dst (MOVBZload src mem) mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 1) {
			break
		}
		v.reset(OpS390XMOVBstore)
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpS390XMOVBZload, config.fe.TypeUInt8())
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 2
	// result: (MOVHstore dst (MOVHZload src mem) mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 2) {
			break
		}
		v.reset(OpS390XMOVHstore)
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpS390XMOVHZload, config.fe.TypeUInt16())
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 4
	// result: (MOVWstore dst (MOVWZload src mem) mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 4) {
			break
		}
		v.reset(OpS390XMOVWstore)
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpS390XMOVWZload, config.fe.TypeUInt32())
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 8
	// result: (MOVDstore dst (MOVDload src mem) mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 8) {
			break
		}
		v.reset(OpS390XMOVDstore)
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpS390XMOVDload, config.fe.TypeUInt64())
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 16
	// result: (MOVDstore [8] dst (MOVDload [8] src mem) 		(MOVDstore dst (MOVDload src mem) mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 16) {
			break
		}
		v.reset(OpS390XMOVDstore)
		v.AuxInt = 8
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpS390XMOVDload, config.fe.TypeUInt64())
		v0.AuxInt = 8
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDstore, TypeMem)
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpS390XMOVDload, config.fe.TypeUInt64())
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 24
	// result: (MOVDstore [16] dst (MOVDload [16] src mem) 	        (MOVDstore [8] dst (MOVDload [8] src mem)                 (MOVDstore dst (MOVDload src mem) mem)))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 24) {
			break
		}
		v.reset(OpS390XMOVDstore)
		v.AuxInt = 16
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpS390XMOVDload, config.fe.TypeUInt64())
		v0.AuxInt = 16
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDstore, TypeMem)
		v1.AuxInt = 8
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpS390XMOVDload, config.fe.TypeUInt64())
		v2.AuxInt = 8
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpS390XMOVDstore, TypeMem)
		v3.AddArg(dst)
		v4 := b.NewValue0(v.Line, OpS390XMOVDload, config.fe.TypeUInt64())
		v4.AddArg(src)
		v4.AddArg(mem)
		v3.AddArg(v4)
		v3.AddArg(mem)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 3
	// result: (MOVBstore [2] dst (MOVBZload [2] src mem) 		(MOVHstore dst (MOVHZload src mem) mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 3) {
			break
		}
		v.reset(OpS390XMOVBstore)
		v.AuxInt = 2
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpS390XMOVBZload, config.fe.TypeUInt8())
		v0.AuxInt = 2
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVHstore, TypeMem)
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpS390XMOVHZload, config.fe.TypeUInt16())
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 5
	// result: (MOVBstore [4] dst (MOVBZload [4] src mem) 		(MOVWstore dst (MOVWZload src mem) mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 5) {
			break
		}
		v.reset(OpS390XMOVBstore)
		v.AuxInt = 4
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpS390XMOVBZload, config.fe.TypeUInt8())
		v0.AuxInt = 4
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVWstore, TypeMem)
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpS390XMOVWZload, config.fe.TypeUInt32())
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 6
	// result: (MOVHstore [4] dst (MOVHZload [4] src mem) 		(MOVWstore dst (MOVWZload src mem) mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 6) {
			break
		}
		v.reset(OpS390XMOVHstore)
		v.AuxInt = 4
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpS390XMOVHZload, config.fe.TypeUInt16())
		v0.AuxInt = 4
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVWstore, TypeMem)
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpS390XMOVWZload, config.fe.TypeUInt32())
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 7
	// result: (MOVBstore [6] dst (MOVBZload [6] src mem) 		(MOVHstore [4] dst (MOVHZload [4] src mem) 			(MOVWstore dst (MOVWZload src mem) mem)))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 7) {
			break
		}
		v.reset(OpS390XMOVBstore)
		v.AuxInt = 6
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpS390XMOVBZload, config.fe.TypeUInt8())
		v0.AuxInt = 6
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVHstore, TypeMem)
		v1.AuxInt = 4
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpS390XMOVHZload, config.fe.TypeUInt16())
		v2.AuxInt = 4
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpS390XMOVWstore, TypeMem)
		v3.AddArg(dst)
		v4 := b.NewValue0(v.Line, OpS390XMOVWZload, config.fe.TypeUInt32())
		v4.AddArg(src)
		v4.AddArg(mem)
		v3.AddArg(v4)
		v3.AddArg(mem)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() > 0 && SizeAndAlign(s).Size() <= 256
	// result: (MVC [makeValAndOff(SizeAndAlign(s).Size(), 0)] dst src mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() > 0 && SizeAndAlign(s).Size() <= 256) {
			break
		}
		v.reset(OpS390XMVC)
		v.AuxInt = makeValAndOff(SizeAndAlign(s).Size(), 0)
		v.AddArg(dst)
		v.AddArg(src)
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() > 256 && SizeAndAlign(s).Size() <= 512
	// result: (MVC [makeValAndOff(SizeAndAlign(s).Size()-256, 256)] dst src (MVC [makeValAndOff(256, 0)] dst src mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() > 256 && SizeAndAlign(s).Size() <= 512) {
			break
		}
		v.reset(OpS390XMVC)
		v.AuxInt = makeValAndOff(SizeAndAlign(s).Size()-256, 256)
		v.AddArg(dst)
		v.AddArg(src)
		v0 := b.NewValue0(v.Line, OpS390XMVC, TypeMem)
		v0.AuxInt = makeValAndOff(256, 0)
		v0.AddArg(dst)
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() > 512 && SizeAndAlign(s).Size() <= 768
	// result: (MVC [makeValAndOff(SizeAndAlign(s).Size()-512, 512)] dst src (MVC [makeValAndOff(256, 256)] dst src (MVC [makeValAndOff(256, 0)] dst src mem)))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() > 512 && SizeAndAlign(s).Size() <= 768) {
			break
		}
		v.reset(OpS390XMVC)
		v.AuxInt = makeValAndOff(SizeAndAlign(s).Size()-512, 512)
		v.AddArg(dst)
		v.AddArg(src)
		v0 := b.NewValue0(v.Line, OpS390XMVC, TypeMem)
		v0.AuxInt = makeValAndOff(256, 256)
		v0.AddArg(dst)
		v0.AddArg(src)
		v1 := b.NewValue0(v.Line, OpS390XMVC, TypeMem)
		v1.AuxInt = makeValAndOff(256, 0)
		v1.AddArg(dst)
		v1.AddArg(src)
		v1.AddArg(mem)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() > 768 && SizeAndAlign(s).Size() <= 1024
	// result: (MVC [makeValAndOff(SizeAndAlign(s).Size()-768, 768)] dst src (MVC [makeValAndOff(256, 512)] dst src (MVC [makeValAndOff(256, 256)] dst src (MVC [makeValAndOff(256, 0)] dst src mem))))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() > 768 && SizeAndAlign(s).Size() <= 1024) {
			break
		}
		v.reset(OpS390XMVC)
		v.AuxInt = makeValAndOff(SizeAndAlign(s).Size()-768, 768)
		v.AddArg(dst)
		v.AddArg(src)
		v0 := b.NewValue0(v.Line, OpS390XMVC, TypeMem)
		v0.AuxInt = makeValAndOff(256, 512)
		v0.AddArg(dst)
		v0.AddArg(src)
		v1 := b.NewValue0(v.Line, OpS390XMVC, TypeMem)
		v1.AuxInt = makeValAndOff(256, 256)
		v1.AddArg(dst)
		v1.AddArg(src)
		v2 := b.NewValue0(v.Line, OpS390XMVC, TypeMem)
		v2.AuxInt = makeValAndOff(256, 0)
		v2.AddArg(dst)
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() > 1024
	// result: (LoweredMove [SizeAndAlign(s).Size()%256] dst src (ADDconst <src.Type> src [(SizeAndAlign(s).Size()/256)*256]) mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() > 1024) {
			break
		}
		v.reset(OpS390XLoweredMove)
		v.AuxInt = SizeAndAlign(s).Size() % 256
		v.AddArg(dst)
		v.AddArg(src)
		v0 := b.NewValue0(v.Line, OpS390XADDconst, src.Type)
		v0.AuxInt = (SizeAndAlign(s).Size() / 256) * 256
		v0.AddArg(src)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpMul16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul16  x y)
	// cond:
	// result: (MULLW  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMULLW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpMul32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul32  x y)
	// cond:
	// result: (MULLW  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMULLW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpMul32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul32F x y)
	// cond:
	// result: (FMULS x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XFMULS)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpMul64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul64  x y)
	// cond:
	// result: (MULLD  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMULLD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpMul64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul64F x y)
	// cond:
	// result: (FMUL x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XFMUL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpMul8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul8   x y)
	// cond:
	// result: (MULLW  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMULLW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpNeg16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg16  x)
	// cond:
	// result: (NEGW (MOVHreg x))
	for {
		x := v.Args[0]
		v.reset(OpS390XNEGW)
		v0 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpNeg32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg32  x)
	// cond:
	// result: (NEGW x)
	for {
		x := v.Args[0]
		v.reset(OpS390XNEGW)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpNeg32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg32F x)
	// cond:
	// result: (FNEGS x)
	for {
		x := v.Args[0]
		v.reset(OpS390XFNEGS)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpNeg64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg64  x)
	// cond:
	// result: (NEG x)
	for {
		x := v.Args[0]
		v.reset(OpS390XNEG)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpNeg64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg64F x)
	// cond:
	// result: (FNEG x)
	for {
		x := v.Args[0]
		v.reset(OpS390XFNEG)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpNeg8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg8   x)
	// cond:
	// result: (NEGW (MOVBreg x))
	for {
		x := v.Args[0]
		v.reset(OpS390XNEGW)
		v0 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpNeq16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq16  x y)
	// cond:
	// result: (MOVDNE (MOVDconst [0]) (MOVDconst [1]) (CMP (MOVHreg x) (MOVHreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDNE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpNeq32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq32  x y)
	// cond:
	// result: (MOVDNE (MOVDconst [0]) (MOVDconst [1]) (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDNE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMPW, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpNeq32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq32F x y)
	// cond:
	// result: (MOVDNE (MOVDconst [0]) (MOVDconst [1]) (FCMPS x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDNE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XFCMPS, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpNeq64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq64  x y)
	// cond:
	// result: (MOVDNE (MOVDconst [0]) (MOVDconst [1]) (CMP x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDNE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpNeq64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq64F x y)
	// cond:
	// result: (MOVDNE (MOVDconst [0]) (MOVDconst [1]) (FCMP x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDNE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XFCMP, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpNeq8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq8   x y)
	// cond:
	// result: (MOVDNE (MOVDconst [0]) (MOVDconst [1]) (CMP (MOVBreg x) (MOVBreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDNE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpNeqB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NeqB   x y)
	// cond:
	// result: (MOVDNE (MOVDconst [0]) (MOVDconst [1]) (CMP (MOVBreg x) (MOVBreg y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDNE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v3 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v3.AddArg(x)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v4.AddArg(y)
		v2.AddArg(v4)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpNeqPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NeqPtr x y)
	// cond:
	// result: (MOVDNE (MOVDconst [0]) (MOVDconst [1]) (CMP x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XMOVDNE)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v1.AuxInt = 1
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpS390XCMP, TypeFlags)
		v2.AddArg(x)
		v2.AddArg(y)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpNilCheck(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NilCheck ptr mem)
	// cond:
	// result: (LoweredNilCheck ptr mem)
	for {
		ptr := v.Args[0]
		mem := v.Args[1]
		v.reset(OpS390XLoweredNilCheck)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpNot(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Not x)
	// cond:
	// result: (XORWconst [1] x)
	for {
		x := v.Args[0]
		v.reset(OpS390XXORWconst)
		v.AuxInt = 1
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpOffPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (OffPtr [off] ptr:(SP))
	// cond:
	// result: (MOVDaddr [off] ptr)
	for {
		off := v.AuxInt
		ptr := v.Args[0]
		if ptr.Op != OpSP {
			break
		}
		v.reset(OpS390XMOVDaddr)
		v.AuxInt = off
		v.AddArg(ptr)
		return true
	}
	// match: (OffPtr [off] ptr)
	// cond: is32Bit(off)
	// result: (ADDconst [off] ptr)
	for {
		off := v.AuxInt
		ptr := v.Args[0]
		if !(is32Bit(off)) {
			break
		}
		v.reset(OpS390XADDconst)
		v.AuxInt = off
		v.AddArg(ptr)
		return true
	}
	// match: (OffPtr [off] ptr)
	// cond:
	// result: (ADD (MOVDconst [off]) ptr)
	for {
		off := v.AuxInt
		ptr := v.Args[0]
		v.reset(OpS390XADD)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = off
		v.AddArg(v0)
		v.AddArg(ptr)
		return true
	}
}
func rewriteValueS390X_OpOr16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Or16 x y)
	// cond:
	// result: (ORW x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XORW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpOr32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Or32 x y)
	// cond:
	// result: (ORW x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XORW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpOr64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Or64 x y)
	// cond:
	// result: (OR x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XOR)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpOr8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Or8  x y)
	// cond:
	// result: (ORW x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XORW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpOrB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (OrB x y)
	// cond:
	// result: (ORW x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XORW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpRsh16Ux16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16Ux16 <t> x y)
	// cond:
	// result: (ANDW (SRW <t> (MOVHZreg x) y) (SUBEWcarrymask <t> (CMPWUconst (MOVHZreg y) [15])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSRW, t)
		v1 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v0.AddArg(y)
		v.AddArg(v0)
		v2 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v3 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v3.AuxInt = 15
		v4 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpRsh16Ux32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16Ux32 <t> x y)
	// cond:
	// result: (ANDW (SRW <t> (MOVHZreg x) y) (SUBEWcarrymask <t> (CMPWUconst y [15])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSRW, t)
		v1 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v0.AddArg(y)
		v.AddArg(v0)
		v2 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v3 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v3.AuxInt = 15
		v3.AddArg(y)
		v2.AddArg(v3)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpRsh16Ux64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16Ux64 <t> x y)
	// cond:
	// result: (ANDW (SRW <t> (MOVHZreg x) y) (SUBEWcarrymask <t> (CMPUconst y [15])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSRW, t)
		v1 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v0.AddArg(y)
		v.AddArg(v0)
		v2 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v3 := b.NewValue0(v.Line, OpS390XCMPUconst, TypeFlags)
		v3.AuxInt = 15
		v3.AddArg(y)
		v2.AddArg(v3)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpRsh16Ux8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16Ux8  <t> x y)
	// cond:
	// result: (ANDW (SRW <t> (MOVHZreg x) y) (SUBEWcarrymask <t> (CMPWUconst (MOVBZreg y) [15])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSRW, t)
		v1 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v0.AddArg(y)
		v.AddArg(v0)
		v2 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v3 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v3.AuxInt = 15
		v4 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpRsh16x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16x16 <t> x y)
	// cond:
	// result: (SRAW <t> (MOVHreg x) (ORW <y.Type> y (NOTW <y.Type> (SUBEWcarrymask <y.Type> (CMPWUconst (MOVHZreg y) [15])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAW)
		v.Type = t
		v0 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XORW, y.Type)
		v1.AddArg(y)
		v2 := b.NewValue0(v.Line, OpS390XNOTW, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, y.Type)
		v4 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v4.AuxInt = 15
		v5 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh16x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16x32 <t> x y)
	// cond:
	// result: (SRAW <t> (MOVHreg x) (ORW <y.Type> y (NOTW <y.Type> (SUBEWcarrymask <y.Type> (CMPWUconst y [15])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAW)
		v.Type = t
		v0 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XORW, y.Type)
		v1.AddArg(y)
		v2 := b.NewValue0(v.Line, OpS390XNOTW, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, y.Type)
		v4 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v4.AuxInt = 15
		v4.AddArg(y)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh16x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16x64 <t> x y)
	// cond:
	// result: (SRAW <t> (MOVHreg x) (OR <y.Type> y (NOT <y.Type> (SUBEcarrymask <y.Type> (CMPUconst y [15])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAW)
		v.Type = t
		v0 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XOR, y.Type)
		v1.AddArg(y)
		v2 := b.NewValue0(v.Line, OpS390XNOT, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XSUBEcarrymask, y.Type)
		v4 := b.NewValue0(v.Line, OpS390XCMPUconst, TypeFlags)
		v4.AuxInt = 15
		v4.AddArg(y)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh16x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16x8  <t> x y)
	// cond:
	// result: (SRAW <t> (MOVHreg x) (ORW <y.Type> y (NOTW <y.Type> (SUBEWcarrymask <y.Type> (CMPWUconst (MOVBZreg y) [15])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAW)
		v.Type = t
		v0 := b.NewValue0(v.Line, OpS390XMOVHreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XORW, y.Type)
		v1.AddArg(y)
		v2 := b.NewValue0(v.Line, OpS390XNOTW, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, y.Type)
		v4 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v4.AuxInt = 15
		v5 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh32Ux16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32Ux16 <t> x y)
	// cond:
	// result: (ANDW (SRW <t> x y) (SUBEWcarrymask <t> (CMPWUconst (MOVHZreg y) [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSRW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 31
		v3 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh32Ux32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32Ux32 <t> x y)
	// cond:
	// result: (ANDW (SRW <t> x y) (SUBEWcarrymask <t> (CMPWUconst y [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSRW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 31
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh32Ux64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32Ux64 <t> x y)
	// cond:
	// result: (ANDW (SRW <t> x y) (SUBEWcarrymask <t> (CMPUconst y [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSRW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPUconst, TypeFlags)
		v2.AuxInt = 31
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh32Ux8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32Ux8  <t> x y)
	// cond:
	// result: (ANDW (SRW <t> x y) (SUBEWcarrymask <t> (CMPWUconst (MOVBZreg y) [31])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSRW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 31
		v3 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh32x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32x16 <t> x y)
	// cond:
	// result: (SRAW <t> x (ORW <y.Type> y (NOTW <y.Type> (SUBEWcarrymask <y.Type> (CMPWUconst (MOVHZreg y) [31])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAW)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, OpS390XORW, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, OpS390XNOTW, y.Type)
		v2 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v3.AuxInt = 31
		v4 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpRsh32x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32x32 <t> x y)
	// cond:
	// result: (SRAW <t> x (ORW <y.Type> y (NOTW <y.Type> (SUBEWcarrymask <y.Type> (CMPWUconst y [31])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAW)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, OpS390XORW, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, OpS390XNOTW, y.Type)
		v2 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v3.AuxInt = 31
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpRsh32x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32x64 <t> x y)
	// cond:
	// result: (SRAW <t> x (OR <y.Type> y (NOT <y.Type> (SUBEcarrymask <y.Type> (CMPUconst y [31])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAW)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, OpS390XOR, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, OpS390XNOT, y.Type)
		v2 := b.NewValue0(v.Line, OpS390XSUBEcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XCMPUconst, TypeFlags)
		v3.AuxInt = 31
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpRsh32x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32x8  <t> x y)
	// cond:
	// result: (SRAW <t> x (ORW <y.Type> y (NOTW <y.Type> (SUBEWcarrymask <y.Type> (CMPWUconst (MOVBZreg y) [31])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAW)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, OpS390XORW, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, OpS390XNOTW, y.Type)
		v2 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v3.AuxInt = 31
		v4 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpRsh64Ux16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64Ux16 <t> x y)
	// cond:
	// result: (AND (SRD <t> x y) (SUBEcarrymask <t> (CMPWUconst (MOVHZreg y) [63])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XAND)
		v0 := b.NewValue0(v.Line, OpS390XSRD, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 63
		v3 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh64Ux32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64Ux32 <t> x y)
	// cond:
	// result: (AND (SRD <t> x y) (SUBEcarrymask <t> (CMPWUconst y [63])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XAND)
		v0 := b.NewValue0(v.Line, OpS390XSRD, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 63
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh64Ux64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64Ux64 <t> x y)
	// cond:
	// result: (AND (SRD <t> x y) (SUBEcarrymask <t> (CMPUconst y [63])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XAND)
		v0 := b.NewValue0(v.Line, OpS390XSRD, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPUconst, TypeFlags)
		v2.AuxInt = 63
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh64Ux8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64Ux8  <t> x y)
	// cond:
	// result: (AND (SRD <t> x y) (SUBEcarrymask <t> (CMPWUconst (MOVBZreg y) [63])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XAND)
		v0 := b.NewValue0(v.Line, OpS390XSRD, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSUBEcarrymask, t)
		v2 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v2.AuxInt = 63
		v3 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh64x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64x16 <t> x y)
	// cond:
	// result: (SRAD <t> x (ORW <y.Type> y (NOTW <y.Type> (SUBEWcarrymask <y.Type> (CMPWUconst (MOVHZreg y) [63])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAD)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, OpS390XORW, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, OpS390XNOTW, y.Type)
		v2 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v3.AuxInt = 63
		v4 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpRsh64x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64x32 <t> x y)
	// cond:
	// result: (SRAD <t> x (ORW <y.Type> y (NOTW <y.Type> (SUBEWcarrymask <y.Type> (CMPWUconst y [63])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAD)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, OpS390XORW, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, OpS390XNOTW, y.Type)
		v2 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v3.AuxInt = 63
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpRsh64x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64x64 <t> x y)
	// cond:
	// result: (SRAD <t> x (OR <y.Type> y (NOT <y.Type> (SUBEcarrymask <y.Type> (CMPUconst y [63])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAD)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, OpS390XOR, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, OpS390XNOT, y.Type)
		v2 := b.NewValue0(v.Line, OpS390XSUBEcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XCMPUconst, TypeFlags)
		v3.AuxInt = 63
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpRsh64x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64x8  <t> x y)
	// cond:
	// result: (SRAD <t> x (ORW <y.Type> y (NOTW <y.Type> (SUBEWcarrymask <y.Type> (CMPWUconst (MOVBZreg y) [63])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAD)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, OpS390XORW, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, OpS390XNOTW, y.Type)
		v2 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v3.AuxInt = 63
		v4 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueS390X_OpRsh8Ux16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8Ux16 <t> x y)
	// cond:
	// result: (ANDW (SRW <t> (MOVBZreg x) y) (SUBEWcarrymask <t> (CMPWUconst (MOVHZreg y) [7])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSRW, t)
		v1 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v0.AddArg(y)
		v.AddArg(v0)
		v2 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v3 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v3.AuxInt = 7
		v4 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpRsh8Ux32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8Ux32 <t> x y)
	// cond:
	// result: (ANDW (SRW <t> (MOVBZreg x) y) (SUBEWcarrymask <t> (CMPWUconst y [7])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSRW, t)
		v1 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v0.AddArg(y)
		v.AddArg(v0)
		v2 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v3 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v3.AuxInt = 7
		v3.AddArg(y)
		v2.AddArg(v3)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpRsh8Ux64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8Ux64 <t> x y)
	// cond:
	// result: (ANDW (SRW <t> (MOVBZreg x) y) (SUBEWcarrymask <t> (CMPUconst y [7])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSRW, t)
		v1 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v0.AddArg(y)
		v.AddArg(v0)
		v2 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v3 := b.NewValue0(v.Line, OpS390XCMPUconst, TypeFlags)
		v3.AuxInt = 7
		v3.AddArg(y)
		v2.AddArg(v3)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpRsh8Ux8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8Ux8  <t> x y)
	// cond:
	// result: (ANDW (SRW <t> (MOVBZreg x) y) (SUBEWcarrymask <t> (CMPWUconst (MOVBZreg y) [7])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XANDW)
		v0 := b.NewValue0(v.Line, OpS390XSRW, t)
		v1 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v0.AddArg(y)
		v.AddArg(v0)
		v2 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, t)
		v3 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v3.AuxInt = 7
		v4 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v.AddArg(v2)
		return true
	}
}
func rewriteValueS390X_OpRsh8x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8x16 <t> x y)
	// cond:
	// result: (SRAW <t> (MOVBreg x) (ORW <y.Type> y (NOTW <y.Type> (SUBEWcarrymask <y.Type> (CMPWUconst (MOVHZreg y) [7])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAW)
		v.Type = t
		v0 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XORW, y.Type)
		v1.AddArg(y)
		v2 := b.NewValue0(v.Line, OpS390XNOTW, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, y.Type)
		v4 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v4.AuxInt = 7
		v5 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh8x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8x32 <t> x y)
	// cond:
	// result: (SRAW <t> (MOVBreg x) (ORW <y.Type> y (NOTW <y.Type> (SUBEWcarrymask <y.Type> (CMPWUconst y [7])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAW)
		v.Type = t
		v0 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XORW, y.Type)
		v1.AddArg(y)
		v2 := b.NewValue0(v.Line, OpS390XNOTW, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, y.Type)
		v4 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v4.AuxInt = 7
		v4.AddArg(y)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh8x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8x64 <t> x y)
	// cond:
	// result: (SRAW <t> (MOVBreg x) (OR <y.Type> y (NOT <y.Type> (SUBEcarrymask <y.Type> (CMPUconst y [7])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAW)
		v.Type = t
		v0 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XOR, y.Type)
		v1.AddArg(y)
		v2 := b.NewValue0(v.Line, OpS390XNOT, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XSUBEcarrymask, y.Type)
		v4 := b.NewValue0(v.Line, OpS390XCMPUconst, TypeFlags)
		v4.AuxInt = 7
		v4.AddArg(y)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpRsh8x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8x8  <t> x y)
	// cond:
	// result: (SRAW <t> (MOVBreg x) (ORW <y.Type> y (NOTW <y.Type> (SUBEWcarrymask <y.Type> (CMPWUconst (MOVBZreg y) [7])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSRAW)
		v.Type = t
		v0 := b.NewValue0(v.Line, OpS390XMOVBreg, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XORW, y.Type)
		v1.AddArg(y)
		v2 := b.NewValue0(v.Line, OpS390XNOTW, y.Type)
		v3 := b.NewValue0(v.Line, OpS390XSUBEWcarrymask, y.Type)
		v4 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v4.AuxInt = 7
		v5 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpS390XADD(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ADD x (MOVDconst [c]))
	// cond: is32Bit(c)
	// result: (ADDconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpS390XADDconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ADD (MOVDconst [c]) x)
	// cond: is32Bit(c)
	// result: (ADDconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpS390XADDconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ADD x (MOVDaddr [c] {s} y))
	// cond: x.Op != OpSB && y.Op != OpSB
	// result: (MOVDaddridx [c] {s} x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDaddr {
			break
		}
		c := v_1.AuxInt
		s := v_1.Aux
		y := v_1.Args[0]
		if !(x.Op != OpSB && y.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVDaddridx)
		v.AuxInt = c
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADD (MOVDaddr [c] {s} x) y)
	// cond: x.Op != OpSB && y.Op != OpSB
	// result: (MOVDaddridx [c] {s} x y)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		c := v_0.AuxInt
		s := v_0.Aux
		x := v_0.Args[0]
		y := v.Args[1]
		if !(x.Op != OpSB && y.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVDaddridx)
		v.AuxInt = c
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADD x (NEG y))
	// cond:
	// result: (SUB x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XNEG {
			break
		}
		y := v_1.Args[0]
		v.reset(OpS390XSUB)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADD <t> x g:(MOVDload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ADDload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVDload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XADDload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (ADD <t> g:(MOVDload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ADDload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVDload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XADDload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XADDW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ADDW x (MOVDconst [c]))
	// cond:
	// result: (ADDWconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpS390XADDWconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ADDW (MOVDconst [c]) x)
	// cond:
	// result: (ADDWconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(OpS390XADDWconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ADDW x (NEGW y))
	// cond:
	// result: (SUBW x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XNEGW {
			break
		}
		y := v_1.Args[0]
		v.reset(OpS390XSUBW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDW <t> x g:(MOVWload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ADDWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVWload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XADDWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (ADDW <t> g:(MOVWload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ADDWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVWload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XADDWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (ADDW <t> x g:(MOVWZload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ADDWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVWZload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XADDWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (ADDW <t> g:(MOVWZload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ADDWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVWZload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XADDWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XADDWconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ADDWconst [c] x)
	// cond: int32(c)==0
	// result: x
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(int32(c) == 0) {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ADDWconst [c] (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [int64(int32(c+d))])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = int64(int32(c + d))
		return true
	}
	// match: (ADDWconst [c] (ADDWconst [d] x))
	// cond:
	// result: (ADDWconst [int64(int32(c+d))] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDWconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(OpS390XADDWconst)
		v.AuxInt = int64(int32(c + d))
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XADDconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ADDconst [c] (MOVDaddr [d] {s} x:(SB)))
	// cond: ((c+d)&1 == 0) && is32Bit(c+d)
	// result: (MOVDaddr [c+d] {s} x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		d := v_0.AuxInt
		s := v_0.Aux
		x := v_0.Args[0]
		if x.Op != OpSB {
			break
		}
		if !(((c+d)&1 == 0) && is32Bit(c+d)) {
			break
		}
		v.reset(OpS390XMOVDaddr)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		return true
	}
	// match: (ADDconst [c] (MOVDaddr [d] {s} x))
	// cond: x.Op != OpSB && is20Bit(c+d)
	// result: (MOVDaddr [c+d] {s} x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		d := v_0.AuxInt
		s := v_0.Aux
		x := v_0.Args[0]
		if !(x.Op != OpSB && is20Bit(c+d)) {
			break
		}
		v.reset(OpS390XMOVDaddr)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		return true
	}
	// match: (ADDconst [c] (MOVDaddridx [d] {s} x y))
	// cond: is20Bit(c+d)
	// result: (MOVDaddridx [c+d] {s} x y)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddridx {
			break
		}
		d := v_0.AuxInt
		s := v_0.Aux
		x := v_0.Args[0]
		y := v_0.Args[1]
		if !(is20Bit(c + d)) {
			break
		}
		v.reset(OpS390XMOVDaddridx)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDconst [0] x)
	// cond:
	// result: x
	for {
		if v.AuxInt != 0 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ADDconst [c] (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [c+d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = c + d
		return true
	}
	// match: (ADDconst [c] (ADDconst [d] x))
	// cond: is32Bit(c+d)
	// result: (ADDconst [c+d] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		if !(is32Bit(c + d)) {
			break
		}
		v.reset(OpS390XADDconst)
		v.AuxInt = c + d
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XAND(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AND x (MOVDconst [c]))
	// cond: is32Bit(c) && c < 0
	// result: (ANDconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		if !(is32Bit(c) && c < 0) {
			break
		}
		v.reset(OpS390XANDconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (AND (MOVDconst [c]) x)
	// cond: is32Bit(c) && c < 0
	// result: (ANDconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(is32Bit(c) && c < 0) {
			break
		}
		v.reset(OpS390XANDconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (AND (MOVDconst [0xFF]) x)
	// cond:
	// result: (MOVBZreg x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		if v_0.AuxInt != 0xFF {
			break
		}
		x := v.Args[1]
		v.reset(OpS390XMOVBZreg)
		v.AddArg(x)
		return true
	}
	// match: (AND x (MOVDconst [0xFF]))
	// cond:
	// result: (MOVBZreg x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		if v_1.AuxInt != 0xFF {
			break
		}
		v.reset(OpS390XMOVBZreg)
		v.AddArg(x)
		return true
	}
	// match: (AND (MOVDconst [0xFFFF]) x)
	// cond:
	// result: (MOVHZreg x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		if v_0.AuxInt != 0xFFFF {
			break
		}
		x := v.Args[1]
		v.reset(OpS390XMOVHZreg)
		v.AddArg(x)
		return true
	}
	// match: (AND x (MOVDconst [0xFFFF]))
	// cond:
	// result: (MOVHZreg x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		if v_1.AuxInt != 0xFFFF {
			break
		}
		v.reset(OpS390XMOVHZreg)
		v.AddArg(x)
		return true
	}
	// match: (AND (MOVDconst [0xFFFFFFFF]) x)
	// cond:
	// result: (MOVWZreg x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		if v_0.AuxInt != 0xFFFFFFFF {
			break
		}
		x := v.Args[1]
		v.reset(OpS390XMOVWZreg)
		v.AddArg(x)
		return true
	}
	// match: (AND x (MOVDconst [0xFFFFFFFF]))
	// cond:
	// result: (MOVWZreg x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		if v_1.AuxInt != 0xFFFFFFFF {
			break
		}
		v.reset(OpS390XMOVWZreg)
		v.AddArg(x)
		return true
	}
	// match: (AND (MOVDconst [c]) (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [c&d])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		d := v_1.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = c & d
		return true
	}
	// match: (AND x x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (AND <t> x g:(MOVDload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ANDload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVDload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XANDload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (AND <t> g:(MOVDload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ANDload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVDload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XANDload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XANDW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ANDW x (MOVDconst [c]))
	// cond:
	// result: (ANDWconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpS390XANDWconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ANDW (MOVDconst [c]) x)
	// cond:
	// result: (ANDWconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(OpS390XANDWconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ANDW x x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ANDW <t> x g:(MOVWload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ANDWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVWload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XANDWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (ANDW <t> g:(MOVWload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ANDWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVWload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XANDWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (ANDW <t> x g:(MOVWZload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ANDWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVWZload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XANDWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (ANDW <t> g:(MOVWZload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ANDWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVWZload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XANDWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XANDWconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ANDWconst [c] (ANDWconst [d] x))
	// cond:
	// result: (ANDWconst [c & d] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XANDWconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(OpS390XANDWconst)
		v.AuxInt = c & d
		v.AddArg(x)
		return true
	}
	// match: (ANDWconst [0xFF] x)
	// cond:
	// result: (MOVBZreg x)
	for {
		if v.AuxInt != 0xFF {
			break
		}
		x := v.Args[0]
		v.reset(OpS390XMOVBZreg)
		v.AddArg(x)
		return true
	}
	// match: (ANDWconst [0xFFFF] x)
	// cond:
	// result: (MOVHZreg x)
	for {
		if v.AuxInt != 0xFFFF {
			break
		}
		x := v.Args[0]
		v.reset(OpS390XMOVHZreg)
		v.AddArg(x)
		return true
	}
	// match: (ANDWconst [c] _)
	// cond: int32(c)==0
	// result: (MOVDconst [0])
	for {
		c := v.AuxInt
		if !(int32(c) == 0) {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = 0
		return true
	}
	// match: (ANDWconst [c] x)
	// cond: int32(c)==-1
	// result: x
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(int32(c) == -1) {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ANDWconst [c] (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [c&d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = c & d
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XANDconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ANDconst [c] (ANDconst [d] x))
	// cond:
	// result: (ANDconst [c & d] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XANDconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(OpS390XANDconst)
		v.AuxInt = c & d
		v.AddArg(x)
		return true
	}
	// match: (ANDconst [0] _)
	// cond:
	// result: (MOVDconst [0])
	for {
		if v.AuxInt != 0 {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = 0
		return true
	}
	// match: (ANDconst [-1] x)
	// cond:
	// result: x
	for {
		if v.AuxInt != -1 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ANDconst [c] (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [c&d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = c & d
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XCMP(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (CMP x (MOVDconst [c]))
	// cond: is32Bit(c)
	// result: (CMPconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpS390XCMPconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (CMP (MOVDconst [c]) x)
	// cond: is32Bit(c)
	// result: (InvertFlags (CMPconst x [c]))
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpS390XInvertFlags)
		v0 := b.NewValue0(v.Line, OpS390XCMPconst, TypeFlags)
		v0.AuxInt = c
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XCMPU(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (CMPU x (MOVDconst [c]))
	// cond: is32Bit(c)
	// result: (CMPUconst x [int64(uint32(c))])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpS390XCMPUconst)
		v.AuxInt = int64(uint32(c))
		v.AddArg(x)
		return true
	}
	// match: (CMPU (MOVDconst [c]) x)
	// cond: is32Bit(c)
	// result: (InvertFlags (CMPUconst x [int64(uint32(c))]))
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpS390XInvertFlags)
		v0 := b.NewValue0(v.Line, OpS390XCMPUconst, TypeFlags)
		v0.AuxInt = int64(uint32(c))
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XCMPUconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (CMPUconst (MOVDconst [x]) [y])
	// cond: uint64(x)==uint64(y)
	// result: (FlagEQ)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		x := v_0.AuxInt
		if !(uint64(x) == uint64(y)) {
			break
		}
		v.reset(OpS390XFlagEQ)
		return true
	}
	// match: (CMPUconst (MOVDconst [x]) [y])
	// cond: uint64(x)<uint64(y)
	// result: (FlagLT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		x := v_0.AuxInt
		if !(uint64(x) < uint64(y)) {
			break
		}
		v.reset(OpS390XFlagLT)
		return true
	}
	// match: (CMPUconst (MOVDconst [x]) [y])
	// cond: uint64(x)>uint64(y)
	// result: (FlagGT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		x := v_0.AuxInt
		if !(uint64(x) > uint64(y)) {
			break
		}
		v.reset(OpS390XFlagGT)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XCMPW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (CMPW x (MOVDconst [c]))
	// cond:
	// result: (CMPWconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpS390XCMPWconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (CMPW (MOVDconst [c]) x)
	// cond:
	// result: (InvertFlags (CMPWconst x [c]))
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(OpS390XInvertFlags)
		v0 := b.NewValue0(v.Line, OpS390XCMPWconst, TypeFlags)
		v0.AuxInt = c
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XCMPWU(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (CMPWU x (MOVDconst [c]))
	// cond:
	// result: (CMPWUconst x [int64(uint32(c))])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpS390XCMPWUconst)
		v.AuxInt = int64(uint32(c))
		v.AddArg(x)
		return true
	}
	// match: (CMPWU (MOVDconst [c]) x)
	// cond:
	// result: (InvertFlags (CMPWUconst x [int64(uint32(c))]))
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(OpS390XInvertFlags)
		v0 := b.NewValue0(v.Line, OpS390XCMPWUconst, TypeFlags)
		v0.AuxInt = int64(uint32(c))
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XCMPWUconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (CMPWUconst (MOVDconst [x]) [y])
	// cond: uint32(x)==uint32(y)
	// result: (FlagEQ)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		x := v_0.AuxInt
		if !(uint32(x) == uint32(y)) {
			break
		}
		v.reset(OpS390XFlagEQ)
		return true
	}
	// match: (CMPWUconst (MOVDconst [x]) [y])
	// cond: uint32(x)<uint32(y)
	// result: (FlagLT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		x := v_0.AuxInt
		if !(uint32(x) < uint32(y)) {
			break
		}
		v.reset(OpS390XFlagLT)
		return true
	}
	// match: (CMPWUconst (MOVDconst [x]) [y])
	// cond: uint32(x)>uint32(y)
	// result: (FlagGT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		x := v_0.AuxInt
		if !(uint32(x) > uint32(y)) {
			break
		}
		v.reset(OpS390XFlagGT)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XCMPWconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (CMPWconst (MOVDconst [x]) [y])
	// cond: int32(x)==int32(y)
	// result: (FlagEQ)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		x := v_0.AuxInt
		if !(int32(x) == int32(y)) {
			break
		}
		v.reset(OpS390XFlagEQ)
		return true
	}
	// match: (CMPWconst (MOVDconst [x]) [y])
	// cond: int32(x)<int32(y)
	// result: (FlagLT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		x := v_0.AuxInt
		if !(int32(x) < int32(y)) {
			break
		}
		v.reset(OpS390XFlagLT)
		return true
	}
	// match: (CMPWconst (MOVDconst [x]) [y])
	// cond: int32(x)>int32(y)
	// result: (FlagGT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		x := v_0.AuxInt
		if !(int32(x) > int32(y)) {
			break
		}
		v.reset(OpS390XFlagGT)
		return true
	}
	// match: (CMPWconst (SRWconst _ [c]) [n])
	// cond: 0 <= n && 0 < c && c <= 32 && (1<<uint64(32-c)) <= uint64(n)
	// result: (FlagLT)
	for {
		n := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XSRWconst {
			break
		}
		c := v_0.AuxInt
		if !(0 <= n && 0 < c && c <= 32 && (1<<uint64(32-c)) <= uint64(n)) {
			break
		}
		v.reset(OpS390XFlagLT)
		return true
	}
	// match: (CMPWconst (ANDWconst _ [m]) [n])
	// cond: 0 <= int32(m) && int32(m) < int32(n)
	// result: (FlagLT)
	for {
		n := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XANDWconst {
			break
		}
		m := v_0.AuxInt
		if !(0 <= int32(m) && int32(m) < int32(n)) {
			break
		}
		v.reset(OpS390XFlagLT)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XCMPconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (CMPconst (MOVDconst [x]) [y])
	// cond: x==y
	// result: (FlagEQ)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		x := v_0.AuxInt
		if !(x == y) {
			break
		}
		v.reset(OpS390XFlagEQ)
		return true
	}
	// match: (CMPconst (MOVDconst [x]) [y])
	// cond: x<y
	// result: (FlagLT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		x := v_0.AuxInt
		if !(x < y) {
			break
		}
		v.reset(OpS390XFlagLT)
		return true
	}
	// match: (CMPconst (MOVDconst [x]) [y])
	// cond: x>y
	// result: (FlagGT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		x := v_0.AuxInt
		if !(x > y) {
			break
		}
		v.reset(OpS390XFlagGT)
		return true
	}
	// match: (CMPconst (MOVBZreg _) [c])
	// cond: 0xFF < c
	// result: (FlagLT)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVBZreg {
			break
		}
		if !(0xFF < c) {
			break
		}
		v.reset(OpS390XFlagLT)
		return true
	}
	// match: (CMPconst (MOVHZreg _) [c])
	// cond: 0xFFFF < c
	// result: (FlagLT)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVHZreg {
			break
		}
		if !(0xFFFF < c) {
			break
		}
		v.reset(OpS390XFlagLT)
		return true
	}
	// match: (CMPconst (MOVWZreg _) [c])
	// cond: 0xFFFFFFFF < c
	// result: (FlagLT)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVWZreg {
			break
		}
		if !(0xFFFFFFFF < c) {
			break
		}
		v.reset(OpS390XFlagLT)
		return true
	}
	// match: (CMPconst (SRDconst _ [c]) [n])
	// cond: 0 <= n && 0 < c && c <= 64 && (1<<uint64(64-c)) <= uint64(n)
	// result: (FlagLT)
	for {
		n := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XSRDconst {
			break
		}
		c := v_0.AuxInt
		if !(0 <= n && 0 < c && c <= 64 && (1<<uint64(64-c)) <= uint64(n)) {
			break
		}
		v.reset(OpS390XFlagLT)
		return true
	}
	// match: (CMPconst (ANDconst _ [m]) [n])
	// cond: 0 <= m && m < n
	// result: (FlagLT)
	for {
		n := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XANDconst {
			break
		}
		m := v_0.AuxInt
		if !(0 <= m && m < n) {
			break
		}
		v.reset(OpS390XFlagLT)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XFMOVDload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (FMOVDload  [off1] {sym} (ADDconst [off2] ptr) mem)
	// cond: is20Bit(off1+off2)
	// result: (FMOVDload [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XFMOVDload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVDload [off1] {sym1} (MOVDaddr [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (FMOVDload [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XFMOVDload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVDload [off1] {sym1} (MOVDaddridx [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (FMOVDloadidx [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddridx {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XFMOVDloadidx)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVDload [off] {sym} (ADD ptr idx) mem)
	// cond: ptr.Op != OpSB
	// result: (FMOVDloadidx [off] {sym} ptr idx mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADD {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XFMOVDloadidx)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XFMOVDloadidx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (FMOVDloadidx [c] {sym} (ADDconst [d] ptr) idx mem)
	// cond:
	// result: (FMOVDloadidx [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XFMOVDloadidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVDloadidx [c] {sym} ptr (ADDconst [d] idx) mem)
	// cond:
	// result: (FMOVDloadidx [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XADDconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpS390XFMOVDloadidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XFMOVDstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (FMOVDstore [off1] {sym} (ADDconst [off2] ptr) val mem)
	// cond: is20Bit(off1+off2)
	// result: (FMOVDstore [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XFMOVDstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVDstore [off1] {sym1} (MOVDaddr [off2] {sym2} base) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (FMOVDstore [off1+off2] {mergeSym(sym1,sym2)} base val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XFMOVDstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVDstore [off1] {sym1} (MOVDaddridx [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (FMOVDstoreidx [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddridx {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XFMOVDstoreidx)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVDstore [off] {sym} (ADD ptr idx) val mem)
	// cond: ptr.Op != OpSB
	// result: (FMOVDstoreidx [off] {sym} ptr idx val mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADD {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XFMOVDstoreidx)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XFMOVDstoreidx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (FMOVDstoreidx [c] {sym} (ADDconst [d] ptr) idx val mem)
	// cond:
	// result: (FMOVDstoreidx [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(OpS390XFMOVDstoreidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVDstoreidx [c] {sym} ptr (ADDconst [d] idx) val mem)
	// cond:
	// result: (FMOVDstoreidx [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XADDconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(OpS390XFMOVDstoreidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XFMOVSload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (FMOVSload  [off1] {sym} (ADDconst [off2] ptr) mem)
	// cond: is20Bit(off1+off2)
	// result: (FMOVSload [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XFMOVSload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVSload [off1] {sym1} (MOVDaddr [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (FMOVSload [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XFMOVSload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVSload [off1] {sym1} (MOVDaddridx [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (FMOVSloadidx [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddridx {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XFMOVSloadidx)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVSload [off] {sym} (ADD ptr idx) mem)
	// cond: ptr.Op != OpSB
	// result: (FMOVSloadidx [off] {sym} ptr idx mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADD {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XFMOVSloadidx)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XFMOVSloadidx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (FMOVSloadidx [c] {sym} (ADDconst [d] ptr) idx mem)
	// cond:
	// result: (FMOVSloadidx [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XFMOVSloadidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVSloadidx [c] {sym} ptr (ADDconst [d] idx) mem)
	// cond:
	// result: (FMOVSloadidx [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XADDconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpS390XFMOVSloadidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XFMOVSstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (FMOVSstore [off1] {sym} (ADDconst [off2] ptr) val mem)
	// cond: is20Bit(off1+off2)
	// result: (FMOVSstore [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XFMOVSstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVSstore [off1] {sym1} (MOVDaddr [off2] {sym2} base) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (FMOVSstore [off1+off2] {mergeSym(sym1,sym2)} base val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XFMOVSstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVSstore [off1] {sym1} (MOVDaddridx [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (FMOVSstoreidx [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddridx {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XFMOVSstoreidx)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVSstore [off] {sym} (ADD ptr idx) val mem)
	// cond: ptr.Op != OpSB
	// result: (FMOVSstoreidx [off] {sym} ptr idx val mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADD {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XFMOVSstoreidx)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XFMOVSstoreidx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (FMOVSstoreidx [c] {sym} (ADDconst [d] ptr) idx val mem)
	// cond:
	// result: (FMOVSstoreidx [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(OpS390XFMOVSstoreidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (FMOVSstoreidx [c] {sym} ptr (ADDconst [d] idx) val mem)
	// cond:
	// result: (FMOVSstoreidx [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XADDconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(OpS390XFMOVSstoreidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVBZload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBZload [off] {sym} ptr (MOVBstore [off2] {sym2} ptr2 x _))
	// cond: sym == sym2 && off == off2 && isSamePtr(ptr, ptr2)
	// result: (MOVDreg x)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVBstore {
			break
		}
		off2 := v_1.AuxInt
		sym2 := v_1.Aux
		ptr2 := v_1.Args[0]
		x := v_1.Args[1]
		if !(sym == sym2 && off == off2 && isSamePtr(ptr, ptr2)) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBZload  [off1] {sym} (ADDconst [off2] ptr) mem)
	// cond: is20Bit(off1+off2)
	// result: (MOVBZload [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XMOVBZload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBZload  [off1] {sym1} (MOVDaddr [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVBZload  [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVBZload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBZload [off1] {sym1} (MOVDaddridx [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVBZloadidx [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddridx {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVBZloadidx)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBZload [off] {sym} (ADD ptr idx) mem)
	// cond: ptr.Op != OpSB
	// result: (MOVBZloadidx [off] {sym} ptr idx mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADD {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVBZloadidx)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVBZloadidx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBZloadidx [c] {sym} (ADDconst [d] ptr) idx mem)
	// cond:
	// result: (MOVBZloadidx [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XMOVBZloadidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBZloadidx [c] {sym} ptr (ADDconst [d] idx) mem)
	// cond:
	// result: (MOVBZloadidx [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XADDconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpS390XMOVBZloadidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVBZreg(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBZreg x:(MOVDLT (MOVDconst [c]) (MOVDconst [d]) _))
	// cond: int64(uint8(c)) == c && int64(uint8(d)) == d
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVDLT {
			break
		}
		x_0 := x.Args[0]
		if x_0.Op != OpS390XMOVDconst {
			break
		}
		c := x_0.AuxInt
		x_1 := x.Args[1]
		if x_1.Op != OpS390XMOVDconst {
			break
		}
		d := x_1.AuxInt
		if !(int64(uint8(c)) == c && int64(uint8(d)) == d) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBZreg x:(MOVDLE (MOVDconst [c]) (MOVDconst [d]) _))
	// cond: int64(uint8(c)) == c && int64(uint8(d)) == d
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVDLE {
			break
		}
		x_0 := x.Args[0]
		if x_0.Op != OpS390XMOVDconst {
			break
		}
		c := x_0.AuxInt
		x_1 := x.Args[1]
		if x_1.Op != OpS390XMOVDconst {
			break
		}
		d := x_1.AuxInt
		if !(int64(uint8(c)) == c && int64(uint8(d)) == d) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBZreg x:(MOVDGT (MOVDconst [c]) (MOVDconst [d]) _))
	// cond: int64(uint8(c)) == c && int64(uint8(d)) == d
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVDGT {
			break
		}
		x_0 := x.Args[0]
		if x_0.Op != OpS390XMOVDconst {
			break
		}
		c := x_0.AuxInt
		x_1 := x.Args[1]
		if x_1.Op != OpS390XMOVDconst {
			break
		}
		d := x_1.AuxInt
		if !(int64(uint8(c)) == c && int64(uint8(d)) == d) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBZreg x:(MOVDGE (MOVDconst [c]) (MOVDconst [d]) _))
	// cond: int64(uint8(c)) == c && int64(uint8(d)) == d
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVDGE {
			break
		}
		x_0 := x.Args[0]
		if x_0.Op != OpS390XMOVDconst {
			break
		}
		c := x_0.AuxInt
		x_1 := x.Args[1]
		if x_1.Op != OpS390XMOVDconst {
			break
		}
		d := x_1.AuxInt
		if !(int64(uint8(c)) == c && int64(uint8(d)) == d) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBZreg x:(MOVDEQ (MOVDconst [c]) (MOVDconst [d]) _))
	// cond: int64(uint8(c)) == c && int64(uint8(d)) == d
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVDEQ {
			break
		}
		x_0 := x.Args[0]
		if x_0.Op != OpS390XMOVDconst {
			break
		}
		c := x_0.AuxInt
		x_1 := x.Args[1]
		if x_1.Op != OpS390XMOVDconst {
			break
		}
		d := x_1.AuxInt
		if !(int64(uint8(c)) == c && int64(uint8(d)) == d) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBZreg x:(MOVDNE (MOVDconst [c]) (MOVDconst [d]) _))
	// cond: int64(uint8(c)) == c && int64(uint8(d)) == d
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVDNE {
			break
		}
		x_0 := x.Args[0]
		if x_0.Op != OpS390XMOVDconst {
			break
		}
		c := x_0.AuxInt
		x_1 := x.Args[1]
		if x_1.Op != OpS390XMOVDconst {
			break
		}
		d := x_1.AuxInt
		if !(int64(uint8(c)) == c && int64(uint8(d)) == d) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBZreg x:(MOVDGTnoinv (MOVDconst [c]) (MOVDconst [d]) _))
	// cond: int64(uint8(c)) == c && int64(uint8(d)) == d
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVDGTnoinv {
			break
		}
		x_0 := x.Args[0]
		if x_0.Op != OpS390XMOVDconst {
			break
		}
		c := x_0.AuxInt
		x_1 := x.Args[1]
		if x_1.Op != OpS390XMOVDconst {
			break
		}
		d := x_1.AuxInt
		if !(int64(uint8(c)) == c && int64(uint8(d)) == d) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBZreg x:(MOVDGEnoinv (MOVDconst [c]) (MOVDconst [d]) _))
	// cond: int64(uint8(c)) == c && int64(uint8(d)) == d
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVDGEnoinv {
			break
		}
		x_0 := x.Args[0]
		if x_0.Op != OpS390XMOVDconst {
			break
		}
		c := x_0.AuxInt
		x_1 := x.Args[1]
		if x_1.Op != OpS390XMOVDconst {
			break
		}
		d := x_1.AuxInt
		if !(int64(uint8(c)) == c && int64(uint8(d)) == d) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBZreg x:(MOVBZload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBZload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBZreg x:(Arg <t>))
	// cond: is8BitInt(t) && !isSigned(t)
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpArg {
			break
		}
		t := x.Type
		if !(is8BitInt(t) && !isSigned(t)) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBZreg x:(MOVBZreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBZreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBZreg (MOVDconst [c]))
	// cond:
	// result: (MOVDconst [int64(uint8(c))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = int64(uint8(c))
		return true
	}
	// match: (MOVBZreg x:(MOVBZload [off] {sym} ptr mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVBZload <v.Type> [off] {sym} ptr mem)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBZload {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		mem := x.Args[1]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, OpS390XMOVBZload, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(mem)
		return true
	}
	// match: (MOVBZreg x:(MOVBZloadidx [off] {sym} ptr idx mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVBZloadidx <v.Type> [off] {sym} ptr idx mem)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBZloadidx {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		idx := x.Args[1]
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, OpS390XMOVBZloadidx, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(idx)
		v0.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVBload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBload   [off1] {sym} (ADDconst [off2] ptr) mem)
	// cond: is20Bit(off1+off2)
	// result: (MOVBload  [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XMOVBload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBload [off1] {sym1} (MOVDaddr [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVBload [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVBload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVBreg(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBreg x:(MOVBload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBreg x:(Arg <t>))
	// cond: is8BitInt(t) && isSigned(t)
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpArg {
			break
		}
		t := x.Type
		if !(is8BitInt(t) && isSigned(t)) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBreg x:(MOVBreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBreg (MOVDconst [c]))
	// cond:
	// result: (MOVDconst [int64(int8(c))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = int64(int8(c))
		return true
	}
	// match: (MOVBreg x:(MOVBZload [off] {sym} ptr mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVBload <v.Type> [off] {sym} ptr mem)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBZload {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		mem := x.Args[1]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, OpS390XMOVBload, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVBstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBstore [off] {sym} ptr (MOVBreg x) mem)
	// cond:
	// result: (MOVBstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVBreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpS390XMOVBstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off] {sym} ptr (MOVBZreg x) mem)
	// cond:
	// result: (MOVBstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVBZreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpS390XMOVBstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore  [off1] {sym} (ADDconst [off2] ptr) val mem)
	// cond: is20Bit(off1+off2)
	// result: (MOVBstore  [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XMOVBstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off] {sym} ptr (MOVDconst [c]) mem)
	// cond: validOff(off) && ptr.Op != OpSB
	// result: (MOVBstoreconst [makeValAndOff(int64(int8(c)),off)] {sym} ptr mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		mem := v.Args[2]
		if !(validOff(off) && ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVBstoreconst)
		v.AuxInt = makeValAndOff(int64(int8(c)), off)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore  [off1] {sym1} (MOVDaddr [off2] {sym2} base) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVBstore  [off1+off2] {mergeSym(sym1,sym2)} base val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVBstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off1] {sym1} (MOVDaddridx [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVBstoreidx [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddridx {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVBstoreidx)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off] {sym} (ADD ptr idx) val mem)
	// cond: ptr.Op != OpSB
	// result: (MOVBstoreidx [off] {sym} ptr idx val mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADD {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVBstoreidx)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [i] {s} p w x:(MOVBstore [i-1] {s} p (SRDconst [8] w) mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && clobber(x)
	// result: (MOVHstore [i-1] {s} p w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w := v.Args[1]
		x := v.Args[2]
		if x.Op != OpS390XMOVBstore {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		x_1 := x.Args[1]
		if x_1.Op != OpS390XSRDconst {
			break
		}
		if x_1.AuxInt != 8 {
			break
		}
		if w != x_1.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHstore)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [i] {s} p w0:(SRDconst [j] w) x:(MOVBstore [i-1] {s} p (SRDconst [j+8] w) mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && clobber(x)
	// result: (MOVHstore [i-1] {s} p w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w0 := v.Args[1]
		if w0.Op != OpS390XSRDconst {
			break
		}
		j := w0.AuxInt
		w := w0.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVBstore {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		x_1 := x.Args[1]
		if x_1.Op != OpS390XSRDconst {
			break
		}
		if x_1.AuxInt != j+8 {
			break
		}
		if w != x_1.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHstore)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [i] {s} p w x:(MOVBstore [i-1] {s} p (SRWconst [8] w) mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && clobber(x)
	// result: (MOVHstore [i-1] {s} p w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w := v.Args[1]
		x := v.Args[2]
		if x.Op != OpS390XMOVBstore {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		x_1 := x.Args[1]
		if x_1.Op != OpS390XSRWconst {
			break
		}
		if x_1.AuxInt != 8 {
			break
		}
		if w != x_1.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHstore)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [i] {s} p w0:(SRWconst [j] w) x:(MOVBstore [i-1] {s} p (SRWconst [j+8] w) mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && clobber(x)
	// result: (MOVHstore [i-1] {s} p w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w0 := v.Args[1]
		if w0.Op != OpS390XSRWconst {
			break
		}
		j := w0.AuxInt
		w := w0.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVBstore {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		x_1 := x.Args[1]
		if x_1.Op != OpS390XSRWconst {
			break
		}
		if x_1.AuxInt != j+8 {
			break
		}
		if w != x_1.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHstore)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [i] {s} p (SRDconst [8] w) x:(MOVBstore [i-1] {s} p w mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && clobber(x)
	// result: (MOVHBRstore [i-1] {s} p w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XSRDconst {
			break
		}
		if v_1.AuxInt != 8 {
			break
		}
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVBstore {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if w != x.Args[1] {
			break
		}
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHBRstore)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [i] {s} p (SRDconst [j] w) x:(MOVBstore [i-1] {s} p w0:(SRDconst [j-8] w) mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && clobber(x)
	// result: (MOVHBRstore [i-1] {s} p w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XSRDconst {
			break
		}
		j := v_1.AuxInt
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVBstore {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		if w0.Op != OpS390XSRDconst {
			break
		}
		if w0.AuxInt != j-8 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHBRstore)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [i] {s} p (SRWconst [8] w) x:(MOVBstore [i-1] {s} p w mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && clobber(x)
	// result: (MOVHBRstore [i-1] {s} p w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XSRWconst {
			break
		}
		if v_1.AuxInt != 8 {
			break
		}
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVBstore {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if w != x.Args[1] {
			break
		}
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHBRstore)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [i] {s} p (SRWconst [j] w) x:(MOVBstore [i-1] {s} p w0:(SRWconst [j-8] w) mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && clobber(x)
	// result: (MOVHBRstore [i-1] {s} p w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XSRWconst {
			break
		}
		j := v_1.AuxInt
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVBstore {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		if w0.Op != OpS390XSRWconst {
			break
		}
		if w0.AuxInt != j-8 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHBRstore)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVBstoreconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBstoreconst [sc] {s} (ADDconst [off] ptr) mem)
	// cond: ValAndOff(sc).canAdd(off)
	// result: (MOVBstoreconst [ValAndOff(sc).add(off)] {s} ptr mem)
	for {
		sc := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(ValAndOff(sc).canAdd(off)) {
			break
		}
		v.reset(OpS390XMOVBstoreconst)
		v.AuxInt = ValAndOff(sc).add(off)
		v.Aux = s
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreconst [sc] {sym1} (MOVDaddr [off] {sym2} ptr) mem)
	// cond: canMergeSym(sym1, sym2) && ValAndOff(sc).canAdd(off)
	// result: (MOVBstoreconst [ValAndOff(sc).add(off)] {mergeSym(sym1, sym2)} ptr mem)
	for {
		sc := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && ValAndOff(sc).canAdd(off)) {
			break
		}
		v.reset(OpS390XMOVBstoreconst)
		v.AuxInt = ValAndOff(sc).add(off)
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreconst [c] {s} p x:(MOVBstoreconst [a] {s} p mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && ValAndOff(a).Off() + 1 == ValAndOff(c).Off()   && clobber(x)
	// result: (MOVHstoreconst [makeValAndOff(ValAndOff(c).Val()&0xff | ValAndOff(a).Val()<<8, ValAndOff(a).Off())] {s} p mem)
	for {
		c := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		x := v.Args[1]
		if x.Op != OpS390XMOVBstoreconst {
			break
		}
		a := x.AuxInt
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		mem := x.Args[1]
		if !(p.Op != OpSB && x.Uses == 1 && ValAndOff(a).Off()+1 == ValAndOff(c).Off() && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHstoreconst)
		v.AuxInt = makeValAndOff(ValAndOff(c).Val()&0xff|ValAndOff(a).Val()<<8, ValAndOff(a).Off())
		v.Aux = s
		v.AddArg(p)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVBstoreidx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBstoreidx [c] {sym} (ADDconst [d] ptr) idx val mem)
	// cond:
	// result: (MOVBstoreidx [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(OpS390XMOVBstoreidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreidx [c] {sym} ptr (ADDconst [d] idx) val mem)
	// cond:
	// result: (MOVBstoreidx [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XADDconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(OpS390XMOVBstoreidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreidx [i] {s} p idx w x:(MOVBstoreidx [i-1] {s} p idx (SRDconst [8] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVHstoreidx [i-1] {s} p idx w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		w := v.Args[2]
		x := v.Args[3]
		if x.Op != OpS390XMOVBstoreidx {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		x_2 := x.Args[2]
		if x_2.Op != OpS390XSRDconst {
			break
		}
		if x_2.AuxInt != 8 {
			break
		}
		if w != x_2.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHstoreidx)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreidx [i] {s} p idx w0:(SRDconst [j] w) x:(MOVBstoreidx [i-1] {s} p idx (SRDconst [j+8] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVHstoreidx [i-1] {s} p idx w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		w0 := v.Args[2]
		if w0.Op != OpS390XSRDconst {
			break
		}
		j := w0.AuxInt
		w := w0.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVBstoreidx {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		x_2 := x.Args[2]
		if x_2.Op != OpS390XSRDconst {
			break
		}
		if x_2.AuxInt != j+8 {
			break
		}
		if w != x_2.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHstoreidx)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreidx [i] {s} p idx w x:(MOVBstoreidx [i-1] {s} p idx (SRWconst [8] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVHstoreidx [i-1] {s} p idx w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		w := v.Args[2]
		x := v.Args[3]
		if x.Op != OpS390XMOVBstoreidx {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		x_2 := x.Args[2]
		if x_2.Op != OpS390XSRWconst {
			break
		}
		if x_2.AuxInt != 8 {
			break
		}
		if w != x_2.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHstoreidx)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreidx [i] {s} p idx w0:(SRWconst [j] w) x:(MOVBstoreidx [i-1] {s} p idx (SRWconst [j+8] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVHstoreidx [i-1] {s} p idx w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		w0 := v.Args[2]
		if w0.Op != OpS390XSRWconst {
			break
		}
		j := w0.AuxInt
		w := w0.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVBstoreidx {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		x_2 := x.Args[2]
		if x_2.Op != OpS390XSRWconst {
			break
		}
		if x_2.AuxInt != j+8 {
			break
		}
		if w != x_2.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHstoreidx)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreidx [i] {s} p idx (SRDconst [8] w) x:(MOVBstoreidx [i-1] {s} p idx w mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVHBRstoreidx [i-1] {s} p idx w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XSRDconst {
			break
		}
		if v_2.AuxInt != 8 {
			break
		}
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVBstoreidx {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		if w != x.Args[2] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHBRstoreidx)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreidx [i] {s} p idx (SRDconst [j] w) x:(MOVBstoreidx [i-1] {s} p idx w0:(SRDconst [j-8] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVHBRstoreidx [i-1] {s} p idx w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XSRDconst {
			break
		}
		j := v_2.AuxInt
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVBstoreidx {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		w0 := x.Args[2]
		if w0.Op != OpS390XSRDconst {
			break
		}
		if w0.AuxInt != j-8 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHBRstoreidx)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreidx [i] {s} p idx (SRWconst [8] w) x:(MOVBstoreidx [i-1] {s} p idx w mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVHBRstoreidx [i-1] {s} p idx w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XSRWconst {
			break
		}
		if v_2.AuxInt != 8 {
			break
		}
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVBstoreidx {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		if w != x.Args[2] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHBRstoreidx)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreidx [i] {s} p idx (SRWconst [j] w) x:(MOVBstoreidx [i-1] {s} p idx w0:(SRWconst [j-8] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVHBRstoreidx [i-1] {s} p idx w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XSRWconst {
			break
		}
		j := v_2.AuxInt
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVBstoreidx {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		w0 := x.Args[2]
		if w0.Op != OpS390XSRWconst {
			break
		}
		if w0.AuxInt != j-8 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVHBRstoreidx)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVDEQ(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDEQ x y (InvertFlags cmp))
	// cond:
	// result: (MOVDEQ x y cmp)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XInvertFlags {
			break
		}
		cmp := v_2.Args[0]
		v.reset(OpS390XMOVDEQ)
		v.AddArg(x)
		v.AddArg(y)
		v.AddArg(cmp)
		return true
	}
	// match: (MOVDEQ _ x (FlagEQ))
	// cond:
	// result: x
	for {
		x := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagEQ {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (MOVDEQ y _ (FlagLT))
	// cond:
	// result: y
	for {
		y := v.Args[0]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagLT {
			break
		}
		v.reset(OpCopy)
		v.Type = y.Type
		v.AddArg(y)
		return true
	}
	// match: (MOVDEQ y _ (FlagGT))
	// cond:
	// result: y
	for {
		y := v.Args[0]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagGT {
			break
		}
		v.reset(OpCopy)
		v.Type = y.Type
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVDGE(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDGE x y (InvertFlags cmp))
	// cond:
	// result: (MOVDLE x y cmp)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XInvertFlags {
			break
		}
		cmp := v_2.Args[0]
		v.reset(OpS390XMOVDLE)
		v.AddArg(x)
		v.AddArg(y)
		v.AddArg(cmp)
		return true
	}
	// match: (MOVDGE _ x (FlagEQ))
	// cond:
	// result: x
	for {
		x := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagEQ {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (MOVDGE y _ (FlagLT))
	// cond:
	// result: y
	for {
		y := v.Args[0]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagLT {
			break
		}
		v.reset(OpCopy)
		v.Type = y.Type
		v.AddArg(y)
		return true
	}
	// match: (MOVDGE _ x (FlagGT))
	// cond:
	// result: x
	for {
		x := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagGT {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVDGT(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDGT x y (InvertFlags cmp))
	// cond:
	// result: (MOVDLT x y cmp)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XInvertFlags {
			break
		}
		cmp := v_2.Args[0]
		v.reset(OpS390XMOVDLT)
		v.AddArg(x)
		v.AddArg(y)
		v.AddArg(cmp)
		return true
	}
	// match: (MOVDGT y _ (FlagEQ))
	// cond:
	// result: y
	for {
		y := v.Args[0]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagEQ {
			break
		}
		v.reset(OpCopy)
		v.Type = y.Type
		v.AddArg(y)
		return true
	}
	// match: (MOVDGT y _ (FlagLT))
	// cond:
	// result: y
	for {
		y := v.Args[0]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagLT {
			break
		}
		v.reset(OpCopy)
		v.Type = y.Type
		v.AddArg(y)
		return true
	}
	// match: (MOVDGT _ x (FlagGT))
	// cond:
	// result: x
	for {
		x := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagGT {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVDLE(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDLE x y (InvertFlags cmp))
	// cond:
	// result: (MOVDGE x y cmp)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XInvertFlags {
			break
		}
		cmp := v_2.Args[0]
		v.reset(OpS390XMOVDGE)
		v.AddArg(x)
		v.AddArg(y)
		v.AddArg(cmp)
		return true
	}
	// match: (MOVDLE _ x (FlagEQ))
	// cond:
	// result: x
	for {
		x := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagEQ {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (MOVDLE _ x (FlagLT))
	// cond:
	// result: x
	for {
		x := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagLT {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (MOVDLE y _ (FlagGT))
	// cond:
	// result: y
	for {
		y := v.Args[0]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagGT {
			break
		}
		v.reset(OpCopy)
		v.Type = y.Type
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVDLT(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDLT x y (InvertFlags cmp))
	// cond:
	// result: (MOVDGT x y cmp)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XInvertFlags {
			break
		}
		cmp := v_2.Args[0]
		v.reset(OpS390XMOVDGT)
		v.AddArg(x)
		v.AddArg(y)
		v.AddArg(cmp)
		return true
	}
	// match: (MOVDLT y _ (FlagEQ))
	// cond:
	// result: y
	for {
		y := v.Args[0]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagEQ {
			break
		}
		v.reset(OpCopy)
		v.Type = y.Type
		v.AddArg(y)
		return true
	}
	// match: (MOVDLT _ x (FlagLT))
	// cond:
	// result: x
	for {
		x := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagLT {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (MOVDLT y _ (FlagGT))
	// cond:
	// result: y
	for {
		y := v.Args[0]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagGT {
			break
		}
		v.reset(OpCopy)
		v.Type = y.Type
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVDNE(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDNE x y (InvertFlags cmp))
	// cond:
	// result: (MOVDNE x y cmp)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XInvertFlags {
			break
		}
		cmp := v_2.Args[0]
		v.reset(OpS390XMOVDNE)
		v.AddArg(x)
		v.AddArg(y)
		v.AddArg(cmp)
		return true
	}
	// match: (MOVDNE y _ (FlagEQ))
	// cond:
	// result: y
	for {
		y := v.Args[0]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagEQ {
			break
		}
		v.reset(OpCopy)
		v.Type = y.Type
		v.AddArg(y)
		return true
	}
	// match: (MOVDNE _ x (FlagLT))
	// cond:
	// result: x
	for {
		x := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagLT {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (MOVDNE _ x (FlagGT))
	// cond:
	// result: x
	for {
		x := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XFlagGT {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVDaddridx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDaddridx [c] {s} (ADDconst [d] x) y)
	// cond: is20Bit(c+d) && x.Op != OpSB
	// result: (MOVDaddridx [c+d] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		y := v.Args[1]
		if !(is20Bit(c+d) && x.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVDaddridx)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (MOVDaddridx [c] {s} x (ADDconst [d] y))
	// cond: is20Bit(c+d) && y.Op != OpSB
	// result: (MOVDaddridx [c+d] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XADDconst {
			break
		}
		d := v_1.AuxInt
		y := v_1.Args[0]
		if !(is20Bit(c+d) && y.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVDaddridx)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (MOVDaddridx [off1] {sym1} (MOVDaddr [off2] {sym2} x) y)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2) && x.Op != OpSB
	// result: (MOVDaddridx [off1+off2] {mergeSym(sym1,sym2)} x y)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		x := v_0.Args[0]
		y := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && x.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVDaddridx)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (MOVDaddridx [off1] {sym1} x (MOVDaddr [off2] {sym2} y))
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2) && y.Op != OpSB
	// result: (MOVDaddridx [off1+off2] {mergeSym(sym1,sym2)} x y)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_1.AuxInt
		sym2 := v_1.Aux
		y := v_1.Args[0]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && y.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVDaddridx)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVDload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDload [off] {sym} ptr (MOVDstore [off2] {sym2} ptr2 x _))
	// cond: sym == sym2 && off == off2 && isSamePtr(ptr, ptr2)
	// result: (MOVDreg x)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDstore {
			break
		}
		off2 := v_1.AuxInt
		sym2 := v_1.Aux
		ptr2 := v_1.Args[0]
		x := v_1.Args[1]
		if !(sym == sym2 && off == off2 && isSamePtr(ptr, ptr2)) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVDload   [off1] {sym} (ADDconst [off2] ptr) mem)
	// cond: is20Bit(off1+off2)
	// result: (MOVDload  [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XMOVDload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDload  [off1] {sym1} (MOVDaddr [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVDload  [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVDload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDload [off1] {sym1} (MOVDaddridx [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVDloadidx [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddridx {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVDloadidx)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDload [off] {sym} (ADD ptr idx) mem)
	// cond: ptr.Op != OpSB
	// result: (MOVDloadidx [off] {sym} ptr idx mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADD {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVDloadidx)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVDloadidx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDloadidx [c] {sym} (ADDconst [d] ptr) idx mem)
	// cond:
	// result: (MOVDloadidx [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XMOVDloadidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDloadidx [c] {sym} ptr (ADDconst [d] idx) mem)
	// cond:
	// result: (MOVDloadidx [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XADDconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpS390XMOVDloadidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVDreg(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDreg x)
	// cond: x.Uses == 1
	// result: (MOVDnop x)
	for {
		x := v.Args[0]
		if !(x.Uses == 1) {
			break
		}
		v.reset(OpS390XMOVDnop)
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVDstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDstore  [off1] {sym} (ADDconst [off2] ptr) val mem)
	// cond: is20Bit(off1+off2)
	// result: (MOVDstore  [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XMOVDstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDstore [off] {sym} ptr (MOVDconst [c]) mem)
	// cond: validValAndOff(c,off) && int64(int16(c)) == c && ptr.Op != OpSB
	// result: (MOVDstoreconst [makeValAndOff(c,off)] {sym} ptr mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		mem := v.Args[2]
		if !(validValAndOff(c, off) && int64(int16(c)) == c && ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVDstoreconst)
		v.AuxInt = makeValAndOff(c, off)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDstore  [off1] {sym1} (MOVDaddr [off2] {sym2} base) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVDstore  [off1+off2] {mergeSym(sym1,sym2)} base val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVDstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDstore [off1] {sym1} (MOVDaddridx [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVDstoreidx [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddridx {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVDstoreidx)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDstore [off] {sym} (ADD ptr idx) val mem)
	// cond: ptr.Op != OpSB
	// result: (MOVDstoreidx [off] {sym} ptr idx val mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADD {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVDstoreidx)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDstore [i] {s} p w1 x:(MOVDstore [i-8] {s} p w0 mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && is20Bit(i-8)   && clobber(x)
	// result: (STMG2 [i-8] {s} p w0 w1 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w1 := v.Args[1]
		x := v.Args[2]
		if x.Op != OpS390XMOVDstore {
			break
		}
		if x.AuxInt != i-8 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && is20Bit(i-8) && clobber(x)) {
			break
		}
		v.reset(OpS390XSTMG2)
		v.AuxInt = i - 8
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(w1)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDstore [i] {s} p w2 x:(STMG2 [i-16] {s} p w0 w1 mem))
	// cond: x.Uses == 1   && is20Bit(i-16)   && clobber(x)
	// result: (STMG3 [i-16] {s} p w0 w1 w2 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w2 := v.Args[1]
		x := v.Args[2]
		if x.Op != OpS390XSTMG2 {
			break
		}
		if x.AuxInt != i-16 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		w1 := x.Args[2]
		mem := x.Args[3]
		if !(x.Uses == 1 && is20Bit(i-16) && clobber(x)) {
			break
		}
		v.reset(OpS390XSTMG3)
		v.AuxInt = i - 16
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(w1)
		v.AddArg(w2)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDstore [i] {s} p w3 x:(STMG3 [i-24] {s} p w0 w1 w2 mem))
	// cond: x.Uses == 1   && is20Bit(i-24)   && clobber(x)
	// result: (STMG4 [i-24] {s} p w0 w1 w2 w3 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w3 := v.Args[1]
		x := v.Args[2]
		if x.Op != OpS390XSTMG3 {
			break
		}
		if x.AuxInt != i-24 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		w1 := x.Args[2]
		w2 := x.Args[3]
		mem := x.Args[4]
		if !(x.Uses == 1 && is20Bit(i-24) && clobber(x)) {
			break
		}
		v.reset(OpS390XSTMG4)
		v.AuxInt = i - 24
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(w1)
		v.AddArg(w2)
		v.AddArg(w3)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVDstoreconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDstoreconst [sc] {s} (ADDconst [off] ptr) mem)
	// cond: ValAndOff(sc).canAdd(off)
	// result: (MOVDstoreconst [ValAndOff(sc).add(off)] {s} ptr mem)
	for {
		sc := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(ValAndOff(sc).canAdd(off)) {
			break
		}
		v.reset(OpS390XMOVDstoreconst)
		v.AuxInt = ValAndOff(sc).add(off)
		v.Aux = s
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDstoreconst [sc] {sym1} (MOVDaddr [off] {sym2} ptr) mem)
	// cond: canMergeSym(sym1, sym2) && ValAndOff(sc).canAdd(off)
	// result: (MOVDstoreconst [ValAndOff(sc).add(off)] {mergeSym(sym1, sym2)} ptr mem)
	for {
		sc := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && ValAndOff(sc).canAdd(off)) {
			break
		}
		v.reset(OpS390XMOVDstoreconst)
		v.AuxInt = ValAndOff(sc).add(off)
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVDstoreidx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDstoreidx [c] {sym} (ADDconst [d] ptr) idx val mem)
	// cond:
	// result: (MOVDstoreidx [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(OpS390XMOVDstoreidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDstoreidx [c] {sym} ptr (ADDconst [d] idx) val mem)
	// cond:
	// result: (MOVDstoreidx [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XADDconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(OpS390XMOVDstoreidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVHBRstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHBRstore [i] {s} p (SRDconst [16] w) x:(MOVHBRstore [i-2] {s} p w mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWBRstore [i-2] {s} p w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XSRDconst {
			break
		}
		if v_1.AuxInt != 16 {
			break
		}
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVHBRstore {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if w != x.Args[1] {
			break
		}
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWBRstore)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHBRstore [i] {s} p (SRDconst [j] w) x:(MOVHBRstore [i-2] {s} p w0:(SRDconst [j-16] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWBRstore [i-2] {s} p w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XSRDconst {
			break
		}
		j := v_1.AuxInt
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVHBRstore {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		if w0.Op != OpS390XSRDconst {
			break
		}
		if w0.AuxInt != j-16 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWBRstore)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHBRstore [i] {s} p (SRWconst [16] w) x:(MOVHBRstore [i-2] {s} p w mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWBRstore [i-2] {s} p w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XSRWconst {
			break
		}
		if v_1.AuxInt != 16 {
			break
		}
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVHBRstore {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if w != x.Args[1] {
			break
		}
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWBRstore)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHBRstore [i] {s} p (SRWconst [j] w) x:(MOVHBRstore [i-2] {s} p w0:(SRWconst [j-16] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWBRstore [i-2] {s} p w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XSRWconst {
			break
		}
		j := v_1.AuxInt
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVHBRstore {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		if w0.Op != OpS390XSRWconst {
			break
		}
		if w0.AuxInt != j-16 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWBRstore)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVHBRstoreidx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHBRstoreidx [i] {s} p idx (SRDconst [16] w) x:(MOVHBRstoreidx [i-2] {s} p idx w mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWBRstoreidx [i-2] {s} p idx w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XSRDconst {
			break
		}
		if v_2.AuxInt != 16 {
			break
		}
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVHBRstoreidx {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		if w != x.Args[2] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWBRstoreidx)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHBRstoreidx [i] {s} p idx (SRDconst [j] w) x:(MOVHBRstoreidx [i-2] {s} p idx w0:(SRDconst [j-16] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWBRstoreidx [i-2] {s} p idx w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XSRDconst {
			break
		}
		j := v_2.AuxInt
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVHBRstoreidx {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		w0 := x.Args[2]
		if w0.Op != OpS390XSRDconst {
			break
		}
		if w0.AuxInt != j-16 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWBRstoreidx)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHBRstoreidx [i] {s} p idx (SRWconst [16] w) x:(MOVHBRstoreidx [i-2] {s} p idx w mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWBRstoreidx [i-2] {s} p idx w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XSRWconst {
			break
		}
		if v_2.AuxInt != 16 {
			break
		}
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVHBRstoreidx {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		if w != x.Args[2] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWBRstoreidx)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHBRstoreidx [i] {s} p idx (SRWconst [j] w) x:(MOVHBRstoreidx [i-2] {s} p idx w0:(SRWconst [j-16] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWBRstoreidx [i-2] {s} p idx w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XSRWconst {
			break
		}
		j := v_2.AuxInt
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVHBRstoreidx {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		w0 := x.Args[2]
		if w0.Op != OpS390XSRWconst {
			break
		}
		if w0.AuxInt != j-16 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWBRstoreidx)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVHZload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHZload [off] {sym} ptr (MOVHstore [off2] {sym2} ptr2 x _))
	// cond: sym == sym2 && off == off2 && isSamePtr(ptr, ptr2)
	// result: (MOVDreg x)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVHstore {
			break
		}
		off2 := v_1.AuxInt
		sym2 := v_1.Aux
		ptr2 := v_1.Args[0]
		x := v_1.Args[1]
		if !(sym == sym2 && off == off2 && isSamePtr(ptr, ptr2)) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHZload  [off1] {sym} (ADDconst [off2] ptr) mem)
	// cond: is20Bit(off1+off2)
	// result: (MOVHZload [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XMOVHZload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHZload  [off1] {sym1} (MOVDaddr [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVHZload  [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVHZload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHZload [off1] {sym1} (MOVDaddridx [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVHZloadidx [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddridx {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVHZloadidx)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHZload [off] {sym} (ADD ptr idx) mem)
	// cond: ptr.Op != OpSB
	// result: (MOVHZloadidx [off] {sym} ptr idx mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADD {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVHZloadidx)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVHZloadidx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHZloadidx [c] {sym} (ADDconst [d] ptr) idx mem)
	// cond:
	// result: (MOVHZloadidx [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XMOVHZloadidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHZloadidx [c] {sym} ptr (ADDconst [d] idx) mem)
	// cond:
	// result: (MOVHZloadidx [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XADDconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpS390XMOVHZloadidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVHZreg(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHZreg x:(MOVBZload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBZload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHZreg x:(MOVHZload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVHZload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHZreg x:(Arg <t>))
	// cond: (is8BitInt(t) || is16BitInt(t)) && !isSigned(t)
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpArg {
			break
		}
		t := x.Type
		if !((is8BitInt(t) || is16BitInt(t)) && !isSigned(t)) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHZreg x:(MOVBZreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBZreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHZreg x:(MOVHZreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVHZreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHZreg (MOVDconst [c]))
	// cond:
	// result: (MOVDconst [int64(uint16(c))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = int64(uint16(c))
		return true
	}
	// match: (MOVHZreg x:(MOVHZload [off] {sym} ptr mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVHZload <v.Type> [off] {sym} ptr mem)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVHZload {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		mem := x.Args[1]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, OpS390XMOVHZload, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(mem)
		return true
	}
	// match: (MOVHZreg x:(MOVHZloadidx [off] {sym} ptr idx mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVHZloadidx <v.Type> [off] {sym} ptr idx mem)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVHZloadidx {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		idx := x.Args[1]
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, OpS390XMOVHZloadidx, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(idx)
		v0.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVHload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHload   [off1] {sym} (ADDconst [off2] ptr) mem)
	// cond: is20Bit(off1+off2)
	// result: (MOVHload  [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XMOVHload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHload [off1] {sym1} (MOVDaddr [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVHload [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVHload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVHreg(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHreg x:(MOVBload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHreg x:(MOVBZload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBZload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHreg x:(MOVHload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVHload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHreg x:(Arg <t>))
	// cond: (is8BitInt(t) || is16BitInt(t)) && isSigned(t)
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpArg {
			break
		}
		t := x.Type
		if !((is8BitInt(t) || is16BitInt(t)) && isSigned(t)) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHreg x:(MOVBreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHreg x:(MOVBZreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBZreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHreg x:(MOVHreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVHreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHreg (MOVDconst [c]))
	// cond:
	// result: (MOVDconst [int64(int16(c))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = int64(int16(c))
		return true
	}
	// match: (MOVHreg x:(MOVHZload [off] {sym} ptr mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVHload <v.Type> [off] {sym} ptr mem)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVHZload {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		mem := x.Args[1]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, OpS390XMOVHload, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVHstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHstore [off] {sym} ptr (MOVHreg x) mem)
	// cond:
	// result: (MOVHstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVHreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpS390XMOVHstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore [off] {sym} ptr (MOVHZreg x) mem)
	// cond:
	// result: (MOVHstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVHZreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpS390XMOVHstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore  [off1] {sym} (ADDconst [off2] ptr) val mem)
	// cond: is20Bit(off1+off2)
	// result: (MOVHstore  [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XMOVHstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore [off] {sym} ptr (MOVDconst [c]) mem)
	// cond: validOff(off) && ptr.Op != OpSB
	// result: (MOVHstoreconst [makeValAndOff(int64(int16(c)),off)] {sym} ptr mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		mem := v.Args[2]
		if !(validOff(off) && ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVHstoreconst)
		v.AuxInt = makeValAndOff(int64(int16(c)), off)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore  [off1] {sym1} (MOVDaddr [off2] {sym2} base) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVHstore  [off1+off2] {mergeSym(sym1,sym2)} base val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVHstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore [off1] {sym1} (MOVDaddridx [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVHstoreidx [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddridx {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVHstoreidx)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore [off] {sym} (ADD ptr idx) val mem)
	// cond: ptr.Op != OpSB
	// result: (MOVHstoreidx [off] {sym} ptr idx val mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADD {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVHstoreidx)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore [i] {s} p w x:(MOVHstore [i-2] {s} p (SRDconst [16] w) mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && clobber(x)
	// result: (MOVWstore [i-2] {s} p w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w := v.Args[1]
		x := v.Args[2]
		if x.Op != OpS390XMOVHstore {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		x_1 := x.Args[1]
		if x_1.Op != OpS390XSRDconst {
			break
		}
		if x_1.AuxInt != 16 {
			break
		}
		if w != x_1.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWstore)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore [i] {s} p w0:(SRDconst [j] w) x:(MOVHstore [i-2] {s} p (SRDconst [j+16] w) mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && clobber(x)
	// result: (MOVWstore [i-2] {s} p w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w0 := v.Args[1]
		if w0.Op != OpS390XSRDconst {
			break
		}
		j := w0.AuxInt
		w := w0.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVHstore {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		x_1 := x.Args[1]
		if x_1.Op != OpS390XSRDconst {
			break
		}
		if x_1.AuxInt != j+16 {
			break
		}
		if w != x_1.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWstore)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore [i] {s} p w x:(MOVHstore [i-2] {s} p (SRWconst [16] w) mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && clobber(x)
	// result: (MOVWstore [i-2] {s} p w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w := v.Args[1]
		x := v.Args[2]
		if x.Op != OpS390XMOVHstore {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		x_1 := x.Args[1]
		if x_1.Op != OpS390XSRWconst {
			break
		}
		if x_1.AuxInt != 16 {
			break
		}
		if w != x_1.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWstore)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore [i] {s} p w0:(SRWconst [j] w) x:(MOVHstore [i-2] {s} p (SRWconst [j+16] w) mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && clobber(x)
	// result: (MOVWstore [i-2] {s} p w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w0 := v.Args[1]
		if w0.Op != OpS390XSRWconst {
			break
		}
		j := w0.AuxInt
		w := w0.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVHstore {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		x_1 := x.Args[1]
		if x_1.Op != OpS390XSRWconst {
			break
		}
		if x_1.AuxInt != j+16 {
			break
		}
		if w != x_1.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWstore)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVHstoreconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHstoreconst [sc] {s} (ADDconst [off] ptr) mem)
	// cond: ValAndOff(sc).canAdd(off)
	// result: (MOVHstoreconst [ValAndOff(sc).add(off)] {s} ptr mem)
	for {
		sc := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(ValAndOff(sc).canAdd(off)) {
			break
		}
		v.reset(OpS390XMOVHstoreconst)
		v.AuxInt = ValAndOff(sc).add(off)
		v.Aux = s
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstoreconst [sc] {sym1} (MOVDaddr [off] {sym2} ptr) mem)
	// cond: canMergeSym(sym1, sym2) && ValAndOff(sc).canAdd(off)
	// result: (MOVHstoreconst [ValAndOff(sc).add(off)] {mergeSym(sym1, sym2)} ptr mem)
	for {
		sc := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && ValAndOff(sc).canAdd(off)) {
			break
		}
		v.reset(OpS390XMOVHstoreconst)
		v.AuxInt = ValAndOff(sc).add(off)
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstoreconst [c] {s} p x:(MOVHstoreconst [a] {s} p mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && ValAndOff(a).Off() + 2 == ValAndOff(c).Off()   && clobber(x)
	// result: (MOVWstoreconst [makeValAndOff(ValAndOff(c).Val()&0xffff | ValAndOff(a).Val()<<16, ValAndOff(a).Off())] {s} p mem)
	for {
		c := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		x := v.Args[1]
		if x.Op != OpS390XMOVHstoreconst {
			break
		}
		a := x.AuxInt
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		mem := x.Args[1]
		if !(p.Op != OpSB && x.Uses == 1 && ValAndOff(a).Off()+2 == ValAndOff(c).Off() && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWstoreconst)
		v.AuxInt = makeValAndOff(ValAndOff(c).Val()&0xffff|ValAndOff(a).Val()<<16, ValAndOff(a).Off())
		v.Aux = s
		v.AddArg(p)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVHstoreidx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHstoreidx [c] {sym} (ADDconst [d] ptr) idx val mem)
	// cond:
	// result: (MOVHstoreidx [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(OpS390XMOVHstoreidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstoreidx [c] {sym} ptr (ADDconst [d] idx) val mem)
	// cond:
	// result: (MOVHstoreidx [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XADDconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(OpS390XMOVHstoreidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstoreidx [i] {s} p idx w x:(MOVHstoreidx [i-2] {s} p idx (SRDconst [16] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWstoreidx [i-2] {s} p idx w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		w := v.Args[2]
		x := v.Args[3]
		if x.Op != OpS390XMOVHstoreidx {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		x_2 := x.Args[2]
		if x_2.Op != OpS390XSRDconst {
			break
		}
		if x_2.AuxInt != 16 {
			break
		}
		if w != x_2.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWstoreidx)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstoreidx [i] {s} p idx w0:(SRDconst [j] w) x:(MOVHstoreidx [i-2] {s} p idx (SRDconst [j+16] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWstoreidx [i-2] {s} p idx w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		w0 := v.Args[2]
		if w0.Op != OpS390XSRDconst {
			break
		}
		j := w0.AuxInt
		w := w0.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVHstoreidx {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		x_2 := x.Args[2]
		if x_2.Op != OpS390XSRDconst {
			break
		}
		if x_2.AuxInt != j+16 {
			break
		}
		if w != x_2.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWstoreidx)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstoreidx [i] {s} p idx w x:(MOVHstoreidx [i-2] {s} p idx (SRWconst [16] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWstoreidx [i-2] {s} p idx w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		w := v.Args[2]
		x := v.Args[3]
		if x.Op != OpS390XMOVHstoreidx {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		x_2 := x.Args[2]
		if x_2.Op != OpS390XSRWconst {
			break
		}
		if x_2.AuxInt != 16 {
			break
		}
		if w != x_2.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWstoreidx)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstoreidx [i] {s} p idx w0:(SRWconst [j] w) x:(MOVHstoreidx [i-2] {s} p idx (SRWconst [j+16] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWstoreidx [i-2] {s} p idx w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		w0 := v.Args[2]
		if w0.Op != OpS390XSRWconst {
			break
		}
		j := w0.AuxInt
		w := w0.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVHstoreidx {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		x_2 := x.Args[2]
		if x_2.Op != OpS390XSRWconst {
			break
		}
		if x_2.AuxInt != j+16 {
			break
		}
		if w != x_2.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVWstoreidx)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVWBRstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWBRstore [i] {s} p (SRDconst [32] w) x:(MOVWBRstore [i-4] {s} p w mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVDBRstore [i-4] {s} p w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XSRDconst {
			break
		}
		if v_1.AuxInt != 32 {
			break
		}
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVWBRstore {
			break
		}
		if x.AuxInt != i-4 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if w != x.Args[1] {
			break
		}
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVDBRstore)
		v.AuxInt = i - 4
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWBRstore [i] {s} p (SRDconst [j] w) x:(MOVWBRstore [i-4] {s} p w0:(SRDconst [j-32] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVDBRstore [i-4] {s} p w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XSRDconst {
			break
		}
		j := v_1.AuxInt
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVWBRstore {
			break
		}
		if x.AuxInt != i-4 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		if w0.Op != OpS390XSRDconst {
			break
		}
		if w0.AuxInt != j-32 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVDBRstore)
		v.AuxInt = i - 4
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVWBRstoreidx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWBRstoreidx [i] {s} p idx (SRDconst [32] w) x:(MOVWBRstoreidx [i-4] {s} p idx w mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVDBRstoreidx [i-4] {s} p idx w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XSRDconst {
			break
		}
		if v_2.AuxInt != 32 {
			break
		}
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVWBRstoreidx {
			break
		}
		if x.AuxInt != i-4 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		if w != x.Args[2] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVDBRstoreidx)
		v.AuxInt = i - 4
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWBRstoreidx [i] {s} p idx (SRDconst [j] w) x:(MOVWBRstoreidx [i-4] {s} p idx w0:(SRDconst [j-32] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVDBRstoreidx [i-4] {s} p idx w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != OpS390XSRDconst {
			break
		}
		j := v_2.AuxInt
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVWBRstoreidx {
			break
		}
		if x.AuxInt != i-4 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		w0 := x.Args[2]
		if w0.Op != OpS390XSRDconst {
			break
		}
		if w0.AuxInt != j-32 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVDBRstoreidx)
		v.AuxInt = i - 4
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVWZload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWZload [off] {sym} ptr (MOVWstore [off2] {sym2} ptr2 x _))
	// cond: sym == sym2 && off == off2 && isSamePtr(ptr, ptr2)
	// result: (MOVDreg x)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVWstore {
			break
		}
		off2 := v_1.AuxInt
		sym2 := v_1.Aux
		ptr2 := v_1.Args[0]
		x := v_1.Args[1]
		if !(sym == sym2 && off == off2 && isSamePtr(ptr, ptr2)) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWZload  [off1] {sym} (ADDconst [off2] ptr) mem)
	// cond: is20Bit(off1+off2)
	// result: (MOVWZload [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XMOVWZload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWZload  [off1] {sym1} (MOVDaddr [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVWZload  [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVWZload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWZload [off1] {sym1} (MOVDaddridx [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVWZloadidx [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddridx {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVWZloadidx)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWZload [off] {sym} (ADD ptr idx) mem)
	// cond: ptr.Op != OpSB
	// result: (MOVWZloadidx [off] {sym} ptr idx mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADD {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVWZloadidx)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVWZloadidx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWZloadidx [c] {sym} (ADDconst [d] ptr) idx mem)
	// cond:
	// result: (MOVWZloadidx [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XMOVWZloadidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWZloadidx [c] {sym} ptr (ADDconst [d] idx) mem)
	// cond:
	// result: (MOVWZloadidx [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XADDconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpS390XMOVWZloadidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVWZreg(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWZreg x:(MOVBZload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBZload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWZreg x:(MOVHZload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVHZload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWZreg x:(MOVWZload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVWZload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWZreg x:(Arg <t>))
	// cond: (is8BitInt(t) || is16BitInt(t) || is32BitInt(t)) && !isSigned(t)
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpArg {
			break
		}
		t := x.Type
		if !((is8BitInt(t) || is16BitInt(t) || is32BitInt(t)) && !isSigned(t)) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWZreg x:(MOVBZreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBZreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWZreg x:(MOVHZreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVHZreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWZreg x:(MOVWZreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVWZreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWZreg (MOVDconst [c]))
	// cond:
	// result: (MOVDconst [int64(uint32(c))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = int64(uint32(c))
		return true
	}
	// match: (MOVWZreg x:(MOVWZload [off] {sym} ptr mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVWZload <v.Type> [off] {sym} ptr mem)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVWZload {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		mem := x.Args[1]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, OpS390XMOVWZload, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(mem)
		return true
	}
	// match: (MOVWZreg x:(MOVWZloadidx [off] {sym} ptr idx mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVWZloadidx <v.Type> [off] {sym} ptr idx mem)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVWZloadidx {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		idx := x.Args[1]
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, OpS390XMOVWZloadidx, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(idx)
		v0.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVWload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWload   [off1] {sym} (ADDconst [off2] ptr) mem)
	// cond: is20Bit(off1+off2)
	// result: (MOVWload  [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XMOVWload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWload [off1] {sym1} (MOVDaddr [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVWload [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVWload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVWreg(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWreg x:(MOVBload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVBZload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBZload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVHload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVHload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVHZload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVHZload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVWload _ _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVWload {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(Arg <t>))
	// cond: (is8BitInt(t) || is16BitInt(t) || is32BitInt(t)) && isSigned(t)
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpArg {
			break
		}
		t := x.Type
		if !((is8BitInt(t) || is16BitInt(t) || is32BitInt(t)) && isSigned(t)) {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVBreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVBZreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVBZreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVHreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVHreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVHreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVHreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVWreg _))
	// cond:
	// result: (MOVDreg x)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVWreg {
			break
		}
		v.reset(OpS390XMOVDreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg (MOVDconst [c]))
	// cond:
	// result: (MOVDconst [int64(int32(c))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = int64(int32(c))
		return true
	}
	// match: (MOVWreg x:(MOVWZload [off] {sym} ptr mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVWload <v.Type> [off] {sym} ptr mem)
	for {
		x := v.Args[0]
		if x.Op != OpS390XMOVWZload {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		mem := x.Args[1]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, OpS390XMOVWload, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVWstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWstore [off] {sym} ptr (MOVWreg x) mem)
	// cond:
	// result: (MOVWstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVWreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpS390XMOVWstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [off] {sym} ptr (MOVWZreg x) mem)
	// cond:
	// result: (MOVWstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVWZreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpS390XMOVWstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore  [off1] {sym} (ADDconst [off2] ptr) val mem)
	// cond: is20Bit(off1+off2)
	// result: (MOVWstore  [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is20Bit(off1 + off2)) {
			break
		}
		v.reset(OpS390XMOVWstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [off] {sym} ptr (MOVDconst [c]) mem)
	// cond: validOff(off) && int64(int16(c)) == c && ptr.Op != OpSB
	// result: (MOVWstoreconst [makeValAndOff(int64(int32(c)),off)] {sym} ptr mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		mem := v.Args[2]
		if !(validOff(off) && int64(int16(c)) == c && ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVWstoreconst)
		v.AuxInt = makeValAndOff(int64(int32(c)), off)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore  [off1] {sym1} (MOVDaddr [off2] {sym2} base) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVWstore  [off1+off2] {mergeSym(sym1,sym2)} base val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVWstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [off1] {sym1} (MOVDaddridx [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVWstoreidx [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddridx {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(OpS390XMOVWstoreidx)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [off] {sym} (ADD ptr idx) val mem)
	// cond: ptr.Op != OpSB
	// result: (MOVWstoreidx [off] {sym} ptr idx val mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADD {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(OpS390XMOVWstoreidx)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [i] {s} p (SRDconst [32] w) x:(MOVWstore [i-4] {s} p w mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && clobber(x)
	// result: (MOVDstore [i-4] {s} p w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XSRDconst {
			break
		}
		if v_1.AuxInt != 32 {
			break
		}
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVWstore {
			break
		}
		if x.AuxInt != i-4 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if w != x.Args[1] {
			break
		}
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVDstore)
		v.AuxInt = i - 4
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [i] {s} p w0:(SRDconst [j] w) x:(MOVWstore [i-4] {s} p (SRDconst [j+32] w) mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && clobber(x)
	// result: (MOVDstore [i-4] {s} p w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w0 := v.Args[1]
		if w0.Op != OpS390XSRDconst {
			break
		}
		j := w0.AuxInt
		w := w0.Args[0]
		x := v.Args[2]
		if x.Op != OpS390XMOVWstore {
			break
		}
		if x.AuxInt != i-4 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		x_1 := x.Args[1]
		if x_1.Op != OpS390XSRDconst {
			break
		}
		if x_1.AuxInt != j+32 {
			break
		}
		if w != x_1.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVDstore)
		v.AuxInt = i - 4
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [i] {s} p w1 x:(MOVWstore [i-4] {s} p w0 mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && is20Bit(i-4)   && clobber(x)
	// result: (STM2 [i-4] {s} p w0 w1 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w1 := v.Args[1]
		x := v.Args[2]
		if x.Op != OpS390XMOVWstore {
			break
		}
		if x.AuxInt != i-4 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		mem := x.Args[2]
		if !(p.Op != OpSB && x.Uses == 1 && is20Bit(i-4) && clobber(x)) {
			break
		}
		v.reset(OpS390XSTM2)
		v.AuxInt = i - 4
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(w1)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [i] {s} p w2 x:(STM2 [i-8] {s} p w0 w1 mem))
	// cond: x.Uses == 1   && is20Bit(i-8)   && clobber(x)
	// result: (STM3 [i-8] {s} p w0 w1 w2 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w2 := v.Args[1]
		x := v.Args[2]
		if x.Op != OpS390XSTM2 {
			break
		}
		if x.AuxInt != i-8 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		w1 := x.Args[2]
		mem := x.Args[3]
		if !(x.Uses == 1 && is20Bit(i-8) && clobber(x)) {
			break
		}
		v.reset(OpS390XSTM3)
		v.AuxInt = i - 8
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(w1)
		v.AddArg(w2)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [i] {s} p w3 x:(STM3 [i-12] {s} p w0 w1 w2 mem))
	// cond: x.Uses == 1   && is20Bit(i-12)   && clobber(x)
	// result: (STM4 [i-12] {s} p w0 w1 w2 w3 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w3 := v.Args[1]
		x := v.Args[2]
		if x.Op != OpS390XSTM3 {
			break
		}
		if x.AuxInt != i-12 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		w1 := x.Args[2]
		w2 := x.Args[3]
		mem := x.Args[4]
		if !(x.Uses == 1 && is20Bit(i-12) && clobber(x)) {
			break
		}
		v.reset(OpS390XSTM4)
		v.AuxInt = i - 12
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(w1)
		v.AddArg(w2)
		v.AddArg(w3)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVWstoreconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWstoreconst [sc] {s} (ADDconst [off] ptr) mem)
	// cond: ValAndOff(sc).canAdd(off)
	// result: (MOVWstoreconst [ValAndOff(sc).add(off)] {s} ptr mem)
	for {
		sc := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		off := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(ValAndOff(sc).canAdd(off)) {
			break
		}
		v.reset(OpS390XMOVWstoreconst)
		v.AuxInt = ValAndOff(sc).add(off)
		v.Aux = s
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreconst [sc] {sym1} (MOVDaddr [off] {sym2} ptr) mem)
	// cond: canMergeSym(sym1, sym2) && ValAndOff(sc).canAdd(off)
	// result: (MOVWstoreconst [ValAndOff(sc).add(off)] {mergeSym(sym1, sym2)} ptr mem)
	for {
		sc := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDaddr {
			break
		}
		off := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && ValAndOff(sc).canAdd(off)) {
			break
		}
		v.reset(OpS390XMOVWstoreconst)
		v.AuxInt = ValAndOff(sc).add(off)
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreconst [c] {s} p x:(MOVWstoreconst [a] {s} p mem))
	// cond: p.Op != OpSB   && x.Uses == 1   && ValAndOff(a).Off() + 4 == ValAndOff(c).Off()   && clobber(x)
	// result: (MOVDstore [ValAndOff(a).Off()] {s} p (MOVDconst [ValAndOff(c).Val()&0xffffffff | ValAndOff(a).Val()<<32]) mem)
	for {
		c := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		x := v.Args[1]
		if x.Op != OpS390XMOVWstoreconst {
			break
		}
		a := x.AuxInt
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		mem := x.Args[1]
		if !(p.Op != OpSB && x.Uses == 1 && ValAndOff(a).Off()+4 == ValAndOff(c).Off() && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVDstore)
		v.AuxInt = ValAndOff(a).Off()
		v.Aux = s
		v.AddArg(p)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = ValAndOff(c).Val()&0xffffffff | ValAndOff(a).Val()<<32
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMOVWstoreidx(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWstoreidx [c] {sym} (ADDconst [d] ptr) idx val mem)
	// cond:
	// result: (MOVWstoreidx [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpS390XADDconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(OpS390XMOVWstoreidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreidx [c] {sym} ptr (ADDconst [d] idx) val mem)
	// cond:
	// result: (MOVWstoreidx [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XADDconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(OpS390XMOVWstoreidx)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreidx [i] {s} p idx w x:(MOVWstoreidx [i-4] {s} p idx (SRDconst [32] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVDstoreidx [i-4] {s} p idx w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		w := v.Args[2]
		x := v.Args[3]
		if x.Op != OpS390XMOVWstoreidx {
			break
		}
		if x.AuxInt != i-4 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		x_2 := x.Args[2]
		if x_2.Op != OpS390XSRDconst {
			break
		}
		if x_2.AuxInt != 32 {
			break
		}
		if w != x_2.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVDstoreidx)
		v.AuxInt = i - 4
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreidx [i] {s} p idx w0:(SRDconst [j] w) x:(MOVWstoreidx [i-4] {s} p idx (SRDconst [j+32] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVDstoreidx [i-4] {s} p idx w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		w0 := v.Args[2]
		if w0.Op != OpS390XSRDconst {
			break
		}
		j := w0.AuxInt
		w := w0.Args[0]
		x := v.Args[3]
		if x.Op != OpS390XMOVWstoreidx {
			break
		}
		if x.AuxInt != i-4 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		x_2 := x.Args[2]
		if x_2.Op != OpS390XSRDconst {
			break
		}
		if x_2.AuxInt != j+32 {
			break
		}
		if w != x_2.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(OpS390XMOVDstoreidx)
		v.AuxInt = i - 4
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMULLD(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MULLD x (MOVDconst [c]))
	// cond: is32Bit(c)
	// result: (MULLDconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpS390XMULLDconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (MULLD (MOVDconst [c]) x)
	// cond: is32Bit(c)
	// result: (MULLDconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpS390XMULLDconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (MULLD <t> x g:(MOVDload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (MULLDload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVDload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XMULLDload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MULLD <t> g:(MOVDload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (MULLDload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVDload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XMULLDload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMULLDconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MULLDconst [-1] x)
	// cond:
	// result: (NEG x)
	for {
		if v.AuxInt != -1 {
			break
		}
		x := v.Args[0]
		v.reset(OpS390XNEG)
		v.AddArg(x)
		return true
	}
	// match: (MULLDconst [0] _)
	// cond:
	// result: (MOVDconst [0])
	for {
		if v.AuxInt != 0 {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = 0
		return true
	}
	// match: (MULLDconst [1] x)
	// cond:
	// result: x
	for {
		if v.AuxInt != 1 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (MULLDconst [c] x)
	// cond: isPowerOfTwo(c)
	// result: (SLDconst [log2(c)] x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(isPowerOfTwo(c)) {
			break
		}
		v.reset(OpS390XSLDconst)
		v.AuxInt = log2(c)
		v.AddArg(x)
		return true
	}
	// match: (MULLDconst [c] x)
	// cond: isPowerOfTwo(c+1) && c >= 15
	// result: (SUB (SLDconst <v.Type> [log2(c+1)] x) x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(isPowerOfTwo(c+1) && c >= 15) {
			break
		}
		v.reset(OpS390XSUB)
		v0 := b.NewValue0(v.Line, OpS390XSLDconst, v.Type)
		v0.AuxInt = log2(c + 1)
		v0.AddArg(x)
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
	// match: (MULLDconst [c] x)
	// cond: isPowerOfTwo(c-1) && c >= 17
	// result: (ADD (SLDconst <v.Type> [log2(c-1)] x) x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(isPowerOfTwo(c-1) && c >= 17) {
			break
		}
		v.reset(OpS390XADD)
		v0 := b.NewValue0(v.Line, OpS390XSLDconst, v.Type)
		v0.AuxInt = log2(c - 1)
		v0.AddArg(x)
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
	// match: (MULLDconst [c] (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [c*d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = c * d
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMULLW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MULLW x (MOVDconst [c]))
	// cond:
	// result: (MULLWconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpS390XMULLWconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (MULLW (MOVDconst [c]) x)
	// cond:
	// result: (MULLWconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(OpS390XMULLWconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (MULLW <t> x g:(MOVWload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (MULLWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVWload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XMULLWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MULLW <t> g:(MOVWload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (MULLWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVWload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XMULLWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MULLW <t> x g:(MOVWZload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (MULLWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVWZload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XMULLWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MULLW <t> g:(MOVWZload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (MULLWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVWZload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XMULLWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XMULLWconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MULLWconst [-1] x)
	// cond:
	// result: (NEGW x)
	for {
		if v.AuxInt != -1 {
			break
		}
		x := v.Args[0]
		v.reset(OpS390XNEGW)
		v.AddArg(x)
		return true
	}
	// match: (MULLWconst [0] _)
	// cond:
	// result: (MOVDconst [0])
	for {
		if v.AuxInt != 0 {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = 0
		return true
	}
	// match: (MULLWconst [1] x)
	// cond:
	// result: x
	for {
		if v.AuxInt != 1 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (MULLWconst [c] x)
	// cond: isPowerOfTwo(c)
	// result: (SLWconst [log2(c)] x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(isPowerOfTwo(c)) {
			break
		}
		v.reset(OpS390XSLWconst)
		v.AuxInt = log2(c)
		v.AddArg(x)
		return true
	}
	// match: (MULLWconst [c] x)
	// cond: isPowerOfTwo(c+1) && c >= 15
	// result: (SUBW (SLWconst <v.Type> [log2(c+1)] x) x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(isPowerOfTwo(c+1) && c >= 15) {
			break
		}
		v.reset(OpS390XSUBW)
		v0 := b.NewValue0(v.Line, OpS390XSLWconst, v.Type)
		v0.AuxInt = log2(c + 1)
		v0.AddArg(x)
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
	// match: (MULLWconst [c] x)
	// cond: isPowerOfTwo(c-1) && c >= 17
	// result: (ADDW (SLWconst <v.Type> [log2(c-1)] x) x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(isPowerOfTwo(c-1) && c >= 17) {
			break
		}
		v.reset(OpS390XADDW)
		v0 := b.NewValue0(v.Line, OpS390XSLWconst, v.Type)
		v0.AuxInt = log2(c - 1)
		v0.AddArg(x)
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
	// match: (MULLWconst [c] (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [int64(int32(c*d))])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = int64(int32(c * d))
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XNEG(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NEG (MOVDconst [c]))
	// cond:
	// result: (MOVDconst [-c])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = -c
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XNEGW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NEGW (MOVDconst [c]))
	// cond:
	// result: (MOVDconst [int64(int32(-c))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = int64(int32(-c))
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XNOT(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NOT x)
	// cond: true
	// result: (XOR (MOVDconst [-1]) x)
	for {
		x := v.Args[0]
		if !(true) {
			break
		}
		v.reset(OpS390XXOR)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = -1
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XNOTW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NOTW x)
	// cond: true
	// result: (XORWconst [-1] x)
	for {
		x := v.Args[0]
		if !(true) {
			break
		}
		v.reset(OpS390XXORWconst)
		v.AuxInt = -1
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XOR(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (OR x (MOVDconst [c]))
	// cond: isU32Bit(c)
	// result: (ORconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		if !(isU32Bit(c)) {
			break
		}
		v.reset(OpS390XORconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (OR (MOVDconst [c]) x)
	// cond: isU32Bit(c)
	// result: (ORconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(isU32Bit(c)) {
			break
		}
		v.reset(OpS390XORconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (OR (MOVDconst [c]) (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [c|d])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		d := v_1.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = c | d
		return true
	}
	// match: (OR x x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (OR <t> x g:(MOVDload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ORload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVDload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XORload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (OR <t> g:(MOVDload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ORload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVDload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XORload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (OR o0:(OR o1:(OR o2:(OR o3:(OR o4:(OR o5:(OR                       x0:(MOVBZload [i]   {s} p mem)     s0:(SLDconst [8]  x1:(MOVBZload [i+1] {s} p mem)))     s1:(SLDconst [16] x2:(MOVBZload [i+2] {s} p mem)))     s2:(SLDconst [24] x3:(MOVBZload [i+3] {s} p mem)))     s3:(SLDconst [32] x4:(MOVBZload [i+4] {s} p mem)))     s4:(SLDconst [40] x5:(MOVBZload [i+5] {s} p mem)))     s5:(SLDconst [48] x6:(MOVBZload [i+6] {s} p mem)))     s6:(SLDconst [56] x7:(MOVBZload [i+7] {s} p mem)))
	// cond: p.Op != OpSB   && x0.Uses == 1   && x1.Uses == 1   && x2.Uses == 1   && x3.Uses == 1   && x4.Uses == 1   && x5.Uses == 1   && x6.Uses == 1   && x7.Uses == 1   && s0.Uses == 1   && s1.Uses == 1   && s2.Uses == 1   && s3.Uses == 1   && s4.Uses == 1   && s5.Uses == 1   && s6.Uses == 1   && o0.Uses == 1   && o1.Uses == 1   && o2.Uses == 1   && o3.Uses == 1   && o4.Uses == 1   && o5.Uses == 1   && mergePoint(b,x0,x1,x2,x3,x4,x5,x6,x7) != nil   && clobber(x0)   && clobber(x1)   && clobber(x2)   && clobber(x3)   && clobber(x4)   && clobber(x5)   && clobber(x6)   && clobber(x7)   && clobber(s0)   && clobber(s1)   && clobber(s2)   && clobber(s3)   && clobber(s4)   && clobber(s5)   && clobber(s6)   && clobber(o0)   && clobber(o1)   && clobber(o2)   && clobber(o3)   && clobber(o4)   && clobber(o5)
	// result: @mergePoint(b,x0,x1,x2,x3,x4,x5,x6,x7) (MOVDBRload [i] {s} p mem)
	for {
		o0 := v.Args[0]
		if o0.Op != OpS390XOR {
			break
		}
		o1 := o0.Args[0]
		if o1.Op != OpS390XOR {
			break
		}
		o2 := o1.Args[0]
		if o2.Op != OpS390XOR {
			break
		}
		o3 := o2.Args[0]
		if o3.Op != OpS390XOR {
			break
		}
		o4 := o3.Args[0]
		if o4.Op != OpS390XOR {
			break
		}
		o5 := o4.Args[0]
		if o5.Op != OpS390XOR {
			break
		}
		x0 := o5.Args[0]
		if x0.Op != OpS390XMOVBZload {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		mem := x0.Args[1]
		s0 := o5.Args[1]
		if s0.Op != OpS390XSLDconst {
			break
		}
		if s0.AuxInt != 8 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != OpS390XMOVBZload {
			break
		}
		if x1.AuxInt != i+1 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if mem != x1.Args[1] {
			break
		}
		s1 := o4.Args[1]
		if s1.Op != OpS390XSLDconst {
			break
		}
		if s1.AuxInt != 16 {
			break
		}
		x2 := s1.Args[0]
		if x2.Op != OpS390XMOVBZload {
			break
		}
		if x2.AuxInt != i+2 {
			break
		}
		if x2.Aux != s {
			break
		}
		if p != x2.Args[0] {
			break
		}
		if mem != x2.Args[1] {
			break
		}
		s2 := o3.Args[1]
		if s2.Op != OpS390XSLDconst {
			break
		}
		if s2.AuxInt != 24 {
			break
		}
		x3 := s2.Args[0]
		if x3.Op != OpS390XMOVBZload {
			break
		}
		if x3.AuxInt != i+3 {
			break
		}
		if x3.Aux != s {
			break
		}
		if p != x3.Args[0] {
			break
		}
		if mem != x3.Args[1] {
			break
		}
		s3 := o2.Args[1]
		if s3.Op != OpS390XSLDconst {
			break
		}
		if s3.AuxInt != 32 {
			break
		}
		x4 := s3.Args[0]
		if x4.Op != OpS390XMOVBZload {
			break
		}
		if x4.AuxInt != i+4 {
			break
		}
		if x4.Aux != s {
			break
		}
		if p != x4.Args[0] {
			break
		}
		if mem != x4.Args[1] {
			break
		}
		s4 := o1.Args[1]
		if s4.Op != OpS390XSLDconst {
			break
		}
		if s4.AuxInt != 40 {
			break
		}
		x5 := s4.Args[0]
		if x5.Op != OpS390XMOVBZload {
			break
		}
		if x5.AuxInt != i+5 {
			break
		}
		if x5.Aux != s {
			break
		}
		if p != x5.Args[0] {
			break
		}
		if mem != x5.Args[1] {
			break
		}
		s5 := o0.Args[1]
		if s5.Op != OpS390XSLDconst {
			break
		}
		if s5.AuxInt != 48 {
			break
		}
		x6 := s5.Args[0]
		if x6.Op != OpS390XMOVBZload {
			break
		}
		if x6.AuxInt != i+6 {
			break
		}
		if x6.Aux != s {
			break
		}
		if p != x6.Args[0] {
			break
		}
		if mem != x6.Args[1] {
			break
		}
		s6 := v.Args[1]
		if s6.Op != OpS390XSLDconst {
			break
		}
		if s6.AuxInt != 56 {
			break
		}
		x7 := s6.Args[0]
		if x7.Op != OpS390XMOVBZload {
			break
		}
		if x7.AuxInt != i+7 {
			break
		}
		if x7.Aux != s {
			break
		}
		if p != x7.Args[0] {
			break
		}
		if mem != x7.Args[1] {
			break
		}
		if !(p.Op != OpSB && x0.Uses == 1 && x1.Uses == 1 && x2.Uses == 1 && x3.Uses == 1 && x4.Uses == 1 && x5.Uses == 1 && x6.Uses == 1 && x7.Uses == 1 && s0.Uses == 1 && s1.Uses == 1 && s2.Uses == 1 && s3.Uses == 1 && s4.Uses == 1 && s5.Uses == 1 && s6.Uses == 1 && o0.Uses == 1 && o1.Uses == 1 && o2.Uses == 1 && o3.Uses == 1 && o4.Uses == 1 && o5.Uses == 1 && mergePoint(b, x0, x1, x2, x3, x4, x5, x6, x7) != nil && clobber(x0) && clobber(x1) && clobber(x2) && clobber(x3) && clobber(x4) && clobber(x5) && clobber(x6) && clobber(x7) && clobber(s0) && clobber(s1) && clobber(s2) && clobber(s3) && clobber(s4) && clobber(s5) && clobber(s6) && clobber(o0) && clobber(o1) && clobber(o2) && clobber(o3) && clobber(o4) && clobber(o5)) {
			break
		}
		b = mergePoint(b, x0, x1, x2, x3, x4, x5, x6, x7)
		v0 := b.NewValue0(v.Line, OpS390XMOVDBRload, config.fe.TypeUInt64())
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = i
		v0.Aux = s
		v0.AddArg(p)
		v0.AddArg(mem)
		return true
	}
	// match: (OR o0:(OR o1:(OR o2:(OR o3:(OR o4:(OR o5:(OR                       x0:(MOVBZloadidx [i]   {s} p idx mem)     s0:(SLDconst [8]  x1:(MOVBZloadidx [i+1] {s} p idx mem)))     s1:(SLDconst [16] x2:(MOVBZloadidx [i+2] {s} p idx mem)))     s2:(SLDconst [24] x3:(MOVBZloadidx [i+3] {s} p idx mem)))     s3:(SLDconst [32] x4:(MOVBZloadidx [i+4] {s} p idx mem)))     s4:(SLDconst [40] x5:(MOVBZloadidx [i+5] {s} p idx mem)))     s5:(SLDconst [48] x6:(MOVBZloadidx [i+6] {s} p idx mem)))     s6:(SLDconst [56] x7:(MOVBZloadidx [i+7] {s} p idx mem)))
	// cond: x0.Uses == 1   && x1.Uses == 1   && x2.Uses == 1   && x3.Uses == 1   && x4.Uses == 1   && x5.Uses == 1   && x6.Uses == 1   && x7.Uses == 1   && s0.Uses == 1   && s1.Uses == 1   && s2.Uses == 1   && s3.Uses == 1   && s4.Uses == 1   && s5.Uses == 1   && s6.Uses == 1   && o0.Uses == 1   && o1.Uses == 1   && o2.Uses == 1   && o3.Uses == 1   && o4.Uses == 1   && o5.Uses == 1   && mergePoint(b,x0,x1,x2,x3,x4,x5,x6,x7) != nil   && clobber(x0)   && clobber(x1)   && clobber(x2)   && clobber(x3)   && clobber(x4)   && clobber(x5)   && clobber(x6)   && clobber(x7)   && clobber(s0)   && clobber(s1)   && clobber(s2)   && clobber(s3)   && clobber(s4)   && clobber(s5)   && clobber(s6)   && clobber(o0)   && clobber(o1)   && clobber(o2)   && clobber(o3)   && clobber(o4)   && clobber(o5)
	// result: @mergePoint(b,x0,x1,x2,x3,x4,x5,x6,x7) (MOVDBRloadidx <v.Type> [i] {s} p idx mem)
	for {
		o0 := v.Args[0]
		if o0.Op != OpS390XOR {
			break
		}
		o1 := o0.Args[0]
		if o1.Op != OpS390XOR {
			break
		}
		o2 := o1.Args[0]
		if o2.Op != OpS390XOR {
			break
		}
		o3 := o2.Args[0]
		if o3.Op != OpS390XOR {
			break
		}
		o4 := o3.Args[0]
		if o4.Op != OpS390XOR {
			break
		}
		o5 := o4.Args[0]
		if o5.Op != OpS390XOR {
			break
		}
		x0 := o5.Args[0]
		if x0.Op != OpS390XMOVBZloadidx {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		idx := x0.Args[1]
		mem := x0.Args[2]
		s0 := o5.Args[1]
		if s0.Op != OpS390XSLDconst {
			break
		}
		if s0.AuxInt != 8 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != OpS390XMOVBZloadidx {
			break
		}
		if x1.AuxInt != i+1 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if idx != x1.Args[1] {
			break
		}
		if mem != x1.Args[2] {
			break
		}
		s1 := o4.Args[1]
		if s1.Op != OpS390XSLDconst {
			break
		}
		if s1.AuxInt != 16 {
			break
		}
		x2 := s1.Args[0]
		if x2.Op != OpS390XMOVBZloadidx {
			break
		}
		if x2.AuxInt != i+2 {
			break
		}
		if x2.Aux != s {
			break
		}
		if p != x2.Args[0] {
			break
		}
		if idx != x2.Args[1] {
			break
		}
		if mem != x2.Args[2] {
			break
		}
		s2 := o3.Args[1]
		if s2.Op != OpS390XSLDconst {
			break
		}
		if s2.AuxInt != 24 {
			break
		}
		x3 := s2.Args[0]
		if x3.Op != OpS390XMOVBZloadidx {
			break
		}
		if x3.AuxInt != i+3 {
			break
		}
		if x3.Aux != s {
			break
		}
		if p != x3.Args[0] {
			break
		}
		if idx != x3.Args[1] {
			break
		}
		if mem != x3.Args[2] {
			break
		}
		s3 := o2.Args[1]
		if s3.Op != OpS390XSLDconst {
			break
		}
		if s3.AuxInt != 32 {
			break
		}
		x4 := s3.Args[0]
		if x4.Op != OpS390XMOVBZloadidx {
			break
		}
		if x4.AuxInt != i+4 {
			break
		}
		if x4.Aux != s {
			break
		}
		if p != x4.Args[0] {
			break
		}
		if idx != x4.Args[1] {
			break
		}
		if mem != x4.Args[2] {
			break
		}
		s4 := o1.Args[1]
		if s4.Op != OpS390XSLDconst {
			break
		}
		if s4.AuxInt != 40 {
			break
		}
		x5 := s4.Args[0]
		if x5.Op != OpS390XMOVBZloadidx {
			break
		}
		if x5.AuxInt != i+5 {
			break
		}
		if x5.Aux != s {
			break
		}
		if p != x5.Args[0] {
			break
		}
		if idx != x5.Args[1] {
			break
		}
		if mem != x5.Args[2] {
			break
		}
		s5 := o0.Args[1]
		if s5.Op != OpS390XSLDconst {
			break
		}
		if s5.AuxInt != 48 {
			break
		}
		x6 := s5.Args[0]
		if x6.Op != OpS390XMOVBZloadidx {
			break
		}
		if x6.AuxInt != i+6 {
			break
		}
		if x6.Aux != s {
			break
		}
		if p != x6.Args[0] {
			break
		}
		if idx != x6.Args[1] {
			break
		}
		if mem != x6.Args[2] {
			break
		}
		s6 := v.Args[1]
		if s6.Op != OpS390XSLDconst {
			break
		}
		if s6.AuxInt != 56 {
			break
		}
		x7 := s6.Args[0]
		if x7.Op != OpS390XMOVBZloadidx {
			break
		}
		if x7.AuxInt != i+7 {
			break
		}
		if x7.Aux != s {
			break
		}
		if p != x7.Args[0] {
			break
		}
		if idx != x7.Args[1] {
			break
		}
		if mem != x7.Args[2] {
			break
		}
		if !(x0.Uses == 1 && x1.Uses == 1 && x2.Uses == 1 && x3.Uses == 1 && x4.Uses == 1 && x5.Uses == 1 && x6.Uses == 1 && x7.Uses == 1 && s0.Uses == 1 && s1.Uses == 1 && s2.Uses == 1 && s3.Uses == 1 && s4.Uses == 1 && s5.Uses == 1 && s6.Uses == 1 && o0.Uses == 1 && o1.Uses == 1 && o2.Uses == 1 && o3.Uses == 1 && o4.Uses == 1 && o5.Uses == 1 && mergePoint(b, x0, x1, x2, x3, x4, x5, x6, x7) != nil && clobber(x0) && clobber(x1) && clobber(x2) && clobber(x3) && clobber(x4) && clobber(x5) && clobber(x6) && clobber(x7) && clobber(s0) && clobber(s1) && clobber(s2) && clobber(s3) && clobber(s4) && clobber(s5) && clobber(s6) && clobber(o0) && clobber(o1) && clobber(o2) && clobber(o3) && clobber(o4) && clobber(o5)) {
			break
		}
		b = mergePoint(b, x0, x1, x2, x3, x4, x5, x6, x7)
		v0 := b.NewValue0(v.Line, OpS390XMOVDBRloadidx, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = i
		v0.Aux = s
		v0.AddArg(p)
		v0.AddArg(idx)
		v0.AddArg(mem)
		return true
	}
	// match: (OR o0:(OR o1:(OR o2:(OR o3:(OR o4:(OR o5:(OR                       x0:(MOVBZload [i]   {s} p mem)     s0:(SLDconst [8]  x1:(MOVBZload [i-1] {s} p mem)))     s1:(SLDconst [16] x2:(MOVBZload [i-2] {s} p mem)))     s2:(SLDconst [24] x3:(MOVBZload [i-3] {s} p mem)))     s3:(SLDconst [32] x4:(MOVBZload [i-4] {s} p mem)))     s4:(SLDconst [40] x5:(MOVBZload [i-5] {s} p mem)))     s5:(SLDconst [48] x6:(MOVBZload [i-6] {s} p mem)))     s6:(SLDconst [56] x7:(MOVBZload [i-7] {s} p mem)))
	// cond: p.Op != OpSB   && x0.Uses == 1   && x1.Uses == 1   && x2.Uses == 1   && x3.Uses == 1   && x4.Uses == 1   && x5.Uses == 1   && x6.Uses == 1   && x7.Uses == 1   && s0.Uses == 1   && s1.Uses == 1   && s2.Uses == 1   && s3.Uses == 1   && s4.Uses == 1   && s5.Uses == 1   && s6.Uses == 1   && o0.Uses == 1   && o1.Uses == 1   && o2.Uses == 1   && o3.Uses == 1   && o4.Uses == 1   && o5.Uses == 1   && mergePoint(b,x0,x1,x2,x3,x4,x5,x6,x7) != nil   && clobber(x0)   && clobber(x1)   && clobber(x2)   && clobber(x3)   && clobber(x4)   && clobber(x5)   && clobber(x6)   && clobber(x7)   && clobber(s0)   && clobber(s1)   && clobber(s2)   && clobber(s3)   && clobber(s4)   && clobber(s5)   && clobber(s6)   && clobber(o0)   && clobber(o1)   && clobber(o2)   && clobber(o3)   && clobber(o4)   && clobber(o5)
	// result: @mergePoint(b,x0,x1,x2,x3,x4,x5,x6,x7) (MOVDload [i-7] {s} p mem)
	for {
		o0 := v.Args[0]
		if o0.Op != OpS390XOR {
			break
		}
		o1 := o0.Args[0]
		if o1.Op != OpS390XOR {
			break
		}
		o2 := o1.Args[0]
		if o2.Op != OpS390XOR {
			break
		}
		o3 := o2.Args[0]
		if o3.Op != OpS390XOR {
			break
		}
		o4 := o3.Args[0]
		if o4.Op != OpS390XOR {
			break
		}
		o5 := o4.Args[0]
		if o5.Op != OpS390XOR {
			break
		}
		x0 := o5.Args[0]
		if x0.Op != OpS390XMOVBZload {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		mem := x0.Args[1]
		s0 := o5.Args[1]
		if s0.Op != OpS390XSLDconst {
			break
		}
		if s0.AuxInt != 8 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != OpS390XMOVBZload {
			break
		}
		if x1.AuxInt != i-1 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if mem != x1.Args[1] {
			break
		}
		s1 := o4.Args[1]
		if s1.Op != OpS390XSLDconst {
			break
		}
		if s1.AuxInt != 16 {
			break
		}
		x2 := s1.Args[0]
		if x2.Op != OpS390XMOVBZload {
			break
		}
		if x2.AuxInt != i-2 {
			break
		}
		if x2.Aux != s {
			break
		}
		if p != x2.Args[0] {
			break
		}
		if mem != x2.Args[1] {
			break
		}
		s2 := o3.Args[1]
		if s2.Op != OpS390XSLDconst {
			break
		}
		if s2.AuxInt != 24 {
			break
		}
		x3 := s2.Args[0]
		if x3.Op != OpS390XMOVBZload {
			break
		}
		if x3.AuxInt != i-3 {
			break
		}
		if x3.Aux != s {
			break
		}
		if p != x3.Args[0] {
			break
		}
		if mem != x3.Args[1] {
			break
		}
		s3 := o2.Args[1]
		if s3.Op != OpS390XSLDconst {
			break
		}
		if s3.AuxInt != 32 {
			break
		}
		x4 := s3.Args[0]
		if x4.Op != OpS390XMOVBZload {
			break
		}
		if x4.AuxInt != i-4 {
			break
		}
		if x4.Aux != s {
			break
		}
		if p != x4.Args[0] {
			break
		}
		if mem != x4.Args[1] {
			break
		}
		s4 := o1.Args[1]
		if s4.Op != OpS390XSLDconst {
			break
		}
		if s4.AuxInt != 40 {
			break
		}
		x5 := s4.Args[0]
		if x5.Op != OpS390XMOVBZload {
			break
		}
		if x5.AuxInt != i-5 {
			break
		}
		if x5.Aux != s {
			break
		}
		if p != x5.Args[0] {
			break
		}
		if mem != x5.Args[1] {
			break
		}
		s5 := o0.Args[1]
		if s5.Op != OpS390XSLDconst {
			break
		}
		if s5.AuxInt != 48 {
			break
		}
		x6 := s5.Args[0]
		if x6.Op != OpS390XMOVBZload {
			break
		}
		if x6.AuxInt != i-6 {
			break
		}
		if x6.Aux != s {
			break
		}
		if p != x6.Args[0] {
			break
		}
		if mem != x6.Args[1] {
			break
		}
		s6 := v.Args[1]
		if s6.Op != OpS390XSLDconst {
			break
		}
		if s6.AuxInt != 56 {
			break
		}
		x7 := s6.Args[0]
		if x7.Op != OpS390XMOVBZload {
			break
		}
		if x7.AuxInt != i-7 {
			break
		}
		if x7.Aux != s {
			break
		}
		if p != x7.Args[0] {
			break
		}
		if mem != x7.Args[1] {
			break
		}
		if !(p.Op != OpSB && x0.Uses == 1 && x1.Uses == 1 && x2.Uses == 1 && x3.Uses == 1 && x4.Uses == 1 && x5.Uses == 1 && x6.Uses == 1 && x7.Uses == 1 && s0.Uses == 1 && s1.Uses == 1 && s2.Uses == 1 && s3.Uses == 1 && s4.Uses == 1 && s5.Uses == 1 && s6.Uses == 1 && o0.Uses == 1 && o1.Uses == 1 && o2.Uses == 1 && o3.Uses == 1 && o4.Uses == 1 && o5.Uses == 1 && mergePoint(b, x0, x1, x2, x3, x4, x5, x6, x7) != nil && clobber(x0) && clobber(x1) && clobber(x2) && clobber(x3) && clobber(x4) && clobber(x5) && clobber(x6) && clobber(x7) && clobber(s0) && clobber(s1) && clobber(s2) && clobber(s3) && clobber(s4) && clobber(s5) && clobber(s6) && clobber(o0) && clobber(o1) && clobber(o2) && clobber(o3) && clobber(o4) && clobber(o5)) {
			break
		}
		b = mergePoint(b, x0, x1, x2, x3, x4, x5, x6, x7)
		v0 := b.NewValue0(v.Line, OpS390XMOVDload, config.fe.TypeUInt64())
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = i - 7
		v0.Aux = s
		v0.AddArg(p)
		v0.AddArg(mem)
		return true
	}
	// match: (OR o0:(OR o1:(OR o2:(OR o3:(OR o4:(OR o5:(OR                       x0:(MOVBZloadidx [i]   {s} p idx mem)     s0:(SLDconst [8]  x1:(MOVBZloadidx [i-1] {s} p idx mem)))     s1:(SLDconst [16] x2:(MOVBZloadidx [i-2] {s} p idx mem)))     s2:(SLDconst [24] x3:(MOVBZloadidx [i-3] {s} p idx mem)))     s3:(SLDconst [32] x4:(MOVBZloadidx [i-4] {s} p idx mem)))     s4:(SLDconst [40] x5:(MOVBZloadidx [i-5] {s} p idx mem)))     s5:(SLDconst [48] x6:(MOVBZloadidx [i-6] {s} p idx mem)))     s6:(SLDconst [56] x7:(MOVBZloadidx [i-7] {s} p idx mem)))
	// cond: x0.Uses == 1   && x1.Uses == 1   && x2.Uses == 1   && x3.Uses == 1   && x4.Uses == 1   && x5.Uses == 1   && x6.Uses == 1   && x7.Uses == 1   && s0.Uses == 1   && s1.Uses == 1   && s2.Uses == 1   && s3.Uses == 1   && s4.Uses == 1   && s5.Uses == 1   && s6.Uses == 1   && o0.Uses == 1   && o1.Uses == 1   && o2.Uses == 1   && o3.Uses == 1   && o4.Uses == 1   && o5.Uses == 1   && mergePoint(b,x0,x1,x2,x3,x4,x5,x6,x7) != nil   && clobber(x0)   && clobber(x1)   && clobber(x2)   && clobber(x3)   && clobber(x4)   && clobber(x5)   && clobber(x6)   && clobber(x7)   && clobber(s0)   && clobber(s1)   && clobber(s2)   && clobber(s3)   && clobber(s4)   && clobber(s5)   && clobber(s6)   && clobber(o0)   && clobber(o1)   && clobber(o2)   && clobber(o3)   && clobber(o4)   && clobber(o5)
	// result: @mergePoint(b,x0,x1,x2,x3,x4,x5,x6,x7) (MOVDloadidx <v.Type> [i-7] {s} p idx mem)
	for {
		o0 := v.Args[0]
		if o0.Op != OpS390XOR {
			break
		}
		o1 := o0.Args[0]
		if o1.Op != OpS390XOR {
			break
		}
		o2 := o1.Args[0]
		if o2.Op != OpS390XOR {
			break
		}
		o3 := o2.Args[0]
		if o3.Op != OpS390XOR {
			break
		}
		o4 := o3.Args[0]
		if o4.Op != OpS390XOR {
			break
		}
		o5 := o4.Args[0]
		if o5.Op != OpS390XOR {
			break
		}
		x0 := o5.Args[0]
		if x0.Op != OpS390XMOVBZloadidx {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		idx := x0.Args[1]
		mem := x0.Args[2]
		s0 := o5.Args[1]
		if s0.Op != OpS390XSLDconst {
			break
		}
		if s0.AuxInt != 8 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != OpS390XMOVBZloadidx {
			break
		}
		if x1.AuxInt != i-1 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if idx != x1.Args[1] {
			break
		}
		if mem != x1.Args[2] {
			break
		}
		s1 := o4.Args[1]
		if s1.Op != OpS390XSLDconst {
			break
		}
		if s1.AuxInt != 16 {
			break
		}
		x2 := s1.Args[0]
		if x2.Op != OpS390XMOVBZloadidx {
			break
		}
		if x2.AuxInt != i-2 {
			break
		}
		if x2.Aux != s {
			break
		}
		if p != x2.Args[0] {
			break
		}
		if idx != x2.Args[1] {
			break
		}
		if mem != x2.Args[2] {
			break
		}
		s2 := o3.Args[1]
		if s2.Op != OpS390XSLDconst {
			break
		}
		if s2.AuxInt != 24 {
			break
		}
		x3 := s2.Args[0]
		if x3.Op != OpS390XMOVBZloadidx {
			break
		}
		if x3.AuxInt != i-3 {
			break
		}
		if x3.Aux != s {
			break
		}
		if p != x3.Args[0] {
			break
		}
		if idx != x3.Args[1] {
			break
		}
		if mem != x3.Args[2] {
			break
		}
		s3 := o2.Args[1]
		if s3.Op != OpS390XSLDconst {
			break
		}
		if s3.AuxInt != 32 {
			break
		}
		x4 := s3.Args[0]
		if x4.Op != OpS390XMOVBZloadidx {
			break
		}
		if x4.AuxInt != i-4 {
			break
		}
		if x4.Aux != s {
			break
		}
		if p != x4.Args[0] {
			break
		}
		if idx != x4.Args[1] {
			break
		}
		if mem != x4.Args[2] {
			break
		}
		s4 := o1.Args[1]
		if s4.Op != OpS390XSLDconst {
			break
		}
		if s4.AuxInt != 40 {
			break
		}
		x5 := s4.Args[0]
		if x5.Op != OpS390XMOVBZloadidx {
			break
		}
		if x5.AuxInt != i-5 {
			break
		}
		if x5.Aux != s {
			break
		}
		if p != x5.Args[0] {
			break
		}
		if idx != x5.Args[1] {
			break
		}
		if mem != x5.Args[2] {
			break
		}
		s5 := o0.Args[1]
		if s5.Op != OpS390XSLDconst {
			break
		}
		if s5.AuxInt != 48 {
			break
		}
		x6 := s5.Args[0]
		if x6.Op != OpS390XMOVBZloadidx {
			break
		}
		if x6.AuxInt != i-6 {
			break
		}
		if x6.Aux != s {
			break
		}
		if p != x6.Args[0] {
			break
		}
		if idx != x6.Args[1] {
			break
		}
		if mem != x6.Args[2] {
			break
		}
		s6 := v.Args[1]
		if s6.Op != OpS390XSLDconst {
			break
		}
		if s6.AuxInt != 56 {
			break
		}
		x7 := s6.Args[0]
		if x7.Op != OpS390XMOVBZloadidx {
			break
		}
		if x7.AuxInt != i-7 {
			break
		}
		if x7.Aux != s {
			break
		}
		if p != x7.Args[0] {
			break
		}
		if idx != x7.Args[1] {
			break
		}
		if mem != x7.Args[2] {
			break
		}
		if !(x0.Uses == 1 && x1.Uses == 1 && x2.Uses == 1 && x3.Uses == 1 && x4.Uses == 1 && x5.Uses == 1 && x6.Uses == 1 && x7.Uses == 1 && s0.Uses == 1 && s1.Uses == 1 && s2.Uses == 1 && s3.Uses == 1 && s4.Uses == 1 && s5.Uses == 1 && s6.Uses == 1 && o0.Uses == 1 && o1.Uses == 1 && o2.Uses == 1 && o3.Uses == 1 && o4.Uses == 1 && o5.Uses == 1 && mergePoint(b, x0, x1, x2, x3, x4, x5, x6, x7) != nil && clobber(x0) && clobber(x1) && clobber(x2) && clobber(x3) && clobber(x4) && clobber(x5) && clobber(x6) && clobber(x7) && clobber(s0) && clobber(s1) && clobber(s2) && clobber(s3) && clobber(s4) && clobber(s5) && clobber(s6) && clobber(o0) && clobber(o1) && clobber(o2) && clobber(o3) && clobber(o4) && clobber(o5)) {
			break
		}
		b = mergePoint(b, x0, x1, x2, x3, x4, x5, x6, x7)
		v0 := b.NewValue0(v.Line, OpS390XMOVDloadidx, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = i - 7
		v0.Aux = s
		v0.AddArg(p)
		v0.AddArg(idx)
		v0.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XORW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ORW x (MOVDconst [c]))
	// cond:
	// result: (ORWconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpS390XORWconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ORW (MOVDconst [c]) x)
	// cond:
	// result: (ORWconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(OpS390XORWconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ORW x x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ORW <t> x g:(MOVWload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ORWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVWload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XORWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (ORW <t> g:(MOVWload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ORWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVWload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XORWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (ORW <t> x g:(MOVWZload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ORWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVWZload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XORWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (ORW <t> g:(MOVWZload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (ORWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVWZload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XORWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (ORW                 x0:(MOVBZload [i]   {s} p mem)     s0:(SLWconst [8] x1:(MOVBZload [i+1] {s} p mem)))
	// cond: p.Op != OpSB   && x0.Uses == 1   && x1.Uses == 1   && s0.Uses == 1   && mergePoint(b,x0,x1) != nil   && clobber(x0)   && clobber(x1)   && clobber(s0)
	// result: @mergePoint(b,x0,x1) (MOVHZreg (MOVHBRload [i] {s} p mem))
	for {
		x0 := v.Args[0]
		if x0.Op != OpS390XMOVBZload {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		mem := x0.Args[1]
		s0 := v.Args[1]
		if s0.Op != OpS390XSLWconst {
			break
		}
		if s0.AuxInt != 8 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != OpS390XMOVBZload {
			break
		}
		if x1.AuxInt != i+1 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if mem != x1.Args[1] {
			break
		}
		if !(p.Op != OpSB && x0.Uses == 1 && x1.Uses == 1 && s0.Uses == 1 && mergePoint(b, x0, x1) != nil && clobber(x0) && clobber(x1) && clobber(s0)) {
			break
		}
		b = mergePoint(b, x0, x1)
		v0 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v.reset(OpCopy)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVHBRload, config.fe.TypeUInt16())
		v1.AuxInt = i
		v1.Aux = s
		v1.AddArg(p)
		v1.AddArg(mem)
		v0.AddArg(v1)
		return true
	}
	// match: (ORW o0:(ORW z0:(MOVHZreg x0:(MOVHBRload [i] {s} p mem))     s0:(SLWconst [16] x1:(MOVBZload [i+2] {s} p mem)))     s1:(SLWconst [24] x2:(MOVBZload [i+3] {s} p mem)))
	// cond: p.Op != OpSB   && z0.Uses == 1   && x0.Uses == 1   && x1.Uses == 1   && x2.Uses == 1   && s0.Uses == 1   && s1.Uses == 1   && o0.Uses == 1   && mergePoint(b,x0,x1,x2) != nil   && clobber(z0)   && clobber(x0)   && clobber(x1)   && clobber(x2)   && clobber(s0)   && clobber(s1)   && clobber(o0)
	// result: @mergePoint(b,x0,x1,x2) (MOVWBRload [i] {s} p mem)
	for {
		o0 := v.Args[0]
		if o0.Op != OpS390XORW {
			break
		}
		z0 := o0.Args[0]
		if z0.Op != OpS390XMOVHZreg {
			break
		}
		x0 := z0.Args[0]
		if x0.Op != OpS390XMOVHBRload {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		mem := x0.Args[1]
		s0 := o0.Args[1]
		if s0.Op != OpS390XSLWconst {
			break
		}
		if s0.AuxInt != 16 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != OpS390XMOVBZload {
			break
		}
		if x1.AuxInt != i+2 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if mem != x1.Args[1] {
			break
		}
		s1 := v.Args[1]
		if s1.Op != OpS390XSLWconst {
			break
		}
		if s1.AuxInt != 24 {
			break
		}
		x2 := s1.Args[0]
		if x2.Op != OpS390XMOVBZload {
			break
		}
		if x2.AuxInt != i+3 {
			break
		}
		if x2.Aux != s {
			break
		}
		if p != x2.Args[0] {
			break
		}
		if mem != x2.Args[1] {
			break
		}
		if !(p.Op != OpSB && z0.Uses == 1 && x0.Uses == 1 && x1.Uses == 1 && x2.Uses == 1 && s0.Uses == 1 && s1.Uses == 1 && o0.Uses == 1 && mergePoint(b, x0, x1, x2) != nil && clobber(z0) && clobber(x0) && clobber(x1) && clobber(x2) && clobber(s0) && clobber(s1) && clobber(o0)) {
			break
		}
		b = mergePoint(b, x0, x1, x2)
		v0 := b.NewValue0(v.Line, OpS390XMOVWBRload, config.fe.TypeUInt32())
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = i
		v0.Aux = s
		v0.AddArg(p)
		v0.AddArg(mem)
		return true
	}
	// match: (ORW                 x0:(MOVBZloadidx [i]   {s} p idx mem)     s0:(SLWconst [8] x1:(MOVBZloadidx [i+1] {s} p idx mem)))
	// cond: x0.Uses == 1   && x1.Uses == 1   && s0.Uses == 1   && mergePoint(b,x0,x1) != nil   && clobber(x0)   && clobber(x1)   && clobber(s0)
	// result: @mergePoint(b,x0,x1) (MOVHZreg (MOVHBRloadidx <v.Type> [i] {s} p idx mem))
	for {
		x0 := v.Args[0]
		if x0.Op != OpS390XMOVBZloadidx {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		idx := x0.Args[1]
		mem := x0.Args[2]
		s0 := v.Args[1]
		if s0.Op != OpS390XSLWconst {
			break
		}
		if s0.AuxInt != 8 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != OpS390XMOVBZloadidx {
			break
		}
		if x1.AuxInt != i+1 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if idx != x1.Args[1] {
			break
		}
		if mem != x1.Args[2] {
			break
		}
		if !(x0.Uses == 1 && x1.Uses == 1 && s0.Uses == 1 && mergePoint(b, x0, x1) != nil && clobber(x0) && clobber(x1) && clobber(s0)) {
			break
		}
		b = mergePoint(b, x0, x1)
		v0 := b.NewValue0(v.Line, OpS390XMOVHZreg, config.fe.TypeUInt64())
		v.reset(OpCopy)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVHBRloadidx, v.Type)
		v1.AuxInt = i
		v1.Aux = s
		v1.AddArg(p)
		v1.AddArg(idx)
		v1.AddArg(mem)
		v0.AddArg(v1)
		return true
	}
	// match: (ORW o0:(ORW z0:(MOVHZreg x0:(MOVHBRloadidx [i] {s} p idx mem))     s0:(SLWconst [16] x1:(MOVBZloadidx [i+2] {s} p idx mem)))     s1:(SLWconst [24] x2:(MOVBZloadidx [i+3] {s} p idx mem)))
	// cond: z0.Uses == 1   && x0.Uses == 1   && x1.Uses == 1   && x2.Uses == 1   && s0.Uses == 1   && s1.Uses == 1   && o0.Uses == 1   && mergePoint(b,x0,x1,x2) != nil   && clobber(z0)   && clobber(x0)   && clobber(x1)   && clobber(x2)   && clobber(s0)   && clobber(s1)   && clobber(o0)
	// result: @mergePoint(b,x0,x1,x2) (MOVWZreg (MOVWBRloadidx <v.Type> [i] {s} p idx mem))
	for {
		o0 := v.Args[0]
		if o0.Op != OpS390XORW {
			break
		}
		z0 := o0.Args[0]
		if z0.Op != OpS390XMOVHZreg {
			break
		}
		x0 := z0.Args[0]
		if x0.Op != OpS390XMOVHBRloadidx {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		idx := x0.Args[1]
		mem := x0.Args[2]
		s0 := o0.Args[1]
		if s0.Op != OpS390XSLWconst {
			break
		}
		if s0.AuxInt != 16 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != OpS390XMOVBZloadidx {
			break
		}
		if x1.AuxInt != i+2 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if idx != x1.Args[1] {
			break
		}
		if mem != x1.Args[2] {
			break
		}
		s1 := v.Args[1]
		if s1.Op != OpS390XSLWconst {
			break
		}
		if s1.AuxInt != 24 {
			break
		}
		x2 := s1.Args[0]
		if x2.Op != OpS390XMOVBZloadidx {
			break
		}
		if x2.AuxInt != i+3 {
			break
		}
		if x2.Aux != s {
			break
		}
		if p != x2.Args[0] {
			break
		}
		if idx != x2.Args[1] {
			break
		}
		if mem != x2.Args[2] {
			break
		}
		if !(z0.Uses == 1 && x0.Uses == 1 && x1.Uses == 1 && x2.Uses == 1 && s0.Uses == 1 && s1.Uses == 1 && o0.Uses == 1 && mergePoint(b, x0, x1, x2) != nil && clobber(z0) && clobber(x0) && clobber(x1) && clobber(x2) && clobber(s0) && clobber(s1) && clobber(o0)) {
			break
		}
		b = mergePoint(b, x0, x1, x2)
		v0 := b.NewValue0(v.Line, OpS390XMOVWZreg, config.fe.TypeUInt64())
		v.reset(OpCopy)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XMOVWBRloadidx, v.Type)
		v1.AuxInt = i
		v1.Aux = s
		v1.AddArg(p)
		v1.AddArg(idx)
		v1.AddArg(mem)
		v0.AddArg(v1)
		return true
	}
	// match: (ORW                  x0:(MOVBZload [i]   {s} p mem)     s0:(SLWconst [8] x1:(MOVBZload [i-1] {s} p mem)))
	// cond: p.Op != OpSB   && x0.Uses == 1   && x1.Uses == 1   && s0.Uses == 1   && mergePoint(b,x0,x1) != nil   && clobber(x0)   && clobber(x1)   && clobber(s0)
	// result: @mergePoint(b,x0,x1) (MOVHZload [i-1] {s} p mem)
	for {
		x0 := v.Args[0]
		if x0.Op != OpS390XMOVBZload {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		mem := x0.Args[1]
		s0 := v.Args[1]
		if s0.Op != OpS390XSLWconst {
			break
		}
		if s0.AuxInt != 8 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != OpS390XMOVBZload {
			break
		}
		if x1.AuxInt != i-1 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if mem != x1.Args[1] {
			break
		}
		if !(p.Op != OpSB && x0.Uses == 1 && x1.Uses == 1 && s0.Uses == 1 && mergePoint(b, x0, x1) != nil && clobber(x0) && clobber(x1) && clobber(s0)) {
			break
		}
		b = mergePoint(b, x0, x1)
		v0 := b.NewValue0(v.Line, OpS390XMOVHZload, config.fe.TypeUInt16())
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = i - 1
		v0.Aux = s
		v0.AddArg(p)
		v0.AddArg(mem)
		return true
	}
	// match: (ORW o0:(ORW x0:(MOVHZload [i] {s} p mem)     s0:(SLWconst [16] x1:(MOVBZload [i-1] {s} p mem)))     s1:(SLWconst [24] x2:(MOVBZload [i-2] {s} p mem)))
	// cond: p.Op != OpSB   && x0.Uses == 1   && x1.Uses == 1   && x2.Uses == 1   && s0.Uses == 1   && s1.Uses == 1   && o0.Uses == 1   && mergePoint(b,x0,x1,x2) != nil   && clobber(x0)   && clobber(x1)   && clobber(x2)   && clobber(s0)   && clobber(s1)   && clobber(o0)
	// result: @mergePoint(b,x0,x1,x2) (MOVWZload [i-2] {s} p mem)
	for {
		o0 := v.Args[0]
		if o0.Op != OpS390XORW {
			break
		}
		x0 := o0.Args[0]
		if x0.Op != OpS390XMOVHZload {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		mem := x0.Args[1]
		s0 := o0.Args[1]
		if s0.Op != OpS390XSLWconst {
			break
		}
		if s0.AuxInt != 16 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != OpS390XMOVBZload {
			break
		}
		if x1.AuxInt != i-1 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if mem != x1.Args[1] {
			break
		}
		s1 := v.Args[1]
		if s1.Op != OpS390XSLWconst {
			break
		}
		if s1.AuxInt != 24 {
			break
		}
		x2 := s1.Args[0]
		if x2.Op != OpS390XMOVBZload {
			break
		}
		if x2.AuxInt != i-2 {
			break
		}
		if x2.Aux != s {
			break
		}
		if p != x2.Args[0] {
			break
		}
		if mem != x2.Args[1] {
			break
		}
		if !(p.Op != OpSB && x0.Uses == 1 && x1.Uses == 1 && x2.Uses == 1 && s0.Uses == 1 && s1.Uses == 1 && o0.Uses == 1 && mergePoint(b, x0, x1, x2) != nil && clobber(x0) && clobber(x1) && clobber(x2) && clobber(s0) && clobber(s1) && clobber(o0)) {
			break
		}
		b = mergePoint(b, x0, x1, x2)
		v0 := b.NewValue0(v.Line, OpS390XMOVWZload, config.fe.TypeUInt32())
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = i - 2
		v0.Aux = s
		v0.AddArg(p)
		v0.AddArg(mem)
		return true
	}
	// match: (ORW                 x0:(MOVBZloadidx [i]   {s} p idx mem)     s0:(SLWconst [8] x1:(MOVBZloadidx [i-1] {s} p idx mem)))
	// cond: x0.Uses == 1   && x1.Uses == 1   && s0.Uses == 1   && mergePoint(b,x0,x1) != nil   && clobber(x0)   && clobber(x1)   && clobber(s0)
	// result: @mergePoint(b,x0,x1) (MOVHZloadidx <v.Type> [i-1] {s} p idx mem)
	for {
		x0 := v.Args[0]
		if x0.Op != OpS390XMOVBZloadidx {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		idx := x0.Args[1]
		mem := x0.Args[2]
		s0 := v.Args[1]
		if s0.Op != OpS390XSLWconst {
			break
		}
		if s0.AuxInt != 8 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != OpS390XMOVBZloadidx {
			break
		}
		if x1.AuxInt != i-1 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if idx != x1.Args[1] {
			break
		}
		if mem != x1.Args[2] {
			break
		}
		if !(x0.Uses == 1 && x1.Uses == 1 && s0.Uses == 1 && mergePoint(b, x0, x1) != nil && clobber(x0) && clobber(x1) && clobber(s0)) {
			break
		}
		b = mergePoint(b, x0, x1)
		v0 := b.NewValue0(v.Line, OpS390XMOVHZloadidx, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = i - 1
		v0.Aux = s
		v0.AddArg(p)
		v0.AddArg(idx)
		v0.AddArg(mem)
		return true
	}
	// match: (ORW o0:(ORW x0:(MOVHZloadidx [i] {s} p idx mem)     s0:(SLWconst [16] x1:(MOVBZloadidx [i-1] {s} p idx mem)))     s1:(SLWconst [24] x2:(MOVBZloadidx [i-2] {s} p idx mem)))
	// cond: x0.Uses == 1   && x1.Uses == 1   && x2.Uses == 1   && s0.Uses == 1   && s1.Uses == 1   && o0.Uses == 1   && mergePoint(b,x0,x1,x2) != nil   && clobber(x0)   && clobber(x1)   && clobber(x2)   && clobber(s0)   && clobber(s1)   && clobber(o0)
	// result: @mergePoint(b,x0,x1,x2) (MOVWZloadidx <v.Type> [i-2] {s} p idx mem)
	for {
		o0 := v.Args[0]
		if o0.Op != OpS390XORW {
			break
		}
		x0 := o0.Args[0]
		if x0.Op != OpS390XMOVHZloadidx {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		idx := x0.Args[1]
		mem := x0.Args[2]
		s0 := o0.Args[1]
		if s0.Op != OpS390XSLWconst {
			break
		}
		if s0.AuxInt != 16 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != OpS390XMOVBZloadidx {
			break
		}
		if x1.AuxInt != i-1 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if idx != x1.Args[1] {
			break
		}
		if mem != x1.Args[2] {
			break
		}
		s1 := v.Args[1]
		if s1.Op != OpS390XSLWconst {
			break
		}
		if s1.AuxInt != 24 {
			break
		}
		x2 := s1.Args[0]
		if x2.Op != OpS390XMOVBZloadidx {
			break
		}
		if x2.AuxInt != i-2 {
			break
		}
		if x2.Aux != s {
			break
		}
		if p != x2.Args[0] {
			break
		}
		if idx != x2.Args[1] {
			break
		}
		if mem != x2.Args[2] {
			break
		}
		if !(x0.Uses == 1 && x1.Uses == 1 && x2.Uses == 1 && s0.Uses == 1 && s1.Uses == 1 && o0.Uses == 1 && mergePoint(b, x0, x1, x2) != nil && clobber(x0) && clobber(x1) && clobber(x2) && clobber(s0) && clobber(s1) && clobber(o0)) {
			break
		}
		b = mergePoint(b, x0, x1, x2)
		v0 := b.NewValue0(v.Line, OpS390XMOVWZloadidx, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = i - 2
		v0.Aux = s
		v0.AddArg(p)
		v0.AddArg(idx)
		v0.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XORWconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ORWconst [c] x)
	// cond: int32(c)==0
	// result: x
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(int32(c) == 0) {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ORWconst [c] _)
	// cond: int32(c)==-1
	// result: (MOVDconst [-1])
	for {
		c := v.AuxInt
		if !(int32(c) == -1) {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = -1
		return true
	}
	// match: (ORWconst [c] (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [c|d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = c | d
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XORconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ORconst [0] x)
	// cond:
	// result: x
	for {
		if v.AuxInt != 0 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ORconst [-1] _)
	// cond:
	// result: (MOVDconst [-1])
	for {
		if v.AuxInt != -1 {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = -1
		return true
	}
	// match: (ORconst [c] (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [c|d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = c | d
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSLD(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SLD x (MOVDconst [c]))
	// cond:
	// result: (SLDconst [c&63] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpS390XSLDconst)
		v.AuxInt = c & 63
		v.AddArg(x)
		return true
	}
	// match: (SLD x (ANDconst [63] y))
	// cond:
	// result: (SLD x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XANDconst {
			break
		}
		if v_1.AuxInt != 63 {
			break
		}
		y := v_1.Args[0]
		v.reset(OpS390XSLD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSLW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SLW x (MOVDconst [c]))
	// cond:
	// result: (SLWconst [c&63] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpS390XSLWconst)
		v.AuxInt = c & 63
		v.AddArg(x)
		return true
	}
	// match: (SLW x (ANDWconst [63] y))
	// cond:
	// result: (SLW x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XANDWconst {
			break
		}
		if v_1.AuxInt != 63 {
			break
		}
		y := v_1.Args[0]
		v.reset(OpS390XSLW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSRAD(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SRAD x (MOVDconst [c]))
	// cond:
	// result: (SRADconst [c&63] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpS390XSRADconst)
		v.AuxInt = c & 63
		v.AddArg(x)
		return true
	}
	// match: (SRAD x (ANDconst [63] y))
	// cond:
	// result: (SRAD x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XANDconst {
			break
		}
		if v_1.AuxInt != 63 {
			break
		}
		y := v_1.Args[0]
		v.reset(OpS390XSRAD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSRADconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SRADconst [c] (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [d>>uint64(c)])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = d >> uint64(c)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSRAW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SRAW x (MOVDconst [c]))
	// cond:
	// result: (SRAWconst [c&63] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpS390XSRAWconst)
		v.AuxInt = c & 63
		v.AddArg(x)
		return true
	}
	// match: (SRAW x (ANDWconst [63] y))
	// cond:
	// result: (SRAW x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XANDWconst {
			break
		}
		if v_1.AuxInt != 63 {
			break
		}
		y := v_1.Args[0]
		v.reset(OpS390XSRAW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSRAWconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SRAWconst [c] (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [d>>uint64(c)])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = d >> uint64(c)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSRD(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SRD x (MOVDconst [c]))
	// cond:
	// result: (SRDconst [c&63] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpS390XSRDconst)
		v.AuxInt = c & 63
		v.AddArg(x)
		return true
	}
	// match: (SRD x (ANDconst [63] y))
	// cond:
	// result: (SRD x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XANDconst {
			break
		}
		if v_1.AuxInt != 63 {
			break
		}
		y := v_1.Args[0]
		v.reset(OpS390XSRD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSRW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SRW x (MOVDconst [c]))
	// cond:
	// result: (SRWconst [c&63] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpS390XSRWconst)
		v.AuxInt = c & 63
		v.AddArg(x)
		return true
	}
	// match: (SRW x (ANDWconst [63] y))
	// cond:
	// result: (SRW x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XANDWconst {
			break
		}
		if v_1.AuxInt != 63 {
			break
		}
		y := v_1.Args[0]
		v.reset(OpS390XSRW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSTM2(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (STM2 [i] {s} p w2 w3 x:(STM2 [i-8] {s} p w0 w1 mem))
	// cond: x.Uses == 1   && is20Bit(i-8)   && clobber(x)
	// result: (STM4 [i-8] {s} p w0 w1 w2 w3 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w2 := v.Args[1]
		w3 := v.Args[2]
		x := v.Args[3]
		if x.Op != OpS390XSTM2 {
			break
		}
		if x.AuxInt != i-8 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		w1 := x.Args[2]
		mem := x.Args[3]
		if !(x.Uses == 1 && is20Bit(i-8) && clobber(x)) {
			break
		}
		v.reset(OpS390XSTM4)
		v.AuxInt = i - 8
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(w1)
		v.AddArg(w2)
		v.AddArg(w3)
		v.AddArg(mem)
		return true
	}
	// match: (STM2 [i] {s} p (SRDconst [32] x) x mem)
	// cond:
	// result: (MOVDstore [i] {s} p x mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XSRDconst {
			break
		}
		if v_1.AuxInt != 32 {
			break
		}
		x := v_1.Args[0]
		if x != v.Args[2] {
			break
		}
		mem := v.Args[3]
		v.reset(OpS390XMOVDstore)
		v.AuxInt = i
		v.Aux = s
		v.AddArg(p)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSTMG2(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (STMG2 [i] {s} p w2 w3 x:(STMG2 [i-16] {s} p w0 w1 mem))
	// cond: x.Uses == 1   && is20Bit(i-16)   && clobber(x)
	// result: (STMG4 [i-16] {s} p w0 w1 w2 w3 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		w2 := v.Args[1]
		w3 := v.Args[2]
		x := v.Args[3]
		if x.Op != OpS390XSTMG2 {
			break
		}
		if x.AuxInt != i-16 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		w1 := x.Args[2]
		mem := x.Args[3]
		if !(x.Uses == 1 && is20Bit(i-16) && clobber(x)) {
			break
		}
		v.reset(OpS390XSTMG4)
		v.AuxInt = i - 16
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(w1)
		v.AddArg(w2)
		v.AddArg(w3)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSUB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SUB x (MOVDconst [c]))
	// cond: is32Bit(c)
	// result: (SUBconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpS390XSUBconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (SUB (MOVDconst [c]) x)
	// cond: is32Bit(c)
	// result: (NEG (SUBconst <v.Type> x [c]))
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpS390XNEG)
		v0 := b.NewValue0(v.Line, OpS390XSUBconst, v.Type)
		v0.AuxInt = c
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	// match: (SUB x x)
	// cond:
	// result: (MOVDconst [0])
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = 0
		return true
	}
	// match: (SUB <t> x g:(MOVDload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (SUBload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVDload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XSUBload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSUBEWcarrymask(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SUBEWcarrymask (FlagEQ))
	// cond:
	// result: (MOVDconst [-1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XFlagEQ {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = -1
		return true
	}
	// match: (SUBEWcarrymask (FlagLT))
	// cond:
	// result: (MOVDconst [-1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XFlagLT {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = -1
		return true
	}
	// match: (SUBEWcarrymask (FlagGT))
	// cond:
	// result: (MOVDconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XFlagGT {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSUBEcarrymask(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SUBEcarrymask (FlagEQ))
	// cond:
	// result: (MOVDconst [-1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XFlagEQ {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = -1
		return true
	}
	// match: (SUBEcarrymask (FlagLT))
	// cond:
	// result: (MOVDconst [-1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XFlagLT {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = -1
		return true
	}
	// match: (SUBEcarrymask (FlagGT))
	// cond:
	// result: (MOVDconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XFlagGT {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSUBW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SUBW x (MOVDconst [c]))
	// cond:
	// result: (SUBWconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpS390XSUBWconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (SUBW (MOVDconst [c]) x)
	// cond:
	// result: (NEGW (SUBWconst <v.Type> x [c]))
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(OpS390XNEGW)
		v0 := b.NewValue0(v.Line, OpS390XSUBWconst, v.Type)
		v0.AuxInt = c
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	// match: (SUBW x x)
	// cond:
	// result: (MOVDconst [0])
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = 0
		return true
	}
	// match: (SUBW <t> x g:(MOVWload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (SUBWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVWload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XSUBWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (SUBW <t> x g:(MOVWZload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (SUBWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVWZload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XSUBWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XSUBWconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SUBWconst [c] x)
	// cond: int32(c) == 0
	// result: x
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(int32(c) == 0) {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (SUBWconst [c] x)
	// cond:
	// result: (ADDWconst [int64(int32(-c))] x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		v.reset(OpS390XADDWconst)
		v.AuxInt = int64(int32(-c))
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpS390XSUBconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SUBconst [0] x)
	// cond:
	// result: x
	for {
		if v.AuxInt != 0 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (SUBconst [c] x)
	// cond: c != -(1<<31)
	// result: (ADDconst [-c] x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(c != -(1 << 31)) {
			break
		}
		v.reset(OpS390XADDconst)
		v.AuxInt = -c
		v.AddArg(x)
		return true
	}
	// match: (SUBconst (MOVDconst [d]) [c])
	// cond:
	// result: (MOVDconst [d-c])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = d - c
		return true
	}
	// match: (SUBconst (SUBconst x [d]) [c])
	// cond: is32Bit(-c-d)
	// result: (ADDconst [-c-d] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XSUBconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		if !(is32Bit(-c - d)) {
			break
		}
		v.reset(OpS390XADDconst)
		v.AuxInt = -c - d
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XXOR(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (XOR x (MOVDconst [c]))
	// cond: isU32Bit(c)
	// result: (XORconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		if !(isU32Bit(c)) {
			break
		}
		v.reset(OpS390XXORconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (XOR (MOVDconst [c]) x)
	// cond: isU32Bit(c)
	// result: (XORconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(isU32Bit(c)) {
			break
		}
		v.reset(OpS390XXORconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (XOR (MOVDconst [c]) (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [c^d])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		d := v_1.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = c ^ d
		return true
	}
	// match: (XOR x x)
	// cond:
	// result: (MOVDconst [0])
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = 0
		return true
	}
	// match: (XOR <t> x g:(MOVDload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (XORload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVDload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XXORload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (XOR <t> g:(MOVDload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (XORload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVDload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XXORload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XXORW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (XORW x (MOVDconst [c]))
	// cond:
	// result: (XORWconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpS390XMOVDconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpS390XXORWconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (XORW (MOVDconst [c]) x)
	// cond:
	// result: (XORWconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(OpS390XXORWconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (XORW x x)
	// cond:
	// result: (MOVDconst [0])
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(OpS390XMOVDconst)
		v.AuxInt = 0
		return true
	}
	// match: (XORW <t> x g:(MOVWload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (XORWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVWload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XXORWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (XORW <t> g:(MOVWload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (XORWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVWload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XXORWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (XORW <t> x g:(MOVWZload [off] {sym} ptr mem))
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (XORWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		x := v.Args[0]
		g := v.Args[1]
		if g.Op != OpS390XMOVWZload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XXORWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (XORW <t> g:(MOVWZload [off] {sym} ptr mem) x)
	// cond: g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)
	// result: (XORWload <t> [off] {sym} x ptr mem)
	for {
		t := v.Type
		g := v.Args[0]
		if g.Op != OpS390XMOVWZload {
			break
		}
		off := g.AuxInt
		sym := g.Aux
		ptr := g.Args[0]
		mem := g.Args[1]
		x := v.Args[1]
		if !(g.Uses == 1 && ptr.Op != OpSB && is20Bit(off) && canMergeLoad(v, g) && clobber(g)) {
			break
		}
		v.reset(OpS390XXORWload)
		v.Type = t
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(x)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XXORWconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (XORWconst [c] x)
	// cond: int32(c)==0
	// result: x
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(int32(c) == 0) {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (XORWconst [c] (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [c^d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = c ^ d
		return true
	}
	return false
}
func rewriteValueS390X_OpS390XXORconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (XORconst [0] x)
	// cond:
	// result: x
	for {
		if v.AuxInt != 0 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (XORconst [c] (MOVDconst [d]))
	// cond:
	// result: (MOVDconst [c^d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpS390XMOVDconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpS390XMOVDconst)
		v.AuxInt = c ^ d
		return true
	}
	return false
}
func rewriteValueS390X_OpSelect0(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Select0 <t> (AddTupleFirst32 tuple val))
	// cond:
	// result: (ADDW val (Select0 <t> tuple))
	for {
		t := v.Type
		v_0 := v.Args[0]
		if v_0.Op != OpS390XAddTupleFirst32 {
			break
		}
		tuple := v_0.Args[0]
		val := v_0.Args[1]
		v.reset(OpS390XADDW)
		v.AddArg(val)
		v0 := b.NewValue0(v.Line, OpSelect0, t)
		v0.AddArg(tuple)
		v.AddArg(v0)
		return true
	}
	// match: (Select0 <t> (AddTupleFirst64 tuple val))
	// cond:
	// result: (ADD val (Select0 <t> tuple))
	for {
		t := v.Type
		v_0 := v.Args[0]
		if v_0.Op != OpS390XAddTupleFirst64 {
			break
		}
		tuple := v_0.Args[0]
		val := v_0.Args[1]
		v.reset(OpS390XADD)
		v.AddArg(val)
		v0 := b.NewValue0(v.Line, OpSelect0, t)
		v0.AddArg(tuple)
		v.AddArg(v0)
		return true
	}
	return false
}
func rewriteValueS390X_OpSelect1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Select1     (AddTupleFirst32 tuple _  ))
	// cond:
	// result: (Select1 tuple)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XAddTupleFirst32 {
			break
		}
		tuple := v_0.Args[0]
		v.reset(OpSelect1)
		v.AddArg(tuple)
		return true
	}
	// match: (Select1     (AddTupleFirst64 tuple _  ))
	// cond:
	// result: (Select1 tuple)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpS390XAddTupleFirst64 {
			break
		}
		tuple := v_0.Args[0]
		v.reset(OpSelect1)
		v.AddArg(tuple)
		return true
	}
	return false
}
func rewriteValueS390X_OpSignExt16to32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt16to32 x)
	// cond:
	// result: (MOVHreg x)
	for {
		x := v.Args[0]
		v.reset(OpS390XMOVHreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpSignExt16to64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt16to64 x)
	// cond:
	// result: (MOVHreg x)
	for {
		x := v.Args[0]
		v.reset(OpS390XMOVHreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpSignExt32to64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt32to64 x)
	// cond:
	// result: (MOVWreg x)
	for {
		x := v.Args[0]
		v.reset(OpS390XMOVWreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpSignExt8to16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt8to16  x)
	// cond:
	// result: (MOVBreg x)
	for {
		x := v.Args[0]
		v.reset(OpS390XMOVBreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpSignExt8to32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt8to32  x)
	// cond:
	// result: (MOVBreg x)
	for {
		x := v.Args[0]
		v.reset(OpS390XMOVBreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpSignExt8to64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt8to64  x)
	// cond:
	// result: (MOVBreg x)
	for {
		x := v.Args[0]
		v.reset(OpS390XMOVBreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpSlicemask(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Slicemask <t> x)
	// cond:
	// result: (XOR (MOVDconst [-1]) (SRADconst <t> (SUBconst <t> x [1]) [63]))
	for {
		t := v.Type
		x := v.Args[0]
		v.reset(OpS390XXOR)
		v0 := b.NewValue0(v.Line, OpS390XMOVDconst, config.fe.TypeUInt64())
		v0.AuxInt = -1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpS390XSRADconst, t)
		v1.AuxInt = 63
		v2 := b.NewValue0(v.Line, OpS390XSUBconst, t)
		v2.AuxInt = 1
		v2.AddArg(x)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueS390X_OpSqrt(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sqrt x)
	// cond:
	// result: (FSQRT x)
	for {
		x := v.Args[0]
		v.reset(OpS390XFSQRT)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpStaticCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (StaticCall [argwid] {target} mem)
	// cond:
	// result: (CALLstatic [argwid] {target} mem)
	for {
		argwid := v.AuxInt
		target := v.Aux
		mem := v.Args[0]
		v.reset(OpS390XCALLstatic)
		v.AuxInt = argwid
		v.Aux = target
		v.AddArg(mem)
		return true
	}
}
func rewriteValueS390X_OpStore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Store [8] ptr val mem)
	// cond: is64BitFloat(val.Type)
	// result: (FMOVDstore ptr val mem)
	for {
		if v.AuxInt != 8 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is64BitFloat(val.Type)) {
			break
		}
		v.reset(OpS390XFMOVDstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (Store [4] ptr val mem)
	// cond: is32BitFloat(val.Type)
	// result: (FMOVSstore ptr val mem)
	for {
		if v.AuxInt != 4 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32BitFloat(val.Type)) {
			break
		}
		v.reset(OpS390XFMOVSstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (Store [8] ptr val mem)
	// cond:
	// result: (MOVDstore ptr val mem)
	for {
		if v.AuxInt != 8 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XMOVDstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (Store [4] ptr val mem)
	// cond:
	// result: (MOVWstore ptr val mem)
	for {
		if v.AuxInt != 4 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XMOVWstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (Store [2] ptr val mem)
	// cond:
	// result: (MOVHstore ptr val mem)
	for {
		if v.AuxInt != 2 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XMOVHstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (Store [1] ptr val mem)
	// cond:
	// result: (MOVBstore ptr val mem)
	for {
		if v.AuxInt != 1 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(OpS390XMOVBstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpSub16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub16  x y)
	// cond:
	// result: (SUBW  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSUBW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpSub32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub32  x y)
	// cond:
	// result: (SUBW  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSUBW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpSub32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub32F x y)
	// cond:
	// result: (FSUBS x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XFSUBS)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpSub64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub64  x y)
	// cond:
	// result: (SUB  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSUB)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpSub64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub64F x y)
	// cond:
	// result: (FSUB x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XFSUB)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpSub8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub8   x y)
	// cond:
	// result: (SUBW  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSUBW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpSubPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SubPtr x y)
	// cond:
	// result: (SUB  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XSUB)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpTrunc16to8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc16to8  x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpTrunc32to16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc32to16 x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpTrunc32to8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc32to8  x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpTrunc64to16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc64to16 x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpTrunc64to32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc64to32 x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpTrunc64to8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc64to8  x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpXor16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Xor16 x y)
	// cond:
	// result: (XORW x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XXORW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpXor32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Xor32 x y)
	// cond:
	// result: (XORW x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XXORW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpXor64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Xor64 x y)
	// cond:
	// result: (XOR x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XXOR)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpXor8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Xor8  x y)
	// cond:
	// result: (XORW x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpS390XXORW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueS390X_OpZero(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Zero [s] _ mem)
	// cond: SizeAndAlign(s).Size() == 0
	// result: mem
	for {
		s := v.AuxInt
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 0) {
			break
		}
		v.reset(OpCopy)
		v.Type = mem.Type
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 1
	// result: (MOVBstoreconst [0] destptr mem)
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 1) {
			break
		}
		v.reset(OpS390XMOVBstoreconst)
		v.AuxInt = 0
		v.AddArg(destptr)
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 2
	// result: (MOVHstoreconst [0] destptr mem)
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 2) {
			break
		}
		v.reset(OpS390XMOVHstoreconst)
		v.AuxInt = 0
		v.AddArg(destptr)
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 4
	// result: (MOVWstoreconst [0] destptr mem)
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 4) {
			break
		}
		v.reset(OpS390XMOVWstoreconst)
		v.AuxInt = 0
		v.AddArg(destptr)
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 8
	// result: (MOVDstoreconst [0] destptr mem)
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 8) {
			break
		}
		v.reset(OpS390XMOVDstoreconst)
		v.AuxInt = 0
		v.AddArg(destptr)
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 3
	// result: (MOVBstoreconst [makeValAndOff(0,2)] destptr 		(MOVHstoreconst [0] destptr mem))
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 3) {
			break
		}
		v.reset(OpS390XMOVBstoreconst)
		v.AuxInt = makeValAndOff(0, 2)
		v.AddArg(destptr)
		v0 := b.NewValue0(v.Line, OpS390XMOVHstoreconst, TypeMem)
		v0.AuxInt = 0
		v0.AddArg(destptr)
		v0.AddArg(mem)
		v.AddArg(v0)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 5
	// result: (MOVBstoreconst [makeValAndOff(0,4)] destptr 		(MOVWstoreconst [0] destptr mem))
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 5) {
			break
		}
		v.reset(OpS390XMOVBstoreconst)
		v.AuxInt = makeValAndOff(0, 4)
		v.AddArg(destptr)
		v0 := b.NewValue0(v.Line, OpS390XMOVWstoreconst, TypeMem)
		v0.AuxInt = 0
		v0.AddArg(destptr)
		v0.AddArg(mem)
		v.AddArg(v0)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 6
	// result: (MOVHstoreconst [makeValAndOff(0,4)] destptr 		(MOVWstoreconst [0] destptr mem))
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 6) {
			break
		}
		v.reset(OpS390XMOVHstoreconst)
		v.AuxInt = makeValAndOff(0, 4)
		v.AddArg(destptr)
		v0 := b.NewValue0(v.Line, OpS390XMOVWstoreconst, TypeMem)
		v0.AuxInt = 0
		v0.AddArg(destptr)
		v0.AddArg(mem)
		v.AddArg(v0)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 7
	// result: (MOVWstoreconst [makeValAndOff(0,3)] destptr 		(MOVWstoreconst [0] destptr mem))
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 7) {
			break
		}
		v.reset(OpS390XMOVWstoreconst)
		v.AuxInt = makeValAndOff(0, 3)
		v.AddArg(destptr)
		v0 := b.NewValue0(v.Line, OpS390XMOVWstoreconst, TypeMem)
		v0.AuxInt = 0
		v0.AddArg(destptr)
		v0.AddArg(mem)
		v.AddArg(v0)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() > 0 && SizeAndAlign(s).Size() <= 1024
	// result: (CLEAR [makeValAndOff(SizeAndAlign(s).Size(), 0)] destptr mem)
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() > 0 && SizeAndAlign(s).Size() <= 1024) {
			break
		}
		v.reset(OpS390XCLEAR)
		v.AuxInt = makeValAndOff(SizeAndAlign(s).Size(), 0)
		v.AddArg(destptr)
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() > 1024
	// result: (LoweredZero [SizeAndAlign(s).Size()%256] destptr (ADDconst <destptr.Type> destptr [(SizeAndAlign(s).Size()/256)*256]) mem)
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() > 1024) {
			break
		}
		v.reset(OpS390XLoweredZero)
		v.AuxInt = SizeAndAlign(s).Size() % 256
		v.AddArg(destptr)
		v0 := b.NewValue0(v.Line, OpS390XADDconst, destptr.Type)
		v0.AuxInt = (SizeAndAlign(s).Size() / 256) * 256
		v0.AddArg(destptr)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueS390X_OpZeroExt16to32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt16to32 x)
	// cond:
	// result: (MOVHZreg x)
	for {
		x := v.Args[0]
		v.reset(OpS390XMOVHZreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpZeroExt16to64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt16to64 x)
	// cond:
	// result: (MOVHZreg x)
	for {
		x := v.Args[0]
		v.reset(OpS390XMOVHZreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpZeroExt32to64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt32to64 x)
	// cond:
	// result: (MOVWZreg x)
	for {
		x := v.Args[0]
		v.reset(OpS390XMOVWZreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpZeroExt8to16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt8to16  x)
	// cond:
	// result: (MOVBZreg x)
	for {
		x := v.Args[0]
		v.reset(OpS390XMOVBZreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpZeroExt8to32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt8to32  x)
	// cond:
	// result: (MOVBZreg x)
	for {
		x := v.Args[0]
		v.reset(OpS390XMOVBZreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueS390X_OpZeroExt8to64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt8to64  x)
	// cond:
	// result: (MOVBZreg x)
	for {
		x := v.Args[0]
		v.reset(OpS390XMOVBZreg)
		v.AddArg(x)
		return true
	}
}
func rewriteBlockS390X(b *Block, config *Config) bool {
	switch b.Kind {
	case BlockS390XEQ:
		// match: (EQ (InvertFlags cmp) yes no)
		// cond:
		// result: (EQ cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XInvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XEQ
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ (FlagEQ) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpS390XFlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ (FlagLT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpS390XFlagLT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (EQ (FlagGT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpS390XFlagGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
	case BlockS390XGE:
		// match: (GE (InvertFlags cmp) yes no)
		// cond:
		// result: (LE cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XInvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XLE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (GE (FlagEQ) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpS390XFlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (GE (FlagLT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpS390XFlagLT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (GE (FlagGT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpS390XFlagGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
	case BlockS390XGT:
		// match: (GT (InvertFlags cmp) yes no)
		// cond:
		// result: (LT cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XInvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XLT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (GT (FlagEQ) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpS390XFlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (GT (FlagLT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpS390XFlagLT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (GT (FlagGT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpS390XFlagGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
	case BlockIf:
		// match: (If (MOVDLT (MOVDconst [0]) (MOVDconst [1]) cmp) yes no)
		// cond:
		// result: (LT cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XMOVDLT {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0.AuxInt != 0 {
				break
			}
			v_1 := v.Args[1]
			if v_1.Op != OpS390XMOVDconst {
				break
			}
			if v_1.AuxInt != 1 {
				break
			}
			cmp := v.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XLT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (MOVDLE (MOVDconst [0]) (MOVDconst [1]) cmp) yes no)
		// cond:
		// result: (LE cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XMOVDLE {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0.AuxInt != 0 {
				break
			}
			v_1 := v.Args[1]
			if v_1.Op != OpS390XMOVDconst {
				break
			}
			if v_1.AuxInt != 1 {
				break
			}
			cmp := v.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XLE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (MOVDGT (MOVDconst [0]) (MOVDconst [1]) cmp) yes no)
		// cond:
		// result: (GT cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XMOVDGT {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0.AuxInt != 0 {
				break
			}
			v_1 := v.Args[1]
			if v_1.Op != OpS390XMOVDconst {
				break
			}
			if v_1.AuxInt != 1 {
				break
			}
			cmp := v.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XGT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (MOVDGE (MOVDconst [0]) (MOVDconst [1]) cmp) yes no)
		// cond:
		// result: (GE cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XMOVDGE {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0.AuxInt != 0 {
				break
			}
			v_1 := v.Args[1]
			if v_1.Op != OpS390XMOVDconst {
				break
			}
			if v_1.AuxInt != 1 {
				break
			}
			cmp := v.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XGE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (MOVDEQ (MOVDconst [0]) (MOVDconst [1]) cmp) yes no)
		// cond:
		// result: (EQ cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XMOVDEQ {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0.AuxInt != 0 {
				break
			}
			v_1 := v.Args[1]
			if v_1.Op != OpS390XMOVDconst {
				break
			}
			if v_1.AuxInt != 1 {
				break
			}
			cmp := v.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XEQ
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (MOVDNE (MOVDconst [0]) (MOVDconst [1]) cmp) yes no)
		// cond:
		// result: (NE cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XMOVDNE {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0.AuxInt != 0 {
				break
			}
			v_1 := v.Args[1]
			if v_1.Op != OpS390XMOVDconst {
				break
			}
			if v_1.AuxInt != 1 {
				break
			}
			cmp := v.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XNE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (MOVDGTnoinv (MOVDconst [0]) (MOVDconst [1]) cmp) yes no)
		// cond:
		// result: (GTF cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XMOVDGTnoinv {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0.AuxInt != 0 {
				break
			}
			v_1 := v.Args[1]
			if v_1.Op != OpS390XMOVDconst {
				break
			}
			if v_1.AuxInt != 1 {
				break
			}
			cmp := v.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XGTF
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (MOVDGEnoinv (MOVDconst [0]) (MOVDconst [1]) cmp) yes no)
		// cond:
		// result: (GEF cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XMOVDGEnoinv {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0.AuxInt != 0 {
				break
			}
			v_1 := v.Args[1]
			if v_1.Op != OpS390XMOVDconst {
				break
			}
			if v_1.AuxInt != 1 {
				break
			}
			cmp := v.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XGEF
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If cond yes no)
		// cond:
		// result: (NE (CMPWconst [0] (MOVBZreg cond)) yes no)
		for {
			v := b.Control
			_ = v
			cond := b.Control
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XNE
			v0 := b.NewValue0(v.Line, OpS390XCMPWconst, TypeFlags)
			v0.AuxInt = 0
			v1 := b.NewValue0(v.Line, OpS390XMOVBZreg, config.fe.TypeUInt64())
			v1.AddArg(cond)
			v0.AddArg(v1)
			b.SetControl(v0)
			_ = yes
			_ = no
			return true
		}
	case BlockS390XLE:
		// match: (LE (InvertFlags cmp) yes no)
		// cond:
		// result: (GE cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XInvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XGE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (LE (FlagEQ) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpS390XFlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (LE (FlagLT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpS390XFlagLT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (LE (FlagGT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpS390XFlagGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
	case BlockS390XLT:
		// match: (LT (InvertFlags cmp) yes no)
		// cond:
		// result: (GT cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XInvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XGT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (LT (FlagEQ) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpS390XFlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (LT (FlagLT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpS390XFlagLT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (LT (FlagGT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpS390XFlagGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
	case BlockS390XNE:
		// match: (NE (CMPWconst [0] (MOVDLT (MOVDconst [0]) (MOVDconst [1]) cmp)) yes no)
		// cond:
		// result: (LT cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XCMPWconst {
				break
			}
			if v.AuxInt != 0 {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDLT {
				break
			}
			v_0_0 := v_0.Args[0]
			if v_0_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0_0.AuxInt != 0 {
				break
			}
			v_0_1 := v_0.Args[1]
			if v_0_1.Op != OpS390XMOVDconst {
				break
			}
			if v_0_1.AuxInt != 1 {
				break
			}
			cmp := v_0.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XLT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (CMPWconst [0] (MOVDLE (MOVDconst [0]) (MOVDconst [1]) cmp)) yes no)
		// cond:
		// result: (LE cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XCMPWconst {
				break
			}
			if v.AuxInt != 0 {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDLE {
				break
			}
			v_0_0 := v_0.Args[0]
			if v_0_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0_0.AuxInt != 0 {
				break
			}
			v_0_1 := v_0.Args[1]
			if v_0_1.Op != OpS390XMOVDconst {
				break
			}
			if v_0_1.AuxInt != 1 {
				break
			}
			cmp := v_0.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XLE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (CMPWconst [0] (MOVDGT (MOVDconst [0]) (MOVDconst [1]) cmp)) yes no)
		// cond:
		// result: (GT cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XCMPWconst {
				break
			}
			if v.AuxInt != 0 {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDGT {
				break
			}
			v_0_0 := v_0.Args[0]
			if v_0_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0_0.AuxInt != 0 {
				break
			}
			v_0_1 := v_0.Args[1]
			if v_0_1.Op != OpS390XMOVDconst {
				break
			}
			if v_0_1.AuxInt != 1 {
				break
			}
			cmp := v_0.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XGT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (CMPWconst [0] (MOVDGE (MOVDconst [0]) (MOVDconst [1]) cmp)) yes no)
		// cond:
		// result: (GE cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XCMPWconst {
				break
			}
			if v.AuxInt != 0 {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDGE {
				break
			}
			v_0_0 := v_0.Args[0]
			if v_0_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0_0.AuxInt != 0 {
				break
			}
			v_0_1 := v_0.Args[1]
			if v_0_1.Op != OpS390XMOVDconst {
				break
			}
			if v_0_1.AuxInt != 1 {
				break
			}
			cmp := v_0.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XGE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (CMPWconst [0] (MOVDEQ (MOVDconst [0]) (MOVDconst [1]) cmp)) yes no)
		// cond:
		// result: (EQ cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XCMPWconst {
				break
			}
			if v.AuxInt != 0 {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDEQ {
				break
			}
			v_0_0 := v_0.Args[0]
			if v_0_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0_0.AuxInt != 0 {
				break
			}
			v_0_1 := v_0.Args[1]
			if v_0_1.Op != OpS390XMOVDconst {
				break
			}
			if v_0_1.AuxInt != 1 {
				break
			}
			cmp := v_0.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XEQ
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (CMPWconst [0] (MOVDNE (MOVDconst [0]) (MOVDconst [1]) cmp)) yes no)
		// cond:
		// result: (NE cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XCMPWconst {
				break
			}
			if v.AuxInt != 0 {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDNE {
				break
			}
			v_0_0 := v_0.Args[0]
			if v_0_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0_0.AuxInt != 0 {
				break
			}
			v_0_1 := v_0.Args[1]
			if v_0_1.Op != OpS390XMOVDconst {
				break
			}
			if v_0_1.AuxInt != 1 {
				break
			}
			cmp := v_0.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XNE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (CMPWconst [0] (MOVDGTnoinv (MOVDconst [0]) (MOVDconst [1]) cmp)) yes no)
		// cond:
		// result: (GTF cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XCMPWconst {
				break
			}
			if v.AuxInt != 0 {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDGTnoinv {
				break
			}
			v_0_0 := v_0.Args[0]
			if v_0_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0_0.AuxInt != 0 {
				break
			}
			v_0_1 := v_0.Args[1]
			if v_0_1.Op != OpS390XMOVDconst {
				break
			}
			if v_0_1.AuxInt != 1 {
				break
			}
			cmp := v_0.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XGTF
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (CMPWconst [0] (MOVDGEnoinv (MOVDconst [0]) (MOVDconst [1]) cmp)) yes no)
		// cond:
		// result: (GEF cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XCMPWconst {
				break
			}
			if v.AuxInt != 0 {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != OpS390XMOVDGEnoinv {
				break
			}
			v_0_0 := v_0.Args[0]
			if v_0_0.Op != OpS390XMOVDconst {
				break
			}
			if v_0_0.AuxInt != 0 {
				break
			}
			v_0_1 := v_0.Args[1]
			if v_0_1.Op != OpS390XMOVDconst {
				break
			}
			if v_0_1.AuxInt != 1 {
				break
			}
			cmp := v_0.Args[2]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XGEF
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (InvertFlags cmp) yes no)
		// cond:
		// result: (NE cmp yes no)
		for {
			v := b.Control
			if v.Op != OpS390XInvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockS390XNE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (FlagEQ) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpS390XFlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (NE (FlagLT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpS390XFlagLT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (FlagGT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpS390XFlagGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
	}
	return false
}
