/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.MultipartDataSource;
import javax.mail.Part;

public abstract class Multipart {
    protected Vector parts;
    protected String contentType = "multipart/mixed";
    protected Part parent = null;

    protected Multipart() {
    }

    protected void setMultipartDataSource(MultipartDataSource mp) throws MessagingException {
        this.contentType = mp.getContentType();
        int count = mp.getCount();
        for (int i = 0; i < count; ++i) {
            this.addBodyPart(mp.getBodyPart(i));
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getCount() throws MessagingException {
        return this.parts == null ? 0 : this.parts.size();
    }

    public BodyPart getBodyPart(int index) throws MessagingException {
        if (this.parts == null) {
            throw new IndexOutOfBoundsException();
        }
        return (BodyPart)this.parts.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeBodyPart(BodyPart part) throws MessagingException {
        if (this.parts == null) {
            throw new MessagingException("No such BodyPart");
        }
        Vector vector = this.parts;
        synchronized (vector) {
            boolean success = this.parts.remove(part);
            if (success) {
                part.setParent(null);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBodyPart(int index) throws MessagingException {
        if (this.parts == null) {
            throw new IndexOutOfBoundsException("No such BodyPart");
        }
        Vector vector = this.parts;
        synchronized (vector) {
            BodyPart part = (BodyPart)this.parts.get(index);
            this.parts.remove(index);
            part.setParent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addBodyPart(BodyPart part) throws MessagingException {
        if (this.parts == null) {
            this.parts = new Vector();
        }
        Vector vector = this.parts;
        synchronized (vector) {
            this.parts.add(part);
            part.setParent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addBodyPart(BodyPart part, int index) throws MessagingException {
        if (this.parts == null) {
            this.parts = new Vector();
        }
        Vector vector = this.parts;
        synchronized (vector) {
            this.parts.add(index, part);
            part.setParent(this);
        }
    }

    public abstract void writeTo(OutputStream var1) throws IOException, MessagingException;

    public Part getParent() {
        return this.parent;
    }

    public void setParent(Part part) {
        this.parent = part;
    }
}

