/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.AcknowledgedRestListener;

public class RestUpdateSettingsAction
extends BaseRestHandler {
    private static final Set<String> VALUES_TO_EXCLUDE = Collections.unmodifiableSet(Sets.newHashSet("error_trace", "pretty", "timeout", "master_timeout", "index", "preserve_existing", "expand_wildcards", "ignore_unavailable", "allow_no_indices"));

    @Inject
    public RestUpdateSettingsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_settings", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_settings", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        UpdateSettingsRequest updateSettingsRequest = Requests.updateSettingsRequest(Strings.splitStringByCommaToArray(request.param("index")));
        updateSettingsRequest.timeout(request.paramAsTime("timeout", updateSettingsRequest.timeout()));
        updateSettingsRequest.setPreserveExisting(request.paramAsBoolean("preserve_existing", updateSettingsRequest.isPreserveExisting()));
        updateSettingsRequest.masterNodeTimeout(request.paramAsTime("master_timeout", updateSettingsRequest.masterNodeTimeout()));
        updateSettingsRequest.indicesOptions(IndicesOptions.fromRequest(request, updateSettingsRequest.indicesOptions()));
        Settings.Builder updateSettings = Settings.builder();
        String bodySettingsStr = request.content().utf8ToString();
        if (Strings.hasText(bodySettingsStr)) {
            Settings buildSettings = Settings.builder().loadFromSource(bodySettingsStr).build();
            for (Map.Entry<String, String> entry : buildSettings.getAsMap().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key.startsWith("settings.")) {
                    key = key.substring("settings.".length());
                }
                updateSettings.put(key, value);
            }
        }
        for (Map.Entry<String, String> entry : request.params().entrySet()) {
            if (VALUES_TO_EXCLUDE.contains(entry.getKey())) continue;
            updateSettings.put(entry.getKey(), entry.getValue());
        }
        updateSettingsRequest.settings(updateSettings);
        return channel -> client.admin().indices().updateSettings(updateSettingsRequest, new AcknowledgedRestListener<UpdateSettingsResponse>(channel));
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }
}

