/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.reindex.AbstractBaseReindexRestHandler;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.search.SearchRequestParsers;

public abstract class AbstractBulkByQueryRestHandler<Request extends AbstractBulkByScrollRequest<Request>, A extends GenericAction<Request, BulkIndexByScrollResponse>>
extends AbstractBaseReindexRestHandler<Request, A> {
    protected AbstractBulkByQueryRestHandler(Settings settings, SearchRequestParsers searchRequestParsers, ClusterService clusterService, A action) {
        super(settings, searchRequestParsers, clusterService, action);
    }

    protected void parseInternalRequest(Request internal, RestRequest restRequest, Map<String, Consumer<Object>> bodyConsumers) throws IOException {
        assert (internal != null) : "Request should not be null";
        assert (restRequest != null) : "RestRequest should not be null";
        SearchRequest searchRequest = ((AbstractBulkByScrollRequest)((Object)internal)).getSearchRequest();
        int scrollSize = searchRequest.source().size();
        searchRequest.source().size(-1);
        restRequest.withContentOrSourceParamParserOrNull(parser -> {
            XContentParser searchRequestParser = this.extractRequestSpecificFieldsAndReturnSearchCompatibleParser((XContentParser)parser, bodyConsumers);
            try {
                RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (RestRequest)restRequest, (SearchRequestParsers)this.searchRequestParsers, (ParseFieldMatcher)this.parseFieldMatcher, (XContentParser)searchRequestParser);
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{searchRequestParser});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{searchRequestParser});
        });
        ((AbstractBulkByScrollRequest)((Object)internal)).setSize(searchRequest.source().size());
        searchRequest.source().size(restRequest.paramAsInt("scroll_size", scrollSize));
        String conflicts = restRequest.param("conflicts");
        if (conflicts != null) {
            ((AbstractBulkByScrollRequest)((Object)internal)).setConflicts(conflicts);
        }
        if (restRequest.hasParam("search_timeout")) {
            searchRequest.source().timeout(restRequest.paramAsTime("search_timeout", null));
        }
    }

    /*
     * Loose catch block
     */
    private XContentParser extractRequestSpecificFieldsAndReturnSearchCompatibleParser(XContentParser parser, Map<String, Consumer<Object>> bodyConsumers) throws IOException {
        if (parser == null) {
            return parser;
        }
        try {
            Map body = parser.map();
            for (Map.Entry<String, Consumer<Object>> consumer : bodyConsumers.entrySet()) {
                Object value = body.remove(consumer.getKey());
                if (value == null) continue;
                consumer.getValue().accept(value);
            }
            try (XContentBuilder builder = XContentFactory.contentBuilder((XContentType)parser.contentType());){
                XContentParser xContentParser = parser.contentType().xContent().createParser(parser.getXContentRegistry(), builder.map(body).bytes());
                return xContentParser;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            parser.close();
        }
    }
}

