/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.mission;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.mission.CompoundMission;
import net.sf.freecol.common.model.mission.GoToMission;
import net.sf.freecol.common.model.mission.ImprovementMission;
import net.sf.freecol.common.model.mission.Mission;

public class MissionManager {
    private static final Logger logger = Logger.getLogger(MissionManager.class.getName());
    private static final Map<String, Constructor<? extends Mission>> missionMap = new HashMap<String, Constructor<? extends Mission>>();

    public static boolean isMissionTag(String tag) {
        return missionMap.containsKey(tag);
    }

    public static Mission getMission(Game game, FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        Constructor<? extends Mission> c = missionMap.get(tag);
        if (c == null) {
            logger.warning("Unknown type of mission: '" + tag + "'.");
            xr.nextTag();
            return null;
        }
        try {
            return c.newInstance(game, xr);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to instatiate mission with tag: " + tag, e);
            return null;
        }
    }

    static {
        try {
            missionMap.put(CompoundMission.getXMLElementTagName(), CompoundMission.class.getConstructor(Game.class, FreeColXMLReader.class));
            missionMap.put(GoToMission.getXMLElementTagName(), GoToMission.class.getConstructor(Game.class, FreeColXMLReader.class));
            missionMap.put(ImprovementMission.getXMLElementTagName(), ImprovementMission.class.getConstructor(Game.class, FreeColXMLReader.class));
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.WARNING, "Missing constructor", e);
        }
    }
}

