#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cryptonite
version: 0.22
id: cryptonite-0.22-7bAfM4r9KLCJIhVfr7jYAd
key: cryptonite-0.22-7bAfM4r9KLCJIhVfr7jYAd
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: vincent@snarc.org
stability: experimental
homepage: https://github.com/haskell-crypto/cryptonite
synopsis: Cryptography Primitives sink
description:
    A repository of cryptographic primitives.
    .
    * Symmetric ciphers: AES, DES, 3DES, Blowfish, Camellia, RC4, Salsa, XSalsa, ChaCha.
    .
    * Hash: SHA1, SHA2, SHA3, SHAKE, MD2, MD4, MD5, Keccak, Skein, Ripemd, Tiger, Whirlpool, Blake2
    .
    * MAC: HMAC, Poly1305
    .
    * Asymmetric crypto: DSA, RSA, DH, ECDH, ECDSA, ECC, Curve25519, Curve448, Ed25519
    .
    * Key Derivation Function: PBKDF2, Scrypt, HKDF, Argon2
    .
    * Cryptographic Random generation: System Entropy, Deterministic Random Generator
    .
    * Data related: Anti-Forensic Information Splitter (AFIS)
    .
    If anything cryptographic related is missing from here, submit
    a pull request to have it added. This package strive to be a
    cryptographic kitchen sink that provides cryptography for everyone.
    .
    Evaluate the security related to your requirements before using.
    .
    Read "Crypto.Tutorial" for a quick start guide.
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
exposed-modules:
    Crypto.Cipher.AES Crypto.Cipher.Blowfish Crypto.Cipher.Camellia
    Crypto.Cipher.ChaCha Crypto.Cipher.ChaChaPoly1305 Crypto.Cipher.DES
    Crypto.Cipher.RC4 Crypto.Cipher.Salsa Crypto.Cipher.TripleDES
    Crypto.Cipher.Types Crypto.Cipher.XSalsa
    Crypto.ConstructHash.MiyaguchiPreneel Crypto.Data.AFIS
    Crypto.Data.Padding Crypto.ECC Crypto.Error Crypto.MAC.CMAC
    Crypto.MAC.Poly1305 Crypto.MAC.HMAC Crypto.Number.Basic
    Crypto.Number.F2m Crypto.Number.Generate
    Crypto.Number.ModArithmetic Crypto.Number.Prime
    Crypto.Number.Serialize Crypto.Number.Serialize.Internal
    Crypto.KDF.Argon2 Crypto.KDF.PBKDF2 Crypto.KDF.Scrypt
    Crypto.KDF.BCrypt Crypto.KDF.HKDF Crypto.Hash Crypto.Hash.IO
    Crypto.Hash.Algorithms Crypto.OTP Crypto.PubKey.Curve25519
    Crypto.PubKey.Curve448 Crypto.PubKey.MaskGenFunction
    Crypto.PubKey.DH Crypto.PubKey.DSA Crypto.PubKey.ECC.Generate
    Crypto.PubKey.ECC.Prim Crypto.PubKey.ECC.DH Crypto.PubKey.ECC.ECDSA
    Crypto.PubKey.ECC.P256 Crypto.PubKey.ECC.Types Crypto.PubKey.ECIES
    Crypto.PubKey.Ed25519 Crypto.PubKey.Ed448 Crypto.PubKey.RSA
    Crypto.PubKey.RSA.PKCS15 Crypto.PubKey.RSA.Prim
    Crypto.PubKey.RSA.PSS Crypto.PubKey.RSA.OAEP
    Crypto.PubKey.RSA.Types Crypto.Random Crypto.Random.Types
    Crypto.Random.Entropy Crypto.Random.EntropyPool
    Crypto.Random.Entropy.Unsafe Crypto.Tutorial
hidden-modules: Crypto.Cipher.AES.Primitive
                Crypto.Cipher.Blowfish.Box Crypto.Cipher.Blowfish.Primitive
                Crypto.Cipher.Camellia.Primitive Crypto.Cipher.DES.Primitive
                Crypto.Cipher.Types.AEAD Crypto.Cipher.Types.Base
                Crypto.Cipher.Types.Block Crypto.Cipher.Types.GF
                Crypto.Cipher.Types.Stream Crypto.Cipher.Types.Utils
                Crypto.Error.Types Crypto.Number.Compat Crypto.Hash.Types
                Crypto.Hash.Blake2s Crypto.Hash.Blake2sp Crypto.Hash.Blake2b
                Crypto.Hash.Blake2bp Crypto.Hash.SHA1 Crypto.Hash.SHA224
                Crypto.Hash.SHA256 Crypto.Hash.SHA384 Crypto.Hash.SHA512
                Crypto.Hash.SHA512t Crypto.Hash.SHA3 Crypto.Hash.Keccak
                Crypto.Hash.MD2 Crypto.Hash.MD4 Crypto.Hash.MD5
                Crypto.Hash.RIPEMD160 Crypto.Hash.Skein256 Crypto.Hash.Skein512
                Crypto.Hash.Tiger Crypto.Hash.Whirlpool
                Crypto.Random.Entropy.Source Crypto.Random.Entropy.Backend
                Crypto.Random.ChaChaDRG Crypto.Random.SystemDRG
                Crypto.Random.Probabilistic Crypto.PubKey.Internal
                Crypto.PubKey.ElGamal Crypto.ECC.Simple.Types
                Crypto.ECC.Simple.Prim Crypto.Internal.Proxy
                Crypto.Internal.ByteArray Crypto.Internal.Compat
                Crypto.Internal.CompatPrim Crypto.Internal.DeepSeq
                Crypto.Internal.Imports Crypto.Internal.Words
                Crypto.Internal.WordArray Crypto.Hash.SHAKE Crypto.Internal.Nat
                Crypto.Random.Entropy.Unix
abi: ac0868c0c1b6993d3d581ef98facb564
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/cryptonite-0.22
library-dirs: /usr/lib/ghc-8.0.1/site-local/cryptonite-0.22
data-dir: /usr/share/arm-linux-ghc-8.0.1/cryptonite-0.22
hs-libraries: HScryptonite-0.22-7bAfM4r9KLCJIhVfr7jYAd
depends:
    base-4.9.0.0 bytestring-0.10.8.1 deepseq-1.4.2.0 ghc-prim-0.5.0.0
    integer-gmp-1.0.0.1 memory-0.14.2-6gBSLDcT37k2vocvCRPqMi
haddock-interfaces: /usr/share/doc/haskell-cryptonite/html/cryptonite.haddock
haddock-html: /usr/share/doc/haskell-cryptonite/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
