/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;

public class MagresReader
extends AtomSetCollectionReader {
    private static final int BLOCK_NEW = -2;
    private static final int BLOCK_NONE = -1;
    private static final int BLOCK_CALC = 0;
    private static final int BLOCK_ATOMS = 1;
    private static final int BLOCK_MAGRES = 2;
    private int currentBlock = -1;
    private float[] cellParams;
    private Map<String, String> magresUnits = new Hashtable<String, String>();
    private Lst<Tensor> interactionTensors = new Lst();
    private SB header = new SB();

    protected void initializeReader() {
        this.setFractionalCoordinates(false);
        this.ignoreFileSpaceGroupName = true;
    }

    protected void finalizeSubclassReader() throws Exception {
        this.asc.setInfo("fileHeader", (Object)this.header.toString());
        this.finalizeReaderASCR();
        if (this.interactionTensors.size() > 0) {
            this.asc.setCurrentModelInfo("interactionTensors", this.interactionTensors);
        }
    }

    protected boolean checkLine() throws Exception {
        if (!this.trimLine()) {
            return true;
        }
        switch (this.checkBlock()) {
            case 0: {
                this.header.append(this.line).append("\n");
                this.appendLoadNote(this.line);
                break;
            }
            case 1: {
                if (this.cellParams == null && this.line.startsWith("lattice")) {
                    return this.readCellParams();
                }
                if (this.line.startsWith("symmetry")) {
                    return this.readSymmetry();
                }
                if (this.line.startsWith("units")) {
                    return this.setUnits(false);
                }
                if (!this.line.startsWith("atom")) break;
                return this.readAtom();
            }
            case 2: {
                if (this.line.startsWith("units")) {
                    return this.setUnits(true);
                }
                return this.readTensor();
            }
        }
        return true;
    }

    private boolean trimLine() {
        int pt = this.line.indexOf("#");
        if (pt >= 0) {
            this.line = this.line.substring(0, pt);
        }
        this.line = this.line.trim();
        return this.line.length() > 0;
    }

    private int checkBlock() {
        if (!(this.line.startsWith("<") && this.line.endsWith(">") || this.line.startsWith("[") && this.line.endsWith("]"))) {
            return this.currentBlock;
        }
        this.line = PT.rep((String)this.line, (String)"<", (String)"[");
        this.line = PT.rep((String)this.line, (String)">", (String)"]");
        switch ("...............[calculation]..[/calculation].[atoms]........[/atoms].......[magres].......[/magres]......".indexOf(this.line + ".") / 15) {
            case 0: {
                Logger.info((String)("block indicator ignored: " + this.line));
                break;
            }
            case 1: {
                if (this.currentBlock != -1) break;
                this.currentBlock = 0;
                break;
            }
            case 2: {
                if (this.currentBlock != 0) break;
                this.currentBlock = -1;
                break;
            }
            case 3: {
                if (this.currentBlock != -1) break;
                this.currentBlock = 1;
                this.asc.newAtomSet();
                this.magresUnits = new Hashtable<String, String>();
                break;
            }
            case 4: {
                if (this.currentBlock != 1) break;
                this.currentBlock = -1;
                break;
            }
            case 5: {
                if (this.currentBlock != -1) break;
                this.currentBlock = 2;
                this.magresUnits = new Hashtable<String, String>();
                this.asc.setCurrentModelInfo("magresUnits", this.magresUnits);
                break;
            }
            case 6: {
                if (this.currentBlock != 2) break;
                this.currentBlock = -1;
            }
        }
        return -2;
    }

    private boolean setUnits(boolean isMagresBlock) {
        String[] tokens = this.getTokens();
        String id = tokens[1];
        if (isMagresBlock) {
            this.appendLoadNote("Ellipsoid set " + PT.esc((String)id) + ": " + (id.startsWith("ms") ? "Magnetic Shielding" : (id.startsWith("efg") ? "Electric Field Gradient" : (id.startsWith("isc") ? "J-Coupling" : "?"))));
        }
        this.magresUnits.put(id, tokens[2]);
        return true;
    }

    private boolean readSymmetry() {
        this.setSymmetryOperator(this.getTokens()[1]);
        return true;
    }

    private boolean readCellParams() throws Exception {
        String[] tokens = this.getTokens();
        this.cellParams = new float[9];
        for (int i = 0; i < 9; ++i) {
            this.cellParams[i] = this.parseFloatStr(tokens[i + 1]);
        }
        this.addPrimitiveLatticeVector(0, this.cellParams, 0);
        this.addPrimitiveLatticeVector(1, this.cellParams, 3);
        this.addPrimitiveLatticeVector(2, this.cellParams, 6);
        this.setSpaceGroupName("P1");
        return true;
    }

    private boolean readAtom() {
        String units = this.magresUnits.get("atom");
        if (units == null) {
            return true;
        }
        float f = units.startsWith("A") ? 1.0f : 0.5291772f;
        String[] tokens = this.getTokens();
        Atom atom = new Atom();
        int pt = 1;
        atom.elementSymbol = tokens[pt++];
        atom.atomName = MagresReader.getAtomName(tokens[pt++], tokens[pt++]);
        this.asc.addAtomWithMappedName(atom);
        float x = this.parseFloatStr(tokens[pt++]) * f;
        float y = this.parseFloatStr(tokens[pt++]) * f;
        float z = this.parseFloatStr(tokens[pt++]) * f;
        atom.set(x, y, z);
        this.setAtomCoord(atom);
        return true;
    }

    private static String getAtomName(String name, String index) {
        return name + "_" + index;
    }

    private boolean readTensor() throws Exception {
        String atomName2;
        String[] tokens = this.getTokens();
        String type = tokens[0];
        String units = this.magresUnits.get(type);
        if (units == null) {
            Logger.warn((String)(type + " ignored; no units defined; line: " + this.line));
            return true;
        }
        boolean isIsc = type.startsWith("isc");
        if (tokens.length == 10) {
            this.magresUnits.remove(type);
            float[] data = new float[9];
            int i = 0;
            while (i < 9) {
                data[i++] = this.parseFloatStr(tokens[i]);
            }
            Logger.info((String)("Magres reader creating magres_" + type + ": " + Escape.eAF((float[])data)));
            this.asc.setCurrentModelInfo("magres_" + type, (Object)data);
        }
        String atomName1 = MagresReader.getAtomName(tokens[1], tokens[2]);
        int pt = 3;
        String string = atomName2 = isIsc ? MagresReader.getAtomName(tokens[pt++], tokens[pt++]) : null;
        if (atomName1.equals(atomName2)) {
            Logger.warn((String)(type + " ignored; atom1 == atom2 for " + atomName1 + " line: " + this.line));
            return true;
        }
        String id = atomName1;
        if (atomName2 != null) {
            id = id + "//" + atomName2;
        }
        double[][] a = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                a[i][j] = Double.valueOf(tokens[pt++]);
            }
        }
        Atom a1 = this.asc.getAtomFromName(atomName1);
        if (a1 == null) {
            return true;
        }
        Atom a2 = null;
        Tensor t = new Tensor().setFromAsymmetricTensor(a, type, id);
        if (atomName2 == null) {
            a1.addTensor(t, null, false);
        } else {
            a2 = this.asc.getAtomFromName(atomName2);
            if (a2 == null) {
                return true;
            }
            this.interactionTensors.addLast((Object)t);
        }
        t.setAtomIndexes(a1.index, a2 == null ? -1 : a2.index);
        return true;
    }
}

