/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Properties;
import java.util.Queue;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.DefaultComboBoxModel;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.nbo.NBODialog;

public class NBOService {
    static final int MODE_ERROR = -1;
    static final int MODE_RAW = 0;
    static final int MODE_MODEL = 1;
    static final int MODE_RUN = 20;
    static final int MODE_VALUE = 45;
    static final int MODE_LIST = 46;
    static final int MODE_LIST_MO = 47;
    static final int MODE_IMAGE = 88;
    static final int MODE_SEARCH_SELECT = 90;
    static final int MODE_LABEL = 50;
    static final int MODE_GETRS = 61;
    static final int MODE_LABEL_BONDS = 62;
    protected int count;
    protected Viewer vwr;
    NBODialog nboDialog;
    protected Process nboServer;
    protected Thread nboListener;
    private InputStream stdout;
    protected BufferedReader nboReader;
    private PrintWriter stdinWriter;
    private SB sbRet;
    private boolean inData;
    protected boolean isWorking;
    String serverPath;
    String serverDir;
    private String nboModel;
    NBOJob currJob;
    Queue<NBOJob> jobQueue;
    protected Object lock;
    private boolean cantStartServer;

    boolean isOffLine() {
        return this.cantStartServer;
    }

    public NBOService(Viewer vwr) {
        this.vwr = vwr;
        this.sbRet = new SB();
        Properties props = JmolPanel.historyFile.getProperties();
        this.setServerPath(props.getProperty("nboServerPath", System.getProperty("user.home") + "/NBOServe"));
        this.jobQueue = new ArrayDeque<NBOJob>();
        this.lock = new Object();
    }

    protected void setServerPath(String path) {
        this.serverPath = path;
        this.serverDir = new File(this.serverPath).getParent() + "/";
    }

    protected void sendToNBO(NBOJob job) {
        String s = "<" + job.cmd + ">";
        this.currJob = job;
        this.nboDialog.inputFileHandler.writeToFile(this.serverDir + "/" + job.cmd, job.sb.toString());
        this.nboDialog.setStatus(job.statusInfo + " (sending job.cmd)");
        this.sendCmd(s);
    }

    private void sendCmd(String s) {
        this.count = 1;
        System.out.println("sending " + s);
        if (this.stdinWriter == null) {
            this.restart();
        }
        this.stdinWriter.println(s);
        this.stdinWriter.flush();
    }

    protected void nboAddModelLine(String line) {
        if (Logger.debugging) {
            Logger.debug(this.inData + " " + this.sbRet.length() + " " + "receiving: " + line);
        }
        if (line.startsWith("DATA \" \"")) {
            this.isWorking = false;
        } else if (line.startsWith("DATA ")) {
            if (line.startsWith("DATA \"model")) {
                this.sbRet.setLength(0);
                line = this.fixNBOModel(line);
            }
            boolean bl = this.inData = line.indexOf("exit") < 0;
            if (this.inData) {
                this.sbRet.append(line + "\n");
            }
        } else if (!this.inData) {
            this.nboDialog.processModelLine(line);
        } else if (this.sbRet != null) {
            this.sbRet.append(line + "\n");
            if (line.indexOf("END") >= 0) {
                this.inData = false;
                if (line.indexOf("\"" + this.nboModel + "\"") >= 0) {
                    this.nboDialog.processModelEnd(this.sbRet.toString(), this.currJob.statusInfo);
                }
                this.sbRet.setLength(0);
                this.nboModel = "\u0000";
            }
        }
    }

    private String fixNBOModel(String line) {
        this.nboModel = PT.getQuotedStringAt(line, 0);
        String s = " NBO " + this.nboModel;
        int pt = line.indexOf("\n");
        return pt < 0 ? line + s : line.substring(0, pt) + s + line.substring(pt);
    }

    String startProcess(boolean sync, int mode) {
        try {
            System.out.println("starting NBO process sync=" + sync);
            File pathToExecutable = new File(this.serverPath);
            ProcessBuilder builder = new ProcessBuilder(this.serverPath);
            builder.directory(new File(pathToExecutable.getParent()));
            builder.redirectErrorStream(true);
            this.nboServer = builder.start();
            this.stdout = this.nboServer.getInputStream();
            this.nboReader = new BufferedReader(new InputStreamReader(this.stdout));
            this.nboListener = null;
            this.nboListener = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean inOpener = false;
                    boolean inRequest = false;
                    System.out.println("nboListener " + this + " running");
                    while (!Thread.currentThread().isInterrupted()) {
                        String line = null;
                        try {
                            block18: while ((line = NBOService.this.nboReader.readLine()) != null) {
                                NBOService.this.logServerLine(line);
                                if (line.indexOf("DATA \" \"") >= 0) {
                                    inOpener = true;
                                    continue;
                                }
                                if (line.indexOf("END \"\"") >= 0) {
                                    inOpener = false;
                                    continue;
                                }
                                if (inOpener) continue;
                                if (line.indexOf("*start*") >= 0) {
                                    if (NBOService.this.currJob.dialogMode == 50) continue;
                                    NBOService.this.isWorking = true;
                                    inRequest = true;
                                    continue;
                                }
                                if (NBOService.this.isFortranError(line)) {
                                    if (line.contains("end of file")) continue;
                                    NBOService.this.nboDialog.alertError(line);
                                    inRequest = false;
                                    NBOService.this.isWorking = false;
                                    continue;
                                }
                                if (line.indexOf("missing or invalid") >= 0) {
                                    NBOService.this.nboDialog.alertError(line);
                                    NBOService.this.isWorking = false;
                                    inRequest = false;
                                }
                                if (line.indexOf("FORTRAN STOP") >= 0) {
                                    NBOService.this.nboDialog.alertError("NBOServe has stopped working");
                                    NBOService.this.restart();
                                }
                                if (line.indexOf("NBOServe") >= 0) {
                                    NBOService.this.nboDialog.licenseInfo.setText("<html><div style='text-align: center'>" + line + "</html>");
                                    NBOService.this.isWorking = false;
                                    continue;
                                }
                                if (line.indexOf("*end*") >= 0) {
                                    Object object = NBOService.this.lock;
                                    synchronized (object) {
                                        if (!NBOService.this.isWorking) {
                                            continue;
                                        }
                                        inRequest = false;
                                        NBOService.this.isWorking = false;
                                        NBOService.this.jobQueue.remove();
                                        NBOService.this.nboDialog.processEnd(NBOService.this.currJob.dialogMode, NBOService.this.currJob.list);
                                        if (!NBOService.this.jobQueue.isEmpty() && NBOService.this.nboDialog.dialogMode != 'r') {
                                            NBOService.this.currJob = NBOService.this.jobQueue.peek();
                                            NBOService.this.sendToNBO(NBOService.this.currJob);
                                        } else {
                                            NBOService.this.currJob = null;
                                        }
                                        continue;
                                    }
                                }
                                switch (NBOService.this.currJob.dialogMode) {
                                    case 45: {
                                        if (!NBOService.this.isWorking || !inRequest) continue block18;
                                        NBOService.this.nboDialog.processValue(line);
                                        inRequest = false;
                                        continue block18;
                                    }
                                    case 46: {
                                        if (!NBOService.this.isWorking || !inRequest) continue block18;
                                        NBOService.this.currJob.list.addElement(line.trim());
                                        continue block18;
                                    }
                                    case 47: {
                                        if (!NBOService.this.isWorking || !inRequest) continue block18;
                                        String tmp = line.replace("MO ", "");
                                        tmp = tmp.replace(" ", ".  ");
                                        NBOService.this.currJob.list.addElement("  " + tmp);
                                        continue block18;
                                    }
                                    case 90: {
                                        if (!line.startsWith(" Select")) continue block18;
                                        inRequest = false;
                                        NBOService.this.isWorking = false;
                                        continue block18;
                                    }
                                    case 88: {
                                        if (!line.contains("Missing valid")) continue block18;
                                        inRequest = false;
                                        NBOService.this.isWorking = false;
                                        NBOService.this.nboDialog.alertError(line);
                                        continue block18;
                                    }
                                    case 50: {
                                        if (NBOService.this.isWorking && inRequest) {
                                            NBOService.this.nboDialog.processLabel(line, NBOService.this.count++);
                                        }
                                        if (line.indexOf("END \"model") < 0) continue block18;
                                        inRequest = true;
                                        NBOService.this.isWorking = true;
                                        continue block18;
                                    }
                                    case 62: {
                                        if (line.indexOf("DATA") >= 0) {
                                            inRequest = false;
                                        }
                                        if (line.indexOf("END") >= 0) {
                                            inRequest = true;
                                            continue block18;
                                        }
                                        if (!NBOService.this.isWorking || !inRequest) continue block18;
                                        NBOService.this.nboDialog.processLabelBonds(line);
                                        continue block18;
                                    }
                                    case 1: {
                                        if (line.indexOf("can't do that") >= 0) {
                                            NBOService.this.nboDialog.processModelLine(line);
                                            inRequest = false;
                                            NBOService.this.isWorking = false;
                                            continue block18;
                                        }
                                        NBOService.this.nboAddModelLine(line);
                                        continue block18;
                                    }
                                    case 61: {
                                        if (!inRequest || !NBOService.this.isWorking) continue block18;
                                        int cnt = Integer.parseInt(line.trim());
                                        for (int i = 1; i <= cnt; ++i) {
                                            NBOService.this.currJob.list.addElement("R.S. " + i);
                                        }
                                        continue block18;
                                    }
                                    case 0: 
                                    case 20: {
                                        continue block18;
                                    }
                                }
                                NBOService.this.nboAddModelLine(line);
                            }
                        }
                        catch (Throwable e1) {
                        }
                    }
                }
            });
            this.nboListener.setName("NBOServiceThread" + System.currentTimeMillis());
            this.nboListener.start();
            this.stdinWriter = new PrintWriter(this.nboServer.getOutputStream());
        }
        catch (IOException e) {
            this.cantStartServer = true;
            this.nboDialog.logInfo(e.getMessage(), 2);
            return e.getMessage();
        }
        return null;
    }

    protected void logServerLine(String line) {
        this.nboDialog.logInfo(line, this.isFortranError(line) ? 2 : 5);
    }

    protected boolean isFortranError(String line) {
        return line.indexOf("Permission denied") >= 0 || line.indexOf("PGFIO-F") >= 0 || line.indexOf("Invalid command") >= 0;
    }

    public void closeProcess() {
        this.isWorking = false;
        this.stdout = null;
        try {
            this.stdinWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stdinWriter = null;
        try {
            this.nboReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nboReader = null;
        try {
            this.nboListener.interrupt();
        }
        catch (Exception e) {
            System.out.println("can't interrupt");
        }
        this.nboListener = null;
        try {
            this.nboServer.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nboServer = null;
    }

    String restart() {
        this.closeProcess();
        return this.startProcess(false, 0);
    }

    public boolean restartIfNecessary() {
        if (this.nboServer == null) {
            this.startProcess(false, 0);
        }
        return this.nboServer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rawCmdNew(String cmd, SB data, int dialogMode, DefaultComboBoxModel<String> list, String status) {
        if (dialogMode == 50) {
            this.nboDialog.runScriptNow("mo delete; nbo delete");
        }
        String fname = null;
        Object object = this.lock;
        synchronized (object) {
            if (data == null) {
                this.nboDialog.logInfo("> " + cmd, 5);
            } else {
                fname = cmd + "_cmd.txt";
                this.nboDialog.logInfo("> " + fname + "\n" + data, 5);
                cmd = "<" + fname + ">";
                this.isWorking = true;
            }
            if (this.jobQueue.isEmpty()) {
                this.currJob = new NBOJob(fname, data, status, list);
                this.jobQueue.add(this.currJob);
                this.currJob.dialogMode = dialogMode;
                this.sendToNBO(this.currJob);
            } else {
                NBOJob j = new NBOJob(fname, data, status, list);
                j.dialogMode = dialogMode;
                this.jobQueue.add(j);
            }
        }
    }

    class NBOJob {
        String cmd;
        String statusInfo;
        DefaultComboBoxModel<String> list;
        SB sb;
        NBODialog dialog;
        protected int dialogMode;

        NBOJob(String cmd, SB sb, String statusInfo, DefaultComboBoxModel<String> list) {
            this.cmd = cmd;
            this.sb = sb;
            this.list = list;
            this.statusInfo = statusInfo;
        }
    }
}

