/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Objects;
import org.openstreetmap.josm.gui.draw.SymbolShape;

public class Symbol {
    private final SymbolShape symbolShape;
    public final int size;
    public final Stroke stroke;
    public final Color strokeColor;
    public final Color fillColor;

    public Symbol(SymbolShape symbolShape, int n, Stroke stroke, Color color, Color color2) {
        if (stroke != null && color == null) {
            throw new IllegalArgumentException("Stroke given without color");
        }
        if (stroke == null && color2 == null) {
            throw new IllegalArgumentException("Either a stroke or a fill color must be given");
        }
        this.symbolShape = symbolShape;
        this.size = n;
        this.stroke = stroke;
        this.strokeColor = color;
        this.fillColor = color2;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Symbol symbol = (Symbol)object;
        return this.symbolShape == symbol.symbolShape && this.size == symbol.size && Objects.equals(this.stroke, symbol.stroke) && Objects.equals(this.strokeColor, symbol.strokeColor) && Objects.equals(this.fillColor, symbol.fillColor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.symbolShape, this.size, this.stroke, this.strokeColor, this.fillColor});
    }

    public String toString() {
        return "symbolShape=" + (Object)((Object)this.symbolShape) + " size=" + this.size + (this.stroke != null ? " stroke=" + this.stroke + " strokeColor=" + this.strokeColor : "") + (this.fillColor != null ? " fillColor=" + this.fillColor : "");
    }

    public Shape buildShapeAround(double d, double d2) {
        return this.symbolShape.shapeAround(d, d2, this.size);
    }
}

