/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.internal.LibraryDef;
import net.rubygrapefruit.platform.internal.NativeLibraryLocator;
import net.rubygrapefruit.platform.internal.Platform;

public class NativeLibraryLoader {
    private final Set<String> loaded = new HashSet<String>();
    private final Platform platform;
    private final NativeLibraryLocator nativeLibraryLocator;

    public NativeLibraryLoader(Platform platform, NativeLibraryLocator nativeLibraryLocator) {
        this.platform = platform;
        this.nativeLibraryLocator = nativeLibraryLocator;
    }

    public void load(String libraryFileName) {
        if (this.loaded.contains(libraryFileName)) {
            return;
        }
        try {
            File libFile = this.nativeLibraryLocator.find(new LibraryDef(libraryFileName, this.platform.getId()));
            if (libFile == null) {
                throw new NativeIntegrationUnavailableException(String.format("Native library '%s' is not available for %s.", libraryFileName, this.platform));
            }
            System.load(libFile.getCanonicalPath());
        }
        catch (NativeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new NativeException(String.format("Failed to load native library '%s' for %s.", libraryFileName, this.platform), t);
        }
        this.loaded.add(libraryFileName);
    }
}

