/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.patterns.typePredicates.TypePredicatesKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public final class PatternTranslator
extends AbstractTranslator {
    @NotNull
    public static PatternTranslator newInstance(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "newInstance"));
        }
        PatternTranslator patternTranslator = new PatternTranslator(context);
        if (patternTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "newInstance"));
        }
        return patternTranslator;
    }

    private PatternTranslator(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "<init>"));
        }
        super(context);
    }

    public static boolean isCastExpression(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "isCastExpression"));
        }
        return PatternTranslator.isSafeCast(expression) || PatternTranslator.isUnsafeCast(expression);
    }

    @NotNull
    public JsExpression translateCastExpression(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        JsExpression onFail;
        TemporaryVariable temporary;
        JsExpression isCheck;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateCastExpression"));
        }
        assert (PatternTranslator.isCastExpression(expression)) : "Expected cast expression, got " + expression;
        KtExpression left = expression.getLeft();
        JsExpression expressionToCast = Translation.translateAsExpression(left, this.context());
        KtTypeReference typeReference = expression.getRight();
        assert (typeReference != null) : "Cast expression must have type reference";
        KotlinType leftType = this.context().bindingContext().getType(left);
        if (leftType != null && KotlinBuiltIns.isChar(leftType)) {
            expressionToCast = JsAstUtils.charToBoxedChar(expressionToCast);
        }
        if ((isCheck = this.translateIsCheck((temporary = this.context().declareTemporary(expressionToCast)).assignmentExpression(), typeReference)) == null) {
            JsExpression jsExpression = expressionToCast;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateCastExpression"));
            }
            return jsExpression;
        }
        if (PatternTranslator.isSafeCast(expression)) {
            onFail = JsLiteral.NULL;
        } else {
            JsExpression throwCCEFunRef = Namer.throwClassCastExceptionFunRef();
            onFail = new JsInvocation(throwCCEFunRef, new JsExpression[0]);
        }
        JsExpression result2 = new JsConditional(isCheck, temporary.reference(), onFail);
        KotlinType expressionType = this.context().bindingContext().getType(expression);
        if (expressionType != null && KotlinBuiltIns.isCharOrNullableChar(expressionType)) {
            result2 = JsAstUtils.boxedCharToChar(result2);
        }
        JsConditional jsConditional = result2;
        if (jsConditional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateCastExpression"));
        }
        return jsConditional;
    }

    @NotNull
    public JsExpression translateIsExpression(@NotNull KtIsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsExpression"));
        }
        KtExpression left = expression.getLeftHandSide();
        JsExpression expressionToCheck = Translation.translateAsExpression(left, this.context());
        KotlinType leftType = this.context().bindingContext().getType(left);
        if (leftType != null && KotlinBuiltIns.isChar(leftType)) {
            expressionToCheck = JsAstUtils.charToBoxedChar(expressionToCheck);
        }
        KtTypeReference typeReference = expression.getTypeReference();
        assert (typeReference != null);
        JsExpression result2 = this.translateIsCheck(expressionToCheck, typeReference);
        if (result2 == null) {
            JsLiteral.JsBooleanLiteral jsBooleanLiteral = JsLiteral.getBoolean(!expression.isNegated());
            if (jsBooleanLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsExpression"));
            }
            return jsBooleanLiteral;
        }
        if (expression.isNegated()) {
            JsPrefixOperation jsPrefixOperation = JsAstUtils.not(result2);
            if (jsPrefixOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsExpression"));
            }
            return jsPrefixOperation;
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsExpression"));
        }
        return jsExpression;
    }

    @Nullable
    public JsExpression translateIsCheck(@NotNull JsExpression subject, @NotNull KtTypeReference targetTypeReference) {
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsCheck"));
        }
        if (targetTypeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetTypeReference", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsCheck"));
        }
        KotlinType targetType = BindingUtils.getTypeByReference(this.bindingContext(), targetTypeReference);
        JsExpression checkFunReference = this.doGetIsTypeCheckCallable(targetType);
        if (checkFunReference == null) {
            return null;
        }
        boolean isReifiedType = TypeUtils.isReifiedTypeParameter(targetType);
        if (!isReifiedType && TypeUtils.isNullableType(targetType) || isReifiedType && KtPsiUtil.findChildByType(targetTypeReference, KtNodeTypes.NULLABLE_TYPE) != null) {
            checkFunReference = this.namer().orNull(checkFunReference);
        }
        return new JsInvocation(checkFunReference, subject);
    }

    @NotNull
    public JsExpression getIsTypeCheckCallable(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallable"));
        }
        JsExpression callable = this.doGetIsTypeCheckCallable(type2);
        assert (callable != null) : "This method should be called only to translate reified type parameters. `callable` should never be null for reified type parameters. Actual type: " + type2;
        if (!TypeUtils.isReifiedTypeParameter(type2) && TypeUtils.isNullableType(type2)) {
            JsExpression jsExpression = this.namer().orNull(callable);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallable"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = callable;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallable"));
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression doGetIsTypeCheckCallable(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "doGetIsTypeCheckCallable"));
        }
        ClassifierDescriptor targetDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (targetDescriptor != null && AnnotationsUtils.isNativeInterface(targetDescriptor)) {
            return type2.isMarkedNullable() ? null : this.namer().isInstanceOf(JsAstUtils.pureFqn("Object", null));
        }
        JsExpression builtinCheck = this.getIsTypeCheckCallableForBuiltin(type2);
        if (builtinCheck != null) {
            return builtinCheck;
        }
        builtinCheck = this.getIsTypeCheckCallableForPrimitiveBuiltin(type2);
        if (builtinCheck != null) {
            return builtinCheck;
        }
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2);
        if (typeParameterDescriptor != null) {
            if (typeParameterDescriptor.isReified()) {
                return this.getIsTypeCheckCallableForReifiedType(typeParameterDescriptor);
            }
            JsExpression result2 = null;
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                JsExpression next = this.doGetIsTypeCheckCallable(upperBound);
                if (next == null) continue;
                result2 = result2 != null ? this.namer().andPredicate(result2, next) : next;
            }
            return result2;
        }
        ClassDescriptor referencedClass = DescriptorUtils.getClassDescriptorForType(type2);
        JsExpression typeName = ReferenceTranslator.translateAsTypeReference(referencedClass, this.context());
        return this.namer().isInstanceOf(typeName);
    }

    @Nullable
    private JsExpression getIsTypeCheckCallableForBuiltin(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallableForBuiltin"));
        }
        if (FunctionTypesKt.isFunctionTypeOrSubtype(type2) && !ReflectionTypes.isNumberedKPropertyOrKMutablePropertyType(type2)) {
            return this.namer().isTypeOf(this.program().getStringLiteral("function"));
        }
        if (KotlinBuiltIns.isArray(type2)) {
            return Namer.IS_ARRAY_FUN_REF;
        }
        if (TypePredicatesKt.getCHAR_SEQUENCE().apply(type2)) {
            return this.namer().isCharSequence();
        }
        if (TypePredicatesKt.getCOMPARABLE().apply(type2)) {
            return this.namer().isComparable();
        }
        return null;
    }

    @Nullable
    private JsExpression getIsTypeCheckCallableForPrimitiveBuiltin(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallableForPrimitiveBuiltin"));
        }
        Name typeName = org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.getNameIfStandardType(type2);
        if (NamePredicate.STRING.apply(typeName)) {
            return this.namer().isTypeOf(this.program().getStringLiteral("string"));
        }
        if (NamePredicate.BOOLEAN.apply(typeName)) {
            return this.namer().isTypeOf(this.program().getStringLiteral("boolean"));
        }
        if (NamePredicate.LONG.apply(typeName)) {
            return this.namer().isInstanceOf(Namer.kotlinLong());
        }
        if (NamePredicate.NUMBER.apply(typeName)) {
            return this.namer().kotlin("isNumber");
        }
        if (NamePredicate.CHAR.apply(typeName)) {
            return this.namer().kotlin("isChar");
        }
        if (NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS.apply(typeName)) {
            return this.namer().isTypeOf(this.program().getStringLiteral("number"));
        }
        return null;
    }

    @NotNull
    private JsExpression getIsTypeCheckCallableForReifiedType(@NotNull TypeParameterDescriptor typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallableForReifiedType"));
        }
        assert (typeParameter.isReified()) : "Expected reified type, actual: " + typeParameter;
        DeclarationDescriptor containingDeclaration = typeParameter.getContainingDeclaration();
        assert (containingDeclaration instanceof CallableDescriptor) : "Expected type parameter " + typeParameter + " to be contained in CallableDescriptor, actual: " + containingDeclaration.getClass();
        JsExpression alias = this.context().getAliasForDescriptor(typeParameter);
        assert (alias != null) : "No alias found for reified type parameter: " + typeParameter;
        JsExpression jsExpression = alias;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallableForReifiedType"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression translateExpressionPattern(@NotNull KotlinType type2, @NotNull JsExpression expressionToMatch, @NotNull KtExpression patternExpression) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionPattern"));
        }
        if (expressionToMatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToMatch", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionPattern"));
        }
        if (patternExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternExpression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionPattern"));
        }
        JsExpression expressionToMatchAgainst = this.translateExpressionForExpressionPattern(patternExpression);
        KotlinType patternType = BindingUtils.getTypeForExpression(this.bindingContext(), patternExpression);
        EqualityType matchEquality = PatternTranslator.equalityType(type2);
        EqualityType patternEquality = PatternTranslator.equalityType(patternType);
        if (matchEquality == EqualityType.PRIMITIVE && patternEquality == EqualityType.PRIMITIVE) {
            JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(expressionToMatch, expressionToMatchAgainst);
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionPattern"));
            }
            return jsBinaryOperation;
        }
        if (expressionToMatchAgainst == JsLiteral.NULL) {
            JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(expressionToMatch, false);
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionPattern"));
            }
            return jsBinaryOperation;
        }
        JsExpression jsExpression = TopLevelFIF.KOTLIN_EQUALS.apply(expressionToMatch, Collections.singletonList(expressionToMatchAgainst), this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionPattern"));
        }
        return jsExpression;
    }

    @NotNull
    private static EqualityType equalityType(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "equalityType"));
        }
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (!(descriptor2 instanceof ClassDescriptor)) {
            EqualityType equalityType = EqualityType.GENERAL;
            if (equalityType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "equalityType"));
            }
            return equalityType;
        }
        PrimitiveType primitive = KotlinBuiltIns.getPrimitiveTypeByFqName(DescriptorUtilsKt.getFqNameUnsafe(descriptor2));
        if (primitive == null) {
            EqualityType equalityType = EqualityType.GENERAL;
            if (equalityType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "equalityType"));
            }
            return equalityType;
        }
        EqualityType equalityType = primitive == PrimitiveType.LONG ? EqualityType.LONG : EqualityType.PRIMITIVE;
        if (equalityType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "equalityType"));
        }
        return equalityType;
    }

    @NotNull
    public JsExpression translateExpressionForExpressionPattern(@NotNull KtExpression patternExpression) {
        if (patternExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternExpression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionForExpressionPattern"));
        }
        JsExpression jsExpression = Translation.translateAsExpression(patternExpression, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionForExpressionPattern"));
        }
        return jsExpression;
    }

    private static boolean isSafeCast(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "isSafeCast"));
        }
        return expression.getOperationReference().getReferencedNameElementType() == KtTokens.AS_SAFE;
    }

    private static boolean isUnsafeCast(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "isUnsafeCast"));
        }
        return expression.getOperationReference().getReferencedNameElementType() == KtTokens.AS_KEYWORD;
    }

    private static enum EqualityType {
        PRIMITIVE,
        LONG,
        GENERAL;

    }
}

