/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.interlis.tools.ModelElementUtility;
import ch.ehi.interlis.views.ViewableDef;
import ch.ehi.uml1_4.foundation.core.Dependency;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.implementation.UmlUsage;
import ch.ehi.umleditor.application.ElementFactory;
import ch.ehi.umleditor.application.ElementUtils;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.application.ModelElementComparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class ReferencableComboBox
extends JComboBox {
    private ModelElement client = null;
    private TreeSet referencables = null;
    private String initialItem = null;
    private Dependency initialDependency = null;

    public ReferencableComboBox() {
    }

    public ReferencableComboBox(Object[] items) {
        super(items);
    }

    public ReferencableComboBox(Vector items) {
        super(items);
    }

    public ReferencableComboBox(ComboBoxModel aModel) {
        super(aModel);
    }

    protected ModelElement getElement() {
        if (this.getSelectedIndex() > 0) {
            Iterator iterator = this.referencables.iterator();
            String name = (String)this.getSelectedItem();
            while (iterator.hasNext()) {
                ModelElement modelElement = (ModelElement)iterator.next();
                if (!ElementUtils.formatWithPackageName(modelElement).equals(name)) continue;
                return modelElement;
            }
        }
        return null;
    }

    private ModelElement getSupplier(Class dependencyClass, ModelElement client) {
        this.client = client;
        Iterator iterator = client.iteratorClientDependency();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (!element.getClass().equals(dependencyClass)) continue;
            this.initialDependency = (Dependency)element;
            return (ModelElement)this.initialDependency.iteratorSupplier().next();
        }
        return null;
    }

    protected boolean hasElementChanged() {
        if (this.getSelectedItem() == null) {
            return this.initialItem != null;
        }
        return !this.getSelectedItem().equals(this.initialItem);
    }

    protected void save0or1Dependency(Class dependencyClass) {
        if (this.hasElementChanged()) {
            if (this.initialDependency != null) {
                this.client.removeClientDependency(this.initialDependency);
                this.initialDependency = null;
            }
            if (this.getElement() != null) {
                try {
                    ModelElement supplier = this.getElement();
                    this.initialDependency = ElementFactory.createDependency(dependencyClass, this.client, supplier);
                }
                catch (Throwable e) {
                    LauncherView.getInstance().handleException(e);
                }
            }
        }
    }

    protected void set0or1Dependency(Class dependencyClass, ModelElement client) {
        this.setElement(ViewableDef.class, client, this.getSupplier(dependencyClass, client));
    }

    private boolean setDisplayList(Set set, ModelElement modelElement, ModelElement currentModelElement) {
        this.referencables = new TreeSet(new ModelElementComparator());
        for (Object object : set) {
            if (modelElement.equals(object)) continue;
            this.referencables.add(object);
        }
        if (currentModelElement != null && !this.referencables.contains(currentModelElement)) {
            this.referencables.add(currentModelElement);
        }
        Vector<String> names = new Vector<String>();
        names.add(new String());
        for (ModelElement refModelElement : this.referencables) {
            names.add(ElementUtils.formatWithPackageName(refModelElement));
        }
        this.setModel(new DefaultComboBoxModel(names));
        if (currentModelElement != null) {
            this.initialItem = ElementUtils.formatWithPackageName(currentModelElement);
            this.setSelectedItem(this.initialItem);
        }
        return names.size() > 0;
    }

    protected void setElement(Class referenceClass, ModelElement modelElement, ModelElement currentModelElement) {
        this.setDisplayList(ModelElementUtility.getReferencableElements(modelElement, referenceClass), modelElement, currentModelElement);
    }

    protected void setElement(Set referencableElements, ModelElement modelElement, ModelElement currentModelElement) {
        this.setDisplayList(referencableElements, modelElement, currentModelElement);
    }

    @Override
    public void setSelectedIndex(int anIndex) {
        if (anIndex == 0 && this.getItemCount() == 0) {
            super.setSelectedIndex(-1);
        } else {
            super.setSelectedIndex(anIndex);
        }
    }

    protected boolean setUsage(ModelElement modelElement) {
        Set ownedElements = ModelElementUtility.getPeerElements(modelElement, null);
        return this.setDisplayList(ownedElements, modelElement, this.getSupplier(UmlUsage.class, modelElement));
    }
}

