/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.EUC_TW;

public class ByteToCharEUC_TW
extends ByteToCharConverter {
    private final byte G0 = 0;
    private final byte G1 = 1;
    private final byte G2 = (byte)2;
    private final byte G3 = (byte)3;
    private final byte G4 = (byte)4;
    private final byte MSB = (byte)-128;
    private final byte SS2 = (byte)-114;
    private byte firstByte = 0;
    private byte state = 0;
    private int cnsPlane = 0;
    private EUC_TW.Decoder dec = (EUC_TW.Decoder)new EUC_TW().newDecoder();

    public int flush(char[] output, int outStart, int outEnd) throws MalformedInputException {
        if (this.state != 0) {
            this.state = 0;
            this.firstByte = 0;
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.reset();
        return 0;
    }

    public void reset() {
        this.dec.reset();
        this.state = 0;
        this.firstByte = 0;
        this.charOff = 0;
        this.byteOff = 0;
    }

    public int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int inputSize = 0;
        char[] c1 = new char[1];
        this.byteOff = inOff;
        this.charOff = outOff;
        this.cnsPlane = 3;
        while (this.byteOff < inEnd) {
            if (this.charOff >= outEnd) {
                throw new ConversionBufferFullException();
            }
            char[] outputChar = null;
            switch (this.state) {
                case 0: {
                    if ((input[this.byteOff] & 0xFFFFFF80) == 0) {
                        outputChar = c1;
                        outputChar[0] = (char)input[this.byteOff];
                        break;
                    }
                    if (input[this.byteOff] == -114) {
                        this.state = (byte)2;
                        break;
                    }
                    this.firstByte = input[this.byteOff];
                    this.state = 1;
                    break;
                }
                case 1: {
                    inputSize = 2;
                    if ((input[this.byteOff] & 0xFFFFFF80) == 0) {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                    this.cnsPlane = 0;
                    outputChar = this.dec.toUnicode(this.firstByte & 0xFF, input[this.byteOff] & 0xFF, this.cnsPlane);
                    this.firstByte = 0;
                    this.state = 0;
                    break;
                }
                case 2: {
                    this.cnsPlane = input[this.byteOff] & 0xF;
                    int n = this.cnsPlane = this.cnsPlane == 15 ? 8 : this.cnsPlane;
                    if (this.cnsPlane < 15) {
                        this.state = (byte)3;
                        break;
                    }
                    this.badInputLength = 2;
                    throw new MalformedInputException();
                }
                case 3: {
                    if ((input[this.byteOff] & 0xFFFFFF80) != 0) {
                        this.firstByte = input[this.byteOff];
                        this.state = (byte)4;
                        break;
                    }
                    this.state = 0;
                    this.badInputLength = 2;
                    throw new MalformedInputException();
                }
                case 4: {
                    if ((input[this.byteOff] & 0xFFFFFF80) == 0) {
                        this.badInputLength = 3;
                        throw new MalformedInputException();
                    }
                    outputChar = this.dec.toUnicode(this.firstByte & 0xFF, input[this.byteOff] & 0xFF, this.cnsPlane - 1);
                    this.firstByte = 0;
                    this.state = 0;
                }
            }
            ++this.byteOff;
            if (this.state != 0) continue;
            if (outputChar == null) {
                if (this.subMode) {
                    outputChar = c1;
                    outputChar[0] = this.subChars[0];
                } else {
                    this.badInputLength = inputSize;
                    throw new UnknownCharacterException();
                }
            }
            output[this.charOff++] = outputChar[0];
        }
        return this.charOff - outOff;
    }

    public String getCharacterEncoding() {
        return "EUC_TW";
    }
}

