/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XOMCharSetList
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 8;
    }

    @Override
    public int getDataSize() {
        return XOMCharSetList.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XOMCharSetList(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XOMCharSetList() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XOMCharSetList.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_charset_count() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_charset_count(int v) {
        log.finest("");
        Native.putInt(this.pData + 0L, v);
    }

    public long get_charset_list(int index) {
        log.finest("");
        return Native.getLong(this.pData + 4L) + (long)(index * Native.getLongSize());
    }

    public long get_charset_list() {
        log.finest("");
        return Native.getLong(this.pData + 4L);
    }

    public void set_charset_list(long v) {
        log.finest("");
        Native.putLong(this.pData + 4L, v);
    }

    @Override
    String getName() {
        return "XOMCharSetList";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(80);
        ret.append("charset_count = ").append(this.get_charset_count()).append(", ");
        ret.append("charset_list = ").append(this.get_charset_list()).append(", ");
        return ret.toString();
    }
}

