/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.ManagementPermission;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class Util {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static ManagementPermission monitorPermission = new ManagementPermission("monitor");
    private static ManagementPermission controlPermission = new ManagementPermission("control");

    private Util() {
    }

    static RuntimeException newException(Exception e) {
        throw new RuntimeException(e);
    }

    static String[] toStringArray(List<String> list) {
        return list.toArray(EMPTY_STRING_ARRAY);
    }

    public static ObjectName newObjectName(String domainAndType, String name) {
        return Util.newObjectName(domainAndType + ",name=" + name);
    }

    public static ObjectName newObjectName(String name) {
        try {
            return ObjectName.getInstance(name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static void checkAccess(ManagementPermission p) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(p);
        }
    }

    static void checkMonitorAccess() throws SecurityException {
        Util.checkAccess(monitorPermission);
    }

    static void checkControlAccess() throws SecurityException {
        Util.checkAccess(controlPermission);
    }
}

