/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.List;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.modules.profiler.heapwalk.memorylint.FieldAccess;

public class StringHelper {
    private FieldAccess fldCount;
    private FieldAccess fldOffset;
    private FieldAccess fldValue;
    private Heap heap;
    private JavaClass clsString;

    StringHelper(Heap heap) {
        this.heap = heap;
        this.clsString = heap.getJavaClassByName("java.lang.String");
        this.fldOffset = new FieldAccess(this.clsString, "offset");
        this.fldCount = new FieldAccess(this.clsString, "count");
        this.fldValue = new FieldAccess(this.clsString, "value");
    }

    public String decodeString(Instance instance) {
        if (instance == null) {
            return "null";
        }
        if (!"java.lang.String".equals(instance.getJavaClass().getName())) {
            return "<<" + instance.getJavaClass().getName() + ">>";
        }
        int n = this.fldOffset.getIntValue(instance);
        int n2 = this.fldCount.getIntValue(instance);
        PrimitiveArrayInstance primitiveArrayInstance = (PrimitiveArrayInstance)this.fldValue.getRefValue(instance);
        if (primitiveArrayInstance == null) {
            return "";
        }
        char[] cArray = this.getCharArray(primitiveArrayInstance);
        return new String(cArray, n, n2);
    }

    private char[] getCharArray(PrimitiveArrayInstance primitiveArrayInstance) {
        List list = primitiveArrayInstance.getValues();
        char[] cArray = new char[primitiveArrayInstance.getLength()];
        assert (cArray.length == list.size());
        int n = 0;
        for (String string : list) {
            cArray[n++] = string.charAt(0);
        }
        return cArray;
    }
}

