/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.BeanProperty;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaConstructor;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class JavaMembers {
    private Class<?> cl;
    private Map<String, Object> members;
    private Map<String, FieldAndMethods> fieldAndMethods;
    private Map<String, Object> staticMembers;
    private Map<String, FieldAndMethods> staticFieldAndMethods;
    NativeJavaMethod ctors;

    JavaMembers(Scriptable scriptable, Class<?> clazz) {
        this(scriptable, clazz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaMembers(Scriptable scriptable, Class<?> clazz, boolean bl) {
        try {
            Context context = ContextFactory.getGlobal().enterContext();
            ClassShutter classShutter = context.getClassShutter();
            if (classShutter != null && !classShutter.visibleToScripts(clazz.getName())) {
                throw Context.reportRuntimeError1("msg.access.prohibited", clazz.getName());
            }
            this.members = new HashMap<String, Object>();
            this.staticMembers = new HashMap<String, Object>();
            this.cl = clazz;
            boolean bl2 = context.hasFeature(13);
            this.reflect(scriptable, bl, bl2);
        }
        finally {
            Context.exit();
        }
    }

    boolean has(String string, boolean bl) {
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        Object object = map.get(string);
        if (object != null) {
            return true;
        }
        return this.findExplicitFunction(string, bl) != null;
    }

    Object get(Scriptable scriptable, String string, Object object, boolean bl) {
        Class<?> clazz;
        Object object2;
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        Object object3 = map.get(string);
        if (!bl && object3 == null) {
            object3 = this.staticMembers.get(string);
        }
        if (object3 == null && (object3 = this.getExplicitFunction(scriptable, string, object, bl)) == null) {
            return Scriptable.NOT_FOUND;
        }
        if (object3 instanceof Scriptable) {
            return object3;
        }
        Context context = Context.getContext();
        try {
            if (object3 instanceof BeanProperty) {
                BeanProperty beanProperty = (BeanProperty)object3;
                if (beanProperty.getter == null) {
                    return Scriptable.NOT_FOUND;
                }
                object2 = beanProperty.getter.invoke(object, Context.emptyArgs);
                clazz = beanProperty.getter.method().getReturnType();
            } else {
                Field field = (Field)object3;
                object2 = field.get(bl ? null : object);
                clazz = field.getType();
            }
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        return context.getWrapFactory().wrap(context, scriptable, object2, clazz);
    }

    void put(Scriptable scriptable, String string, Object object, Object object2, boolean bl) {
        Object object3;
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        Object object4 = map.get(string);
        if (!bl && object4 == null) {
            object4 = this.staticMembers.get(string);
        }
        if (object4 == null) {
            throw this.reportMemberNotFound(string);
        }
        if (object4 instanceof FieldAndMethods) {
            object3 = (FieldAndMethods)map.get(string);
            object4 = ((FieldAndMethods)object3).field;
        }
        if (object4 instanceof BeanProperty) {
            object3 = (BeanProperty)object4;
            if (((BeanProperty)object3).setter == null) {
                throw this.reportMemberNotFound(string);
            }
            if (((BeanProperty)object3).setters == null || object2 == null) {
                Class<?> clazz = ((BeanProperty)object3).setter.argTypes[0];
                Object[] objectArray = new Object[]{Context.jsToJava(object2, clazz)};
                try {
                    ((BeanProperty)object3).setter.invoke(object, objectArray);
                }
                catch (Exception exception) {
                    throw Context.throwAsScriptRuntimeEx(exception);
                }
            } else {
                Object[] objectArray = new Object[]{object2};
                ((BeanProperty)object3).setters.call(Context.getContext(), ScriptableObject.getTopLevelScope(scriptable), scriptable, objectArray);
            }
        } else {
            if (!(object4 instanceof Field)) {
                object3 = object4 == null ? "msg.java.internal.private" : "msg.java.method.assign";
                throw Context.reportRuntimeError1((String)object3, string);
            }
            object3 = (Field)object4;
            Object object5 = Context.jsToJava(object2, ((Field)object3).getType());
            try {
                ((Field)object3).set(object, object5);
            }
            catch (IllegalAccessException illegalAccessException) {
                if ((((Field)object3).getModifiers() & 0x10) != 0) {
                    return;
                }
                throw Context.throwAsScriptRuntimeEx(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Context.reportRuntimeError3("msg.java.internal.field.type", object2.getClass().getName(), object3, object.getClass().getName());
            }
        }
    }

    Object[] getIds(boolean bl) {
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        return map.keySet().toArray(new Object[map.size()]);
    }

    static String javaSignature(Class<?> clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        int n = 0;
        do {
            ++n;
        } while ((clazz = clazz.getComponentType()).isArray());
        String string = clazz.getName();
        String string2 = "[]";
        if (n == 1) {
            return string.concat(string2);
        }
        int n2 = string.length() + n * string2.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(string);
        while (n != 0) {
            --n;
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    static String liveConnectSignature(Class<?>[] classArray) {
        int n = classArray.length;
        if (n == 0) {
            return "()";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i != n; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(JavaMembers.javaSignature(classArray[i]));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private MemberBox findExplicitFunction(String string, boolean bl) {
        boolean bl2;
        int n = string.indexOf(40);
        if (n < 0) {
            return null;
        }
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        MemberBox[] memberBoxArray = null;
        boolean bl3 = bl2 = bl && n == 0;
        if (bl2) {
            memberBoxArray = this.ctors.methods;
        } else {
            MemberBox[] memberBoxArray2 = string.substring(0, n);
            Object object = map.get(memberBoxArray2);
            if (!bl && object == null) {
                object = this.staticMembers.get(memberBoxArray2);
            }
            if (object instanceof NativeJavaMethod) {
                NativeJavaMethod nativeJavaMethod = (NativeJavaMethod)object;
                memberBoxArray = nativeJavaMethod.methods;
            }
        }
        if (memberBoxArray != null) {
            for (MemberBox memberBox : memberBoxArray) {
                Class<?>[] classArray = memberBox.argTypes;
                String string2 = JavaMembers.liveConnectSignature(classArray);
                if (n + string2.length() != string.length() || !string.regionMatches(n, string2, 0, string2.length())) continue;
                return memberBox;
            }
        }
        return null;
    }

    private Object getExplicitFunction(Scriptable scriptable, String string, Object object, boolean bl) {
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        Object object2 = null;
        MemberBox memberBox = this.findExplicitFunction(string, bl);
        if (memberBox != null) {
            Scriptable scriptable2 = ScriptableObject.getFunctionPrototype(scriptable);
            if (memberBox.isCtor()) {
                NativeJavaConstructor nativeJavaConstructor = new NativeJavaConstructor(memberBox);
                nativeJavaConstructor.setPrototype(scriptable2);
                object2 = nativeJavaConstructor;
                map.put(string, nativeJavaConstructor);
            } else {
                String string2 = memberBox.getName();
                object2 = map.get(string2);
                if (object2 instanceof NativeJavaMethod && ((NativeJavaMethod)object2).methods.length > 1) {
                    NativeJavaMethod nativeJavaMethod = new NativeJavaMethod(memberBox, string);
                    nativeJavaMethod.setPrototype(scriptable2);
                    map.put(string, nativeJavaMethod);
                    object2 = nativeJavaMethod;
                }
            }
        }
        return object2;
    }

    private static Method[] discoverAccessibleMethods(Class<?> clazz, boolean bl, boolean bl2) {
        HashMap<MethodSignature, Method> hashMap = new HashMap<MethodSignature, Method>();
        JavaMembers.discoverAccessibleMethods(clazz, hashMap, bl, bl2);
        return hashMap.values().toArray(new Method[hashMap.size()]);
    }

    private static void discoverAccessibleMethods(Class<?> clazz, Map<MethodSignature, Method> map, boolean bl, boolean bl2) {
        Class<?>[] classArray;
        if (Modifier.isPublic(clazz.getModifiers()) || bl2) {
            try {
                if (bl || bl2) {
                    while (clazz != null) {
                        MethodSignature methodSignature;
                        try {
                            Method[] methodArray2;
                            for (Method method : methodArray2 = clazz.getDeclaredMethods()) {
                                int methodSignature2 = method.getModifiers();
                                if (!Modifier.isPublic(methodSignature2) && !Modifier.isProtected(methodSignature2) && !bl2 || map.containsKey(methodSignature = new MethodSignature(method))) continue;
                                if (bl2 && !method.isAccessible()) {
                                    method.setAccessible(true);
                                }
                                map.put(methodSignature, method);
                            }
                            clazz = clazz.getSuperclass();
                        }
                        catch (SecurityException securityException) {
                            Method[] methodArray;
                            for (Method method : methodArray = clazz.getMethods()) {
                                methodSignature = new MethodSignature(method);
                                if (map.containsKey(methodSignature)) continue;
                                map.put(methodSignature, method);
                            }
                            break;
                        }
                    }
                } else {
                    Method[] methodArray;
                    for (Method method : methodArray = clazz.getMethods()) {
                        MethodSignature methodSignature = new MethodSignature(method);
                        if (map.containsKey(methodSignature)) continue;
                        map.put(methodSignature, method);
                    }
                }
                return;
            }
            catch (SecurityException securityException) {
                Context.reportWarning("Could not discover accessible methods of class " + clazz.getName() + " due to lack of privileges, attemping superclasses/interfaces.");
            }
        }
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            JavaMembers.discoverAccessibleMethods(clazz2, map, bl, bl2);
        }
        Class<?> clazz3 = clazz.getSuperclass();
        if (clazz3 != null) {
            JavaMembers.discoverAccessibleMethods(clazz3, map, bl, bl2);
        }
    }

    private void reflect(Scriptable scriptable, boolean bl, boolean bl2) {
        Object object;
        Field[] fieldArray;
        Object object2;
        Map<String, Object> map;
        Object v;
        Method[] methodArray;
        for (Method method : methodArray = JavaMembers.discoverAccessibleMethods(this.cl, bl, bl2)) {
            ObjArray bl7;
            int n = method.getModifiers();
            boolean bl3 = Modifier.isStatic(n);
            Map<String, Object> map22 = bl3 ? this.staticMembers : this.members;
            map = map22.get(v = method.getName());
            if (map == null) {
                map22.put((String)v, method);
                continue;
            }
            if (map instanceof ObjArray) {
                bl7 = (ObjArray)((Object)map);
            } else {
                if (!(map instanceof Method)) {
                    Kit.codeBug();
                }
                bl7 = new ObjArray();
                bl7.add(map);
                map22.put((String)v, bl7);
            }
            bl7.add(method);
        }
        for (int i = 0; i != 2; ++i) {
            int n = i == 0 ? 1 : 0;
            Map<String, Object> map3 = n != 0 ? this.staticMembers : this.members;
            for (Map.Entry entry : map3.entrySet()) {
                MemberBox[] memberBoxArray;
                Object v2 = entry.getValue();
                if (v2 instanceof Method) {
                    memberBoxArray = new MemberBox[]{new MemberBox((Method)v2)};
                } else {
                    v = (ObjArray)v2;
                    int n2 = ((ObjArray)v).size();
                    if (n2 < 2) {
                        Kit.codeBug();
                    }
                    memberBoxArray = new MemberBox[n2];
                    for (int j = 0; j != n2; ++j) {
                        object2 = (Method)((ObjArray)v).get(j);
                        memberBoxArray[j] = new MemberBox((Method)object2);
                    }
                }
                v = new NativeJavaMethod(memberBoxArray);
                if (scriptable != null) {
                    ScriptRuntime.setFunctionProtoAndParent((BaseFunction)v, scriptable);
                }
                map3.put((String)entry.getKey(), v);
            }
        }
        for (Field field : fieldArray = this.getAccessibleFields(bl, bl2)) {
            String string = field.getName();
            int n = field.getModifiers();
            try {
                boolean bl3 = Modifier.isStatic(n);
                map = bl3 ? this.staticMembers : this.members;
                Object object3 = map.get(string);
                if (object3 == null) {
                    map.put(string, field);
                    continue;
                }
                if (object3 instanceof NativeJavaMethod) {
                    Map<String, FieldAndMethods> map2;
                    object2 = (NativeJavaMethod)object3;
                    object = new FieldAndMethods(scriptable, ((NativeJavaMethod)object2).methods, field);
                    Map<String, FieldAndMethods> map3 = map2 = bl3 ? this.staticFieldAndMethods : this.fieldAndMethods;
                    if (map2 == null) {
                        map2 = new HashMap<String, FieldAndMethods>();
                        if (bl3) {
                            this.staticFieldAndMethods = map2;
                        } else {
                            this.fieldAndMethods = map2;
                        }
                    }
                    map2.put(string, (FieldAndMethods)object);
                    map.put(string, object);
                    continue;
                }
                if (object3 instanceof Field) {
                    object2 = (Field)object3;
                    if (!((Field)object2).getDeclaringClass().isAssignableFrom(field.getDeclaringClass())) continue;
                    map.put(string, field);
                    continue;
                }
                Kit.codeBug();
            }
            catch (SecurityException securityException) {
                Context.reportWarning("Could not access field " + string + " of class " + this.cl.getName() + " due to lack of privileges.");
            }
        }
        for (int i = 0; i != 2; ++i) {
            int n = i == 0 ? 1 : 0;
            Map<String, Object> map6 = n != 0 ? this.staticMembers : this.members;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (String string : map6.keySet()) {
                Object object4;
                Object object5;
                boolean bl4 = string.startsWith("get");
                boolean bl5 = string.startsWith("set");
                boolean bl6 = string.startsWith("is");
                if (!bl4 && !bl6 && !bl5 || ((String)(object2 = string.substring(bl6 ? 2 : 3))).length() == 0) continue;
                object = object2;
                char c = ((String)object2).charAt(0);
                if (Character.isUpperCase(c)) {
                    if (((String)object2).length() == 1) {
                        object = ((String)object2).toLowerCase();
                    } else {
                        char c2 = ((String)object2).charAt(1);
                        if (!Character.isUpperCase(c2)) {
                            object = Character.toLowerCase(c) + ((String)object2).substring(1);
                        }
                    }
                }
                if (hashMap.containsKey(object) || (object5 = map6.get(object)) != null && (!bl2 || !(object5 instanceof Member) || !Modifier.isPrivate(((Member)object5).getModifiers()))) continue;
                MemberBox memberBox = null;
                memberBox = this.findGetter(n != 0, map6, "get", (String)object2);
                if (memberBox == null) {
                    memberBox = this.findGetter(n != 0, map6, "is", (String)object2);
                }
                MemberBox memberBox2 = null;
                NativeJavaMethod nativeJavaMethod = null;
                String string2 = "set".concat((String)object2);
                if (map6.containsKey(string2) && (object4 = map6.get(string2)) instanceof NativeJavaMethod) {
                    NativeJavaMethod nativeJavaMethod2 = (NativeJavaMethod)object4;
                    if (memberBox != null) {
                        Class<?> clazz = memberBox.method().getReturnType();
                        memberBox2 = JavaMembers.extractSetMethod(clazz, nativeJavaMethod2.methods, n != 0);
                    } else {
                        memberBox2 = JavaMembers.extractSetMethod(nativeJavaMethod2.methods, n != 0);
                    }
                    if (nativeJavaMethod2.methods.length > 1) {
                        nativeJavaMethod = nativeJavaMethod2;
                    }
                }
                object4 = new BeanProperty(memberBox, memberBox2, nativeJavaMethod);
                hashMap.put(object, object4);
            }
            for (String string : hashMap.keySet()) {
                Object v3 = hashMap.get(string);
                map6.put(string, v3);
            }
        }
        Constructor<?>[] constructorArray = this.getAccessibleConstructors(bl2);
        MemberBox[] memberBoxArray = new MemberBox[constructorArray.length];
        for (int i = 0; i != constructorArray.length; ++i) {
            memberBoxArray[i] = new MemberBox(constructorArray[i]);
        }
        this.ctors = new NativeJavaMethod(memberBoxArray, this.cl.getSimpleName());
    }

    private Constructor<?>[] getAccessibleConstructors(boolean bl) {
        if (bl && this.cl != ScriptRuntime.ClassClass) {
            try {
                AccessibleObject[] accessibleObjectArray = this.cl.getDeclaredConstructors();
                AccessibleObject.setAccessible(accessibleObjectArray, true);
                return accessibleObjectArray;
            }
            catch (SecurityException securityException) {
                Context.reportWarning("Could not access constructor  of class " + this.cl.getName() + " due to lack of privileges.");
            }
        }
        return this.cl.getConstructors();
    }

    private Field[] getAccessibleFields(boolean bl, boolean bl2) {
        if (bl2 || bl) {
            try {
                ArrayList<Field> arrayList = new ArrayList<Field>();
                for (Class<?> clazz = this.cl; clazz != null; clazz = clazz.getSuperclass()) {
                    Field[] fieldArray;
                    for (Field field : fieldArray = clazz.getDeclaredFields()) {
                        int n = field.getModifiers();
                        if (!bl2 && !Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        arrayList.add(field);
                    }
                }
                return arrayList.toArray(new Field[arrayList.size()]);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return this.cl.getFields();
    }

    private MemberBox findGetter(boolean bl, Map<String, Object> map, String string, String string2) {
        Object object;
        String string3 = string.concat(string2);
        if (map.containsKey(string3) && (object = map.get(string3)) instanceof NativeJavaMethod) {
            NativeJavaMethod nativeJavaMethod = (NativeJavaMethod)object;
            return JavaMembers.extractGetMethod(nativeJavaMethod.methods, bl);
        }
        return null;
    }

    private static MemberBox extractGetMethod(MemberBox[] memberBoxArray, boolean bl) {
        for (MemberBox memberBox : memberBoxArray) {
            if (memberBox.argTypes.length != 0 || bl && !memberBox.isStatic()) continue;
            Class<?> clazz = memberBox.method().getReturnType();
            if (clazz == Void.TYPE) break;
            return memberBox;
        }
        return null;
    }

    private static MemberBox extractSetMethod(Class<?> clazz, MemberBox[] memberBoxArray, boolean bl) {
        for (int i = 1; i <= 2; ++i) {
            for (MemberBox memberBox : memberBoxArray) {
                Class<?>[] classArray;
                if (bl && !memberBox.isStatic() || (classArray = memberBox.argTypes).length != 1) continue;
                if (i == 1) {
                    if (classArray[0] != clazz) continue;
                    return memberBox;
                }
                if (i != 2) {
                    Kit.codeBug();
                }
                if (!classArray[0].isAssignableFrom(clazz)) continue;
                return memberBox;
            }
        }
        return null;
    }

    private static MemberBox extractSetMethod(MemberBox[] memberBoxArray, boolean bl) {
        for (MemberBox memberBox : memberBoxArray) {
            if (bl && !memberBox.isStatic() || memberBox.method().getReturnType() != Void.TYPE || memberBox.argTypes.length != 1) continue;
            return memberBox;
        }
        return null;
    }

    Map<String, FieldAndMethods> getFieldAndMethodsObjects(Scriptable scriptable, Object object, boolean bl) {
        Map<String, FieldAndMethods> map;
        Map<String, FieldAndMethods> map2 = map = bl ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (map == null) {
            return null;
        }
        int n = map.size();
        HashMap<String, FieldAndMethods> hashMap = new HashMap<String, FieldAndMethods>(n);
        for (FieldAndMethods fieldAndMethods : map.values()) {
            FieldAndMethods fieldAndMethods2 = new FieldAndMethods(scriptable, fieldAndMethods.methods, fieldAndMethods.field);
            fieldAndMethods2.javaObject = object;
            hashMap.put(fieldAndMethods.field.getName(), fieldAndMethods2);
        }
        return hashMap;
    }

    static JavaMembers lookupClass(Scriptable scriptable, Class<?> clazz, Class<?> clazz2, boolean bl) {
        JavaMembers javaMembers;
        ClassCache classCache = ClassCache.get(scriptable);
        Map<Class<?>, JavaMembers> map = classCache.getClassCacheMap();
        Class<?> clazz3 = clazz;
        while (true) {
            if ((javaMembers = map.get(clazz3)) != null) {
                if (clazz3 != clazz) {
                    map.put(clazz, javaMembers);
                }
                return javaMembers;
            }
            try {
                javaMembers = new JavaMembers(classCache.getAssociatedScope(), clazz3, bl);
            }
            catch (SecurityException securityException) {
                if (clazz2 != null && clazz2.isInterface()) {
                    clazz3 = clazz2;
                    clazz2 = null;
                    continue;
                }
                Class<?> clazz4 = clazz3.getSuperclass();
                if (clazz4 == null) {
                    if (clazz3.isInterface()) {
                        clazz4 = ScriptRuntime.ObjectClass;
                    } else {
                        throw securityException;
                    }
                }
                clazz3 = clazz4;
                continue;
            }
            break;
        }
        if (classCache.isCachingEnabled()) {
            map.put(clazz3, javaMembers);
            if (clazz3 != clazz) {
                map.put(clazz, javaMembers);
            }
        }
        return javaMembers;
    }

    RuntimeException reportMemberNotFound(String string) {
        return Context.reportRuntimeError2("msg.java.member.not.found", this.cl.getName(), string);
    }

    private static final class MethodSignature {
        private final String name;
        private final Class<?>[] args;

        private MethodSignature(String string, Class<?>[] classArray) {
            this.name = string;
            this.args = classArray;
        }

        MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object object) {
            if (object instanceof MethodSignature) {
                MethodSignature methodSignature = (MethodSignature)object;
                return methodSignature.name.equals(this.name) && Arrays.equals(this.args, methodSignature.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }
}

