/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.java.ArrayReadNode;
import com.oracle.truffle.api.interop.java.ArrayReadNodeGen;
import com.oracle.truffle.api.interop.java.ArrayWriteNode;
import com.oracle.truffle.api.interop.java.ArrayWriteNodeGen;
import com.oracle.truffle.api.interop.java.JavaFunctionMessageResolution;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.interop.java.ToJavaNodeGen;
import com.oracle.truffle.api.interop.java.TypeAndClass;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;

class JavaObjectMessageResolution {
    JavaObjectMessageResolution() {
    }

    static abstract class PropertiesNode
    extends Node {
        PropertiesNode() {
        }

        @CompilerDirectives.TruffleBoundary
        public Object access(JavaObject receiver) {
            String[] fields;
            if (receiver.obj instanceof Map) {
                Map map = (Map)receiver.obj;
                fields = new String[map.size()];
                int i = 0;
                for (Object key : map.keySet()) {
                    fields[i++] = Objects.toString(key, null);
                }
            } else {
                fields = TruffleOptions.AOT ? new String[]{} : JavaInteropReflect.findPublicFieldsNames(receiver.clazz);
            }
            return JavaInterop.asTruffleObject(fields);
        }
    }

    static abstract class WriteFieldNode
    extends Node {
        @Node.Child
        private ToJavaNode toJava = ToJavaNodeGen.create();
        @Node.Child
        private ArrayWriteNode write = ArrayWriteNodeGen.create();

        WriteFieldNode() {
        }

        public Object access(VirtualFrame frame, JavaObject receiver, String name, Object value) {
            Object obj = receiver.obj;
            if (obj instanceof Map) {
                Map map = (Map)obj;
                Object convertedValue = this.toJava.execute(frame, value, TypeAndClass.ANY);
                return map.put(name, convertedValue);
            }
            if (TruffleOptions.AOT) {
                throw UnsupportedMessageException.raise(Message.WRITE);
            }
            Field f = JavaInteropReflect.findField(receiver, name);
            Object convertedValue = this.toJava.execute(frame, value, new TypeAndClass(f.getGenericType(), f.getType()));
            JavaInteropReflect.setField(obj, f, convertedValue);
            return JavaObject.NULL;
        }

        public Object access(VirtualFrame frame, JavaObject receiver, Number index, Object value) {
            return this.write.executeWithTarget(frame, receiver, index, value);
        }
    }

    static abstract class ReadFieldNode
    extends Node {
        @Node.Child
        private ArrayReadNode read = ArrayReadNodeGen.create();

        ReadFieldNode() {
        }

        public Object access(VirtualFrame frame, JavaObject object, Number index) {
            return this.read.executeWithTarget(frame, object, index);
        }

        @CompilerDirectives.TruffleBoundary
        public Object access(JavaObject object, String name) {
            try {
                if (object.obj instanceof Map) {
                    Map map = (Map)object.obj;
                    return JavaInterop.asTruffleValue(map.get(name));
                }
                if (TruffleOptions.AOT) {
                    return JavaObject.NULL;
                }
                return JavaInteropReflect.readField(object, name);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static abstract class UnboxNode
    extends Node {
        UnboxNode() {
        }

        public Object access(JavaObject object) {
            return ToJavaNode.toPrimitive(object.obj, null);
        }
    }

    static abstract class BoxedCheckNode
    extends Node {
        BoxedCheckNode() {
        }

        public Object access(JavaObject object) {
            return ToJavaNode.isPrimitive(object.obj);
        }
    }

    static abstract class NullCheckNode
    extends Node {
        NullCheckNode() {
        }

        public Object access(JavaObject object) {
            return object == JavaObject.NULL;
        }
    }

    static abstract class NewNode
    extends Node {
        NewNode() {
        }

        public Object access(JavaObject object, Object[] args) {
            return NewNode.execute(object, args);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object execute(JavaObject receiver, Object[] args) {
            if (receiver.obj != null) {
                throw new IllegalStateException("Can only work on classes: " + receiver.obj);
            }
            if (TruffleOptions.AOT) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof JavaObject)) continue;
                args[i] = ((JavaObject)args[i]).obj;
            }
            return JavaInteropReflect.newConstructor(receiver.clazz, args);
        }
    }

    static abstract class InvokeNode
    extends Node {
        @Node.Child
        private JavaFunctionMessageResolution.ExecuteNode.DoExecuteNode doExecute;

        InvokeNode() {
        }

        public Object access(VirtualFrame frame, JavaObject object, String name, Object[] args) {
            if (TruffleOptions.AOT) {
                throw UnsupportedMessageException.raise(Message.createInvoke(args.length));
            }
            Method foundMethod = JavaInteropReflect.findMethod(object, name, args);
            if (foundMethod != null) {
                if (this.doExecute == null || args.length != this.doExecute.numberOfArguments()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.doExecute = this.insert(new JavaFunctionMessageResolution.ExecuteNode.DoExecuteNode(args.length));
                }
                return this.doExecute.execute(frame, foundMethod, object.obj, args);
            }
            throw UnknownIdentifierException.raise(name);
        }
    }

    static abstract class ArrayHasSizeNode
    extends Node {
        ArrayHasSizeNode() {
        }

        public Object access(JavaObject receiver) {
            Object obj = receiver.obj;
            if (obj == null) {
                return false;
            }
            try {
                return obj instanceof Object[] || Array.getLength(obj) >= 0;
            }
            catch (IllegalArgumentException ex) {
                return Boolean.FALSE;
            }
        }
    }

    static abstract class ArrayGetSizeNode
    extends Node {
        ArrayGetSizeNode() {
        }

        public Object access(JavaObject receiver) {
            Object obj = receiver.obj;
            if (obj == null) {
                return 0;
            }
            return Array.getLength(obj);
        }
    }
}

