/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.BinaryOperatorParseNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public class OpAsgnAndParseNode
extends ParseNode
implements BinaryOperatorParseNode {
    private final ParseNode firstNode;
    private final ParseNode secondNode;

    public OpAsgnAndParseNode(SourceIndexLength position, ParseNode headNode, ParseNode valueNode) {
        super(position, headNode.containsVariableAssignment() || valueNode.containsVariableAssignment());
        assert (headNode != null) : "headNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.firstNode = headNode;
        this.secondNode = valueNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.OPASGNANDNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitOpAsgnAndNode(this);
    }

    @Override
    public ParseNode getFirstNode() {
        return this.firstNode;
    }

    @Override
    public ParseNode getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.firstNode, this.secondNode);
    }
}

