/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.impl.models.http.request;

import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.AbstractHttpByteHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.HttpPanelViewModelUtils;

public class RequestByteHttpPanelViewModel
extends AbstractHttpByteHttpPanelViewModel {
    private static final Logger logger = Logger.getLogger(RequestByteHttpPanelViewModel.class);

    @Override
    public byte[] getData() {
        if (this.httpMessage == null) {
            return new byte[0];
        }
        byte[] byArray = this.httpMessage.getRequestHeader().toString().getBytes();
        byte[] byArray2 = this.httpMessage.getRequestBody().getBytes();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    @Override
    public void setData(byte[] byArray) {
        int n = this.findHeaderLimit(byArray);
        if (n == -1) {
            logger.warn((Object)("Could not Save Header, limit not found. Header: " + new String(byArray)));
            return;
        }
        try {
            this.httpMessage.setRequestHeader(new String(byArray, 0, n));
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            logger.warn((Object)("Could not Save Header: " + new String(byArray, 0, n)), (Throwable)httpMalformedHeaderException);
        }
        this.httpMessage.getRequestBody().setBody(ArrayUtils.subarray(byArray, n, byArray.length));
        HttpPanelViewModelUtils.updateRequestContentLength(this.httpMessage);
    }

    private int findHeaderLimit(byte[] byArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = -1;
        for (int i = 0; i < byArray.length; ++i) {
            if (!bl2 && byArray[i] == 13) {
                bl2 = true;
                continue;
            }
            if (!bl3 && byArray[i] == 10) {
                if (bl) {
                    n = i;
                    break;
                }
                bl = true;
                bl2 = false;
                bl3 = false;
                continue;
            }
            bl2 = false;
            bl3 = false;
            bl = false;
        }
        return n;
    }
}

