/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.Color;
import java.util.Objects;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.styleelement.MapImage;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.TextLabel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class AreaElement
extends StyleElement {
    public Color color;
    public MapImage fillImage;
    public TextLabel text;
    public Float extent;
    public Float extentThreshold;

    protected AreaElement(Cascade cascade, Color color, MapImage mapImage, Float f, Float f2, TextLabel textLabel) {
        super(cascade, 1.0f);
        CheckParameterUtil.ensureParameterNotNull(color);
        this.color = color;
        this.fillImage = mapImage;
        this.extent = f;
        this.extentThreshold = f2;
        this.text = textLabel;
    }

    public static AreaElement create(Environment environment) {
        Object object;
        Object object2;
        Color color;
        Cascade cascade = environment.mc.getCascade(environment.layer);
        MapImage mapImage = null;
        MapPaintStyles.IconReference iconReference = cascade.get("fill-image", null, MapPaintStyles.IconReference.class);
        if (iconReference != null) {
            mapImage = new MapImage(iconReference.iconName, iconReference.source, false);
            color = new Color(mapImage.getImage(false).getRGB(mapImage.getWidth() / 2, mapImage.getHeight() / 2));
            mapImage.alpha = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.fill-image-alpha", 255)));
            object2 = Utils.colorFloat2int(cascade.get("fill-opacity", null, Float.TYPE));
            if (object2 != null) {
                mapImage.alpha = (Integer)object2;
            }
        } else {
            color = cascade.get("fill-color", null, Color.class);
            if (color != null) {
                int n = color.getAlpha();
                if (n == 255) {
                    n = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.fillalpha", 50)));
                }
                if ((object = Utils.colorFloat2int(cascade.get("fill-opacity", null, Float.TYPE))) != null) {
                    n = (Integer)object;
                }
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
            }
        }
        object2 = null;
        object = cascade.get("text-position", null, Keyword.class);
        if (object == null || "center".equals(((Keyword)object).val)) {
            object2 = TextLabel.create(environment, PaintColors.AREA_TEXT.get(), true);
        }
        Float f = cascade.get("fill-extent", null, Float.TYPE);
        Float f2 = cascade.get("fill-extent-threshold", null, Float.TYPE);
        if (color != null) {
            return new AreaElement(cascade, color, mapImage, f, f2, (TextLabel)object2);
        }
        return null;
    }

    @Override
    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, StyledMapRenderer styledMapRenderer, boolean bl, boolean bl2, boolean bl3) {
        Color color = this.color;
        if (osmPrimitive instanceof Way) {
            if (this.color != null) {
                if (bl) {
                    color = mapPaintSettings.getSelectedColor(this.color.getAlpha());
                } else if (bl2) {
                    color = mapPaintSettings.getRelationSelectedColor(this.color.getAlpha());
                }
            }
            styledMapRenderer.drawArea((Way)osmPrimitive, color, this.fillImage, this.extent, this.extentThreshold, styledMapRenderer.isInactiveMode() || osmPrimitive.isDisabled(), this.text);
        } else if (osmPrimitive instanceof Relation) {
            if (this.color != null && (bl || bl2)) {
                color = mapPaintSettings.getRelationSelectedColor(this.color.getAlpha());
            }
            styledMapRenderer.drawArea((Relation)osmPrimitive, color, this.fillImage, this.extent, this.extentThreshold, styledMapRenderer.isInactiveMode() || osmPrimitive.isDisabled(), this.text);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AreaElement areaElement = (AreaElement)object;
        return Objects.equals(this.color, areaElement.color) && Objects.equals(this.fillImage, areaElement.fillImage) && Objects.equals(this.text, areaElement.text) && Objects.equals(this.extent, areaElement.extent) && Objects.equals(this.extentThreshold, areaElement.extentThreshold);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.color, this.fillImage, this.text, this.extent, this.extentThreshold);
    }

    @Override
    public String toString() {
        return "AreaElemStyle{" + super.toString() + "color=" + Utils.toString(this.color) + " fillImage=[" + this.fillImage + "]}";
    }
}

