/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapPolygonImpl;
import org.openstreetmap.gui.jmapviewer.MapRectangleImpl;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.imagery.AddImageryDialog;
import org.openstreetmap.josm.gui.preferences.imagery.AddImageryPanel;
import org.openstreetmap.josm.gui.preferences.imagery.AddTMSLayerPanel;
import org.openstreetmap.josm.gui.preferences.imagery.AddWMSLayerPanel;
import org.openstreetmap.josm.gui.preferences.imagery.AddWMTSLayerPanel;
import org.openstreetmap.josm.gui.preferences.imagery.CacheContentsPanel;
import org.openstreetmap.josm.gui.preferences.imagery.CommonSettingsPanel;
import org.openstreetmap.josm.gui.preferences.imagery.TMSSettingsPanel;
import org.openstreetmap.josm.gui.preferences.imagery.WMSSettingsPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;

public final class ImageryPreference
extends DefaultTabPreferenceSetting {
    private ImageryProvidersPanel imageryProviders;
    private ImageryLayerInfo layerInfo;
    private final CommonSettingsPanel commonSettings = new CommonSettingsPanel();
    private final WMSSettingsPanel wmsSettings = new WMSSettingsPanel();
    private final TMSSettingsPanel tmsSettings = new TMSSettingsPanel();

    private ImageryPreference() {
        super("imagery", I18n.tr("Imagery Preferences", new Object[0]), I18n.tr("Modify list of imagery layers displayed in the Imagery menu", new Object[0]), false, new JTabbedPane());
    }

    private static void addSettingsSection(JPanel jPanel, String string, JPanel jPanel2) {
        ImageryPreference.addSettingsSection(jPanel, string, jPanel2, GBC.eol());
    }

    private static void addSettingsSection(JPanel jPanel, String string, JPanel jPanel2, GBC gBC) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setLabelFor(jPanel2);
        jPanel.add((Component)jLabel, GBC.std());
        jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(5, 0, 0, 0));
        jPanel.add((Component)jPanel2, gBC.insets(20, 5, 0, 10));
    }

    private Component buildSettingsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ImageryPreference.addSettingsSection(jPanel, I18n.tr("Common Settings", new Object[0]), this.commonSettings);
        ImageryPreference.addSettingsSection(jPanel, I18n.tr("WMS Settings", new Object[0]), this.wmsSettings, GBC.eol().fill(2));
        ImageryPreference.addSettingsSection(jPanel, I18n.tr("TMS Settings", new Object[0]), this.tmsSettings, GBC.eol().fill(2));
        jPanel.add((Component)new JPanel(), GBC.eol().fill(1));
        return GuiHelper.setDefaultIncrement(new JScrollPane(jPanel));
    }

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        PreferenceTabbedPane.PreferencePanel preferencePanel = preferenceTabbedPane.createPreferenceTab(this);
        JTabbedPane jTabbedPane = this.getTabPane();
        this.layerInfo = new ImageryLayerInfo(ImageryLayerInfo.instance);
        this.imageryProviders = new ImageryProvidersPanel(preferenceTabbedPane, this.layerInfo);
        jTabbedPane.addTab(I18n.tr("Imagery providers", new Object[0]), this.imageryProviders);
        jTabbedPane.addTab(I18n.tr("Settings", new Object[0]), this.buildSettingsPanel());
        jTabbedPane.addTab(I18n.tr("Offset bookmarks", new Object[0]), new OffsetBookmarksPanel(preferenceTabbedPane));
        jTabbedPane.addTab(I18n.tr("Cache contents", new Object[0]), new CacheContentsPanel());
        this.loadSettings();
        preferencePanel.add((Component)jTabbedPane, GBC.std().fill(1));
    }

    public ImageryProvidersPanel getProvidersPanel() {
        return this.imageryProviders;
    }

    private void loadSettings() {
        this.commonSettings.loadSettings();
        this.wmsSettings.loadSettings();
        this.tmsSettings.loadSettings();
    }

    @Override
    public boolean ok() {
        this.layerInfo.save();
        ImageryLayerInfo.instance.clear();
        ImageryLayerInfo.instance.load(false);
        Main.main.menu.imageryMenu.refreshOffsetMenu();
        OffsetBookmark.saveBookmarks();
        if (!GraphicsEnvironment.isHeadless()) {
            DownloadDialog.getInstance().refreshTileSources();
        }
        boolean bl = this.commonSettings.saveSettings();
        boolean bl2 = this.wmsSettings.saveSettings();
        boolean bl3 = this.tmsSettings.saveSettings();
        return bl || bl2 || bl3;
    }

    public void setServerUrl(String string, String string2) {
        for (int i = 0; i < this.imageryProviders.activeModel.getRowCount(); ++i) {
            if (!string.equals(this.imageryProviders.activeModel.getValueAt(i, 0).toString())) continue;
            this.imageryProviders.activeModel.setValueAt(string2, i, 1);
            return;
        }
        this.imageryProviders.activeModel.addRow(new String[]{string, string2});
    }

    public String getServerUrl(String string) {
        for (int i = 0; i < this.imageryProviders.activeModel.getRowCount(); ++i) {
            if (!string.equals(this.imageryProviders.activeModel.getValueAt(i, 0).toString())) continue;
            return this.imageryProviders.activeModel.getValueAt(i, 1).toString();
        }
        return null;
    }

    public static void initialize() {
        ImageryLayerInfo.instance.load(true);
        OffsetBookmark.loadBookmarks();
        Main.main.menu.imageryMenu.refreshImageryMenu();
        Main.main.menu.imageryMenu.refreshOffsetMenu();
    }

    static class OffsetBookmarksPanel
    extends JPanel {
        private final transient List<OffsetBookmark> bookmarks = OffsetBookmark.allBookmarks;
        private final OffsetsBookmarksModel model = new OffsetsBookmarksModel();

        OffsetBookmarksPanel(PreferenceTabbedPane preferenceTabbedPane) {
            super(new GridBagLayout());
            JTable jTable = new JTable(this.model){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    return model.getValueAt(this.rowAtPoint(point), this.columnAtPoint(point)).toString();
                }
            };
            JScrollPane jScrollPane = new JScrollPane(jTable);
            this.add((Component)jScrollPane, GBC.eol().fill(1));
            jScrollPane.setPreferredSize(new Dimension(200, 200));
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            tableColumnModel.getColumn(0).setPreferredWidth(150);
            tableColumnModel.getColumn(1).setPreferredWidth(200);
            tableColumnModel.getColumn(2).setPreferredWidth(300);
            tableColumnModel.getColumn(3).setPreferredWidth(150);
            tableColumnModel.getColumn(4).setPreferredWidth(150);
            JPanel jPanel = new JPanel(new FlowLayout());
            JButton jButton = new JButton(I18n.tr("Add", new Object[0]));
            jPanel.add((Component)jButton, GBC.std().insets(0, 5, 0, 0));
            jButton.addActionListener(actionEvent -> this.model.addRow(new OffsetBookmark(Main.getProjection().toCode(), "", "", 0.0, 0.0)));
            JButton jButton2 = new JButton(I18n.tr("Delete", new Object[0]));
            jPanel.add((Component)jButton2, GBC.std().insets(0, 5, 0, 0));
            jButton2.addActionListener(actionEvent -> {
                if (jTable.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("Please select the row to delete.", new Object[0]));
                } else {
                    Integer n;
                    while ((n = Integer.valueOf(jTable.getSelectedRow())) != -1) {
                        this.model.removeRow(n);
                    }
                }
            });
            this.add((Component)jPanel, GBC.eol());
        }

        private class OffsetsBookmarksModel
        extends DefaultTableModel {
            OffsetsBookmarksModel() {
                this.setColumnIdentifiers(new String[]{I18n.tr("Projection", new Object[0]), I18n.tr("Layer", new Object[0]), I18n.tr("Name", new Object[0]), I18n.tr("Easting", new Object[0]), I18n.tr("Northing", new Object[0])});
            }

            private OffsetBookmark getRow(int n) {
                return (OffsetBookmark)OffsetBookmarksPanel.this.bookmarks.get(n);
            }

            private void addRow(OffsetBookmark offsetBookmark) {
                OffsetBookmarksPanel.this.bookmarks.add(offsetBookmark);
                int n = this.getRowCount() - 1;
                this.fireTableRowsInserted(n, n);
            }

            @Override
            public void removeRow(int n) {
                OffsetBookmarksPanel.this.bookmarks.remove(this.getRow(n));
                this.fireTableRowsDeleted(n, n);
            }

            @Override
            public int getRowCount() {
                return OffsetBookmarksPanel.this.bookmarks.size();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                OffsetBookmark offsetBookmark = (OffsetBookmark)OffsetBookmarksPanel.this.bookmarks.get(n);
                switch (n2) {
                    case 0: {
                        if (offsetBookmark.projectionCode == null) {
                            return "";
                        }
                        return offsetBookmark.projectionCode;
                    }
                    case 1: {
                        return offsetBookmark.layerName;
                    }
                    case 2: {
                        return offsetBookmark.name;
                    }
                    case 3: {
                        return offsetBookmark.dx;
                    }
                    case 4: {
                        return offsetBookmark.dy;
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                OffsetBookmark offsetBookmark = (OffsetBookmark)OffsetBookmarksPanel.this.bookmarks.get(n);
                switch (n2) {
                    case 1: {
                        offsetBookmark.layerName = object.toString();
                        break;
                    }
                    case 2: {
                        offsetBookmark.name = object.toString();
                        break;
                    }
                    case 3: {
                        offsetBookmark.dx = Double.parseDouble((String)object);
                        break;
                    }
                    case 4: {
                        offsetBookmark.dy = Double.parseDouble((String)object);
                        break;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                }
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 >= 1;
            }
        }
    }

    public static class ImageryProvidersPanel
    extends JPanel {
        public final JTable activeTable;
        public final JTable defaultTable;
        private final transient DefListSelectionListener defaultTableListener;
        public final JMapViewer defaultMap;
        public final ImageryLayerTableModel activeModel;
        public final ImageryDefaultLayerTableModel defaultModel;
        public final JToolBar activeToolbar;
        public final JToolBar middleToolbar;
        public final JToolBar defaultToolbar;
        private final PreferenceTabbedPane gui;
        private final transient ImageryLayerInfo layerInfo;

        public ImageryProvidersPanel(PreferenceTabbedPane preferenceTabbedPane, ImageryLayerInfo imageryLayerInfo) {
            super(new GridBagLayout());
            this.gui = preferenceTabbedPane;
            this.layerInfo = imageryLayerInfo;
            this.activeModel = new ImageryLayerTableModel();
            this.activeTable = new JTable(this.activeModel){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    return activeModel.getValueAt(this.rowAtPoint(point), this.columnAtPoint(point)).toString();
                }
            };
            this.activeTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this.defaultModel = new ImageryDefaultLayerTableModel();
            this.defaultTable = new JTable(this.defaultModel);
            this.defaultModel.addTableModelListener(tableModelEvent -> this.activeTable.repaint());
            this.activeModel.addTableModelListener(tableModelEvent -> this.defaultTable.repaint());
            TableColumnModel tableColumnModel = this.defaultTable.getColumnModel();
            tableColumnModel.getColumn(2).setPreferredWidth(800);
            tableColumnModel.getColumn(2).setCellRenderer(new ImageryURLTableCellRenderer(this.layerInfo.getLayers()));
            tableColumnModel.getColumn(1).setPreferredWidth(400);
            tableColumnModel.getColumn(1).setCellRenderer(new ImageryNameTableCellRenderer());
            tableColumnModel.getColumn(0).setPreferredWidth(50);
            tableColumnModel = this.activeTable.getColumnModel();
            tableColumnModel.getColumn(1).setPreferredWidth(800);
            tableColumnModel.getColumn(1).setCellRenderer(new ImageryURLTableCellRenderer(this.layerInfo.getAllDefaultLayers()));
            tableColumnModel.getColumn(0).setPreferredWidth(200);
            RemoveEntryAction removeEntryAction = new RemoveEntryAction();
            this.activeTable.getSelectionModel().addListSelectionListener(removeEntryAction);
            this.add((Component)new JLabel(I18n.tr("Available default entries:", new Object[0])), GBC.eol().insets(5, 5, 0, 0));
            JScrollPane jScrollPane = new JScrollPane(this.defaultTable);
            jScrollPane.setPreferredSize(new Dimension(200, 200));
            this.add((Component)jScrollPane, GBC.std().insets(0, 5, 0, 0).fill(1).weight(1.0, 0.6).insets(5, 0, 0, 0));
            this.defaultMap = new JMapViewer();
            this.defaultMap.setTileSource(new OsmTileSource.Mapnik());
            this.defaultMap.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        defaultMap.getAttribution().handleAttribution(mouseEvent.getPoint(), true);
                    }
                }
            });
            this.defaultMap.setZoomContolsVisible(false);
            this.defaultMap.setMinimumSize(new Dimension(100, 200));
            this.add((Component)this.defaultMap, GBC.std().insets(5, 5, 0, 0).fill(1).weight(0.33, 0.6).insets(5, 0, 0, 0));
            this.defaultTableListener = new DefListSelectionListener();
            this.defaultTable.getSelectionModel().addListSelectionListener(this.defaultTableListener);
            this.defaultToolbar = new JToolBar(1);
            this.defaultToolbar.setFloatable(false);
            this.defaultToolbar.setBorderPainted(false);
            this.defaultToolbar.setOpaque(false);
            this.defaultToolbar.add(new ReloadAction());
            this.add((Component)this.defaultToolbar, GBC.eol().anchor(15).insets(0, 0, 5, 0));
            ActivateAction activateAction = new ActivateAction();
            this.defaultTable.getSelectionModel().addListSelectionListener(activateAction);
            JButton jButton = new JButton(activateAction);
            this.middleToolbar = new JToolBar(0);
            this.middleToolbar.setFloatable(false);
            this.middleToolbar.setBorderPainted(false);
            this.middleToolbar.setOpaque(false);
            this.middleToolbar.add(jButton);
            this.add((Component)this.middleToolbar, GBC.eol().anchor(10).insets(5, 15, 5, 0));
            this.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
            this.add((Component)new JLabel(I18n.tr("Selected entries:", new Object[0])), GBC.eol().insets(5, 0, 0, 0));
            JScrollPane jScrollPane2 = new JScrollPane(this.activeTable);
            this.add((Component)jScrollPane2, GBC.std().fill(1).span(-1).weight(1.0, 0.4).insets(5, 0, 0, 5));
            jScrollPane2.setPreferredSize(new Dimension(200, 200));
            this.activeToolbar = new JToolBar(1);
            this.activeToolbar.setFloatable(false);
            this.activeToolbar.setBorderPainted(false);
            this.activeToolbar.setOpaque(false);
            this.activeToolbar.add(new NewEntryAction(ImageryInfo.ImageryType.WMS));
            this.activeToolbar.add(new NewEntryAction(ImageryInfo.ImageryType.TMS));
            this.activeToolbar.add(new NewEntryAction(ImageryInfo.ImageryType.WMTS));
            this.activeToolbar.add(removeEntryAction);
            this.add((Component)this.activeToolbar, GBC.eol().anchor(11).insets(0, 0, 5, 5));
        }

        private static boolean confirmEulaAcceptance(PreferenceTabbedPane preferenceTabbedPane, String string) {
            URL uRL = null;
            try {
                uRL = new URL(string.replaceAll("\\{lang\\}", LanguageInfo.getWikiLanguagePrefix()));
                JosmEditorPane josmEditorPane = null;
                try {
                    josmEditorPane = new JosmEditorPane(uRL);
                }
                catch (IOException iOException) {
                    Main.trace(iOException);
                    try {
                        uRL = new URL(string.replaceAll("\\{lang\\}", ""));
                        josmEditorPane = new JosmEditorPane(uRL);
                    }
                    catch (IOException iOException2) {
                        Main.debug(iOException2);
                        JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("EULA license URL not available: {0}", string));
                        return false;
                    }
                }
                Box box = Box.createVerticalBox();
                josmEditorPane.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(josmEditorPane);
                jScrollPane.setPreferredSize(new Dimension(400, 400));
                box.add(jScrollPane);
                int n = JOptionPane.showConfirmDialog(Main.parent, box, I18n.tr("Please abort if you are not sure", new Object[0]), 0, 2);
                if (n == 0) {
                    return true;
                }
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("Malformed URL for the EULA licence: {0}", string));
            }
            return false;
        }

        public class ImageryDefaultLayerTableModel
        extends DefaultTableModel {
            public ImageryDefaultLayerTableModel() {
                this.setColumnIdentifiers(new String[]{"", I18n.tr("Menu Name (Default)", new Object[0]), I18n.tr("Imagery URL (Default)", new Object[0])});
            }

            public ImageryInfo getRow(int n) {
                return ImageryProvidersPanel.this.layerInfo.getAllDefaultLayers().get(n);
            }

            @Override
            public int getRowCount() {
                return ImageryProvidersPanel.this.layerInfo.getAllDefaultLayers().size();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                ImageryInfo imageryInfo = ImageryProvidersPanel.this.layerInfo.getAllDefaultLayers().get(n);
                switch (n2) {
                    case 0: {
                        return imageryInfo.getCountryCode();
                    }
                    case 1: {
                        return imageryInfo;
                    }
                    case 2: {
                        return imageryInfo.getExtendedUrl();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        }

        public class ImageryLayerTableModel
        extends DefaultTableModel {
            public ImageryLayerTableModel() {
                this.setColumnIdentifiers(new String[]{I18n.tr("Menu Name", new Object[0]), I18n.tr("Imagery URL", new Object[0])});
            }

            public ImageryInfo getRow(int n) {
                return ImageryProvidersPanel.this.layerInfo.getLayers().get(n);
            }

            public void addRow(ImageryInfo imageryInfo) {
                ImageryProvidersPanel.this.layerInfo.add(imageryInfo);
                int n = this.getRowCount() - 1;
                this.fireTableRowsInserted(n, n);
            }

            @Override
            public void removeRow(int n) {
                ImageryProvidersPanel.this.layerInfo.remove(this.getRow(n));
                this.fireTableRowsDeleted(n, n);
            }

            @Override
            public int getRowCount() {
                return ImageryProvidersPanel.this.layerInfo.getLayers().size();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                ImageryInfo imageryInfo = ImageryProvidersPanel.this.layerInfo.getLayers().get(n);
                switch (n2) {
                    case 0: {
                        return imageryInfo.getName();
                    }
                    case 1: {
                        return imageryInfo.getExtendedUrl();
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (ImageryProvidersPanel.this.layerInfo.getLayers().size() <= n) {
                    return;
                }
                ImageryInfo imageryInfo = ImageryProvidersPanel.this.layerInfo.getLayers().get(n);
                switch (n2) {
                    case 0: {
                        imageryInfo.setName((String)object);
                        imageryInfo.clearId();
                        break;
                    }
                    case 1: {
                        imageryInfo.setExtendedUrl((String)object);
                        imageryInfo.clearId();
                        break;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                }
            }
        }

        private class ReloadAction
        extends AbstractAction {
            ReloadAction() {
                this.putValue("ShortDescription", I18n.tr("Update default entries", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageryProvidersPanel.this.layerInfo.loadDefaults(true, false, false);
                ImageryProvidersPanel.this.defaultModel.fireTableDataChanged();
                ImageryProvidersPanel.this.defaultTable.getSelectionModel().clearSelection();
                ImageryProvidersPanel.this.defaultTableListener.clearMap();
                ImageryProvidersPanel.this.activeModel.fireTableDataChanged();
            }
        }

        private class ActivateAction
        extends AbstractAction
        implements ListSelectionListener {
            ActivateAction() {
                this.putValue("Name", I18n.tr("Activate", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("copy selected defaults", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("preferences", "activate-down"));
            }

            protected void updateEnabledState() {
                this.setEnabled(ImageryProvidersPanel.this.defaultTable.getSelectedRowCount() > 0);
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                this.updateEnabledState();
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ImageryProvidersPanel.this.defaultTable.getSelectedRows();
                if (nArray.length == 0) {
                    JOptionPane.showMessageDialog(ImageryProvidersPanel.this.gui, I18n.tr("Please select at least one row to copy.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                    return;
                }
                HashSet<String> hashSet = new HashSet<String>();
                block0: for (int n : nArray) {
                    ImageryInfo imageryInfo = ImageryProvidersPanel.this.defaultModel.getRow(n);
                    for (int i = 0; i < ImageryProvidersPanel.this.activeModel.getRowCount(); ++i) {
                        if (!imageryInfo.equalsBaseValues(ImageryProvidersPanel.this.activeModel.getRow(i))) continue;
                        ImageryProvidersPanel.this.activeTable.getSelectionModel().setSelectionInterval(i, i);
                        ImageryProvidersPanel.this.activeTable.scrollRectToVisible(ImageryProvidersPanel.this.activeTable.getCellRect(i, 0, true));
                        continue block0;
                    }
                    String string = imageryInfo.getEulaAcceptanceRequired();
                    if (string != null && !hashSet.contains(string)) {
                        if (!ImageryProvidersPanel.confirmEulaAcceptance(ImageryProvidersPanel.this.gui, string)) continue;
                        hashSet.add(string);
                    }
                    ImageryProvidersPanel.this.activeModel.addRow(new ImageryInfo(imageryInfo));
                    int n2 = ImageryProvidersPanel.this.activeModel.getRowCount() - 1;
                    ImageryProvidersPanel.this.activeTable.getSelectionModel().setSelectionInterval(n2, n2);
                    ImageryProvidersPanel.this.activeTable.scrollRectToVisible(ImageryProvidersPanel.this.activeTable.getCellRect(n2, 0, true));
                }
            }
        }

        private class RemoveEntryAction
        extends AbstractAction
        implements ListSelectionListener {
            RemoveEntryAction() {
                this.putValue("Name", I18n.tr("Remove", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Remove entry", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
                this.updateEnabledState();
            }

            protected final void updateEnabledState() {
                this.setEnabled(ImageryProvidersPanel.this.activeTable.getSelectedRowCount() > 0);
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                this.updateEnabledState();
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n;
                while ((n = Integer.valueOf(ImageryProvidersPanel.this.activeTable.getSelectedRow())) != -1) {
                    ImageryProvidersPanel.this.activeModel.removeRow(n);
                }
            }
        }

        private class NewEntryAction
        extends AbstractAction {
            private final ImageryInfo.ImageryType type;

            NewEntryAction(ImageryInfo.ImageryType imageryType) {
                this.putValue("Name", imageryType.toString());
                this.putValue("ShortDescription", I18n.tr("Add a new {0} entry by entering the URL", imageryType.toString()));
                String string = "add";
                switch (imageryType) {
                    case WMS: {
                        string = "add_wms";
                        break;
                    }
                    case TMS: {
                        string = "add_tms";
                        break;
                    }
                    case WMTS: {
                        string = "add_wmts";
                        break;
                    }
                }
                this.putValue("SmallIcon", ImageProvider.get("dialogs", string));
                this.type = imageryType;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddImageryPanel addImageryPanel;
                switch (this.type) {
                    case WMS: {
                        addImageryPanel = new AddWMSLayerPanel();
                        break;
                    }
                    case TMS: {
                        addImageryPanel = new AddTMSLayerPanel();
                        break;
                    }
                    case WMTS: {
                        addImageryPanel = new AddWMTSLayerPanel();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Type " + (Object)((Object)this.type) + " not supported");
                    }
                }
                AddImageryDialog addImageryDialog = new AddImageryDialog(ImageryProvidersPanel.this.gui, addImageryPanel);
                addImageryDialog.showDialog();
                if (addImageryDialog.getValue() == 1) {
                    try {
                        ImageryProvidersPanel.this.activeModel.addRow(addImageryPanel.getImageryInfo());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (illegalArgumentException.getMessage() == null || illegalArgumentException.getMessage().isEmpty()) {
                            throw illegalArgumentException;
                        }
                        JOptionPane.showMessageDialog(Main.parent, illegalArgumentException.getMessage(), I18n.tr("Error", new Object[0]), 0);
                    }
                }
            }
        }

        private final class DefListSelectionListener
        implements ListSelectionListener {
            private final Map<Integer, MapRectangle> mapRectangles = new HashMap<Integer, MapRectangle>();
            private final Map<Integer, List<MapPolygon>> mapPolygons = new HashMap<Integer, List<MapPolygon>>();

            private DefListSelectionListener() {
            }

            private void clearMap() {
                ImageryProvidersPanel.this.defaultMap.removeAllMapRectangles();
                ImageryProvidersPanel.this.defaultMap.removeAllMapPolygons();
                this.mapRectangles.clear();
                this.mapPolygons.clear();
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getFirstIndex() == -1) {
                    this.clearMap();
                } else if (!listSelectionEvent.getValueIsAdjusting()) {
                    for (int i = listSelectionEvent.getFirstIndex(); i <= listSelectionEvent.getLastIndex(); ++i) {
                        this.updateBoundsAndShapes(i);
                    }
                    if (!this.mapRectangles.isEmpty() || !this.mapPolygons.isEmpty()) {
                        ImageryProvidersPanel.this.defaultMap.setDisplayToFitMapElements(false, true, true);
                        ImageryProvidersPanel.this.defaultMap.zoomOut();
                    }
                }
            }

            private void updateBoundsAndShapes(int n) {
                ImageryInfo.ImageryBounds imageryBounds = ImageryProvidersPanel.this.defaultModel.getRow(n).getBounds();
                if (imageryBounds != null) {
                    List<Shape> list = imageryBounds.getShapes();
                    if (list != null && !list.isEmpty()) {
                        if (ImageryProvidersPanel.this.defaultTable.getSelectionModel().isSelectedIndex(n)) {
                            if (!this.mapPolygons.containsKey(n)) {
                                ArrayList<MapPolygonImpl> arrayList = new ArrayList<MapPolygonImpl>();
                                this.mapPolygons.put(n, arrayList);
                                for (Shape shape : list) {
                                    MapPolygonImpl mapPolygonImpl = new MapPolygonImpl(shape.getPoints());
                                    arrayList.add(mapPolygonImpl);
                                    ImageryProvidersPanel.this.defaultMap.addMapPolygon(mapPolygonImpl);
                                }
                            }
                        } else if (this.mapPolygons.containsKey(n)) {
                            for (MapPolygon mapPolygon : this.mapPolygons.get(n)) {
                                ImageryProvidersPanel.this.defaultMap.removeMapPolygon(mapPolygon);
                            }
                            this.mapPolygons.remove(n);
                        }
                    } else if (ImageryProvidersPanel.this.defaultTable.getSelectionModel().isSelectedIndex(n)) {
                        if (!this.mapRectangles.containsKey(n)) {
                            Coordinate coordinate = new Coordinate(imageryBounds.getMaxLat(), imageryBounds.getMinLon());
                            Coordinate coordinate2 = new Coordinate(imageryBounds.getMinLat(), imageryBounds.getMaxLon());
                            MapRectangleImpl mapRectangleImpl = new MapRectangleImpl(coordinate, coordinate2);
                            this.mapRectangles.put(n, mapRectangleImpl);
                            ImageryProvidersPanel.this.defaultMap.addMapRectangle(mapRectangleImpl);
                        }
                    } else if (this.mapRectangles.containsKey(n)) {
                        ImageryProvidersPanel.this.defaultMap.removeMapRectangle(this.mapRectangles.get(n));
                        this.mapRectangles.remove(n);
                    }
                }
            }
        }

        private static class ImageryNameTableCellRenderer
        extends DefaultTableCellRenderer {
            private ImageryNameTableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                ImageryInfo imageryInfo = (ImageryInfo)object;
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, imageryInfo == null ? null : imageryInfo.getName(), bl, bl2, n, n2);
                GuiHelper.setBackgroundReadable(jLabel, UIManager.getColor("Table.background"));
                if (imageryInfo != null) {
                    jLabel.setToolTipText(imageryInfo.getToolTipText());
                }
                return jLabel;
            }
        }

        private static class ImageryURLTableCellRenderer
        extends DefaultTableCellRenderer {
            private static final ColorProperty IMAGERY_BACKGROUND_COLOR = new ColorProperty(I18n.marktr("Imagery Background: Default"), new Color(200, 255, 200));
            private final transient List<ImageryInfo> layers;

            ImageryURLTableCellRenderer(List<ImageryInfo> list) {
                this.layers = list;
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                GuiHelper.setBackgroundReadable(jLabel, UIManager.getColor("Table.background"));
                if (object != null) {
                    String string = object.toString();
                    for (ImageryInfo imageryInfo : this.layers) {
                        if (!imageryInfo.getExtendedUrl().equals(string)) continue;
                        GuiHelper.setBackgroundReadable(jLabel, IMAGERY_BACKGROUND_COLOR.get());
                        break;
                    }
                    jLabel.setToolTipText((String)object);
                }
                return jLabel;
            }
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ImageryPreference();
        }
    }
}

