/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.Translator;

public class JREDesc {
    private static final Pattern heapPattern = Pattern.compile("\\d+[kmg]?");
    private final Version.JreVersion version;
    private final URL location;
    private final String initialHeapSize;
    private final String maximumHeapSize;
    private final String vmArgs;
    private final List<ResourcesDesc> resources;

    public JREDesc(Version.JreVersion version, URL location, String vmArgs, String initialHeapSize, String maximumHeapSize, List<ResourcesDesc> resources) throws ParseException {
        this.version = version;
        this.location = location;
        this.vmArgs = vmArgs;
        this.initialHeapSize = JREDesc.checkHeapSize(initialHeapSize);
        this.maximumHeapSize = JREDesc.checkHeapSize(maximumHeapSize);
        this.resources = resources;
    }

    public Version.JreVersion getVersion() {
        return this.version;
    }

    public boolean isPlatformVersion() {
        return this.getLocation() == null;
    }

    public URL getLocation() {
        return this.location;
    }

    public String getMaximumHeapSize() {
        return this.maximumHeapSize;
    }

    public String getInitialHeapSize() {
        return this.initialHeapSize;
    }

    public List<ResourcesDesc> getResourcesDesc() {
        return this.resources;
    }

    public String getVMArgs() {
        return this.vmArgs;
    }

    static String checkHeapSize(String heapSize) throws ParseException {
        if (heapSize == null) {
            return null;
        }
        String heapSizeLower = (heapSize = heapSize.trim()).toLowerCase();
        Matcher heapMatcher = heapPattern.matcher(heapSizeLower);
        if (!heapMatcher.matches()) {
            throw new ParseException(Translator.R("PBadHeapSize", heapSize));
        }
        return heapSize;
    }
}

