/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui.unused;

import dguitar.codecs.guitarPro.GPBeat;
import dguitar.codecs.guitarPro.GPEffectsOnNote;
import dguitar.codecs.guitarPro.GPNote;
import dguitar.gui.BarMTP;
import dguitar.gui.BarPanel;
import dguitar.gui.DisplayOptions;
import dguitar.gui.MusicCursor;
import dguitar.gui.MusicCursorPosition;
import dguitar.gui.unused.NoteComponent;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class BarStandard
extends BarMTP
implements MouseListener,
MouseMotionListener {
    private Vector Notes = new Vector(0, 1);
    private Point p;
    private Point pAnt = null;
    private boolean avoidNoteClipping = true;
    private boolean showSnap = true;
    private Rectangle snapRect;

    public BarStandard(DisplayOptions cdo, BarPanel BP) {
        super(cdo, BP);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public NoteComponent findNote(Point pos) {
        NoteComponent n = null;
        boolean found = false;
        int i = 0;
        while (i < this.Notes.size() && !found) {
            n = (NoteComponent)this.Notes.elementAt(i);
            found = n.p.equals(pos);
            ++i;
        }
        if (!found) {
            n = null;
        }
        return n;
    }

    public MusicCursorPosition snapX(int x, MusicCursor ms) {
        return null;
    }

    public Point snap(Point pos, Point rel) {
        Point resp = new Point();
        int snapX = 0;
        int snapY = 2 * (pos.y - this.getDisplayOptions().TopOffset) / this.getDisplayOptions().LS;
        resp.y = snapY * this.getDisplayOptions().LS / 2 + this.getDisplayOptions().TopOffset;
        if (rel != null) {
            rel.x = snapX;
            rel.y = 4 * (this.getDisplayOptions().TopOffset + this.BP.H + this.getDisplayOptions().LS - pos.y) / this.getDisplayOptions().LS;
        }
        return resp;
    }

    private void drawSnap(Point pp) {
        Graphics g = this.getGraphics();
        this.snapRect = new Rectangle();
        this.snapRect.x = pp.x - 4;
        this.snapRect.y = pp.y - 3;
        this.snapRect.width = 8;
        this.snapRect.height = 6;
        g.drawRect(this.snapRect.x, this.snapRect.y, this.snapRect.width, this.snapRect.height);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        NoteComponent n;
        this.p = mouseEvent.getPoint();
        Point newPRelative = new Point();
        Point newP = this.snap(this.p, newPRelative);
        if (this.avoidNoteClipping && newP.y <= 29 && this.pAnt != null) {
            newP = this.pAnt;
        }
        if ((n = this.findNote(newP)) != null) {
            this.Notes.remove(n);
            this.repaint();
        } else if (newP.y > 29 && newP.x > 14 && newP.x < this.getWidth() - 14) {
            String str = this.getCursor().getName();
            Integer aux = new Integer(str);
            n = new NoteComponent(newP, aux - 1, newPRelative);
            this.Notes.add(n);
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.pAnt != null && this.showSnap) {
            this.repaint();
            this.pAnt = null;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.p = mouseEvent.getPoint();
        Point newPRelative = new Point();
        Point newP = this.snap(this.p, newPRelative);
        if ((!this.avoidNoteClipping || this.avoidNoteClipping && newP.y > 29) && newP.x > 14 && newP.x < this.getWidth() - 14 && !newP.equals(this.pAnt)) {
            Graphics g = this.getGraphics();
            if (this.pAnt != null && this.showSnap) {
                g.setClip(this.snapRect.x, this.snapRect.y, this.snapRect.width + 1, this.snapRect.height + 1);
                this.paint(g);
            }
            if (this.showSnap) {
                this.drawSnap(newP);
            }
            this.pAnt = newP;
        }
    }

    public int calculateHeightOfString(int s) {
        int y = this.getDisplayOptions().TopOffset + this.BP.H - s * this.getDisplayOptions().LS;
        y += (7 - this.BP.LINES) * this.getDisplayOptions().LS;
        return y += this.fontAscent / 2;
    }

    public void paintRhythmHL(Graphics g, int x, int lowest, int n, GPBeat prev) {
        int aux = 0;
        int x2 = x;
        if (prev != null) {
            int i = 0;
            while (i <= n) {
                aux = lowest - i * 3;
                g.setColor(this.colorPrev);
                x2 = i <= this.lastNumHLines ? x - this.calculateWidthOfBeat(prev) + this.getDisplayOptions().NS / 2 + 1 : x - this.getDisplayOptions().NS / 2;
                ++i;
            }
        } else {
            int i = 0;
            while (i <= n) {
                aux = lowest - i * 3;
                g.setColor(this.colorNext);
                x2 = x + this.getDisplayOptions().NS / 2;
                ++i;
            }
        }
        g.drawLine(x, aux - 1, x2, aux - 1);
        g.drawLine(x, aux, x2, aux);
    }

    public void paintNote(Graphics g, int x, int y, GPNote note) {
    }

    public void paintSilence(Graphics g, int currentX, GPBeat beat, int contSilences) {
    }

    public void paintEffects(Graphics g, int currentX, int y, GPEffectsOnNote EON, int contEON, GPBeat beat) {
    }
}

