/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import jogamp.opengl.util.pngj.FilterType;
import jogamp.opengl.util.pngj.FilterWriteStrategy;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.ImageLine;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngIDatChunkOutputStream;
import jogamp.opengl.util.pngj.PngReader;
import jogamp.opengl.util.pngj.PngjExceptionInternal;
import jogamp.opengl.util.pngj.PngjOutputException;
import jogamp.opengl.util.pngj.PngjUnsupportedException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunksListForWrite;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkIEND;
import jogamp.opengl.util.pngj.chunks.PngChunkIHDR;
import jogamp.opengl.util.pngj.chunks.PngChunkSkipped;
import jogamp.opengl.util.pngj.chunks.PngChunkTextVar;
import jogamp.opengl.util.pngj.chunks.PngMetadata;

public class PngWriter {
    public final ImageInfo imgInfo;
    private final String filename;
    protected int rowNum = -1;
    private final ChunksListForWrite chunksList;
    private final PngMetadata metadata;
    protected int currentChunkGroup = -1;
    protected FilterWriteStrategy filterStrat;
    private int compLevel = 6;
    private boolean shouldCloseStream = true;
    private PngIDatChunkOutputStream datStream;
    private DeflaterOutputStream datStreamDeflated;
    private int deflaterStrategy = 1;
    private int[] histox = new int[256];
    private int idatMaxSize = 0;
    private final OutputStream os;
    protected byte[] rowb = null;
    protected byte[] rowbfilter = null;
    protected byte[] rowbprev = null;
    private boolean unpackedMode = false;

    public PngWriter(OutputStream outputStream, ImageInfo imageInfo) {
        this(outputStream, imageInfo, "[NO FILENAME AVAILABLE]");
    }

    public PngWriter(OutputStream outputStream, ImageInfo imageInfo, String string) {
        this.filename = string == null ? "" : string;
        this.os = outputStream;
        this.imgInfo = imageInfo;
        this.rowb = new byte[imageInfo.bytesPerRow + 1];
        this.rowbprev = new byte[this.rowb.length];
        this.rowbfilter = new byte[this.rowb.length];
        this.chunksList = new ChunksListForWrite(imageInfo);
        this.metadata = new PngMetadata(this.chunksList);
        this.filterStrat = new FilterWriteStrategy(imageInfo, FilterType.FILTER_DEFAULT);
    }

    private void init() {
        this.datStream = new PngIDatChunkOutputStream(this.os, this.idatMaxSize);
        Deflater deflater = new Deflater(this.compLevel);
        deflater.setStrategy(this.deflaterStrategy);
        this.datStreamDeflated = new DeflaterOutputStream((OutputStream)this.datStream, deflater);
        this.writeSignatureAndIHDR();
        this.writeFirstChunks();
    }

    private void reportResultsForFilter(int n, FilterType filterType, boolean bl) {
        Arrays.fill(this.histox, 0);
        int n2 = 0;
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            byte by = this.rowbfilter[i];
            n2 = by < 0 ? (n2 -= by) : (n2 += by);
            int n3 = by & 0xFF;
            this.histox[n3] = this.histox[n3] + 1;
        }
        this.filterStrat.fillResultsForFilter(n, filterType, n2, this.histox, bl);
    }

    private void writeEndChunk() {
        PngChunkIEND pngChunkIEND = new PngChunkIEND(this.imgInfo);
        pngChunkIEND.createRawChunk().writeChunk(this.os);
    }

    private void writeFirstChunks() {
        int n = 0;
        this.currentChunkGroup = 1;
        n = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 2;
        n = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        if (n > 0 && this.imgInfo.greyscale) {
            throw new PngjOutputException("cannot write palette for this format");
        }
        if (n == 0 && this.imgInfo.indexed) {
            throw new PngjOutputException("missing palette");
        }
        this.currentChunkGroup = 3;
        n = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 4;
    }

    private void writeLastChunks() {
        this.currentChunkGroup = 5;
        this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        List<PngChunk> list = this.chunksList.getQueuedChunks();
        if (!list.isEmpty()) {
            throw new PngjOutputException(list.size() + " chunks were not written! Eg: " + list.get(0).toString());
        }
        this.currentChunkGroup = 6;
    }

    private void writeSignatureAndIHDR() {
        this.currentChunkGroup = 0;
        PngHelperInternal.writeBytes(this.os, PngHelperInternal.getPngIdSignature());
        PngChunkIHDR pngChunkIHDR = new PngChunkIHDR(this.imgInfo);
        pngChunkIHDR.setCols(this.imgInfo.cols);
        pngChunkIHDR.setRows(this.imgInfo.rows);
        pngChunkIHDR.setBitspc(this.imgInfo.bitDepth);
        int n = 0;
        if (this.imgInfo.alpha) {
            n += 4;
        }
        if (this.imgInfo.indexed) {
            ++n;
        }
        if (!this.imgInfo.greyscale) {
            n += 2;
        }
        pngChunkIHDR.setColormodel(n);
        pngChunkIHDR.setCompmeth(0);
        pngChunkIHDR.setFilmeth(0);
        pngChunkIHDR.setInterlaced(0);
        pngChunkIHDR.createRawChunk().writeChunk(this.os);
    }

    protected void encodeRowFromByte(byte[] byArray) {
        if (byArray.length == this.imgInfo.samplesPerRowPacked) {
            int n = 1;
            if (this.imgInfo.bitDepth <= 8) {
                for (byte by : byArray) {
                    this.rowb[n++] = by;
                }
            } else {
                byte[] byArray2 = byArray;
                int n2 = byArray2.length;
                for (int i = 0; i < n2; ++i) {
                    byte by;
                    this.rowb[n] = by = byArray2[i];
                    n += 2;
                }
            }
        } else {
            if (byArray.length >= this.imgInfo.samplesPerRow && this.unpackedMode) {
                ImageLine.packInplaceByte(this.imgInfo, byArray, byArray, false);
            }
            if (this.imgInfo.bitDepth <= 8) {
                int n = 1;
                for (int i = 0; i < this.imgInfo.samplesPerRowPacked; ++i) {
                    this.rowb[n++] = byArray[i];
                }
            } else {
                int n = 1;
                for (int i = 0; i < this.imgInfo.samplesPerRowPacked; ++i) {
                    this.rowb[n++] = byArray[i];
                    this.rowb[n++] = 0;
                }
            }
        }
    }

    protected void encodeRowFromInt(int[] nArray) {
        if (nArray.length == this.imgInfo.samplesPerRowPacked) {
            int n = 1;
            if (this.imgInfo.bitDepth <= 8) {
                for (int n2 : nArray) {
                    this.rowb[n++] = (byte)n2;
                }
            } else {
                for (int n3 : nArray) {
                    this.rowb[n++] = (byte)(n3 >> 8);
                    this.rowb[n++] = (byte)n3;
                }
            }
        } else {
            if (nArray.length >= this.imgInfo.samplesPerRow && this.unpackedMode) {
                ImageLine.packInplaceInt(this.imgInfo, nArray, nArray, false);
            }
            if (this.imgInfo.bitDepth <= 8) {
                int n = 1;
                for (int i = 0; i < this.imgInfo.samplesPerRowPacked; ++i) {
                    this.rowb[n++] = (byte)nArray[i];
                }
            } else {
                int n = 1;
                for (int i = 0; i < this.imgInfo.samplesPerRowPacked; ++i) {
                    this.rowb[n++] = (byte)(nArray[i] >> 8);
                    this.rowb[n++] = (byte)nArray[i];
                }
            }
        }
    }

    private void filterRow(int n) {
        if (this.filterStrat.shouldTestAll(n)) {
            this.filterRowNone();
            this.reportResultsForFilter(n, FilterType.FILTER_NONE, true);
            this.filterRowSub();
            this.reportResultsForFilter(n, FilterType.FILTER_SUB, true);
            this.filterRowUp();
            this.reportResultsForFilter(n, FilterType.FILTER_UP, true);
            this.filterRowAverage();
            this.reportResultsForFilter(n, FilterType.FILTER_AVERAGE, true);
            this.filterRowPaeth();
            this.reportResultsForFilter(n, FilterType.FILTER_PAETH, true);
        }
        FilterType filterType = this.filterStrat.gimmeFilterType(n, true);
        this.rowbfilter[0] = (byte)filterType.val;
        switch (filterType) {
            case FILTER_NONE: {
                this.filterRowNone();
                break;
            }
            case FILTER_SUB: {
                this.filterRowSub();
                break;
            }
            case FILTER_UP: {
                this.filterRowUp();
                break;
            }
            case FILTER_AVERAGE: {
                this.filterRowAverage();
                break;
            }
            case FILTER_PAETH: {
                this.filterRowPaeth();
                break;
            }
            default: {
                throw new PngjUnsupportedException("Filter type " + (Object)((Object)filterType) + " not implemented");
            }
        }
        this.reportResultsForFilter(n, filterType, false);
    }

    private void prepareEncodeRow(int n) {
        if (this.datStream == null) {
            this.init();
        }
        ++this.rowNum;
        if (n >= 0 && this.rowNum != n) {
            throw new PngjOutputException("rows must be written in order: expected:" + this.rowNum + " passed:" + n);
        }
        byte[] byArray = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = byArray;
    }

    private void filterAndSend(int n) {
        this.filterRow(n);
        try {
            this.datStreamDeflated.write(this.rowbfilter, 0, this.imgInfo.bytesPerRow + 1);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    protected void filterRowAverage() {
        int n = this.imgInfo.bytesPerRow;
        int n2 = 1 - this.imgInfo.bytesPixel;
        int n3 = 1;
        while (n3 <= n) {
            this.rowbfilter[n3] = (byte)(this.rowb[n3] - ((this.rowbprev[n3] & 0xFF) + (n2 > 0 ? this.rowb[n2] & 0xFF : 0)) / 2);
            ++n3;
            ++n2;
        }
    }

    protected void filterRowNone() {
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            this.rowbfilter[i] = this.rowb[i];
        }
    }

    protected void filterRowPaeth() {
        int n = this.imgInfo.bytesPerRow;
        int n2 = 1 - this.imgInfo.bytesPixel;
        int n3 = 1;
        while (n3 <= n) {
            this.rowbfilter[n3] = (byte)PngHelperInternal.filterRowPaeth(this.rowb[n3], n2 > 0 ? this.rowb[n2] & 0xFF : 0, this.rowbprev[n3] & 0xFF, n2 > 0 ? this.rowbprev[n2] & 0xFF : 0);
            ++n3;
            ++n2;
        }
    }

    protected void filterRowSub() {
        int n;
        for (n = 1; n <= this.imgInfo.bytesPixel; ++n) {
            this.rowbfilter[n] = this.rowb[n];
        }
        int n2 = 1;
        n = this.imgInfo.bytesPixel + 1;
        while (n <= this.imgInfo.bytesPerRow) {
            this.rowbfilter[n] = (byte)PngHelperInternal.filterRowSub(this.rowb[n], this.rowb[n2]);
            ++n;
            ++n2;
        }
    }

    protected void filterRowUp() {
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            this.rowbfilter[i] = (byte)PngHelperInternal.filterRowUp(this.rowb[i], this.rowbprev[i]);
        }
    }

    protected int sumRowbfilter() {
        int n = 0;
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            if (this.rowbfilter[i] < 0) {
                n -= this.rowbfilter[i];
                continue;
            }
            n += this.rowbfilter[i];
        }
        return n;
    }

    private void copyChunks(PngReader pngReader, int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.currentChunkGroup >= 4;
        if (bl && pngReader.getCurrentChunkGroup() < 6) {
            throw new PngjExceptionInternal("tried to copy last chunks but reader has not ended");
        }
        for (PngChunk pngChunk : pngReader.getChunksList().getChunks()) {
            int n2 = pngChunk.getChunkGroup();
            if (n2 < 4 && bl2) continue;
            boolean bl4 = false;
            if (pngChunk.crit) {
                if (pngChunk.id.equals("PLTE")) {
                    if (this.imgInfo.indexed && ChunkHelper.maskMatch(n, 1)) {
                        bl4 = true;
                    }
                    if (!this.imgInfo.greyscale && ChunkHelper.maskMatch(n, 8)) {
                        bl4 = true;
                    }
                }
            } else {
                boolean bl5 = pngChunk instanceof PngChunkTextVar;
                boolean bl6 = pngChunk.safe;
                if (ChunkHelper.maskMatch(n, 8)) {
                    bl4 = true;
                }
                if (bl6 && ChunkHelper.maskMatch(n, 4)) {
                    bl4 = true;
                }
                if (pngChunk.id.equals("tRNS") && ChunkHelper.maskMatch(n, 64)) {
                    bl4 = true;
                }
                if (pngChunk.id.equals("pHYs") && ChunkHelper.maskMatch(n, 16)) {
                    bl4 = true;
                }
                if (bl5 && ChunkHelper.maskMatch(n, 32)) {
                    bl4 = true;
                }
                if (!(!ChunkHelper.maskMatch(n, 256) || ChunkHelper.isUnknown(pngChunk) || bl5 || pngChunk.id.equals("hIST") || pngChunk.id.equals("tIME"))) {
                    bl4 = true;
                }
                if (pngChunk instanceof PngChunkSkipped) {
                    bl4 = false;
                }
            }
            if (!bl4) continue;
            this.chunksList.queue(PngChunk.cloneChunk(pngChunk, this.imgInfo));
        }
    }

    public void copyChunksFirst(PngReader pngReader, int n) {
        this.copyChunks(pngReader, n, false);
    }

    public void copyChunksLast(PngReader pngReader, int n) {
        this.copyChunks(pngReader, n, true);
    }

    public double computeCompressionRatio() {
        if (this.currentChunkGroup < 6) {
            throw new PngjOutputException("must be called after end()");
        }
        double d = this.datStream.getCountFlushed();
        double d2 = (this.imgInfo.bytesPerRow + 1) * this.imgInfo.rows;
        return d / d2;
    }

    public void end() {
        if (this.rowNum != this.imgInfo.rows - 1) {
            throw new PngjOutputException("all rows have not been written");
        }
        try {
            this.datStreamDeflated.finish();
            this.datStream.flush();
            this.writeLastChunks();
            this.writeEndChunk();
            if (this.shouldCloseStream) {
                this.os.close();
            }
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public ChunksListForWrite getChunksList() {
        return this.chunksList;
    }

    public String getFilename() {
        return this.filename;
    }

    public PngMetadata getMetadata() {
        return this.metadata;
    }

    public void setCompLevel(int n) {
        if (n < 0 || n > 9) {
            throw new PngjOutputException("Compression level invalid (" + n + ") Must be 0..9");
        }
        this.compLevel = n;
    }

    public void setFilterType(FilterType filterType) {
        this.filterStrat = new FilterWriteStrategy(this.imgInfo, filterType);
    }

    public void setIdatMaxSize(int n) {
        this.idatMaxSize = n;
    }

    public void setShouldCloseStream(boolean bl) {
        this.shouldCloseStream = bl;
    }

    public void setDeflaterStrategy(int n) {
        this.deflaterStrategy = n;
    }

    public void writeRow(ImageLine imageLine) {
        this.writeRow(imageLine.scanline, imageLine.getRown());
    }

    public void writeRow(ImageLine imageLine, int n) {
        this.unpackedMode = imageLine.samplesUnpacked;
        if (imageLine.sampleType == ImageLine.SampleType.INT) {
            this.writeRowInt(imageLine.scanline, n);
        } else {
            this.writeRowByte(imageLine.scanlineb, n);
        }
    }

    public void writeRow(int[] nArray) {
        this.writeRow(nArray, -1);
    }

    public void writeRow(int[] nArray, int n) {
        this.writeRowInt(nArray, n);
    }

    public void writeRowInt(int[] nArray, int n) {
        this.prepareEncodeRow(n);
        this.encodeRowFromInt(nArray);
        this.filterAndSend(n);
    }

    public void writeRowByte(byte[] byArray, int n) {
        this.prepareEncodeRow(n);
        this.encodeRowFromByte(byArray);
        this.filterAndSend(n);
    }

    public void writeRowsInt(int[][] nArray) {
        for (int i = 0; i < this.imgInfo.rows; ++i) {
            this.writeRowInt(nArray[i], i);
        }
    }

    public void writeRowsByte(byte[][] byArray) {
        for (int i = 0; i < this.imgInfo.rows; ++i) {
            this.writeRowByte(byArray[i], i);
        }
    }

    public boolean isUnpackedMode() {
        return this.unpackedMode;
    }

    public void setUseUnPackedMode(boolean bl) {
        this.unpackedMode = bl;
    }
}

