

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Add points before and after bends in routes (bend){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Add points before and after bends in routes (bend)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="Data_Filters.html">Prev</a> </td><th width="60%" align="center">Chapter 4. Data Filters</th><td width="20%" align="right"> <a accesskey="n" href="filter_polygon.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="filter_bend"></a>Add points before and after bends in routes (bend)</h2></div></div></div><p>The bend filter modifies each route replacing each point inside a
curve with two points: one at a given distance in the direction of the
previous point, and another at the same distance in the direction of
the next point in the route. It only replaces points where there is a
change in heading big enough.</p><p>When creating a route, points are usually created inside curves or
intersections. That means that, while navigating that route using a
GPS unit, the course pointer would aim to the inside of that curve or
intersection, and only when you have passed that point will the GPS 
aim to the next waypoint in the route. This behaviour is useful in
marine navigation but when biking, for instance, it may be a bit late
to decide where to turn to in an intersection.</p><p>This filter tries to solve that creating a waypoint before and after
where there is a change in direction.That way, the course pointer will
point to the direction you should turn to ahead in time.</p><p>For this filter to work correctly, the route should be simple enough
that there is only one waypoint inside each curve or intersection.
Because of that, it is usually a good idea to use the simplify filter
before this one.</p><p>This command line reads route.gpx and replaces each point with other two
points: one 25 metres before and another 25 metres after the original
point. It replaces a point only if there is a change of direction
larger than 5 degrees.</p><p><strong class="userinput"><code>gpsbabel -i gpx -f route.gpx -x
bend,distance=25,interpolate,minangle=5 -o gpx -F newroute.gpx
</code></strong></p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_bend_o_distance"></a>distance option</h3></div></div></div><p>
      Distance to the bend in meters where the new points will be added.
    </p><p>Distance in meters to the original point where the new points will be added.</p><p>The new points will be created at this distance. The first one in the
direction of the previous point, ant the second one in the direction
of the next point in the route.</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_bend_o_minangle"></a>minangle option</h3></div></div></div><p>
      Minimum bend angle in degrees.
    </p><p>Minimum curve angle in degrees.</p><p>The substitution will only be made if the change in the heading is
greater than this value. This avoids replacing a point if the GPS unit
is already pointing in the correct direction, or if the route reaches
a certain point and goes back the same road.</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="Data_Filters.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Data_Filters.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="filter_polygon.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Chapter 4. Data Filters </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Include Only Points Inside Polygon (polygon)</td></tr></table></div>
  
      {/literal}{/block}
  