/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultFileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.DefaultFileDetails;
import org.gradle.api.internal.changedetection.state.DirSnapshot;
import org.gradle.api.internal.changedetection.state.DirectoryTreeDetails;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileDetails;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.FileSystemMirror;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.SnapshotNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.internal.nativeintegration.filesystem.FileMetadataSnapshot;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.FileType;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileCollectionSnapshotter
implements FileCollectionSnapshotter {
    private final FileHasher hasher;
    private final StringInterner stringInterner;
    private final FileSystem fileSystem;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final FileSystemMirror fileSystemMirror;

    public AbstractFileCollectionSnapshotter(FileHasher hasher, StringInterner stringInterner, FileSystem fileSystem, DirectoryFileTreeFactory directoryFileTreeFactory, FileSystemMirror fileSystemMirror) {
        this.hasher = hasher;
        this.stringInterner = stringInterner;
        this.fileSystem = fileSystem;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.fileSystemMirror = fileSystemMirror;
    }

    @Override
    public void registerSerializers(SerializerRegistry registry) {
        registry.register(DefaultFileCollectionSnapshot.class, (Serializer)new DefaultFileCollectionSnapshot.SerializerImpl(this.stringInterner));
    }

    @Override
    public FileCollectionSnapshot snapshot(FileCollection input, TaskFilePropertyCompareStrategy compareStrategy, SnapshotNormalizationStrategy snapshotNormalizationStrategy) {
        LinkedList fileTreeElements = Lists.newLinkedList();
        FileCollectionInternal fileCollection = (FileCollectionInternal)input;
        FileCollectionVisitorImpl visitor = new FileCollectionVisitorImpl(fileTreeElements);
        fileCollection.visitRootElements(visitor);
        if (fileTreeElements.isEmpty()) {
            return FileCollectionSnapshot.EMPTY;
        }
        LinkedHashMap snapshots = Maps.newLinkedHashMap();
        for (FileDetails fileDetails : fileTreeElements) {
            NormalizedFileSnapshot normalizedSnapshot;
            String absolutePath = fileDetails.getPath();
            if (snapshots.containsKey(absolutePath) || (normalizedSnapshot = snapshotNormalizationStrategy.getNormalizedSnapshot(fileDetails, this.stringInterner)) == null) continue;
            snapshots.put(absolutePath, normalizedSnapshot);
        }
        return new DefaultFileCollectionSnapshot(snapshots, compareStrategy, snapshotNormalizationStrategy.isPathAbsolute());
    }

    private DirSnapshot dirSnapshot() {
        return DirSnapshot.getInstance();
    }

    private MissingFileSnapshot missingFileSnapshot() {
        return MissingFileSnapshot.getInstance();
    }

    private FileHashSnapshot fileSnapshot(FileTreeElement fileDetails) {
        return new FileHashSnapshot(this.hasher.hash(fileDetails), fileDetails.getLastModified());
    }

    private FileHashSnapshot fileSnapshot(File file, FileMetadataSnapshot fileDetails) {
        return new FileHashSnapshot(this.hasher.hash(file, fileDetails), fileDetails.getLastModified());
    }

    private String getPath(File file) {
        return this.stringInterner.intern(file.getAbsolutePath());
    }

    protected List<FileDetails> normaliseTreeElements(List<FileDetails> treeNonRootElements) {
        return treeNonRootElements;
    }

    protected FileDetails normaliseFileElement(FileDetails details) {
        return details;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileVisitorImpl
    implements FileVisitor {
        private final List<FileDetails> fileTreeElements;

        FileVisitorImpl(List<FileDetails> fileTreeElements) {
            this.fileTreeElements = fileTreeElements;
        }

        @Override
        public void visitDir(FileVisitDetails dirDetails) {
            this.fileTreeElements.add(new DefaultFileDetails(AbstractFileCollectionSnapshotter.this.getPath(dirDetails.getFile()), dirDetails.getRelativePath(), FileType.Directory, false, AbstractFileCollectionSnapshotter.this.dirSnapshot()));
        }

        @Override
        public void visitFile(FileVisitDetails fileDetails) {
            this.fileTreeElements.add(new DefaultFileDetails(AbstractFileCollectionSnapshotter.this.getPath(fileDetails.getFile()), fileDetails.getRelativePath(), FileType.RegularFile, false, AbstractFileCollectionSnapshotter.this.fileSnapshot(fileDetails)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileCollectionVisitorImpl
    implements FileCollectionVisitor {
        private final List<FileDetails> fileTreeElements;

        FileCollectionVisitorImpl(List<FileDetails> fileTreeElements) {
            this.fileTreeElements = fileTreeElements;
        }

        @Override
        public void visitCollection(FileCollectionInternal fileCollection) {
            block5: for (File file : fileCollection) {
                FileDetails details = AbstractFileCollectionSnapshotter.this.fileSystemMirror.getFile(file.getPath());
                if (details == null) {
                    details = this.calculateDetails(file);
                    AbstractFileCollectionSnapshotter.this.fileSystemMirror.putFile(details);
                }
                switch (details.getType()) {
                    case Missing: {
                        this.fileTreeElements.add(details);
                        continue block5;
                    }
                    case RegularFile: {
                        this.fileTreeElements.add(AbstractFileCollectionSnapshotter.this.normaliseFileElement(details));
                        continue block5;
                    }
                    case Directory: {
                        this.fileTreeElements.add(details);
                        this.visitDirectoryTree(AbstractFileCollectionSnapshotter.this.directoryFileTreeFactory.create(file));
                        continue block5;
                    }
                }
                throw new AssertionError();
            }
        }

        private DefaultFileDetails calculateDetails(File file) {
            String path = AbstractFileCollectionSnapshotter.this.getPath(file);
            FileMetadataSnapshot stat = AbstractFileCollectionSnapshotter.this.fileSystem.stat(file);
            switch (stat.getType()) {
                case Missing: {
                    return new DefaultFileDetails(path, new RelativePath(true, file.getName()), FileType.Missing, true, AbstractFileCollectionSnapshotter.this.missingFileSnapshot());
                }
                case Directory: {
                    return new DefaultFileDetails(path, new RelativePath(false, file.getName()), FileType.Directory, true, AbstractFileCollectionSnapshotter.this.dirSnapshot());
                }
                case RegularFile: {
                    return new DefaultFileDetails(path, new RelativePath(true, file.getName()), FileType.RegularFile, true, AbstractFileCollectionSnapshotter.this.fileSnapshot(file, stat));
                }
            }
            throw new IllegalArgumentException("Unrecognized file type: " + stat.getType());
        }

        @Override
        public void visitTree(FileTreeInternal fileTree) {
            List<Object> elements = Lists.newArrayList();
            fileTree.visitTreeOrBackingFile(new FileVisitorImpl(elements));
            elements = AbstractFileCollectionSnapshotter.this.normaliseTreeElements(elements);
            this.fileTreeElements.addAll(elements);
        }

        @Override
        public void visitDirectoryTree(DirectoryFileTree directoryTree) {
            List<Object> elements;
            if (!directoryTree.getPatterns().isEmpty()) {
                elements = Lists.newArrayList();
                directoryTree.visit(new FileVisitorImpl(elements));
            } else {
                DirectoryTreeDetails treeDetails = AbstractFileCollectionSnapshotter.this.fileSystemMirror.getDirectoryTree(directoryTree.getDir().getAbsolutePath());
                if (treeDetails != null) {
                    elements = treeDetails.elements;
                } else {
                    String path = AbstractFileCollectionSnapshotter.this.getPath(directoryTree.getDir());
                    elements = Lists.newArrayList();
                    directoryTree.visit(new FileVisitorImpl(elements));
                    DirectoryTreeDetails details = new DirectoryTreeDetails(path, (List<FileDetails>)ImmutableList.copyOf((Collection)elements));
                    AbstractFileCollectionSnapshotter.this.fileSystemMirror.putDirectory(details);
                }
            }
            elements = AbstractFileCollectionSnapshotter.this.normaliseTreeElements(elements);
            this.fileTreeElements.addAll(elements);
        }
    }
}

