/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.tasks.TaskState;
import org.gradle.caching.internal.tasks.statistics.TaskExecutionStatistics;
import org.gradle.caching.internal.tasks.statistics.TaskExecutionStatisticsListener;
import org.gradle.initialization.BuildCompletionListener;

public class TaskExecutionStatisticsEventAdapter
implements BuildCompletionListener,
TaskExecutionListener {
    private final TaskExecutionStatisticsListener listener;
    private final Map<TaskExecutionOutcome, Integer> taskCounts = Maps.newEnumMap((Map)Maps.toMap(Arrays.asList(TaskExecutionOutcome.values()), (Function)Functions.constant((Object)0)));
    private int cacheMissCount;

    public TaskExecutionStatisticsEventAdapter(TaskExecutionStatisticsListener listener) {
        this.listener = listener;
    }

    public void completed() {
        this.listener.buildFinished(new TaskExecutionStatistics(this.taskCounts, this.cacheMissCount));
    }

    public void beforeExecute(Task task) {
    }

    public void afterExecute(Task task, TaskState state) {
        TaskStateInternal stateInternal = (TaskStateInternal)state;
        TaskExecutionOutcome outcome = stateInternal.getOutcome();
        this.taskCounts.put(outcome, this.taskCounts.get((Object)outcome) + 1);
        if (outcome == TaskExecutionOutcome.EXECUTED && stateInternal.getTaskOutputCaching().isEnabled()) {
            ++this.cacheMissCount;
        }
    }
}

