/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import com.google.common.hash.HashCode;
import com.google.common.io.Files;
import groovy.lang.Script;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.codehaus.groovy.ast.ClassNode;
import org.gradle.api.Action;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.PersistentCache;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.RemappingScriptSource;
import org.gradle.groovy.scripts.internal.ScriptClassCompiler;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCacheBackedScriptClassCompiler
implements ScriptClassCompiler,
Closeable {
    private final ScriptCompilationHandler scriptCompilationHandler;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final CacheRepository cacheRepository;
    private final CacheValidator validator;
    private final FileHasher hasher;
    private final ClassLoaderCache classLoaderCache;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;

    public FileCacheBackedScriptClassCompiler(CacheRepository cacheRepository, CacheValidator validator, ScriptCompilationHandler scriptCompilationHandler, ProgressLoggerFactory progressLoggerFactory, FileHasher hasher, ClassLoaderCache classLoaderCache, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        this.cacheRepository = cacheRepository;
        this.validator = validator;
        this.scriptCompilationHandler = scriptCompilationHandler;
        this.progressLoggerFactory = progressLoggerFactory;
        this.hasher = hasher;
        this.classLoaderCache = classLoaderCache;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
    }

    @Override
    public <T extends Script, M> CompiledScript<T, M> compile(ScriptSource source, ClassLoader classLoader, ClassLoaderId classLoaderId, CompileOperation<M> operation, Class<T> scriptBaseClass, Action<? super ClassNode> verifier) {
        assert (source.getResource().isContentCached());
        if (source.getResource().getHasEmptyContent()) {
            return this.emptyCompiledScript(classLoaderId, operation);
        }
        HashCode sourceHashCode = this.hasher.hash(source.getResource());
        String sourceHash = HashUtil.compactStringFor((HashCode)sourceHashCode);
        String dslId = operation.getId();
        HashCode classLoaderHash = this.classLoaderHierarchyHasher.getClassLoaderHash(classLoader);
        if (classLoaderHash == null) {
            throw new IllegalArgumentException("Unknown classloader: " + classLoader);
        }
        String classpathHash = dslId + classLoaderHash;
        RemappingScriptSource remapped = new RemappingScriptSource(source);
        PersistentCache remappedClassesCache = this.cacheRepository.cache("scripts-remapped/" + source.getClassName() + "/" + sourceHash + "/" + classpathHash).withDisplayName(dslId + " remapped class cache for " + sourceHash).withValidator(this.validator).withInitializer(new ProgressReportingInitializer(this.progressLoggerFactory, new RemapBuildScriptsAction<M, T>(remapped, classpathHash, sourceHash, dslId, classLoader, operation, verifier, scriptBaseClass), "Compiling script into cache", "Compiling " + source.getFileName() + " into local build cache")).open();
        remappedClassesCache.close();
        File remappedClassesDir = this.classesDir(remappedClassesCache);
        File remappedMetadataDir = this.metadataDir(remappedClassesCache);
        return this.scriptCompilationHandler.loadFromDir(source, sourceHashCode, classLoader, remappedClassesDir, remappedMetadataDir, operation, scriptBaseClass, classLoaderId);
    }

    private <T extends Script, M> CompiledScript<T, M> emptyCompiledScript(ClassLoaderId classLoaderId, CompileOperation<M> operation) {
        this.classLoaderCache.remove(classLoaderId);
        return new EmptyCompiledScript(operation);
    }

    @Override
    public void close() {
    }

    private File classesDir(PersistentCache cache) {
        return new File(cache.getBaseDir(), "classes");
    }

    private File metadataDir(PersistentCache cache) {
        return new File(cache.getBaseDir(), "metadata");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemapBuildScriptsAction<M, T extends Script>
    implements Action<PersistentCache> {
        private final String classpathHash;
        private final String sourceHash;
        private final String dslId;
        private final ScriptSource source;
        private final RemappingScriptSource remapped;
        private final ClassLoader classLoader;
        private final CompileOperation<M> operation;
        private final Action<? super ClassNode> verifier;
        private final Class<T> scriptBaseClass;

        public RemapBuildScriptsAction(RemappingScriptSource remapped, String classpathHash, String sourceHash, String dslId, ClassLoader classLoader, CompileOperation<M> operation, Action<? super ClassNode> verifier, Class<T> scriptBaseClass) {
            this.classpathHash = classpathHash;
            this.sourceHash = sourceHash;
            this.dslId = dslId;
            this.remapped = remapped;
            this.source = remapped.getSource();
            this.classLoader = classLoader;
            this.operation = operation;
            this.verifier = verifier;
            this.scriptBaseClass = scriptBaseClass;
        }

        public void execute(PersistentCache remappedClassesCache) {
            PersistentCache cache = FileCacheBackedScriptClassCompiler.this.cacheRepository.cache("scripts/" + this.sourceHash + "/" + this.dslId + "/" + this.classpathHash).withValidator(FileCacheBackedScriptClassCompiler.this.validator).withDisplayName(this.dslId + " generic class cache for " + this.source.getDisplayName()).withInitializer(new ProgressReportingInitializer(FileCacheBackedScriptClassCompiler.this.progressLoggerFactory, new CompileToCrossBuildCacheAction(this.remapped, this.classLoader, this.operation, this.verifier, this.scriptBaseClass), "Compiling script into cache", "Compiling " + this.source.getDisplayName() + " to cross build script cache")).open();
            cache.close();
            File genericClassesDir = FileCacheBackedScriptClassCompiler.this.classesDir(cache);
            File metadataDir = FileCacheBackedScriptClassCompiler.this.metadataDir(cache);
            this.remapClasses(genericClassesDir, FileCacheBackedScriptClassCompiler.this.classesDir(remappedClassesCache), this.remapped);
            this.copyMetadata(metadataDir, FileCacheBackedScriptClassCompiler.this.metadataDir(remappedClassesCache));
        }

        private void remapClasses(File scriptCacheDir, File relocalizedDir, RemappingScriptSource source) {
            File[] files;
            ScriptSource origin = source.getSource();
            String className = origin.getClassName();
            if (!relocalizedDir.exists()) {
                relocalizedDir.mkdir();
            }
            if ((files = scriptCacheDir.listFiles()) != null) {
                for (File file : files) {
                    String renamed = file.getName();
                    if (renamed.startsWith("_BuildScript_")) {
                        renamed = className + renamed.substring("_BuildScript_".length());
                    }
                    ClassWriter cv = new ClassWriter(0);
                    BuildScriptRemapper remapper = new BuildScriptRemapper((ClassVisitor)cv, origin);
                    try {
                        ClassReader cr = new ClassReader(Files.toByteArray((File)file));
                        cr.accept((ClassVisitor)remapper, 0);
                        Files.write((byte[])cv.toByteArray(), (File)new File(relocalizedDir, renamed));
                    }
                    catch (IOException ex) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)ex);
                    }
                }
            }
        }

        private void copyMetadata(File source, File dest) {
            if (dest.mkdir()) {
                for (File src : source.listFiles()) {
                    try {
                        Files.copy((File)src, (File)new File(dest, src.getName()));
                    }
                    catch (IOException ex) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)ex);
                    }
                }
            }
        }
    }

    private static class BuildScriptRemapper
    extends ClassVisitor
    implements Opcodes {
        private final ScriptSource scriptSource;

        public BuildScriptRemapper(ClassVisitor cv, ScriptSource source) {
            super(327680, cv);
            this.scriptSource = source;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.cv.visit(version, access, this.remap(name), this.remap(signature), this.remap(superName), this.remap(interfaces));
        }

        public void visitSource(String source, String debug) {
            this.cv.visitSource(this.scriptSource.getFileName(), debug);
        }

        private String[] remap(String[] names) {
            if (names == null) {
                return null;
            }
            String[] remapped = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                remapped[i] = this.remap(names[i]);
            }
            return remapped;
        }

        private String remap(String name) {
            if (name == null) {
                return null;
            }
            return name.replaceAll("_BuildScript_", this.scriptSource.getClassName());
        }

        private Object remap(Object o) {
            if (o instanceof Type) {
                return Type.getType((String)this.remap(((Type)o).getDescriptor()));
            }
            if ("@@sourceuri@@".equals(o)) {
                URI uri = this.scriptSource.getResource().getLocation().getURI();
                return uri == null ? null : uri.toString();
            }
            if ("@@sourcedesc@@".equals(o)) {
                return this.scriptSource.getDisplayName();
            }
            return o;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, this.remap(desc), this.remap(signature), this.remap(exceptions));
            if (mv != null && (access & 0x400) == 0) {
                mv = new MethodRenamer(mv);
            }
            return mv;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return super.visitField(access, name, this.remap(desc), this.remap(signature), this.remap(value));
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            super.visitInnerClass(this.remap(name), this.remap(outerName), this.remap(innerName), access);
        }

        public void visitOuterClass(String owner, String name, String desc) {
            super.visitOuterClass(this.remap(owner), this.remap(name), this.remap(desc));
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return super.visitAnnotation(this.remap(desc), visible);
        }

        class MethodRenamer
        extends MethodVisitor {
            public MethodRenamer(MethodVisitor mv) {
                super(327680, mv);
            }

            public void visitTypeInsn(int i, String name) {
                this.mv.visitTypeInsn(i, BuildScriptRemapper.this.remap(name));
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                this.mv.visitFieldInsn(opcode, BuildScriptRemapper.this.remap(owner), name, BuildScriptRemapper.this.remap(desc));
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean intf) {
                this.mv.visitMethodInsn(opcode, BuildScriptRemapper.this.remap(owner), name, BuildScriptRemapper.this.remap(desc), intf);
            }

            public void visitLdcInsn(Object cst) {
                super.visitLdcInsn(BuildScriptRemapper.this.remap(cst));
            }

            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                super.visitLocalVariable(name, BuildScriptRemapper.this.remap(desc), BuildScriptRemapper.this.remap(signature), start, end, index);
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return super.visitAnnotation(BuildScriptRemapper.this.remap(desc), visible);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyCompiledScript<T extends Script, M>
    implements CompiledScript<T, M> {
        private final M data;

        public EmptyCompiledScript(CompileOperation<M> operation) {
            this.data = operation.getExtractedData();
        }

        @Override
        public boolean getRunDoesSomething() {
            return false;
        }

        @Override
        public boolean getHasMethods() {
            return false;
        }

        @Override
        public Class<? extends T> loadClass() {
            throw new UnsupportedOperationException("Cannot load a script that does nothing.");
        }

        @Override
        public M getData() {
            return this.data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProgressReportingInitializer
    implements Action<PersistentCache> {
        private ProgressLoggerFactory progressLoggerFactory;
        private Action<? super PersistentCache> delegate;
        private final String shortDescription;
        private final String longDescription;

        public ProgressReportingInitializer(ProgressLoggerFactory progressLoggerFactory, Action<PersistentCache> delegate, String shortDescription, String longDescription) {
            this.progressLoggerFactory = progressLoggerFactory;
            this.delegate = delegate;
            this.shortDescription = shortDescription;
            this.longDescription = longDescription;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(PersistentCache cache) {
            ProgressLogger op = this.progressLoggerFactory.newOperation(FileCacheBackedScriptClassCompiler.class).start(this.shortDescription, this.longDescription);
            try {
                this.delegate.execute((Object)cache);
            }
            finally {
                op.completed();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompileToCrossBuildCacheAction
    implements Action<PersistentCache> {
        private final Action<? super ClassNode> verifier;
        private final Class<? extends Script> scriptBaseClass;
        private final ClassLoader classLoader;
        private final CompileOperation<?> transformer;
        private final ScriptSource source;

        public <T extends Script> CompileToCrossBuildCacheAction(ScriptSource source, ClassLoader classLoader, CompileOperation<?> transformer, Action<? super ClassNode> verifier, Class<T> scriptBaseClass) {
            this.source = source;
            this.classLoader = classLoader;
            this.transformer = transformer;
            this.verifier = verifier;
            this.scriptBaseClass = scriptBaseClass;
        }

        public void execute(PersistentCache cache) {
            File classesDir = FileCacheBackedScriptClassCompiler.this.classesDir(cache);
            File metadataDir = FileCacheBackedScriptClassCompiler.this.metadataDir(cache);
            FileCacheBackedScriptClassCompiler.this.scriptCompilationHandler.compileToDir(this.source, this.classLoader, classesDir, metadataDir, this.transformer, this.scriptBaseClass, this.verifier);
        }
    }
}

