/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.CompatibilityRuleChainInternal;
import org.gradle.api.internal.attributes.DisambiguationRuleChainInternal;
import org.gradle.internal.Cast;

public class ComponentAttributeMatcher {
    public boolean isMatching(AttributesSchema schema, AttributeContainer candidate, AttributeContainer requested, boolean incompleteCandidate) {
        MatchDetails details = new MatchDetails();
        this.doMatchCandidate(schema, schema, (HasAttributes)candidate, requested, incompleteCandidate, details);
        return details.compatible;
    }

    public List<? extends HasAttributes> match(AttributesSchema consumerAttributeSchema, AttributesSchema producerAttributeSchema, List<HasAttributes> candidates, AttributeContainer requested) {
        return new Matcher(consumerAttributeSchema, producerAttributeSchema, candidates, requested).getMatches();
    }

    private void doMatchCandidate(AttributesSchema consumerAttributeSchema, AttributesSchema producerAttributeSchema, HasAttributes candidate, AttributeContainer requested, boolean incompleteCandidate, MatchDetails details) {
        Set requestedAttributes = (Set)Cast.uncheckedCast((Object)requested.keySet());
        AttributeContainer candidateAttributesContainer = candidate.getAttributes();
        Set dependencyAttributes = (Set)Cast.uncheckedCast((Object)candidateAttributesContainer.keySet());
        Sets.SetView allAttributes = Sets.union((Set)requestedAttributes, (Set)dependencyAttributes);
        for (Attribute attribute : allAttributes) {
            AttributeValue<Object> consumerValue = this.attributeValue((Attribute<Object>)attribute, consumerAttributeSchema, requested);
            AttributeContainer candidateContainerToUse = candidateAttributesContainer;
            if (incompleteCandidate && !candidateAttributesContainer.contains(attribute)) {
                candidateContainerToUse = requested;
            }
            AttributeValue<Object> producerValue = this.attributeValue((Attribute<Object>)attribute, producerAttributeSchema, candidateContainerToUse);
            details.update((Attribute<Object>)attribute, consumerAttributeSchema, producerAttributeSchema, (AttributeValue<Object>)consumerValue, (AttributeValue<Object>)producerValue);
        }
    }

    private AttributeValue<Object> attributeValue(Attribute<Object> attribute, AttributesSchema schema, AttributeContainer container) {
        AttributeValue attributeValue = schema.hasAttribute(attribute) ? (container.contains(attribute) ? AttributeValue.of((Object)container.getAttribute(attribute)) : AttributeValue.missing()) : AttributeValue.unknown();
        return attributeValue;
    }

    private static class CandidateDetails
    implements MultipleCandidatesDetails<Object> {
        private final ListMultimap<Object, HasAttributes> candidatesByValue;
        private final List<HasAttributes> best;

        public CandidateDetails(ListMultimap<Object, HasAttributes> candidatesByValue, List<HasAttributes> best) {
            this.candidatesByValue = candidatesByValue;
            this.best = best;
        }

        public Set<Object> getCandidateValues() {
            return this.candidatesByValue.keySet();
        }

        public void closestMatch(Object candidate) {
            List hasAttributes = this.candidatesByValue.get(candidate);
            for (HasAttributes attributes : hasAttributes) {
                this.best.add(attributes);
            }
        }
    }

    private static class MatchDetails {
        private final Map<Attribute<Object>, Object> matchesByAttribute = Maps.newHashMap();
        private boolean compatible = true;

        private MatchDetails() {
        }

        private void update(final Attribute<Object> attribute, AttributesSchema consumerSchema, AttributesSchema producerSchema, final AttributeValue<Object> consumerValue, final AttributeValue<Object> producerValue) {
            AttributesSchema schemaToUse = consumerSchema;
            boolean missingOrUnknown = false;
            if (consumerValue.isUnknown() || consumerValue.isMissing()) {
                schemaToUse = producerSchema;
                missingOrUnknown = true;
            } else if (producerValue.isUnknown() || producerValue.isMissing()) {
                missingOrUnknown = true;
            }
            AttributeMatchingStrategy strategy = schemaToUse.getMatchingStrategy(attribute);
            CompatibilityRuleChainInternal compatibilityRules = (CompatibilityRuleChainInternal)strategy.getCompatibilityRules();
            if (missingOrUnknown) {
                if (compatibilityRules.isCompatibleWhenMissing()) {
                    if (producerValue.isPresent()) {
                        this.matchesByAttribute.put(attribute, producerValue.get());
                    }
                } else {
                    this.compatible = false;
                }
                return;
            }
            CompatibilityCheckDetails<Object> details = new CompatibilityCheckDetails<Object>(){

                public Object getConsumerValue() {
                    return consumerValue.get();
                }

                public Object getProducerValue() {
                    return producerValue.get();
                }

                public void compatible() {
                    MatchDetails.this.matchesByAttribute.put(attribute, producerValue.get());
                }

                public void incompatible() {
                    MatchDetails.this.compatible = false;
                }
            };
            try {
                compatibilityRules.execute((Object)details);
            }
            catch (Exception ex) {
                throw new GradleException("Unexpected error thrown when trying to match attribute values with " + strategy, (Throwable)ex);
            }
        }
    }

    private class Matcher {
        private final AttributesSchema consumerAttributeSchema;
        private final AttributesSchema producerAttributeSchema;
        private final Map<HasAttributes, MatchDetails> matchDetails = Maps.newHashMap();
        private final AttributeContainer requested;

        public Matcher(AttributesSchema consumerAttributeSchema, AttributesSchema producerAttributeSchema, Iterable<HasAttributes> candidates, AttributeContainer requested) {
            this.consumerAttributeSchema = consumerAttributeSchema;
            this.producerAttributeSchema = producerAttributeSchema;
            for (HasAttributes cand : candidates) {
                if (cand.getAttributes().isEmpty()) continue;
                this.matchDetails.put(cand, new MatchDetails());
            }
            this.requested = requested;
            this.doMatch();
        }

        private void doMatch() {
            for (Map.Entry<HasAttributes, MatchDetails> entry : this.matchDetails.entrySet()) {
                ComponentAttributeMatcher.this.doMatchCandidate(this.consumerAttributeSchema, this.producerAttributeSchema, entry.getKey(), this.requested, false, entry.getValue());
            }
        }

        public List<? extends HasAttributes> getMatches() {
            ArrayList<HasAttributes> matches = new ArrayList<HasAttributes>(1);
            for (Map.Entry<HasAttributes, MatchDetails> entry : this.matchDetails.entrySet()) {
                MatchDetails details = entry.getValue();
                if (!details.compatible) continue;
                matches.add(entry.getKey());
            }
            return this.disambiguateUsingClosestMatch(matches);
        }

        private List<HasAttributes> disambiguateUsingClosestMatch(List<HasAttributes> matchs) {
            if (matchs.size() > 1) {
                return this.selectClosestMatches(matchs);
            }
            return matchs;
        }

        private List<HasAttributes> selectClosestMatches(List<HasAttributes> matchs) {
            ArrayList remainingMatches = Lists.newArrayList(matchs);
            ArrayList best = Lists.newArrayListWithCapacity((int)matchs.size());
            ArrayListMultimap candidatesByValue = ArrayListMultimap.create();
            HashSet allAttributes = Sets.newHashSet();
            for (MatchDetails details : this.matchDetails.values()) {
                allAttributes.addAll(details.matchesByAttribute.keySet());
            }
            for (Attribute attribute : allAttributes) {
                for (HasAttributes match : matchs) {
                    Map matchedAttributes = this.matchDetails.get(match).matchesByAttribute;
                    Object val = matchedAttributes.get(attribute);
                    candidatesByValue.put(val, (Object)match);
                }
                AttributesSchema schemaToUse = this.consumerAttributeSchema.hasAttribute(attribute) ? this.consumerAttributeSchema : this.producerAttributeSchema;
                this.disambiguate(remainingMatches, (ListMultimap<Object, HasAttributes>)candidatesByValue, schemaToUse.getMatchingStrategy(attribute), best);
                if (remainingMatches.isEmpty()) {
                    return matchs;
                }
                candidatesByValue.clear();
                best.clear();
            }
            if (!remainingMatches.isEmpty()) {
                return remainingMatches;
            }
            return null;
        }

        private void disambiguate(List<HasAttributes> remainingMatches, ListMultimap<Object, HasAttributes> candidatesByValue, AttributeMatchingStrategy<?> matchingStrategy, List<HasAttributes> best) {
            if (candidatesByValue.isEmpty()) {
                return;
            }
            AttributeMatchingStrategy ms = (AttributeMatchingStrategy)Cast.uncheckedCast(matchingStrategy);
            CandidateDetails details = new CandidateDetails(candidatesByValue, best);
            DisambiguationRuleChainInternal disambiguationRules = (DisambiguationRuleChainInternal)ms.getDisambiguationRules();
            disambiguationRules.execute((Object)details);
            remainingMatches.retainAll(best);
        }
    }
}

