/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import org.gradle.api.Action;
import org.gradle.internal.Actions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastActionSet<T>
implements Action<T> {
    private Action<T> singleAction;
    private LinkedHashSet<Action<T>> multipleActions;

    public void add(Action<T> action) {
        if (action instanceof FastActionSet) {
            this.addOtherSet((FastActionSet)action);
            return;
        }
        if (action == Actions.DO_NOTHING) {
            return;
        }
        if (this.singleAction == null && this.multipleActions == null) {
            this.singleAction = action;
            return;
        }
        if (this.multipleActions != null) {
            this.multipleActions.add(action);
            return;
        }
        if (this.singleAction == action || this.singleAction.equals(action)) {
            return;
        }
        this.multipleActions = Sets.newLinkedHashSet();
        this.multipleActions.add(this.singleAction);
        this.multipleActions.add(action);
        this.singleAction = null;
    }

    protected void addOtherSet(FastActionSet<T> action) {
        FastActionSet<T> sas = action;
        if (sas.singleAction != null) {
            this.add(sas.singleAction);
        } else if (sas.multipleActions != null) {
            for (Action action2 : sas.multipleActions) {
                this.add(action2);
            }
        }
    }

    @Override
    public void execute(T t) {
        if (this.singleAction != null) {
            this.singleAction.execute(t);
        } else if (this.multipleActions != null) {
            for (Action action : this.multipleActions) {
                action.execute(t);
            }
        }
    }

    boolean isEmpty() {
        return this.singleAction == null && this.multipleActions == null;
    }

    int size() {
        if (this.singleAction == null) {
            if (this.multipleActions == null) {
                return 0;
            }
            return this.multipleActions.size();
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FastActionSet that = (FastActionSet)o;
        if (this.singleAction != null ? !this.singleAction.equals(that.singleAction) : that.singleAction != null) {
            return false;
        }
        return this.multipleActions != null ? this.multipleActions.equals(that.multipleActions) : that.multipleActions == null;
    }

    public int hashCode() {
        int result = this.singleAction != null ? this.singleAction.hashCode() : 0;
        result = 31 * result + (this.multipleActions != null ? this.multipleActions.hashCode() : 0);
        return result;
    }
}

