/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;

public class InlineUtil {
    public static boolean isInlineLambdaParameter(@NotNull ParameterDescriptor valueParameterOrReceiver) {
        if (valueParameterOrReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterOrReceiver", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "isInlineLambdaParameter"));
        }
        return (!(valueParameterOrReceiver instanceof ValueParameterDescriptor) || !((ValueParameterDescriptor)valueParameterOrReceiver).isNoinline()) && FunctionTypesKt.isFunctionType(valueParameterOrReceiver.getOriginal().getType());
    }

    public static boolean isInline(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof FunctionDescriptor && InlineUtil.getInlineStrategy((FunctionDescriptor)descriptor2).isInline();
    }

    public static boolean hasInlineAccessors(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "hasInlineAccessors"));
        }
        PropertyGetterDescriptor getter = propertyDescriptor.getGetter();
        PropertySetterDescriptor setter = propertyDescriptor.getSetter();
        return getter != null && getter.isInline() || setter != null && setter.isInline();
    }

    public static boolean isPropertyWithAllAccessorsAreInline(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "isPropertyWithAllAccessorsAreInline"));
        }
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return false;
        }
        PropertyGetterDescriptor getter = ((PropertyDescriptor)descriptor2).getGetter();
        if (getter == null || !getter.isInline()) {
            return false;
        }
        if (((PropertyDescriptor)descriptor2).isVar()) {
            PropertySetterDescriptor setter = ((PropertyDescriptor)descriptor2).getSetter();
            return setter != null && setter.isInline();
        }
        return true;
    }

    public static boolean isInlineOrContainingInline(@Nullable DeclarationDescriptor descriptor2) {
        if (InlineUtil.isInline(descriptor2)) {
            return true;
        }
        if (descriptor2 == null) {
            return false;
        }
        return InlineUtil.isInlineOrContainingInline(descriptor2.getContainingDeclaration());
    }

    @NotNull
    private static InlineStrategy getInlineStrategy(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getInlineStrategy"));
        }
        if (descriptor2.isInline()) {
            InlineStrategy inlineStrategy = InlineStrategy.AS_FUNCTION;
            if (inlineStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getInlineStrategy"));
            }
            return inlineStrategy;
        }
        InlineStrategy inlineStrategy = InlineStrategy.NOT_INLINE;
        if (inlineStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getInlineStrategy"));
        }
        return inlineStrategy;
    }

    public static boolean checkNonLocalReturnUsage(@NotNull DeclarationDescriptor fromFunction, @NotNull KtExpression startExpression, @NotNull ResolutionContext<?> context) {
        if (fromFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFunction", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "checkNonLocalReturnUsage"));
        }
        if (startExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startExpression", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "checkNonLocalReturnUsage"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "checkNonLocalReturnUsage"));
        }
        Object containingFunction = context.getContextParentOfType(startExpression, KtClassOrObject.class, KtDeclarationWithBody.class);
        if (containingFunction == null) {
            return false;
        }
        DeclarationDescriptor containingFunctionDescriptor = context.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, containingFunction);
        if (containingFunctionDescriptor == null) {
            return false;
        }
        BindingContext bindingContext = context.trace.getBindingContext();
        while (InlineUtil.canBeInlineArgument(containingFunction) && fromFunction != containingFunctionDescriptor) {
            if (!InlineUtil.isInlinedArgument((KtFunction)containingFunction, bindingContext, true)) {
                return false;
            }
            containingFunction = (containingFunctionDescriptor = InlineUtil.getContainingClassOrFunctionDescriptor(containingFunctionDescriptor, true)) != null ? DescriptorToSourceUtils.descriptorToDeclaration(containingFunctionDescriptor) : null;
        }
        return fromFunction == containingFunctionDescriptor;
    }

    public static boolean isInlinedArgument(@NotNull KtFunction argument, @NotNull BindingContext bindingContext, boolean checkNonLocalReturn) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "isInlinedArgument"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "isInlinedArgument"));
        }
        ValueParameterDescriptor descriptor2 = InlineUtil.getInlineArgumentDescriptor(argument, bindingContext);
        if (descriptor2 != null) {
            return !checkNonLocalReturn || InlineUtil.allowsNonLocalReturns(descriptor2);
        }
        return false;
    }

    @Nullable
    public static ValueParameterDescriptor getInlineArgumentDescriptor(@NotNull KtFunction argument, @NotNull BindingContext bindingContext) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getInlineArgumentDescriptor"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getInlineArgumentDescriptor"));
        }
        if (!InlineUtil.canBeInlineArgument(argument)) {
            return null;
        }
        KtExpression call = KtPsiUtil.getParentCallIfPresent(argument);
        if (call == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(call, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        CallableDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
        if (!InlineUtil.isInline(descriptor2) && !InlineUtil.isArrayConstructorWithLambda(descriptor2)) {
            return null;
        }
        ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(resolvedCall2.getCall(), argument);
        if (valueArgument == null) {
            return null;
        }
        ArgumentMapping mapping = resolvedCall2.getArgumentMapping(valueArgument);
        if (!(mapping instanceof ArgumentMatch)) {
            return null;
        }
        ValueParameterDescriptor parameter = ((ArgumentMatch)mapping).getValueParameter();
        return InlineUtil.isInlineLambdaParameter(parameter) ? parameter : null;
    }

    public static boolean canBeInlineArgument(@Nullable PsiElement functionalExpression) {
        return functionalExpression instanceof KtFunctionLiteral || functionalExpression instanceof KtNamedFunction;
    }

    public static boolean isArrayConstructorWithLambda(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "isArrayConstructorWithLambda"));
        }
        return descriptor2.getValueParameters().size() == 2 && descriptor2 instanceof ConstructorDescriptor && KotlinBuiltIns.isArrayOrPrimitiveArray(((ConstructorDescriptor)descriptor2).getConstructedClass());
    }

    @Nullable
    public static DeclarationDescriptor getContainingClassOrFunctionDescriptor(@NotNull DeclarationDescriptor descriptor2, boolean strict) {
        DeclarationDescriptor current;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getContainingClassOrFunctionDescriptor"));
        }
        DeclarationDescriptor declarationDescriptor = current = strict ? descriptor2.getContainingDeclaration() : descriptor2;
        while (current != null) {
            if (current instanceof FunctionDescriptor || current instanceof ClassDescriptor) {
                return current;
            }
            current = current.getContainingDeclaration();
        }
        return null;
    }

    public static boolean allowsNonLocalReturns(@NotNull CallableDescriptor lambda2) {
        if (lambda2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "allowsNonLocalReturns"));
        }
        return !(lambda2 instanceof ValueParameterDescriptor) || !((ValueParameterDescriptor)lambda2).isCrossinline();
    }

    public static boolean containsReifiedTypeParameters(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "containsReifiedTypeParameters"));
        }
        for (TypeParameterDescriptor typeParameterDescriptor : descriptor2.getTypeParameters()) {
            if (!typeParameterDescriptor.isReified()) continue;
            return true;
        }
        return false;
    }
}

