/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Properties;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.nbo.NBOFileHandler;
import org.openscience.jmol.app.nbo.NBOService;

abstract class NBODialogConfig
extends JDialog {
    private static final String DEFAULT_SCRIPT = "set bondpicking true;set multipleBondSpacing -0.5;set zoomlarge false;select none;";
    protected static final String INPUT_FILE_EXTENSIONS = "adf;cfi;com;g09;gau;gms;jag;log;mm2;mnd;mol;mp;nw;orc;pqs;qc;vfi;xyz;47";
    protected static final String OUTPUT_FILE_EXTENSIONS = "adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;mol;xyz;vfi;g09;com";
    protected static final String JMOL_EXTENSIONS = "xyz;mol";
    protected static final String sep = System.getProperty("line.separator");
    protected Viewer vwr;
    protected NBOService nboService;
    protected JLabel icon;
    protected JSplitPane centerPanel;
    protected JPanel modulePanel;
    protected NBOFileHandler inputFileHandler;
    protected NBOFileHandler saveFileHandler;
    protected static final Font nboFont = new Font("Arial", 1, 16);
    protected static final Font monoFont = new Font("Monospaced", 1, 16);
    protected static final Font titleFont = new Font("Arial", 3, 18);
    protected static final Color titleColor = Color.blue;
    protected JTextPane jpNBOLog;
    protected String bodyText = "";
    protected boolean showAtNum;
    protected boolean nboView;
    protected boolean useWireMesh;
    protected char dialogMode;
    protected Color orbColor1;
    protected Color orbColor2;
    protected String color1;
    protected String color2;
    protected float opacityOp;
    protected String reqInfo;
    protected boolean debugVerbose;

    protected NBODialogConfig(JFrame f) {
        super(f);
    }

    protected JPanel buildSettingsPanel() {
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 1));
        JTextField serverPath = new JTextField(this.nboService.serverPath);
        filePanel.add(NBODialogConfig.titleBox(" Location of NBOServe.exe ", null));
        Box serverBox = this.borderBox(true);
        JButton browse = new JButton("...");
        serverBox.add(this.addPathBox(serverPath, 0, browse));
        filePanel.add(serverBox);
        JLabel lab = new JLabel();
        lab.setAlignmentX(0.5f);
        if (this.nboService.restartIfNecessary()) {
            lab.setText("NBOServe connected successfully");
            lab.setForeground(Color.black);
        } else {
            String s = "Could not connect to NBOServe. If it is already running from another instance of Jmol, you must first close that instance.";
            lab.setText(s);
            lab.setForeground(Color.red);
            this.alertError(s);
        }
        serverBox.setMaximumSize(new Dimension(350, 50));
        filePanel.add(serverBox);
        filePanel.add(NBODialogConfig.titleBox(" Location of Working Directory ", null));
        Box workBox = this.borderBox(true);
        filePanel.add(workBox);
        Properties props = JmolPanel.historyFile.getProperties();
        String workingPath = props.getProperty("workingPath", System.getProperty("user.home"));
        JTextField runPath = new JTextField(workingPath);
        browse = new JButton("...");
        workBox.add(this.addPathBox(runPath, 1, browse));
        workBox.setMaximumSize(new Dimension(350, 80));
        filePanel.add(workBox);
        JLabel label = new JLabel("(This directory must be different than NBOServe's directory)");
        label.setAlignmentX(0.5f);
        workBox.add(label);
        filePanel.add(NBODialogConfig.titleBox(" Settings ", null));
        JCheckBox jCheckAtomNum = new JCheckBox("Show Atom Numbers");
        jCheckAtomNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.showAtNum = !NBODialogConfig.this.showAtNum;
                NBODialogConfig.this.showAtomNums(false);
            }
        });
        this.showAtNum = true;
        jCheckAtomNum.setSelected(true);
        Box settingsBox = this.borderBox(true);
        settingsBox.add(jCheckAtomNum);
        JCheckBox jCheckSelHalo = new JCheckBox("Show selection halos on atoms");
        jCheckSelHalo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.runScriptNow("select " + ((JCheckBox)e.getSource()).isSelected());
            }
        });
        jCheckSelHalo.doClick();
        settingsBox.add(jCheckSelHalo);
        String viewOps = props.getProperty("viewOptions");
        if (viewOps != null) {
            if (!viewOps.equals("nboView")) {
                String[] toks = viewOps.split(",");
                this.orbColor1 = new Color(Integer.parseInt(toks[0]));
                this.orbColor2 = new Color(Integer.parseInt(toks[1]));
                this.opacityOp = Float.parseFloat(toks[2]);
                this.useWireMesh = toks[3].contains("true");
                this.runScriptNow("nbo " + (this.useWireMesh ? "nofill mesh" : "fill nomesh"));
            } else {
                this.orbColor1 = Color.cyan;
                this.orbColor2 = Color.yellow;
                this.opacityOp = 0.3f;
                this.useWireMesh = false;
            }
        } else {
            this.orbColor1 = Color.blue;
            this.orbColor2 = Color.red;
            this.opacityOp = 0.0f;
            this.useWireMesh = true;
        }
        this.color1 = "[" + this.orbColor1.getRed() + " " + this.orbColor1.getGreen() + " " + this.orbColor1.getBlue() + "]";
        this.color2 = "[" + this.orbColor2.getRed() + " " + this.orbColor2.getGreen() + " " + this.orbColor2.getBlue() + "]";
        final JCheckBox jCheckWireMesh = new JCheckBox("Use wire mesh for orbital display");
        settingsBox.add(jCheckWireMesh);
        Color[] colors = new Color[]{Color.red, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta};
        JPanel displayOps = new JPanel(new GridLayout(1, 4));
        displayOps.add(new JLabel("(+) color: "));
        final JComboBox<Color> colorBox1 = new JComboBox<Color>(colors);
        colorBox1.setRenderer(new ColorRenderer());
        colorBox1.setSelectedItem(this.orbColor1);
        displayOps.add(colorBox1);
        colorBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.orbColor1 = (Color)colorBox1.getSelectedItem();
                NBODialogConfig.this.color1 = "[" + NBODialogConfig.this.orbColor1.getRed() + " " + NBODialogConfig.this.orbColor1.getGreen() + " " + NBODialogConfig.this.orbColor1.getBlue() + "]";
                NBODialogConfig.this.runScriptNow("nbo color " + NBODialogConfig.this.color2 + " " + NBODialogConfig.this.color1 + ";mo color " + NBODialogConfig.this.color2 + " " + NBODialogConfig.this.color1);
                Properties props = new Properties();
                props.setProperty("viewOptions", NBODialogConfig.this.orbColor1.getRGB() + "," + NBODialogConfig.this.orbColor2.getRGB() + "," + NBODialogConfig.this.opacityOp + "," + NBODialogConfig.this.useWireMesh);
                JmolPanel.historyFile.addProperties(props);
            }
        });
        displayOps.add(new JLabel("  (-) color: "));
        final JComboBox<Color> colorBox2 = new JComboBox<Color>(colors);
        colorBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.orbColor2 = (Color)colorBox2.getSelectedItem();
                NBODialogConfig.this.color2 = "[" + NBODialogConfig.this.orbColor2.getRed() + " " + NBODialogConfig.this.orbColor2.getGreen() + " " + NBODialogConfig.this.orbColor2.getBlue() + "]";
                NBODialogConfig.this.runScriptNow("nbo color " + NBODialogConfig.this.color2 + " " + NBODialogConfig.this.color1 + ";mo color " + NBODialogConfig.this.color2 + " " + NBODialogConfig.this.color1);
                Properties props = new Properties();
                props.setProperty("viewOptions", NBODialogConfig.this.orbColor1.getRGB() + "," + NBODialogConfig.this.orbColor2.getRGB() + "," + NBODialogConfig.this.opacityOp + "," + NBODialogConfig.this.useWireMesh);
                JmolPanel.historyFile.addProperties(props);
            }
        });
        colorBox2.setSelectedItem(this.orbColor2);
        colorBox2.setRenderer(new ColorRenderer());
        displayOps.add(colorBox2);
        displayOps.setAlignmentX(0.0f);
        settingsBox.add(displayOps);
        settingsBox.add(Box.createRigidArea(new Dimension(10, 10)));
        final JSlider opacity = new JSlider();
        opacity.setMinimum(0);
        opacity.setMaximum(10);
        opacity.setMajorTickSpacing(1);
        opacity.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i < 10; ++i) {
            labelTable.put(new Integer(i), new JLabel("0." + i));
        }
        labelTable.put(new Integer(10), new JLabel("1"));
        opacity.setPaintLabels(true);
        opacity.setLabelTable(labelTable);
        opacity.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NBODialogConfig.this.opacityOp = (float)opacity.getValue() / 10.0f;
                NBODialogConfig.this.runScriptNow("nbo translucent " + NBODialogConfig.this.opacityOp + ";mo translucent " + NBODialogConfig.this.opacityOp);
                Properties props = new Properties();
                props.setProperty("viewOptions", NBODialogConfig.this.orbColor1.getRGB() + "," + NBODialogConfig.this.orbColor2.getRGB() + "," + NBODialogConfig.this.opacityOp + "," + NBODialogConfig.this.useWireMesh);
                JmolPanel.historyFile.addProperties(props);
            }
        });
        Box opacBox = Box.createHorizontalBox();
        opacBox.add(new JLabel("Orbital opacity:  "));
        opacBox.setAlignmentX(0.0f);
        opacBox.add(opacity);
        settingsBox.add(opacBox);
        jCheckWireMesh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean bl = NBODialogConfig.this.useWireMesh = !NBODialogConfig.this.useWireMesh;
                if (NBODialogConfig.this.useWireMesh) {
                    opacity.setValue(0);
                    NBODialogConfig.this.runScriptNow("nbo nofill mesh;mo nofill mesh");
                } else {
                    NBODialogConfig.this.runScriptNow("nbo fill nomesh;mo fill nomesh");
                }
                Properties props = new Properties();
                props.setProperty("viewOptions", NBODialogConfig.this.orbColor1.getRGB() + "," + NBODialogConfig.this.orbColor2.getRGB() + "," + NBODialogConfig.this.opacityOp + "," + NBODialogConfig.this.useWireMesh);
                JmolPanel.historyFile.addProperties(props);
            }
        });
        if (this.useWireMesh) {
            jCheckWireMesh.setSelected(true);
        }
        JCheckBox jCheckNboView = new JCheckBox("Emulate NBO View");
        settingsBox.add(jCheckNboView);
        jCheckNboView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    NBODialogConfig.this.setNBOColorScheme();
                    colorBox1.setSelectedItem(Color.cyan);
                    colorBox2.setSelectedItem(Color.yellow);
                    opacity.setValue(3);
                    if (jCheckWireMesh.isSelected()) {
                        jCheckWireMesh.doClick();
                    }
                    Properties props = new Properties();
                    props.setProperty("viewOptions", "nboView");
                    JmolPanel.historyFile.addProperties(props);
                } else {
                    NBODialogConfig.this.resetColorScheme();
                }
            }
        });
        JCheckBox jb = new JCheckBox("Verbose Debugging");
        settingsBox.add(jb);
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.debugVerbose = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        if (viewOps.equals("nboView")) {
            jCheckNboView.doClick();
        } else {
            opacity.setValue((int)(this.opacityOp * 10.0f));
        }
        settingsBox.setBorder(BorderFactory.createLineBorder(Color.black));
        filePanel.add(settingsBox);
        return filePanel;
    }

    private Box addPathBox(final JTextField tf, final int m, JButton b) {
        Box box = Box.createHorizontalBox();
        box.add(tf);
        box.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.showNBOPathDialog(tf, tf.getText(), m);
            }
        });
        return box;
    }

    protected void showNBOPathDialog(JTextField tf, String f, int mode) {
        JFileChooser myChooser = new JFileChooser();
        String fname = f;
        String exe = "";
        if (mode == 0) {
            exe = "exe";
            myChooser.setFileFilter(new FileNameExtensionFilter(exe, exe));
            myChooser.setFileHidingEnabled(true);
            myChooser.setSelectedFile(new File(f));
        } else {
            myChooser.setFileSelectionMode(1);
            myChooser.setSelectedFile(new File(fname + "/ "));
        }
        int button = myChooser.showDialog(this, GT._("Select"));
        if (button == 0) {
            File newFile = myChooser.getSelectedFile();
            String path = newFile.toString();
            switch (mode) {
                case 0: {
                    this.nboService.setServerPath(path);
                    System.out.println(path);
                    tf.setText(path);
                    this.log("NBOServe location changed changed:<br> " + path, 'b');
                    this.saveNBOServePath();
                    this.connect();
                    break;
                }
                case 1: {
                    String workingPath = path;
                    Properties props = new Properties();
                    props.setProperty("workingPath", workingPath);
                    JmolPanel.historyFile.addProperties(props);
                    tf.setText(path);
                    this.log("Run file directory changed:<br> " + path, 'b');
                }
            }
        }
    }

    private void saveNBOServePath() {
        Properties props = new Properties();
        props.setProperty("nboServerPath", this.nboService.serverPath);
        JmolPanel.historyFile.addProperties(props);
    }

    protected static Box titleBox(String st, Component c) {
        Box box = Box.createVerticalBox();
        JLabel title = new JLabel(st);
        title.setAlignmentX(0.0f);
        title.setBackground(titleColor);
        title.setForeground(Color.white);
        title.setFont(titleFont);
        title.setOpaque(true);
        if (c != null) {
            JPanel box2 = new JPanel(new BorderLayout());
            box2.setAlignmentX(0.0f);
            box2.add((Component)title, "West");
            box2.add(c, "East");
            box2.setMaximumSize(new Dimension(355, 25));
            box.add(box2);
        } else {
            box.add(title);
        }
        box.setAlignmentX(0.0f);
        return box;
    }

    protected Box borderBox(boolean vert) {
        Box box = vert ? Box.createVerticalBox() : Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.setBorder(BorderFactory.createLineBorder(Color.black));
        return box;
    }

    protected void setNBOColorScheme() {
        this.nboView = true;
        String atomColors = "";
        String fname = "org/openscience/jmol/app/nbo/help/atomColors.txt";
        try {
            atomColors = GuiMap.getResourceString((Object)this, (String)fname);
        }
        catch (IOException e) {
            this.alertError("Atom colors not found");
        }
        this.runScriptNow(atomColors + ";refresh");
    }

    protected void resetColorScheme() {
        this.nboView = false;
        this.runScriptNow("background black;set defaultcolors Jmol;refresh;");
    }

    protected void showAtomNums(boolean alpha) {
        if (!this.showAtNum) {
            this.runScriptNow("select {*};label off; select remove {*}");
            return;
        }
        SB sb = new SB();
        sb.append("select {*};label %a;");
        String color = "black";
        if (!this.nboView) {
            color = "gray";
        }
        sb.append("select {*};color labels white;");
        sb.append("select {H*};color labels " + color + ";" + "set labeloffset 0 0 {*}; select remove {*};");
        this.runScriptNow(sb.toString());
    }

    protected void centerDialog(JDialog d) {
        int x = this.getWidth() / 2 - d.getWidth() / 2 + this.getX();
        int y = this.getHeight() / 2 - d.getHeight() / 2;
        d.setLocation(x, y);
    }

    protected synchronized void log(String line, char chFormat) {
        if (line.trim().equals("") || this.jpNBOLog == null || !this.debugVerbose && "b|r".indexOf("" + chFormat) < 0) {
            return;
        }
        if (line.trim().length() >= 1) {
            String format0;
            line = PT.rep(line.trim(), "<", "&lt;");
            line = PT.rep(line, ">", "&gt;");
            line = PT.rep(line, "&lt;br&gt;", "<br>");
            String format1 = format0 = "" + chFormat;
            if (chFormat == 'r') {
                format0 = "b style=color:red";
                format1 = "b";
            }
            if (!format0.equals("p")) {
                line = "<" + format0 + ">" + line + "</" + format1 + ">";
            }
            this.bodyText = this.bodyText + line + "\n<br>";
            this.jpNBOLog.setText("<html>" + this.bodyText + "</html>");
        }
        this.jpNBOLog.setCaretPosition(this.jpNBOLog.getDocument().getLength());
    }

    protected void alertError(String line) {
        this.log(line, 'r');
        this.vwr.alert(line);
    }

    protected void logInfo(String msg, int mode) {
        Logger.info(msg);
        this.log(msg, (char)(mode == 4 ? 112 : (mode == 2 ? 114 : (mode == 3 ? 98 : 105))));
    }

    protected void sendDefaultScript() {
        this.runScriptNow(DEFAULT_SCRIPT);
    }

    protected void runScriptQueued(String script) {
        this.logInfo("_$ " + PT.rep(script, "\n", "<br>"), 5);
        this.vwr.script(script);
    }

    protected synchronized String runScriptNow(String script) {
        this.logInfo("!$ " + script, 5);
        return PT.trim(this.vwr.runScript(script), "\n");
    }

    private boolean connect() {
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        File f = new File(this.nboService.serverDir + "gennbo.bat");
        if (!f.exists()) {
            this.log("gennbo.bat not found, make sure gennbo.bat is in same directory as nboserve.exe", 'b');
            return false;
        }
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        String realArch = arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "64" : "32";
        BufferedReader b = null;
        try {
            String line;
            b = new BufferedReader(new FileReader(f));
            while ((line = b.readLine()) != null) {
                if (!line.startsWith("set INT=")) continue;
                line = realArch.equals("64") ? "set INT=i8" : "set INT=i4";
            }
            b.close();
        }
        catch (FileNotFoundException e) {
            this.log("Error opening gennbo.bat", 'b');
            return false;
        }
        catch (IOException e) {
            this.log("Error opening gennbo.bat", 'b');
            return false;
        }
        boolean isOK = this.checkEnabled();
        if (isOK) {
            this.icon.setText("Connected");
        }
        return isOK;
    }

    protected boolean checkEnabled() {
        boolean haveService = this.nboService.serverPath.length() > 0;
        boolean enabled = haveService && this.nboService.restartIfNecessary();
        return enabled;
    }

    protected String evaluateJmolString(String expr) {
        return this.vwr.evaluateExpressionAsVariable(expr).asString();
    }

    protected String getJmolFilename() {
        return this.evaluateJmolString("getProperty('filename')");
    }

    protected void loadModelFileQueued(File f, boolean saveOrientation, boolean isAppend) {
        String s = "load " + (isAppend ? "append " : "") + "\"" + f.getAbsolutePath() + "\"";
        if (saveOrientation) {
            s = "save orientation o1;" + s + ";restore orientation o1";
        }
        this.runScriptQueued(s);
    }

    protected void colorMeshes() {
        this.runScriptNow((this.useWireMesh ? "nbo mesh nofill translucent " + this.opacityOp + ";mo mesh nofill translucent " + this.opacityOp : "nbo nomesh fill translucent " + this.opacityOp + ";mo nomesh fill translucent " + this.opacityOp) + ";nbo color " + this.color2 + " " + this.color1 + ";mo color " + this.color2 + " " + this.color1);
    }

    class StyledComboBoxUI
    extends MetalComboBoxUI {
        protected int height;
        protected int width;

        protected StyledComboBoxUI(int h, int w) {
            this.height = h;
            this.width = w;
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup popup = new BasicComboPopup(this.comboBox){

                @Override
                protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
                    return super.computePopupBounds(px, py, Math.max(StyledComboBoxUI.this.width, pw), StyledComboBoxUI.this.height);
                }
            };
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return popup;
        }
    }

    class HelpBtn
    extends JButton
    implements ActionListener {
        private String url;

        protected HelpBtn(String url) {
            super("Help");
            this.setBackground(Color.black);
            this.setForeground(Color.white);
            this.url = url;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            try {
                URI uri = new URI("http://nbo6.chem.wisc.edu/jmol_help/" + this.url);
                Desktop.getDesktop().browse(uri);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class ColorRenderer
    extends JButton
    implements ListCellRenderer {
        boolean b = false;

        public ColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public void setBackground(Color bg) {
            if (!this.b) {
                return;
            }
            super.setBackground(bg);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.b = true;
            this.setText(" ");
            this.setBackground((Color)value);
            this.b = false;
            return this;
        }
    }
}

