/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightVariableBase
extends LightElement
implements OriginInfoAwareElement,
PsiVariable {
    protected PsiElement myScope;
    protected PsiIdentifier myNameIdentifier;
    protected PsiType myType;
    protected final PsiModifierList myModifierList;
    protected boolean myWritable;
    private String myOriginInfo;

    public LightVariableBase(PsiManager manager, PsiIdentifier nameIdentifier, PsiType type2, boolean writable, PsiElement scope) {
        this(manager, nameIdentifier, JavaLanguage.INSTANCE, type2, writable, scope);
    }

    public LightVariableBase(PsiManager manager, PsiIdentifier nameIdentifier, Language language, PsiType type2, boolean writable, PsiElement scope) {
        super(manager, language);
        this.myNameIdentifier = nameIdentifier;
        this.myWritable = writable;
        this.myType = type2;
        this.myScope = scope;
        this.myModifierList = this.createModifierList();
    }

    protected PsiModifierList createModifierList() {
        return new LightModifierList(this.getManager());
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement psiElement = this.myScope;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightVariableBase", "getDeclarationScope"));
        }
        return psiElement;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return this.myNameIdentifier;
    }

    @Override
    public boolean isValid() {
        return this.myNameIdentifier == null || this.myNameIdentifier.isValid();
    }

    @Override
    @NotNull
    public String getName() {
        String string = StringUtil.notNullize(this.getNameIdentifier().getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightVariableBase", "getName"));
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightVariableBase", "setName"));
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name2);
        return this;
    }

    @Override
    @NotNull
    public PsiType getType() {
        if (this.myType == null) {
            this.myType = this.computeType();
        }
        PsiType psiType = this.myType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightVariableBase", "getType"));
        }
        return psiType;
    }

    @NotNull
    protected PsiType computeType() {
        PsiPrimitiveType psiPrimitiveType = PsiType.VOID;
        if (psiPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightVariableBase", "computeType"));
        }
        return psiPrimitiveType;
    }

    @Override
    @NotNull
    public PsiTypeElement getTypeElement() {
        PsiTypeElement psiTypeElement = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createTypeElement(this.myType);
        if (psiTypeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightVariableBase", "getTypeElement"));
        }
        return psiTypeElement;
    }

    @Override
    public PsiModifierList getModifierList() {
        return this.myModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightVariableBase", "hasModifierProperty"));
        }
        return this.getModifierList().hasModifierProperty(name2);
    }

    @Override
    public PsiExpression getInitializer() {
        return null;
    }

    @Override
    public boolean hasInitializer() {
        return false;
    }

    @Override
    public String getText() {
        return this.myNameIdentifier.getText();
    }

    @Override
    public Object computeConstantValue() {
        return null;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public boolean isWritable() {
        return this.myWritable;
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.VARIABLE_ICON, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    @Nullable
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    public void setOriginInfo(String originInfo) {
        this.myOriginInfo = originInfo;
    }
}

