/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.common.Symbol;
import org.jetbrains.kotlin.js.util.AstUtil;

public final class JsFunction
extends JsLiteral
implements HasName {
    @NotNull
    private JsBlock body;
    private List<JsParameter> params;
    @NotNull
    private final JsFunctionScope scope;
    private JsName name;

    public JsFunction(@NotNull JsScope parentScope, @NotNull String description) {
        if (parentScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentScope", "org/jetbrains/kotlin/js/backend/ast/JsFunction", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/kotlin/js/backend/ast/JsFunction", "<init>"));
        }
        this(parentScope, description, null);
    }

    public JsFunction(@NotNull JsScope parentScope, @NotNull JsBlock body, @NotNull String description) {
        if (parentScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentScope", "org/jetbrains/kotlin/js/backend/ast/JsFunction", "<init>"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "org/jetbrains/kotlin/js/backend/ast/JsFunction", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/kotlin/js/backend/ast/JsFunction", "<init>"));
        }
        this(parentScope, description, null);
        this.body = body;
    }

    private JsFunction(@NotNull JsScope parentScope, @NotNull String description, @Nullable JsName name2) {
        if (parentScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentScope", "org/jetbrains/kotlin/js/backend/ast/JsFunction", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/kotlin/js/backend/ast/JsFunction", "<init>"));
        }
        this.name = name2;
        this.scope = new JsFunctionScope(parentScope, name2 == null ? description : name2.getIdent());
    }

    @NotNull
    public JsBlock getBody() {
        JsBlock jsBlock = this.body;
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsFunction", "getBody"));
        }
        return jsBlock;
    }

    @Override
    public JsName getName() {
        return this.name;
    }

    @Override
    public Symbol getSymbol() {
        return this.name;
    }

    @NotNull
    public List<JsParameter> getParameters() {
        if (this.params == null) {
            this.params = new SmartList<JsParameter>();
        }
        List<JsParameter> list2 = this.params;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsFunction", "getParameters"));
        }
        return list2;
    }

    @NotNull
    public JsFunctionScope getScope() {
        JsFunctionScope jsFunctionScope = this.scope;
        if (jsFunctionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsFunction", "getScope"));
        }
        return jsFunctionScope;
    }

    public void setBody(@NotNull JsBlock body) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "org/jetbrains/kotlin/js/backend/ast/JsFunction", "setBody"));
        }
        this.body = body;
    }

    @Override
    public void setName(@Nullable JsName name2) {
        this.name = name2;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitFunction(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.acceptWithInsertRemove(this.getParameters());
        visitor2.accept(this.body);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptList(this.getParameters());
            this.body = v.acceptStatement(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsFunction deepCopy() {
        JsFunction functionCopy = new JsFunction(this.scope.getParent(), this.scope.getDescription(), this.name);
        functionCopy.getScope().copyOwnNames(this.scope);
        functionCopy.setBody(this.body.deepCopy());
        functionCopy.params = AstUtil.deepCopy(this.params);
        JsFunction jsFunction = functionCopy.withMetadataFrom(this);
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsFunction", "deepCopy"));
        }
        return jsFunction;
    }
}

