/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.initializer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNumberLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.declaration.DelegationTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.initializer.InitializerUtils;
import org.jetbrains.kotlin.js.translate.initializer.InitializerVisitor;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.jsAstUtils.AstUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public final class ClassInitializerTranslator
extends AbstractTranslator {
    @NotNull
    private final KtClassOrObject classDeclaration;
    @NotNull
    private final JsFunction initFunction;
    @NotNull
    private final TranslationContext context;
    @NotNull
    private final ClassDescriptor classDescriptor;
    private final ConstructorDescriptor primaryConstructor;
    private int ordinal;

    public ClassInitializerTranslator(@NotNull KtClassOrObject classDeclaration, @NotNull TranslationContext context, @NotNull JsFunction initFunction) {
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "<init>"));
        }
        if (initFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initFunction", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "<init>"));
        }
        super(context);
        this.classDeclaration = classDeclaration;
        this.initFunction = initFunction;
        this.context = context.contextWithScope(initFunction);
        this.classDescriptor = BindingUtils.getClassDescriptor(this.bindingContext(), classDeclaration);
        this.primaryConstructor = this.classDescriptor.getUnsubstitutedPrimaryConstructor();
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    @NotNull
    protected TranslationContext context() {
        TranslationContext translationContext = this.context;
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "context"));
        }
        return translationContext;
    }

    public void generateInitializeMethod(DelegationTranslator delegationTranslator) {
        this.addOuterClassReference(this.classDescriptor);
        if (this.primaryConstructor != null) {
            this.initFunction.getBody().getStatements().addAll(FunctionBodyTranslator.setDefaultValueForArguments(this.primaryConstructor, this.context()));
            this.mayBeAddCallToSuperMethod(this.initFunction);
            this.initFunction.getParameters().addAll(this.translatePrimaryConstructorParameters());
            if (this.classDescriptor.getKind() == ClassKind.ENUM_CLASS) {
                ClassInitializerTranslator.addEnumClassParameters(this.initFunction);
            }
        }
        this.addThrowableCall();
        delegationTranslator.addInitCode(this.initFunction.getBody().getStatements());
        new InitializerVisitor().traverseContainer(this.classDeclaration, this.context().innerBlock(this.initFunction.getBody()));
    }

    private static void addEnumClassParameters(JsFunction constructorFunction) {
        JsName nameParamName = constructorFunction.getScope().declareFreshName("name");
        JsName ordinalParamName = constructorFunction.getScope().declareFreshName("ordinal");
        constructorFunction.getParameters().addAll(0, Arrays.asList(new JsParameter(nameParamName), new JsParameter(ordinalParamName)));
        constructorFunction.getBody().getStatements().add(JsAstUtils.assignmentToThisField("name$", nameParamName.makeRef()));
        constructorFunction.getBody().getStatements().add(JsAstUtils.assignmentToThisField("ordinal$", ordinalParamName.makeRef()));
    }

    private void addOuterClassReference(ClassDescriptor classDescriptor) {
        JsName outerName = this.context.getOuterClassReference(classDescriptor);
        if (outerName == null) {
            return;
        }
        this.initFunction.getParameters().add(0, new JsParameter(outerName));
        JsNameRef paramRef = JsAstUtils.pureFqn(outerName, null);
        JsBinaryOperation assignment = JsAstUtils.assignment(JsAstUtils.pureFqn(outerName, (JsExpression)JsLiteral.THIS), paramRef);
        this.initFunction.getBody().getStatements().add(new JsExpressionStatement(assignment));
    }

    @NotNull
    public static JsExpression generateEnumEntryInstanceCreation(@NotNull TranslationContext context, @NotNull KtEnumEntry enumEntry, int ordinal) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "generateEnumEntryInstanceCreation"));
        }
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "generateEnumEntryInstanceCreation"));
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getSuperCall(context.bindingContext(), enumEntry);
        if (resolvedCall2 == null) {
            assert (enumEntry.getInitializerList() == null) : "Super call is missing on an enum entry with explicit initializer list " + PsiUtilsKt.getTextWithLocation(enumEntry);
            resolvedCall2 = CallUtilKt.getFunctionResolvedCallWithAssert(enumEntry, context.bindingContext());
        }
        JsStringLiteral nameArg = context.program().getStringLiteral(enumEntry.getName());
        JsNumberLiteral ordinalArg = context.program().getNumberLiteral(ordinal);
        List<JsExpression> additionalArgs = Arrays.asList(nameArg, ordinalArg);
        JsExpression call2 = CallTranslator.translate(context, resolvedCall2);
        if (call2 instanceof JsInvocation) {
            JsInvocation invocation = (JsInvocation)call2;
            invocation.getArguments().addAll(0, additionalArgs);
        } else if (call2 instanceof JsNew) {
            JsNew invocation = (JsNew)call2;
            invocation.getArguments().addAll(0, additionalArgs);
        }
        JsExpression jsExpression = call2;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "generateEnumEntryInstanceCreation"));
        }
        return jsExpression;
    }

    private void mayBeAddCallToSuperMethod(JsFunction initializer2) {
        if (this.classDeclaration.hasModifier(KtTokens.ENUM_KEYWORD)) {
            this.addCallToSuperMethod(Collections.<JsExpression>emptyList(), initializer2);
        } else if (BindingUtils.hasAncestorClass(this.bindingContext(), this.classDeclaration)) {
            ResolvedCall<FunctionDescriptor> superCall = BindingUtils.getSuperCall(this.bindingContext(), this.classDeclaration);
            if (superCall == null) {
                if (DescriptorUtils.isEnumEntry(this.classDescriptor)) {
                    this.addCallToSuperMethod(this.getAdditionalArgumentsForEnumConstructor(), initializer2);
                }
                return;
            }
            if (JsDescriptorUtils.isImmediateSubtypeOfError(this.classDescriptor)) {
                ClassInitializerTranslator.emulateSuperCallToNativeError(this.context, this.classDescriptor, superCall, JsLiteral.THIS);
                return;
            }
            if (this.classDeclaration instanceof KtEnumEntry) {
                JsExpression expression = CallTranslator.translate(this.context(), superCall, null);
                JsExpression fixedInvocation = AstUtilsKt.toInvocationWith(expression, this.getAdditionalArgumentsForEnumConstructor(), 0, JsLiteral.THIS);
                this.initFunction.getBody().getStatements().add(fixedInvocation.makeStmt());
            } else {
                UsageTracker tracker;
                List<DeclarationDescriptor> superclassClosure;
                ArrayList<JsExpression> arguments2 = new ArrayList<JsExpression>();
                ConstructorDescriptor superDescriptor = (ConstructorDescriptor)superCall.getResultingDescriptor();
                if (superDescriptor instanceof TypeAliasConstructorDescriptor) {
                    superDescriptor = ((TypeAliasConstructorDescriptor)superDescriptor).getUnderlyingConstructorDescriptor();
                }
                if ((superclassClosure = this.context.getClassOrConstructorClosure(superDescriptor)) != null && (tracker = this.context.usageTracker()) != null) {
                    for (DeclarationDescriptor capturedValue : superclassClosure) {
                        tracker.used(capturedValue);
                        arguments2.add(tracker.getCapturedDescriptorToJsName().get(capturedValue).makeRef());
                    }
                }
                if (superCall.getDispatchReceiver() != null) {
                    JsExpression receiver = this.context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForReceiver(superCall.getDispatchReceiver()));
                    arguments2.add(receiver);
                }
                if (!DescriptorUtils.isAnonymousObject(this.classDescriptor)) {
                    arguments2.addAll(CallArgumentTranslator.translate(superCall, null, this.context()).getTranslateArguments());
                } else {
                    for (ValueParameterDescriptor parameter : superDescriptor.getValueParameters()) {
                        JsName parameterName = this.context.getNameForDescriptor(parameter);
                        arguments2.add(parameterName.makeRef());
                        initializer2.getParameters().add(new JsParameter(parameterName));
                    }
                }
                if (superDescriptor.isPrimary()) {
                    this.addCallToSuperMethod(arguments2, initializer2);
                } else {
                    int maxValueArgumentIndex = 0;
                    for (ValueParameterDescriptor arg : superCall.getValueArguments().keySet()) {
                        ResolvedValueArgument resolvedArg = superCall.getValueArguments().get(arg);
                        if (resolvedArg instanceof DefaultValueArgument) continue;
                        maxValueArgumentIndex = Math.max(maxValueArgumentIndex, arg.getIndex() + 1);
                    }
                    int padSize = superDescriptor.getValueParameters().size() - maxValueArgumentIndex;
                    while (padSize-- > 0) {
                        arguments2.add(Namer.getUndefinedExpression());
                    }
                    this.addCallToSuperSecondaryConstructor(arguments2, superDescriptor);
                }
            }
        }
    }

    public static void emulateSuperCallToNativeError(@NotNull TranslationContext context, @NotNull ClassDescriptor classDescriptor, @NotNull ResolvedCall<? extends FunctionDescriptor> superCall, @NotNull JsExpression receiver) {
        JsExpression correctedMessage;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "emulateSuperCallToNativeError"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "emulateSuperCallToNativeError"));
        }
        if (superCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superCall", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "emulateSuperCallToNativeError"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "emulateSuperCallToNativeError"));
        }
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassOrAny(classDescriptor);
        JsExpression superClassRef = ReferenceTranslator.translateAsTypeReference(superClass, context);
        JsInvocation superInvocation = new JsInvocation((JsExpression)Namer.getFunctionCallRef(superClassRef), receiver.deepCopy());
        List<JsStatement> statements = context.getCurrentBlock().getStatements();
        statements.add(JsAstUtils.asSyntheticStatement(superInvocation));
        JsExpression messageArgument = Namer.getUndefinedExpression();
        JsExpression causeArgument = JsLiteral.NULL;
        for (ValueParameterDescriptor param : superCall.getResultingDescriptor().getValueParameters()) {
            ResolvedValueArgument argument = superCall.getValueArguments().get(param);
            if (!(argument instanceof ExpressionValueArgument)) continue;
            ExpressionValueArgument exprArgument = (ExpressionValueArgument)argument;
            assert (exprArgument.getValueArgument() != null);
            KtExpression value = exprArgument.getValueArgument().getArgumentExpression();
            assert (value != null);
            JsExpression jsValue = Translation.translateAsExpression(value, context);
            if (KotlinBuiltIns.isStringOrNullableString(param.getType())) {
                messageArgument = context.cacheExpressionIfNeeded(jsValue);
                continue;
            }
            if (TypeUtilsKt.isConstructedFromClassWithGivenFqName(param.getType(), KotlinBuiltIns.FQ_NAMES.throwable)) {
                causeArgument = context.cacheExpressionIfNeeded(jsValue);
                continue;
            }
            statements.add(JsAstUtils.asSyntheticStatement(jsValue));
        }
        PropertyDescriptor messageProperty = DescriptorUtils.getPropertyByName(classDescriptor.getUnsubstitutedMemberScope(), Name.identifier("message"));
        JsNameRef messageRef = JsAstUtils.pureFqn(context.getNameForBackingField(messageProperty), receiver.deepCopy());
        JsBinaryOperation messageIsUndefined = JsAstUtils.typeOfIs(messageArgument, context.program().getStringLiteral("undefined"));
        JsBinaryOperation causeIsNull = new JsBinaryOperation(JsBinaryOperator.NEQ, causeArgument, JsLiteral.NULL);
        JsBinaryOperation causeToStringCond = JsAstUtils.and(messageIsUndefined, causeIsNull);
        JsInvocation causeToString = new JsInvocation((JsExpression)JsAstUtils.pureFqn("toString", (JsExpression)Namer.kotlinObject()), causeArgument.deepCopy());
        if (causeArgument == JsLiteral.NULL) {
            correctedMessage = messageArgument.deepCopy();
        } else {
            if (JsAstUtils.isUndefinedExpression(messageArgument)) {
                causeToStringCond = causeIsNull;
            }
            correctedMessage = new JsConditional(causeToStringCond, causeToString, messageArgument);
        }
        statements.add(JsAstUtils.asSyntheticStatement(JsAstUtils.assignment(messageRef, correctedMessage)));
        PropertyDescriptor causeProperty = DescriptorUtils.getPropertyByName(classDescriptor.getUnsubstitutedMemberScope(), Name.identifier("cause"));
        JsNameRef causeRef = JsAstUtils.pureFqn(context.getNameForBackingField(causeProperty), receiver.deepCopy());
        statements.add(JsAstUtils.asSyntheticStatement(JsAstUtils.assignment(causeRef, causeArgument.deepCopy())));
    }

    @NotNull
    private List<JsExpression> getAdditionalArgumentsForEnumConstructor() {
        ArrayList<JsExpression> additionalArguments = new ArrayList<JsExpression>();
        additionalArguments.add(this.program().getStringLiteral(this.classDescriptor.getName().asString()));
        additionalArguments.add(this.program().getNumberLiteral(this.ordinal));
        ArrayList<JsExpression> arrayList = additionalArguments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "getAdditionalArgumentsForEnumConstructor"));
        }
        return arrayList;
    }

    private void addCallToSuperMethod(@NotNull List<JsExpression> arguments2, @NotNull JsFunction initializer2) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "addCallToSuperMethod"));
        }
        if (initializer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "addCallToSuperMethod"));
        }
        if (initializer2.getName() == null) {
            JsName ref = this.context().scope().declareName("$fun");
            initializer2.setName(ref);
        }
        ClassDescriptor superclassDescriptor = DescriptorUtilsKt.getSuperClassOrAny(this.classDescriptor);
        JsNameRef superConstructorRef = this.context().getInnerReference(superclassDescriptor);
        JsInvocation call2 = new JsInvocation((JsExpression)Namer.getFunctionCallRef(superConstructorRef), new JsExpression[0]);
        call2.getArguments().add(JsLiteral.THIS);
        call2.getArguments().addAll(arguments2);
        this.initFunction.getBody().getStatements().add(call2.makeStmt());
    }

    private void addCallToSuperSecondaryConstructor(@NotNull List<JsExpression> arguments2, @NotNull ConstructorDescriptor descriptor2) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "addCallToSuperSecondaryConstructor"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "addCallToSuperSecondaryConstructor"));
        }
        JsNameRef reference = this.context.getInnerReference(descriptor2);
        JsInvocation call2 = new JsInvocation((JsExpression)reference, new JsExpression[0]);
        call2.getArguments().addAll(arguments2);
        call2.getArguments().add(JsLiteral.THIS);
        this.initFunction.getBody().getStatements().add(call2.makeStmt());
    }

    @NotNull
    private List<JsParameter> translatePrimaryConstructorParameters() {
        List<KtParameter> parameterList = PsiUtils.getPrimaryConstructorParameters(this.classDeclaration);
        ArrayList<JsParameter> result2 = new ArrayList<JsParameter>();
        for (KtParameter jetParameter : parameterList) {
            result2.add(this.translateParameter(jetParameter));
        }
        ArrayList<JsParameter> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "translatePrimaryConstructorParameters"));
        }
        return arrayList;
    }

    @NotNull
    private JsParameter translateParameter(@NotNull KtParameter jetParameter) {
        if (jetParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetParameter", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "translateParameter"));
        }
        DeclarationDescriptor parameterDescriptor = BindingUtils.getDescriptorForElement(this.bindingContext(), jetParameter);
        JsName parameterName = this.context().getNameForDescriptor(parameterDescriptor);
        JsParameter jsParameter = new JsParameter(parameterName);
        this.mayBeAddInitializerStatementForProperty(jsParameter, jetParameter);
        JsParameter jsParameter2 = jsParameter;
        if (jsParameter2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "translateParameter"));
        }
        return jsParameter2;
    }

    private void mayBeAddInitializerStatementForProperty(@NotNull JsParameter jsParameter, @NotNull KtParameter jetParameter) {
        if (jsParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsParameter", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "mayBeAddInitializerStatementForProperty"));
        }
        if (jetParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetParameter", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "mayBeAddInitializerStatementForProperty"));
        }
        PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptorForConstructorParameter(this.bindingContext(), jetParameter);
        if (propertyDescriptor == null) {
            return;
        }
        JsNameRef initialValueForProperty = jsParameter.getName().makeRef();
        this.addInitializerOrPropertyDefinition(initialValueForProperty, propertyDescriptor);
    }

    private void addInitializerOrPropertyDefinition(@NotNull JsNameRef initialValue, @NotNull PropertyDescriptor propertyDescriptor) {
        if (initialValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialValue", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "addInitializerOrPropertyDefinition"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "addInitializerOrPropertyDefinition"));
        }
        this.initFunction.getBody().getStatements().add(InitializerUtils.generateInitializerForProperty(this.context(), propertyDescriptor, initialValue));
    }

    private void addThrowableCall() {
        if (!JsDescriptorUtils.isExceptionClass(this.classDescriptor)) {
            return;
        }
        if (JsDescriptorUtils.isImmediateSubtypeOfError(this.classDescriptor)) {
            ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassOrAny(this.classDescriptor);
            JsInvocation invocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn("captureStack", (JsExpression)Namer.kotlinObject()), ReferenceTranslator.translateAsTypeReference(superClass, this.context()), JsLiteral.THIS);
            this.initFunction.getBody().getStatements().add(JsAstUtils.asSyntheticStatement(invocation));
        }
        JsStringLiteral nameLiteral = this.context.program().getStringLiteral(this.context.getInnerNameForDescriptor(this.classDescriptor).getIdent());
        JsBinaryOperation nameAssignment = JsAstUtils.assignment(JsAstUtils.pureFqn("name", (JsExpression)JsLiteral.THIS), nameLiteral);
        this.initFunction.getBody().getStatements().add(JsAstUtils.asSyntheticStatement(nameAssignment));
    }
}

