/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.NewCapturedTypeConstructor;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/CapturedTypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "typeProjection", "Lorg/jetbrains/kotlin/types/TypeProjection;", "(Lorg/jetbrains/kotlin/types/TypeProjection;)V", "newTypeConstructor", "Lorg/jetbrains/kotlin/types/checker/NewCapturedTypeConstructor;", "getNewTypeConstructor", "()Lorg/jetbrains/kotlin/types/checker/NewCapturedTypeConstructor;", "setNewTypeConstructor", "(Lorg/jetbrains/kotlin/types/checker/NewCapturedTypeConstructor;)V", "getTypeProjection", "()Lorg/jetbrains/kotlin/types/TypeProjection;", "getBuiltIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getDeclarationDescriptor", "", "getParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getSupertypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "isDenotable", "", "isFinal", "toString", "", "kotlin-compiler"})
public final class CapturedTypeConstructor
implements TypeConstructor {
    @Nullable
    private NewCapturedTypeConstructor newTypeConstructor;
    @NotNull
    private final TypeProjection typeProjection;

    @Nullable
    public final NewCapturedTypeConstructor getNewTypeConstructor() {
        return this.newTypeConstructor;
    }

    public final void setNewTypeConstructor(@Nullable NewCapturedTypeConstructor newCapturedTypeConstructor) {
        this.newTypeConstructor = newCapturedTypeConstructor;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        KotlinType kotlinType;
        if (Intrinsics.areEqual((Object)this.typeProjection.getProjectionKind(), (Object)Variance.OUT_VARIANCE)) {
            KotlinType kotlinType2 = this.typeProjection.getType();
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "typeProjection.type");
        } else {
            SimpleType simpleType2 = this.getBuiltIns().getNullableAnyType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "builtIns.nullableAnyType");
            kotlinType = simpleType2;
        }
        KotlinType superType = kotlinType;
        return CollectionsKt.listOf(superType);
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Nullable
    public Void getDeclarationDescriptor() {
        return null;
    }

    @NotNull
    public String toString() {
        return "CapturedTypeConstructor(" + this.typeProjection + ")";
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        KotlinBuiltIns kotlinBuiltIns = this.typeProjection.getType().getConstructor().getBuiltIns();
        Intrinsics.checkExpressionValueIsNotNull(kotlinBuiltIns, "typeProjection.type.constructor.builtIns");
        return kotlinBuiltIns;
    }

    @NotNull
    public final TypeProjection getTypeProjection() {
        return this.typeProjection;
    }

    public CapturedTypeConstructor(@NotNull TypeProjection typeProjection) {
        Intrinsics.checkParameterIsNotNull(typeProjection, "typeProjection");
        this.typeProjection = typeProjection;
        boolean bl = Intrinsics.areEqual((Object)this.typeProjection.getProjectionKind(), (Object)Variance.INVARIANT) ^ true;
        if (_Assertions.ENABLED && !bl) {
            String string = "Only nontrivial projections can be captured, not: " + this.typeProjection;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }
}

