/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.testingUtils;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.incremental.testingUtils.IncrementalModificationUtilsKt;
import org.jetbrains.kotlin.incremental.testingUtils.Modification;
import org.jetbrains.kotlin.incremental.testingUtils.TouchFile;
import org.jetbrains.kotlin.incremental.testingUtils.TouchPolicy;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0002\u001a:\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00010\u00012\u0006\u0010\b\u001a\u00020\u00072\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"COMMANDS", "", "", "COMMANDS_AS_MESSAGE_PART", "COMMANDS_AS_REGEX_PART", "copyTestSources", "", "Ljava/io/File;", "testDataDir", "sourceDestinationDir", "filePrefix", "getModificationsToPerform", "Lorg/jetbrains/kotlin/incremental/testingUtils/Modification;", "moduleNames", "", "allowNoFilesWithSuffixInTestData", "", "touchPolicy", "Lorg/jetbrains/kotlin/incremental/testingUtils/TouchPolicy;", "kotlin-build-common"})
public final class IncrementalModificationUtilsKt {
    private static final List<String> COMMANDS = CollectionsKt.listOf((Object[])new String[]{"new", "touch", "delete"});
    private static final String COMMANDS_AS_REGEX_PART = CollectionsKt.joinToString$default((Iterable)COMMANDS, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
    private static final String COMMANDS_AS_MESSAGE_PART = CollectionsKt.joinToString$default((Iterable)COMMANDS, (CharSequence)"/", null, null, (int)0, null, (Function1)COMMANDS_AS_MESSAGE_PART.1.INSTANCE, (int)30, null);

    @NotNull
    public static final Map<File, File> copyTestSources(@NotNull File testDataDir, @NotNull File sourceDestinationDir, @NotNull String filePrefix) {
        Intrinsics.checkParameterIsNotNull((Object)testDataDir, (String)"testDataDir");
        Intrinsics.checkParameterIsNotNull((Object)sourceDestinationDir, (String)"sourceDestinationDir");
        Intrinsics.checkParameterIsNotNull((Object)filePrefix, (String)"filePrefix");
        HashMap mapping = new HashMap();
        FileUtil.copyDir((File)testDataDir, (File)sourceDestinationDir, (FileFilter)new FileFilter(filePrefix){
            final /* synthetic */ String $filePrefix;

            public final boolean accept(File it) {
                return it.isDirectory() || StringsKt.startsWith$default((String)it.getName(), (String)this.$filePrefix, (boolean)false, (int)2, null) && (StringsKt.endsWith$default((String)it.getName(), (String)".kt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it.getName(), (String)".java", (boolean)false, (int)2, null));
            }
            {
                this.$filePrefix = string;
            }
        });
        for (File file : FilesKt.walk$default((File)sourceDestinationDir, null, (int)1, null)) {
            File file2;
            if (!file.isFile()) continue;
            Object object = filePrefix;
            if (object.length() == 0) {
                file2 = file;
            } else {
                object = new File(sourceDestinationDir, StringsKt.removePrefix((String)file.getName(), (CharSequence)filePrefix));
                File $receiver = (File)object;
                file.renameTo($receiver);
                file2 = (File)object;
            }
            File renamedFile = file2;
            object = mapping;
            File file3 = new File(testDataDir, file.getName());
            object.put(renamedFile, file3);
        }
        return mapping;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<List<Modification>> getModificationsToPerform(@NotNull File testDataDir, @Nullable Collection<String> moduleNames, boolean allowNoFilesWithSuffixInTestData, @NotNull TouchPolicy touchPolicy) {
        Object $receiver$iv$iv;
        boolean haveFilesWithNumbers;
        Object $receiver$iv;
        boolean haveFilesWithoutNumbers;
        Iterator iterator;
        Object element$iv2;
        Function3<String, String, String, List<? extends Modification>> getModificationsForIteration$;
        block9: {
            boolean bl;
            boolean bl2;
            CharSequence charSequence;
            block8: {
                Intrinsics.checkParameterIsNotNull((Object)testDataDir, (String)"testDataDir");
                Intrinsics.checkParameterIsNotNull((Object)((Object)touchPolicy), (String)"touchPolicy");
                getModificationsForIteration$ = new Function3<String, String, String, List<? extends Modification>>(moduleNames, touchPolicy, testDataDir){
                    final /* synthetic */ Collection $moduleNames;
                    final /* synthetic */ TouchPolicy $touchPolicy;
                    final /* synthetic */ File $testDataDir;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<Modification> invoke(@NotNull String newSuffix, @NotNull String touchSuffix, @NotNull String deleteSuffix) {
                        Intrinsics.checkParameterIsNotNull((Object)newSuffix, (String)"newSuffix");
                        Intrinsics.checkParameterIsNotNull((Object)touchSuffix, (String)"touchSuffix");
                        Intrinsics.checkParameterIsNotNull((Object)deleteSuffix, (String)"deleteSuffix");
                        Function1<String, Pair<? extends String, ? extends String>> splitToModuleNameAndFileName$ = new Function1<String, Pair<? extends String, ? extends String>>(this){
                            final /* synthetic */ getModificationsToPerform.1 this$0;

                            @NotNull
                            public final Pair<String, String> invoke(@NotNull String fileName) {
                                boolean bl;
                                Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
                                int underscore = StringsKt.indexOf$default((CharSequence)fileName, (String)"_", (int)0, (boolean)false, (int)6, null);
                                if (underscore != -1) {
                                    Pair pair;
                                    boolean bl2;
                                    String string = fileName;
                                    int n = 0;
                                    String string2 = string;
                                    if (string2 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    String string3 = string2.substring(n, underscore);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    String module = string3;
                                    boolean bl3 = bl2 = this.this$0.$moduleNames != null;
                                    if (_Assertions.ENABLED && !bl2) {
                                        String string4 = "File name has module prefix, but multi-module environment is absent";
                                        throw (Throwable)((Object)new AssertionError((Object)string4));
                                    }
                                    Collection collection = this.this$0.$moduleNames;
                                    if (collection == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    bl2 = collection.contains(module);
                                    if (_Assertions.ENABLED && !bl2) {
                                        String string5 = "Module not found for file with prefix: " + fileName;
                                        throw (Throwable)((Object)new AssertionError((Object)string5));
                                    }
                                    String string6 = fileName;
                                    n = underscore + 1;
                                    String string7 = module;
                                    Pair pair2 = pair;
                                    Pair pair3 = pair;
                                    String string8 = string6;
                                    if (string8 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    String string9 = string8.substring(n);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                                    String string10 = string9;
                                    pair2((Object)string7, (Object)string10);
                                    return pair3;
                                }
                                boolean bl4 = bl = this.this$0.$moduleNames == null;
                                if (_Assertions.ENABLED && !bl) {
                                    String string = "Test is multi-module, but file has no module prefix: " + fileName;
                                    throw (Throwable)((Object)new AssertionError((Object)string));
                                }
                                return new Pair(null, (Object)fileName);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        };
                        Map rules2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)newSuffix, (Object)((Object)getModificationsToPerform.rules.1.INSTANCE)), TuplesKt.to((Object)touchSuffix, (Object)new Function2<String, File, TouchFile>(this){
                            final /* synthetic */ getModificationsToPerform.1 this$0;

                            @NotNull
                            public final TouchFile invoke(@NotNull String path, @NotNull File file) {
                                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                                return new TouchFile(path, this.this$0.$touchPolicy);
                            }
                            {
                                this.this$0 = var1_1;
                                super(2);
                            }
                        }), TuplesKt.to((Object)deleteSuffix, (Object)((Object)getModificationsToPerform.rules.3.INSTANCE))});
                        ArrayList<Object> modifications = new ArrayList<Object>();
                        for (File file : FilesKt.walkTopDown((File)this.$testDataDir)) {
                            void suffix;
                            void fileName;
                            void createModification;
                            void var12_12;
                            void moduleName;
                            Object object;
                            Object v0;
                            Object it;
                            Iterator<T> iterator;
                            Object $receiver$iv;
                            String relativeFilePath;
                            block4: {
                                if (!file.isFile()) continue;
                                relativeFilePath = FilesKt.toRelativeString((File)file, (File)this.$testDataDir);
                                $receiver$iv = rules2.entrySet();
                                iterator = $receiver$iv.iterator();
                                while (iterator.hasNext()) {
                                    T element$iv = iterator.next();
                                    it = (Map.Entry)element$iv;
                                    if (!StringsKt.endsWith$default((String)file.getPath(), (String)((String)it.getKey()), (boolean)false, (int)2, null)) continue;
                                    v0 = element$iv;
                                    break block4;
                                }
                                v0 = null;
                            }
                            Map.Entry entry = v0;
                            if (entry == null) {
                                continue;
                            }
                            $receiver$iv = object = entry;
                            String string = (String)$receiver$iv.getKey();
                            $receiver$iv = object;
                            Function2 function2 = (Function2)$receiver$iv.getValue();
                            object = null;
                            iterator = splitToModuleNameAndFileName$.invoke(relativeFilePath);
                            object = (String)iterator.component1();
                            $receiver$iv = (String)iterator.component2();
                            iterator = null;
                            String string2 = moduleName;
                            if (string2 == null || (string2 = (String)(it = (String)(var12_12 = string2)) + "/src") == null) {
                                string2 = "src";
                            }
                            String srcDir = string2;
                            modifications.add(createModification.invoke((Object)(srcDir + "/" + StringsKt.removeSuffix((String)fileName, (CharSequence)((CharSequence)suffix))), (Object)file));
                        }
                        return modifications;
                    }
                    {
                        this.$moduleNames = collection;
                        this.$touchPolicy = touchPolicy;
                        this.$testDataDir = file;
                        super(3);
                    }
                };
                Sequence $receiver$iv2 = (Sequence)FilesKt.walkTopDown((File)testDataDir);
                for (Object element$iv2 : $receiver$iv2) {
                    File it = (File)element$iv2;
                    iterator = it.getName();
                    charSequence = ".+" + "\\" + ".(" + COMMANDS_AS_REGEX_PART + ")" + "$";
                    if (!(charSequence = new Regex((String)charSequence)).matches((CharSequence)((Object)iterator))) continue;
                    bl2 = true;
                    break block8;
                }
                bl2 = false;
            }
            haveFilesWithoutNumbers = bl2;
            $receiver$iv = (Sequence)FilesKt.walkTopDown((File)testDataDir);
            element$iv2 = $receiver$iv.iterator();
            while (element$iv2.hasNext()) {
                Object element$iv3 = element$iv2.next();
                File it = (File)element$iv3;
                charSequence = it.getName();
                String $i$a$1$any = ".+" + "\\" + ".(" + COMMANDS_AS_REGEX_PART + ")" + "\\" + "." + "\\" + "d+" + "$";
                if (!($i$a$1$any = new Regex($i$a$1$any)).matches(charSequence)) continue;
                bl = true;
                break block9;
            }
            bl = haveFilesWithNumbers = false;
        }
        if (haveFilesWithoutNumbers && haveFilesWithNumbers) {
            throw (Throwable)new IllegalStateException("Bad test data format: files ending with both unnumbered and numbered " + COMMANDS_AS_MESSAGE_PART + " were found");
        }
        if (!haveFilesWithoutNumbers && !haveFilesWithNumbers) {
            if (allowNoFilesWithSuffixInTestData) {
                return CollectionsKt.listOf((Object)CollectionsKt.emptyList());
            }
            throw (Throwable)new IllegalStateException("Bad test data format: no files ending with " + COMMANDS_AS_MESSAGE_PART + " found");
        }
        if (haveFilesWithoutNumbers) {
            return CollectionsKt.listOf(getModificationsForIteration$.invoke(".new", ".touch", ".delete"));
        }
        $receiver$iv = (Iterable)new IntRange(1, 10);
        element$iv2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int $i$a$1$any = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            List<Modification> list = getModificationsForIteration$.invoke(".new." + (int)it, ".touch." + (int)it, ".delete." + (int)it);
            collection.add(list);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            List it = (List)element$iv$iv;
            Collection collection = it;
            if (!(!collection.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

