/*
 * Decompiled with CFR 0.152.
 */
package com.metasploit.meterpreter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TLVPacket {
    public static final int PACKET_TYPE_REQUEST = 0;
    public static final int PACKET_TYPE_RESPONSE = 1;
    public static final int TLV_META_TYPE_NONE = 0;
    public static final int TLV_META_TYPE_STRING = 65536;
    public static final int TLV_META_TYPE_UINT = 131072;
    public static final int TLV_META_TYPE_RAW = 262144;
    public static final int TLV_META_TYPE_BOOL = 524288;
    public static final int TLV_META_TYPE_QWORD = 0x100000;
    public static final int TLV_META_TYPE_COMPRESSED = 0x20000000;
    public static final int TLV_META_TYPE_GROUP = 0x40000000;
    public static final int TLV_META_TYPE_COMPLEX = Integer.MIN_VALUE;
    public static final int TLV_META_TYPE_MASK = -535887872;
    private List typeOrder = new ArrayList();
    private List valueList = new ArrayList();
    private Map valueMap = new HashMap();
    private List overflowList = new ArrayList();

    public TLVPacket() {
    }

    public TLVPacket(DataInputStream dataInputStream, int n) throws IOException {
        while (n > 0) {
            Object object;
            Object object2;
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            if (n2 > n) break;
            byte[] byArray = new byte[n2 - 8];
            n -= n2;
            if ((n3 & 0x20000000) != 0) {
                dataInputStream.readFully(byArray);
                object2 = byArray;
            } else if ((n3 & 0x10000) != 0) {
                dataInputStream.readFully(byArray);
                object = new String(byArray, "UTF-8");
                if (!((String)object).endsWith("\u0000")) {
                    throw new IOException("C string is not 0 terminated: " + (String)object);
                }
                if (((String)(object = ((String)object).substring(0, ((String)object).length() - 1))).indexOf(0) != -1) {
                    throw new IOException("Embedded null detected: " + (String)object);
                }
                object2 = object;
            } else if ((n3 & 0x100000) != 0 && n2 == 16) {
                object2 = new Long(dataInputStream.readLong());
            } else if ((n3 & 0x20000) != 0 && n2 == 12) {
                object2 = new Integer(dataInputStream.readInt());
            } else if ((n3 & 0x80000) != 0 && n2 == 9) {
                object2 = new Boolean(dataInputStream.readBoolean());
            } else if ((n3 & 0x40000) != 0) {
                dataInputStream.readFully(byArray);
                object2 = byArray;
            } else if ((n3 & 0x40000000) != 0) {
                dataInputStream.readFully(byArray);
                object = new DataInputStream(new ByteArrayInputStream(byArray));
                object2 = new TLVPacket((DataInputStream)object, byArray.length);
                ((FilterInputStream)object).close();
            } else if ((n3 & Integer.MIN_VALUE) != 0) {
                dataInputStream.readFully(byArray);
                object2 = byArray;
            } else {
                throw new IOException("Unsupported type: " + n3 + "/" + n2);
            }
            this.add(n3, object2);
        }
        if (n != 0) {
            throw new IOException("Incomplete packets detected");
        }
    }

    public void add(int n, Object object) throws IOException {
        ArrayList arrayList = null;
        Integer n2 = new Integer(n);
        this.typeOrder.add(n2);
        if (this.valueMap.containsKey(n2)) {
            arrayList = (ArrayList)this.valueMap.get(n2);
        } else {
            arrayList = new ArrayList();
            this.valueMap.put(n2, arrayList);
        }
        arrayList.add(new Integer(this.valueList.size()));
        this.valueList.add(object);
    }

    public void addOverflow(int n, Object object) throws IOException {
        this.overflowList.add(new Integer(n));
        this.overflowList.add(object);
    }

    public void add(int n, long l) throws IOException {
        this.add(n, new Long(l));
    }

    public void add(int n, int n2) throws IOException {
        this.add(n, new Integer(n2));
    }

    public void add(int n, boolean bl) throws IOException {
        this.add(n, new Boolean(bl));
    }

    public List getTypeOrder() {
        return Collections.unmodifiableList(this.typeOrder);
    }

    public Object getValue(int n) {
        ArrayList arrayList = (ArrayList)this.valueMap.get(new Integer(n));
        if (arrayList == null) {
            throw new IllegalArgumentException("Cannot find type " + n);
        }
        return this.valueList.get((Integer)arrayList.get(0));
    }

    public List getValues(int n) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = (ArrayList)this.valueMap.get(new Integer(n));
        if (arrayList2 == null) {
            throw new IllegalArgumentException("Cannot find type " + n);
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList.add(this.valueList.get((Integer)arrayList2.get(i)));
        }
        return arrayList;
    }

    public Object getValue(int n, Object object) {
        ArrayList arrayList = (ArrayList)this.valueMap.get(new Integer(n));
        if (arrayList == null) {
            return object;
        }
        return this.valueList.get((Integer)arrayList.get(0));
    }

    public String getStringValue(int n) {
        return (String)this.getValue(n);
    }

    public String getStringValue(int n, String string) {
        return (String)this.getValue(n, string);
    }

    public long getLongValue(int n) {
        return (Long)this.getValue(n);
    }

    public int getIntValue(int n) {
        return (Integer)this.getValue(n);
    }

    public boolean getBooleanValue(int n) {
        return (Boolean)this.getValue(n);
    }

    public byte[] getRawValue(int n) {
        return (byte[])this.getValue(n);
    }

    public byte[] getRawValue(int n, byte[] byArray) {
        return (byte[])this.getValue(n, byArray);
    }

    public TLVPacket createResponse() throws IOException {
        TLVPacket tLVPacket = new TLVPacket();
        tLVPacket.add(65537, this.getStringValue(65537));
        tLVPacket.add(65538, this.getStringValue(65538, null));
        return tLVPacket;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Object object;
        int n;
        for (Integer n2 : this.typeOrder) {
            n = n2;
            object = this.getValue(n);
            TLVPacket.write(dataOutputStream, n, object);
        }
        Iterator iterator = this.overflowList.iterator();
        while (iterator.hasNext()) {
            Integer n2;
            n2 = (Integer)iterator.next();
            n = n2;
            object = iterator.next();
            TLVPacket.write(dataOutputStream, n, object);
        }
    }

    private static void write(DataOutputStream dataOutputStream, int n, Object object) throws IOException {
        byte[] byArray;
        if ((n & 0x10000) != 0) {
            byArray = ((String)object + "\u0000").getBytes("UTF-8");
        } else {
            if ((n & 0x100000) != 0) {
                dataOutputStream.writeInt(16);
                dataOutputStream.writeInt(n);
                dataOutputStream.writeLong((Long)object);
                return;
            }
            if ((n & 0x20000) != 0) {
                dataOutputStream.writeInt(12);
                dataOutputStream.writeInt(n);
                dataOutputStream.writeInt((Integer)object);
                return;
            }
            if ((n & 0x80000) != 0) {
                dataOutputStream.writeInt(9);
                dataOutputStream.writeInt(n);
                dataOutputStream.writeBoolean((Boolean)object);
                return;
            }
            if ((n & 0x40000) != 0) {
                byArray = (byte[])object;
            } else if ((n & 0x40000000) != 0) {
                byArray = ((TLVPacket)object).toByteArray();
            } else if ((n & Integer.MIN_VALUE) != 0) {
                byArray = (byte[])object;
            } else {
                throw new IOException("Unsupported type: " + n);
            }
        }
        dataOutputStream.writeInt(8 + byArray.length);
        dataOutputStream.writeInt(n);
        dataOutputStream.write(byArray);
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(new DataOutputStream(byteArrayOutputStream));
        return byteArrayOutputStream.toByteArray();
    }
}

