/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Enumeration
implements Cloneable {
    private List<Element> elements;
    private boolean is_Final = false;

    public Enumeration(List<Element> elements) {
        this.elements = elements;
    }

    public Enumeration(Enumeration src) {
        int sz = src.elements.size();
        this.elements = new ArrayList<Element>(sz);
        int s = sz;
        for (int i = 0; i < s; ++i) {
            this.elements.add(src.getElement(i).clone());
        }
        this.is_Final = src.is_Final;
    }

    public void addElement(Element newele) {
        for (Element ele : this.elements) {
            if (!ele.getName().equals(newele.getName())) continue;
            throw new Ili2cSemanticException(newele.getSourceLine(), ch.interlis.ili2c.metamodel.Element.formatMessage("err_enumerationType_DupEle", newele.getName()));
        }
        this.elements.add(newele);
    }

    public Iterator<Element> getElements() {
        return this.elements.iterator();
    }

    public Element getElement(int index) {
        return this.elements.get(index);
    }

    public int size() {
        return this.elements.size();
    }

    public int treeSize() {
        int sz;
        int ts = sz = this.size();
        for (int i = 0; i < sz; ++i) {
            Enumeration e = this.getElement((int)i).subEnum;
            if (e == null) continue;
            ts += e.treeSize() - 1;
        }
        return ts;
    }

    public void setFinal(boolean newValue) {
        this.is_Final = newValue;
    }

    public boolean isFinal() {
        return this.is_Final;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(50);
        buf.append('(');
        for (int i = 0; i < this.elements.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.elements.get(i).toString());
        }
        if (this.is_Final) {
            if (this.elements.size() > 0) {
                buf.append(" : ");
            }
            buf.append("FINAL");
        }
        buf.append(')');
        return buf.toString();
    }

    public Enumeration clone() {
        Enumeration cloned = null;
        try {
            int sz = this.elements.size();
            cloned = (Enumeration)super.clone();
            cloned.elements = new ArrayList<Element>(sz);
            for (int i = 0; i < sz; ++i) {
                cloned.elements.add(this.getElement(i).clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return cloned;
    }

    public static class Element
    implements Cloneable {
        protected String name = "";
        protected Enumeration subEnum = null;
        private String documentation = null;
        private Settings metaValues = null;
        private int sourceLine = 0;

        public Element(Element src) {
            this.name = src.name;
            this.documentation = src.documentation;
            if (src.subEnum != null) {
                this.subEnum = new Enumeration(src.subEnum);
            }
            this.sourceLine = src.sourceLine;
            this.metaValues = new Settings(src.metaValues);
        }

        public Element(String name) {
            this.name = name;
        }

        public Element(String name, Enumeration subEnum) {
            this.name = name;
            this.subEnum = subEnum;
        }

        public String getName() {
            return this.name;
        }

        public Enumeration getSubEnumeration() {
            return this.subEnum;
        }

        public void setSubEnumeration(Enumeration newSubEnum) {
            this.subEnum = newSubEnum;
        }

        public String toString() {
            if (this.subEnum == null) {
                return this.name;
            }
            return this.name + " " + this.subEnum.toString();
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public void setDocumentation(String string) {
            this.documentation = string;
        }

        public int getSourceLine() {
            return this.sourceLine;
        }

        public void setSourceLine(int sourceLine) {
            this.sourceLine = sourceLine;
        }

        public Settings getMetaValues() {
            if (this.metaValues == null) {
                this.metaValues = new Settings();
            }
            return this.metaValues;
        }

        public void setMetaValues(Settings metaValues) {
            this.metaValues = metaValues;
        }

        public Element clone() {
            Element cloned = null;
            try {
                cloned = (Element)super.clone();
                if (this.subEnum != null) {
                    cloned.subEnum = this.subEnum.clone();
                }
                if (this.metaValues != null) {
                    cloned.metaValues = new Settings(this.metaValues);
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return cloned;
        }
    }
}

