/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.model.StructuralNodeModifier;
import org.zaproxy.zap.view.AbstractMultipleOptionsTableModel;

public class StructuralNodeModifiersTableModel
extends AbstractMultipleOptionsTableModel<StructuralNodeModifier> {
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("context.ddn.table.header.type"), Constant.messages.getString("context.ddn.table.header.name"), Constant.messages.getString("context.ddn.table.header.regex")};
    private static final long serialVersionUID = 4463944219657112162L;
    private List<StructuralNodeModifier> snms = new ArrayList<StructuralNodeModifier>();

    public StructuralNodeModifiersTableModel(List<StructuralNodeModifier> list) {
        this.snms = new ArrayList<StructuralNodeModifier>(list);
    }

    public StructuralNodeModifiersTableModel() {
        this.snms = new ArrayList<StructuralNodeModifier>();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.snms.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                switch (this.snms.get(n).getType()) {
                    case StructuralParameter: {
                        return Constant.messages.getString("context.ddn.table.type.struct");
                    }
                    case DataDrivenNode: {
                        return Constant.messages.getString("context.ddn.table.type.data");
                    }
                }
                return null;
            }
            case 1: {
                return this.snms.get(n).getName();
            }
            case 2: {
                if (this.snms.get(n).getPattern() != null) {
                    return this.snms.get(n).getPattern().pattern();
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public List<StructuralNodeModifier> getElements() {
        return this.snms;
    }

    public List<StructuralNodeModifier> getStructuralNodeModifiers() {
        return this.snms;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setStructuralNodeModifiers(List<StructuralNodeModifier> list) {
        this.snms = new ArrayList<StructuralNodeModifier>(list);
        this.fireTableDataChanged();
    }

    public void addStructuralNodeModifiers(List<StructuralNodeModifier> list) {
        this.snms.addAll(list);
        this.fireTableDataChanged();
    }

    public void removeAllStructuralNodeModifiers() {
        this.snms = new ArrayList<StructuralNodeModifier>();
        this.fireTableDataChanged();
    }

    public void addStructuralNodeModifier(StructuralNodeModifier structuralNodeModifier) {
        this.snms.add(structuralNodeModifier);
        this.fireTableRowsInserted(this.snms.size() - 1, this.snms.size() - 1);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }
}

