/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.win.EHTMLReadMode;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

class HTMLCodec
extends InputStream {
    public static final String ENCODING = "UTF-8";
    public static final String VERSION = "Version:";
    public static final String START_HTML = "StartHTML:";
    public static final String END_HTML = "EndHTML:";
    public static final String START_FRAGMENT = "StartFragment:";
    public static final String END_FRAGMENT = "EndFragment:";
    public static final String START_SELECTION = "StartSelection:";
    public static final String END_SELECTION = "EndSelection:";
    public static final String START_FRAGMENT_CMT = "<!--StartFragment-->";
    public static final String END_FRAGMENT_CMT = "<!--EndFragment-->";
    public static final String SOURCE_URL = "SourceURL:";
    public static final String DEF_SOURCE_URL = "about:blank";
    public static final String EOLN = "\r\n";
    private static final String VERSION_NUM = "1.0";
    private static final int PADDED_WIDTH = 10;
    private final BufferedInputStream bufferedStream;
    private boolean descriptionParsed = false;
    private boolean closed = false;
    public static final int BYTE_BUFFER_LEN = 8192;
    public static final int CHAR_BUFFER_LEN = 2730;
    private static final String FAILURE_MSG = "Unable to parse HTML description: ";
    private static final String INVALID_MSG = " invalid";
    private long iHTMLStart;
    private long iHTMLEnd;
    private long iFragStart;
    private long iFragEnd;
    private long iSelStart;
    private long iSelEnd;
    private String stBaseURL;
    private String stVersion;
    private long iStartOffset;
    private long iEndOffset;
    private long iReadCount;
    private EHTMLReadMode readMode;

    private static String toPaddedString(int n, int width) {
        String string = "" + n;
        int len = string.length();
        if (n >= 0 && len < width) {
            char[] array = new char[width - len];
            Arrays.fill(array, '0');
            StringBuffer buffer = new StringBuffer(width);
            buffer.append(array);
            buffer.append(string);
            string = buffer.toString();
        }
        return string;
    }

    public static byte[] convertToHTMLFormat(byte[] bytes) {
        String htmlPrefix = "";
        String htmlSuffix = "";
        String stContext = new String(bytes);
        String stUpContext = stContext.toUpperCase();
        if (-1 == stUpContext.indexOf("<HTML")) {
            htmlPrefix = "<HTML>";
            htmlSuffix = "</HTML>";
            if (-1 == stUpContext.indexOf("<BODY")) {
                htmlPrefix = htmlPrefix + "<BODY>";
                htmlSuffix = "</BODY>" + htmlSuffix;
            }
        }
        htmlPrefix = htmlPrefix + START_FRAGMENT_CMT;
        htmlSuffix = END_FRAGMENT_CMT + htmlSuffix;
        String stBaseUrl = DEF_SOURCE_URL;
        int nStartHTML = VERSION.length() + VERSION_NUM.length() + EOLN.length() + START_HTML.length() + 10 + EOLN.length() + END_HTML.length() + 10 + EOLN.length() + START_FRAGMENT.length() + 10 + EOLN.length() + END_FRAGMENT.length() + 10 + EOLN.length() + SOURCE_URL.length() + stBaseUrl.length() + EOLN.length();
        int nStartFragment = nStartHTML + htmlPrefix.length();
        int nEndFragment = nStartFragment + bytes.length - 1;
        int nEndHTML = nEndFragment + htmlSuffix.length();
        StringBuilder header = new StringBuilder(nStartFragment + START_FRAGMENT_CMT.length());
        header.append(VERSION);
        header.append(VERSION_NUM);
        header.append(EOLN);
        header.append(START_HTML);
        header.append(HTMLCodec.toPaddedString(nStartHTML, 10));
        header.append(EOLN);
        header.append(END_HTML);
        header.append(HTMLCodec.toPaddedString(nEndHTML, 10));
        header.append(EOLN);
        header.append(START_FRAGMENT);
        header.append(HTMLCodec.toPaddedString(nStartFragment, 10));
        header.append(EOLN);
        header.append(END_FRAGMENT);
        header.append(HTMLCodec.toPaddedString(nEndFragment, 10));
        header.append(EOLN);
        header.append(SOURCE_URL);
        header.append(stBaseUrl);
        header.append(EOLN);
        header.append(htmlPrefix);
        byte[] headerBytes = null;
        byte[] trailerBytes = null;
        try {
            headerBytes = header.toString().getBytes(ENCODING);
            trailerBytes = htmlSuffix.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException cannotHappen) {
            // empty catch block
        }
        byte[] retval = new byte[headerBytes.length + bytes.length + trailerBytes.length];
        System.arraycopy(headerBytes, 0, retval, 0, headerBytes.length);
        System.arraycopy(bytes, 0, retval, headerBytes.length, bytes.length - 1);
        System.arraycopy(trailerBytes, 0, retval, headerBytes.length + bytes.length - 1, trailerBytes.length);
        retval[retval.length - 1] = 0;
        return retval;
    }

    public HTMLCodec(InputStream _bytestream, EHTMLReadMode _readMode) throws IOException {
        this.bufferedStream = new BufferedInputStream(_bytestream, 8192);
        this.readMode = _readMode;
    }

    public synchronized String getBaseURL() throws IOException {
        if (!this.descriptionParsed) {
            this.parseDescription();
        }
        return this.stBaseURL;
    }

    public synchronized String getVersion() throws IOException {
        if (!this.descriptionParsed) {
            this.parseDescription();
        }
        return this.stVersion;
    }

    private void parseDescription() throws IOException {
        String stLine;
        this.stBaseURL = null;
        this.stVersion = null;
        this.iSelStart = -1L;
        this.iSelEnd = -1L;
        this.iFragStart = -1L;
        this.iFragEnd = -1L;
        this.iHTMLStart = -1L;
        this.iHTMLEnd = -1L;
        this.bufferedStream.mark(8192);
        String[] astEntries = new String[]{VERSION, START_HTML, END_HTML, START_FRAGMENT, END_FRAGMENT, START_SELECTION, END_SELECTION, SOURCE_URL};
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)this.bufferedStream, ENCODING), 2730);
        long iHeadSize = 0L;
        long iCRSize = EOLN.length();
        int iEntCount = astEntries.length;
        boolean bContinue = true;
        block16: for (int iEntry = 0; iEntry < iEntCount && null != (stLine = bufferedReader.readLine()); ++iEntry) {
            while (iEntry < iEntCount) {
                if (stLine.startsWith(astEntries[iEntry])) {
                    iHeadSize += (long)stLine.length() + iCRSize;
                    String stValue = stLine.substring(astEntries[iEntry].length()).trim();
                    if (null == stValue) continue block16;
                    try {
                        switch (iEntry) {
                            case 0: {
                                this.stVersion = stValue;
                                break;
                            }
                            case 1: {
                                this.iHTMLStart = Integer.parseInt(stValue);
                                break;
                            }
                            case 2: {
                                this.iHTMLEnd = Integer.parseInt(stValue);
                                break;
                            }
                            case 3: {
                                this.iFragStart = Integer.parseInt(stValue);
                                break;
                            }
                            case 4: {
                                this.iFragEnd = Integer.parseInt(stValue);
                                break;
                            }
                            case 5: {
                                this.iSelStart = Integer.parseInt(stValue);
                                break;
                            }
                            case 6: {
                                this.iSelEnd = Integer.parseInt(stValue);
                                break;
                            }
                            case 7: {
                                this.stBaseURL = stValue;
                            }
                        }
                        continue block16;
                    }
                    catch (NumberFormatException e) {
                        throw new IOException(FAILURE_MSG + astEntries[iEntry] + " value " + e + INVALID_MSG);
                    }
                }
                ++iEntry;
            }
        }
        if (-1L == this.iHTMLStart) {
            this.iHTMLStart = iHeadSize;
        }
        if (-1L == this.iFragStart) {
            this.iFragStart = this.iHTMLStart;
        }
        if (-1L == this.iFragEnd) {
            this.iFragEnd = this.iHTMLEnd;
        }
        if (-1L == this.iSelStart) {
            this.iSelStart = this.iFragStart;
        }
        if (-1L == this.iSelEnd) {
            this.iSelEnd = this.iFragEnd;
        }
        switch (this.readMode) {
            case HTML_READ_ALL: {
                this.iStartOffset = this.iHTMLStart;
                this.iEndOffset = this.iHTMLEnd;
                break;
            }
            case HTML_READ_FRAGMENT: {
                this.iStartOffset = this.iFragStart;
                this.iEndOffset = this.iFragEnd;
                break;
            }
            default: {
                this.iStartOffset = this.iSelStart;
                this.iEndOffset = this.iSelEnd;
            }
        }
        this.bufferedStream.reset();
        if (-1L == this.iStartOffset) {
            throw new IOException("Unable to parse HTML description: invalid HTML format.");
        }
        int curOffset = 0;
        while ((long)curOffset < this.iStartOffset) {
            curOffset = (int)((long)curOffset + this.bufferedStream.skip(this.iStartOffset - (long)curOffset));
        }
        this.iReadCount = curOffset;
        if (this.iStartOffset != this.iReadCount) {
            throw new IOException("Unable to parse HTML description: Byte stream ends in description.");
        }
        this.descriptionParsed = true;
    }

    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (!this.descriptionParsed) {
            this.parseDescription();
        }
        if (-1L != this.iEndOffset && this.iReadCount >= this.iEndOffset) {
            return -1;
        }
        int retval = this.bufferedStream.read();
        if (retval == -1) {
            return -1;
        }
        ++this.iReadCount;
        return retval;
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.bufferedStream.close();
        }
    }
}

