/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.Utils;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.skin.ScrollBarSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;

public class ScrollBar
extends Control {
    private DoubleProperty min;
    private DoubleProperty max;
    private DoubleProperty value;
    private ObjectProperty<Orientation> orientation;
    private DoubleProperty unitIncrement;
    private DoubleProperty blockIncrement;
    private DoubleProperty visibleAmount;
    private static final String DEFAULT_STYLE_CLASS = "scroll-bar";
    private static final String PSEUDO_CLASS_VERTICAL = "vertical";
    private static final String PSEUDO_CLASS_HORIZONTAL = "horizontal";
    private static final long VERTICAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("vertical");
    private static final long HORIZONTAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("horizontal");

    public ScrollBar() {
        this.setWidth(ScrollBarSkin.DEFAULT_WIDTH);
        this.setHeight(ScrollBarSkin.DEFAULT_LENGTH);
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        StyleableProperty styleableProperty = StyleableProperty.getStyleableProperty(this.focusTraversableProperty());
        styleableProperty.set(this, Boolean.FALSE);
    }

    public final void setMin(double d) {
        this.minProperty().set(d);
    }

    public final double getMin() {
        return this.min == null ? 0.0 : this.min.get();
    }

    public final DoubleProperty minProperty() {
        if (this.min == null) {
            this.min = new SimpleDoubleProperty(this, "min");
        }
        return this.min;
    }

    public final void setMax(double d) {
        this.maxProperty().set(d);
    }

    public final double getMax() {
        return this.max == null ? 100.0 : this.max.get();
    }

    public final DoubleProperty maxProperty() {
        if (this.max == null) {
            this.max = new SimpleDoubleProperty(this, "max", 100.0);
        }
        return this.max;
    }

    public final void setValue(double d) {
        this.valueProperty().set(d);
    }

    public final double getValue() {
        return this.value == null ? 0.0 : this.value.get();
    }

    public final DoubleProperty valueProperty() {
        if (this.value == null) {
            this.value = new SimpleDoubleProperty(this, "value");
        }
        return this.value;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set(orientation);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.HORIZONTAL : (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new StyleableObjectProperty<Orientation>(Orientation.HORIZONTAL){

                @Override
                protected void invalidated() {
                    ScrollBar.this.impl_pseudoClassStateChanged(ScrollBar.PSEUDO_CLASS_VERTICAL);
                    ScrollBar.this.impl_pseudoClassStateChanged(ScrollBar.PSEUDO_CLASS_HORIZONTAL);
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.ORIENTATION;
                }

                @Override
                public Object getBean() {
                    return ScrollBar.this;
                }

                @Override
                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public final void setUnitIncrement(double d) {
        this.unitIncrementProperty().set(d);
    }

    public final double getUnitIncrement() {
        return this.unitIncrement == null ? 1.0 : this.unitIncrement.get();
    }

    public final DoubleProperty unitIncrementProperty() {
        if (this.unitIncrement == null) {
            this.unitIncrement = new StyleableDoubleProperty(1.0){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.UNIT_INCREMENT;
                }

                @Override
                public Object getBean() {
                    return ScrollBar.this;
                }

                @Override
                public String getName() {
                    return "unitIncrement";
                }
            };
        }
        return this.unitIncrement;
    }

    public final void setBlockIncrement(double d) {
        this.blockIncrementProperty().set(d);
    }

    public final double getBlockIncrement() {
        return this.blockIncrement == null ? 10.0 : this.blockIncrement.get();
    }

    public final DoubleProperty blockIncrementProperty() {
        if (this.blockIncrement == null) {
            this.blockIncrement = new StyleableDoubleProperty(10.0){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.BLOCK_INCREMENT;
                }

                @Override
                public Object getBean() {
                    return ScrollBar.this;
                }

                @Override
                public String getName() {
                    return "blockIncrement";
                }
            };
        }
        return this.blockIncrement;
    }

    public final void setVisibleAmount(double d) {
        this.visibleAmountProperty().set(d);
    }

    public final double getVisibleAmount() {
        return this.visibleAmount == null ? 15.0 : this.visibleAmount.get();
    }

    public final DoubleProperty visibleAmountProperty() {
        if (this.visibleAmount == null) {
            this.visibleAmount = new SimpleDoubleProperty(this, "visibleAmount");
        }
        return this.visibleAmount;
    }

    public void adjustValue(double d) {
        double d2 = (this.getMax() - this.getMin()) * Utils.clamp(0.0, d, 1.0) + this.getMin();
        if (d2 != this.getValue()) {
            boolean bl;
            double d3 = d2 > this.getValue() ? this.getValue() + this.getBlockIncrement() : this.getValue() - this.getBlockIncrement();
            boolean bl2 = bl = d > (this.getValue() - this.getMin()) / (this.getMax() - this.getMin());
            if (bl && d3 > d2) {
                d3 = d2;
            }
            if (!bl && d3 < d2) {
                d3 = d2;
            }
            this.setValue(Utils.clamp(this.getMin(), d3, this.getMax()));
        }
    }

    public void increment() {
        this.setValue(Utils.clamp(this.getMin(), this.getValue() + this.getUnitIncrement(), this.getMax()));
    }

    public void decrement() {
        this.setValue(Utils.clamp(this.getMin(), this.getValue() - this.getUnitIncrement(), this.getMax()));
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return ScrollBar.impl_CSS_STYLEABLES();
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        return l |= this.getOrientation() == Orientation.VERTICAL ? VERTICAL_PSEUDOCLASS_STATE : HORIZONTAL_PSEUDOCLASS_STATE;
    }

    @Override
    @Deprecated
    protected Boolean impl_cssGetFocusTraversableInitialValue() {
        return Boolean.FALSE;
    }

    private static class StyleableProperties {
        private static final StyleableProperty<ScrollBar, Orientation> ORIENTATION = new StyleableProperty<ScrollBar, Orientation>("-fx-orientation", new EnumConverter(Orientation.class), Orientation.HORIZONTAL){

            @Override
            public Orientation getInitialValue(ScrollBar scrollBar) {
                return scrollBar.getOrientation();
            }

            @Override
            public boolean isSettable(ScrollBar scrollBar) {
                return scrollBar.orientation == null || !scrollBar.orientation.isBound();
            }

            @Override
            public WritableValue<Orientation> getWritableValue(ScrollBar scrollBar) {
                return scrollBar.orientationProperty();
            }
        };
        private static final StyleableProperty<ScrollBar, Number> UNIT_INCREMENT = new StyleableProperty<ScrollBar, Number>("-fx-unit-increment", (StyleConverter)SizeConverter.getInstance(), (Number)1.0){

            @Override
            public boolean isSettable(ScrollBar scrollBar) {
                return scrollBar.unitIncrement == null || !scrollBar.unitIncrement.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(ScrollBar scrollBar) {
                return scrollBar.unitIncrementProperty();
            }
        };
        private static final StyleableProperty<ScrollBar, Number> BLOCK_INCREMENT = new StyleableProperty<ScrollBar, Number>("-fx-block-increment", (StyleConverter)SizeConverter.getInstance(), (Number)10.0){

            @Override
            public boolean isSettable(ScrollBar scrollBar) {
                return scrollBar.blockIncrement == null || !scrollBar.blockIncrement.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(ScrollBar scrollBar) {
                return scrollBar.blockIncrementProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, ORIENTATION, UNIT_INCREMENT, BLOCK_INCREMENT);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

