#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: postgresql-binary
version: 0.12.1
id: postgresql-binary-0.12.1-1aQvuy9PxBwCNgGBx3Z3Y1
key: postgresql-binary-0.12.1-1aQvuy9PxBwCNgGBx3Z3Y1
license: MIT
copyright: (c) 2014, Nikita Volkov
maintainer: Nikita Volkov <nikita.y.volkov@mail.ru>
homepage: https://github.com/nikita-volkov/postgresql-binary
synopsis: Encoders and decoders for the PostgreSQL'\''s binary format
description:
    An API for dealing with PostgreSQL'\''s binary data format.
    .
    It can be used to implement performant bindings to Postgres.
    E.g., <http://hackage.haskell.org/package/hasql "hasql">
    is based on this library.
    .
    It supports all Postgres versions starting from 8.3
    and is tested against 8.3, 9.3 and 9.5
    with the @integer_datetimes@ setting off and on.
category: PostgreSQL, Database, Codecs, Parsing
author: Nikita Volkov <nikita.y.volkov@mail.ru>
exposed: True
exposed-modules:
    PostgreSQL.Binary.Decoding PostgreSQL.Binary.Encoding
    PostgreSQL.Binary.Data
hidden-modules: PostgreSQL.Binary.Encoding.Builders
                PostgreSQL.Binary.Prelude PostgreSQL.Binary.Integral
                PostgreSQL.Binary.Interval PostgreSQL.Binary.Numeric
                PostgreSQL.Binary.Time PostgreSQL.Binary.Inet
                PostgreSQL.Binary.BuilderPrim
abi: b46031e132d0ae45e0f77e120dcc2200
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/postgresql-binary-0.12.1
library-dirs: /usr/lib/ghc-8.0.1/site-local/postgresql-binary-0.12.1
data-dir: /usr/share/arm-linux-ghc-8.0.1/postgresql-binary-0.12.1
hs-libraries: HSpostgresql-binary-0.12.1-1aQvuy9PxBwCNgGBx3Z3Y1
depends:
    aeson-1.0.2.1-9juLbWuUPUaFK1txzTGd5H base-4.9.0.0
    base-prelude-1.2.0.1-fuY5fEKAmeDVnWLCVSGcQ
    binary-parser-0.5.2-KrT1wpGVHHQAnAvgXVnl3m bytestring-0.10.8.1
    bytestring-strict-builder-0.4.3-AI02jfF4yqsKMyow1yWBTm
    containers-0.5.7.1 loch-th-0.2.1-HeAYtId6vjrGaOk8hiaVQf
    network-ip-0.3-9DyWy0OilTn4eRIQnjHrim
    placeholders-0.1-Jaw2KlzCEKg3F0WJS0H8eo
    scientific-0.3.4.10-HyvEaD9RF3TGwvwmkJHXws
    text-1.2.2.1-FgcR4Xf0VlEHD9HLxzq9WJ time-1.6.0.1
    transformers-0.5.2.0
    unordered-containers-0.2.8.0-HozSxlbOa6oDZVsS46CFCU
    uuid-1.3.13-Dtwa7uQPao7BTXtMhkKopa
    vector-0.11.0.0-BEDZb5o2QOhGbIm6ky7rl6
haddock-interfaces: /usr/share/doc/haskell-postgresql-binary/html/postgresql-binary.haddock
haddock-html: /usr/share/doc/haskell-postgresql-binary/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
