/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.audio;

import java.awt.event.ActionEvent;
import java.net.URL;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class AudioPlayPauseAction
extends JosmAction {
    public AudioPlayPauseAction() {
        super(I18n.trc("audio", "Play/Pause"), "audio-playpause", I18n.tr("Play/pause audio.", new Object[0]), Shortcut.registerShortcut("audio:pause", I18n.tr("Audio: {0}", I18n.trc("audio", "Play/Pause")), 46, 5003), true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        URL uRL = AudioPlayer.url();
        try {
            if (uRL != null && AudioPlayer.paused()) {
                AudioPlayer.play(uRL);
            } else if (AudioPlayer.playing()) {
                if (!Utils.equalsEpsilon(AudioPlayer.speed(), 1.0)) {
                    AudioPlayer.play(uRL, AudioPlayer.position());
                } else {
                    AudioPlayer.pause();
                }
            } else {
                AudioMarker audioMarker = AudioMarker.recentlyPlayedMarker();
                if (audioMarker != null) {
                    audioMarker.play();
                } else {
                    MarkerLayer.playAudio();
                }
            }
        }
        catch (Exception exception) {
            AudioPlayer.audioMalfunction(exception);
        }
    }
}

