/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangeCommand
extends Command {
    private final OsmPrimitive osm;
    private final OsmPrimitive newOsm;

    public ChangeCommand(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        this.osm = osmPrimitive;
        this.newOsm = osmPrimitive2;
        this.sanityChecks();
    }

    public ChangeCommand(OsmDataLayer osmDataLayer, OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        super(osmDataLayer);
        this.osm = osmPrimitive;
        this.newOsm = osmPrimitive2;
        this.sanityChecks();
    }

    public ChangeCommand(DataSet dataSet, OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        super(dataSet);
        this.osm = osmPrimitive;
        this.newOsm = osmPrimitive2;
        this.sanityChecks();
    }

    private void sanityChecks() {
        CheckParameterUtil.ensureParameterNotNull(this.osm, "osm");
        CheckParameterUtil.ensureParameterNotNull(this.newOsm, "newOsm");
        if (this.newOsm instanceof Way && ((Way)this.newOsm).getNodesCount() == 0) {
            throw new IllegalArgumentException(I18n.tr("New way {0} has 0 nodes", this.newOsm));
        }
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.osm.cloneFrom(this.newOsm);
        this.osm.setModified(true);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.osm);
    }

    @Override
    public String getDescriptionText() {
        String string;
        switch (OsmPrimitiveType.from(this.osm)) {
            case NODE: {
                string = I18n.marktr("Change node {0}");
                break;
            }
            case WAY: {
                string = I18n.marktr("Change way {0}");
                break;
            }
            case RELATION: {
                string = I18n.marktr("Change relation {0}");
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return I18n.tr(string, this.osm.getDisplayName(DefaultNameFormatter.getInstance()));
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get(this.osm.getDisplayType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.osm, this.newOsm);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ChangeCommand changeCommand = (ChangeCommand)object;
        return Objects.equals(this.osm, changeCommand.osm) && Objects.equals(this.newOsm, changeCommand.newOsm);
    }
}

